/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.HDDStatus;
import com.supermicro.ipmi.HDDStatusLogical;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;

public class IPMIHDDOEMCommand
extends IPMICommand {
    public static final int HDD_MAP_RAW_LENGTH = 80;
    public static final int HDD_LOGICAL_MAP_RAW_LENGTH = 8;

    public IPMIHDDOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public void CMD_______________________() {
    }

    public IPMIMessage getHDDExistAndErrBitMapCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{76};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getHDDInfoStructureCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{77, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getAllHDDInfoStructureCommand(byte[] offset, byte[] size) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{78, offset[0]};
        data[2] = offset[1];
        data[3] = size[0];
        data[4] = size[1];
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getLogicalHDDTargetIdExistBitMapCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{81};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getLogicalHDDInfoStructureCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{82, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getLogicalAllHDDInfoStructureCommand(byte[] offset, byte[] size) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{83, offset[0]};
        data[2] = offset[1];
        data[3] = size[0];
        data[4] = size[1];
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public void API_______________________() {
    }

    public byte[] getHDDExistAndErrBitMap() throws IPMIException {
        IPMIMessage resMessage = this.getHDDExistAndErrBitMapCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getHDDExistAndErrBitMap failed");
    }

    public HDDStatus getHDDInfoStructure(byte index) throws IPMIException {
        IPMIMessage resMessage = this.getHDDInfoStructureCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                HDDStatus hddStatus = new HDDStatus();
                if (hddStatus.fromRaw(resMessage.data)) {
                    return hddStatus;
                }
                return null;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getHDDExistAndErrBitMap failed");
    }

    public byte[] getLogicalHDDTargetIdExistBitMap() throws IPMIException {
        IPMIMessage resMessage = this.getLogicalHDDTargetIdExistBitMapCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getLogicalHDDTargetIdExistBitMapCommand failed");
    }

    public HDDStatusLogical getLogicalHDDInfoStructure(byte index) throws IPMIException {
        IPMIMessage resMessage = this.getLogicalHDDInfoStructureCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                HDDStatusLogical hddStatusLogical = new HDDStatusLogical();
                if (hddStatusLogical.fromRaw(resMessage.data)) {
                    return hddStatusLogical;
                }
                return null;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getHDDInfoStructureCommand failed");
    }

    public String drawExistAndErriBitMap() throws IPMIException {
        byte[] map = this.getHDDExistAndErrBitMap();
        HDDMap hddMap = new HDDMap();
        hddMap.fromRaw(map);
        return hddMap.drawAllMap();
    }

    public String drawLogicalHDDTargetIdExistBitMap() throws IPMIException {
        byte[] map = this.getLogicalHDDTargetIdExistBitMap();
        HDDLogicalMap hddLogicalMap = new HDDLogicalMap();
        hddLogicalMap.fromRaw(map);
        return hddLogicalMap.drawAllMap();
    }

    public HDDMap getHDDMap() throws IPMIException {
        byte[] map = this.getHDDExistAndErrBitMap();
        if (map.length != 80) {
            return null;
        }
        HDDMap hddMap = new HDDMap();
        hddMap.fromRaw(map);
        return hddMap;
    }

    public HDDLogicalMap getLogicalHDDMap() throws IPMIException {
        byte[] map = this.getLogicalHDDTargetIdExistBitMap();
        if (map.length != 8) {
            return null;
        }
        HDDLogicalMap hddLogicalMap = new HDDLogicalMap();
        hddLogicalMap.fromRaw(map);
        return hddLogicalMap;
    }

    public HDDStatus getAllHDDInfoStructure(byte index1, byte index2) throws IPMIException {
        return null;
    }

    public void ENTITY____________________() {
    }

    public void MAIN______________________() {
    }

    public static void main(String[] args) {
        IPMIHDDOEMCommand.main_status(args);
        IPMIHDDOEMCommand.main_logical_status(args);
    }

    public static void main_testDrawMap(String[] args) {
    }

    public static void main_status(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("172.31.11.86");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMIHDDOEMCommand ipmiHDDOEMCommand = new IPMIHDDOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiHDDOEMCommand);
        if (ipmiHDDOEMCommand.getIPMIInterface() == null) {
            System.out.println("ip or password error");
            return;
        }
        try {
            String mapStr = ipmiHDDOEMCommand.drawExistAndErriBitMap();
            System.out.println(mapStr);
            byte[] map = ipmiHDDOEMCommand.getHDDExistAndErrBitMap();
            System.out.println("map =" + ByteUtility.bytesToHex(map));
            for (int i2 = 0; i2 < 100; ++i2) {
                HDDStatus hddStatus = ipmiHDDOEMCommand.getHDDInfoStructure((byte)i2);
                System.out.println("i = " + i2);
                System.out.println(hddStatus.toString());
            }
        }
        catch (IPMIException ex) {
            // empty catch block
        }
        sessionController.closeSession();
    }

    public static void main_logical_status(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("172.31.9.122");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMIHDDOEMCommand ipmiHDDOEMCommand = new IPMIHDDOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiHDDOEMCommand);
        if (ipmiHDDOEMCommand.getIPMIInterface() == null) {
            System.out.println("ip or password error");
            return;
        }
        try {
            String mapStr = ipmiHDDOEMCommand.drawLogicalHDDTargetIdExistBitMap();
            System.out.println(mapStr);
            byte[] map = ipmiHDDOEMCommand.getLogicalHDDTargetIdExistBitMap();
            System.out.println("map =" + ByteUtility.bytesToHex(map));
            for (int i2 = 0; i2 < 5; ++i2) {
                HDDStatusLogical hddStatusLogical = ipmiHDDOEMCommand.getLogicalHDDInfoStructure((byte)i2);
                System.out.println("i = " + i2);
                System.out.println(hddStatusLogical.toString());
            }
        }
        catch (IPMIException ex) {
            // empty catch block
        }
        sessionController.closeSession();
    }

    public class HDDLogicalMap {
        byte[][] hddExistMap;

        public void fromRaw(byte[] raw) {
            if (raw.length != 8) {
                return;
            }
            this.hddExistMap = new byte[4][2];
            int count = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                for (int j2 = 0; j2 < 2; ++j2) {
                    this.hddExistMap[i2][j2] = raw[count];
                    ++count;
                }
            }
        }

        public String toString() {
            return null;
        }

        public String drawAllMap() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < this.hddExistMap.length; ++i2) {
                String map = this.drawMap(this.hddExistMap[i2], i2);
                stringBuffer.append(map + "\n");
            }
            stringBuffer.append("O: Present\n");
            stringBuffer.append("-: Not Present");
            return stringBuffer.toString();
        }

        public String drawMap(byte[] existMap, int index) {
            StringBuffer formatedString = new StringBuffer();
            String num = " %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s\n";
            String sep = "---------------------------------------------------------------\n";
            String map = " %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s  %2s";
            formatedString.append(String.format(num, index * 16 + 0, index * 16 + 1, index * 16 + 2, index * 16 + 3, index * 16 + 4, index * 16 + 5, index * 16 + 6, index * 16 + 7, index * 16 + 8, index * 16 + 9, index * 16 + 10, index * 16 + 11, index * 16 + 12, index * 16 + 13, index * 16 + 14, index * 16 + 15));
            formatedString.append(sep);
            formatedString.append(String.format(map, this.c(existMap, 0), this.c(existMap, 1), this.c(existMap, 2), this.c(existMap, 3), this.c(existMap, 4), this.c(existMap, 5), this.c(existMap, 6), this.c(existMap, 7), this.c(existMap, 8), this.c(existMap, 9), this.c(existMap, 10), this.c(existMap, 11), this.c(existMap, 12), this.c(existMap, 13), this.c(existMap, 14), this.c(existMap, 15)));
            return formatedString.toString();
        }

        public String c(byte[] existMap, int index) {
            int existInt = ByteUtility.twoBytesToIntLSB(existMap);
            int existflag = existInt & 1 << index;
            if (existflag > 0) {
                return "O";
            }
            return "-";
        }

        public boolean isExist(int index) {
            if (index < 0 || index > 64) {
                return false;
            }
            int i2 = index / 16;
            int j2 = index % 16;
            int existLong = ByteUtility.twoBytesToIntLSB(this.hddExistMap[i2]);
            int existflag = existLong & 1 << j2;
            return existflag > 0;
        }
    }

    public class HDDMap {
        byte[][] hddExistMap;
        byte[][] hddErrorMap;

        public void fromRaw(byte[] raw) {
            int j2;
            int i2;
            if (raw.length != 80) {
                return;
            }
            this.hddExistMap = new byte[10][4];
            this.hddErrorMap = new byte[10][4];
            int count = 0;
            for (i2 = 0; i2 < 10; ++i2) {
                for (j2 = 0; j2 < 4; ++j2) {
                    this.hddExistMap[i2][j2] = raw[count];
                    ++count;
                }
            }
            for (i2 = 0; i2 < 10; ++i2) {
                for (j2 = 0; j2 < 4; ++j2) {
                    this.hddErrorMap[i2][j2] = raw[count];
                    ++count;
                }
            }
        }

        public String toString() {
            return null;
        }

        public String drawAllMap() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < this.hddExistMap.length; ++i2) {
                if (this.hddExistMap[i2][0] == 0 && this.hddExistMap[i2][1] == 0 && this.hddExistMap[i2][2] == 0) continue;
                String map = this.drawMap(this.hddExistMap[i2], this.hddErrorMap[i2]);
                stringBuffer.append("\nEnclosure Set: " + (i2 + 1) + "\n");
                stringBuffer.append(map + "\n");
            }
            stringBuffer.append("X: Error\n");
            stringBuffer.append("O: Present\n");
            stringBuffer.append("-: Not Present");
            return stringBuffer.toString();
        }

        public String drawMap(byte[] existMap, byte[] errorMap) {
            StringBuffer formatedString = new StringBuffer();
            String num = "00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23\n";
            String sep = "-----------------------------------------------------------------------\n";
            String map = " %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s  %1s";
            formatedString.append(num);
            formatedString.append(sep);
            formatedString.append(String.format(map, this.c(existMap, errorMap, 0), this.c(existMap, errorMap, 1), this.c(existMap, errorMap, 2), this.c(existMap, errorMap, 3), this.c(existMap, errorMap, 4), this.c(existMap, errorMap, 5), this.c(existMap, errorMap, 6), this.c(existMap, errorMap, 7), this.c(existMap, errorMap, 8), this.c(existMap, errorMap, 9), this.c(existMap, errorMap, 10), this.c(existMap, errorMap, 11), this.c(existMap, errorMap, 12), this.c(existMap, errorMap, 13), this.c(existMap, errorMap, 14), this.c(existMap, errorMap, 15), this.c(existMap, errorMap, 16), this.c(existMap, errorMap, 17), this.c(existMap, errorMap, 18), this.c(existMap, errorMap, 19), this.c(existMap, errorMap, 20), this.c(existMap, errorMap, 21), this.c(existMap, errorMap, 22), this.c(existMap, errorMap, 23), this.c(existMap, errorMap, 24)));
            return formatedString.toString();
        }

        public String c(byte[] existMap, byte[] errorMap, int index) {
            long existLong = ByteUtility.fourBytesToIntByLSBFirst(existMap);
            long errorLong = ByteUtility.fourBytesToIntByLSBFirst(errorMap);
            long existflag = existLong & (long)(1 << index);
            long errorflag = errorLong & (long)(1 << index);
            if (existflag > 0L) {
                if (errorflag > 0L) {
                    return "X";
                }
                return "O";
            }
            return "-";
        }

        public boolean isExist(int index) {
            if (index < 0 || index > 240) {
                return false;
            }
            int i2 = index / 24;
            int j2 = index % 24;
            long existLong = ByteUtility.fourBytesToIntByLSBFirst(this.hddExistMap[i2]);
            long existflag = existLong & (long)(1 << j2);
            return existflag > 0L;
        }

        public boolean isError(int index) {
            if (index < 0 || index > 240) {
                return false;
            }
            int i2 = index / 24;
            int j2 = index % 24;
            long errorLong = ByteUtility.fourBytesToIntByLSBFirst(this.hddErrorMap[i2]);
            long errorflag = errorLong & (long)(1 << j2);
            return errorflag > 0L;
        }
    }
}

