/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.IIPMIMessage;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SELInfo;
import java.util.ArrayList;
import java.util.Calendar;

public class KCS
implements IPMIInterface {
    public native byte executeAsyncCommand(int var1, int var2, byte[] var3);

    public native byte executeCommand(int var1, int var2, byte[] var3);

    public native byte[] getResult();

    public native int getResultLength();

    @Override
    public void initialize(IPMIInterfaceConfig config) {
        System.loadLibrary("KCSNativeMethod");
    }

    @Override
    public IPMIMessage send(IIPMIMessage ipmiMessage) {
        IPMIMessage anIPMIMessage = (IPMIMessage)ipmiMessage;
        byte completeCode = this.executeCommand(anIPMIMessage.netFnLun, anIPMIMessage.cmd, anIPMIMessage.data);
        IPMIMessage resIPMIMessage = new IPMIMessage();
        if (completeCode == 0) {
            byte[] result = this.getResult();
            resIPMIMessage.data = result;
        }
        resIPMIMessage.completionCode = completeCode;
        return resIPMIMessage;
    }

    @Override
    public IPMIMessage receive() {
        return null;
    }

    @Override
    public void drop(IIPMIMessage ipmiMessage) {
        IPMIMessage anIPMIMessage = (IPMIMessage)ipmiMessage;
        byte completeCode = this.executeCommand(anIPMIMessage.netFnLun, anIPMIMessage.cmd, anIPMIMessage.data);
    }

    public static void main(String[] args) {
        boolean result;
        String communityString;
        String getwayMAC;
        String getwayIP;
        String subnetMask;
        String mac;
        KCS kcs = new KCS();
        kcs.initialize(null);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(kcs);
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        ACPIInfo acpiInfo = ipmiGlobalCommand.getACPI();
        MessageCenter.getInstance().put(deviceInfo.toString());
        MessageCenter.getInstance().put(acpiInfo.getDeviceStateInfo());
        MessageCenter.getInstance().put(acpiInfo.getSystemStateInfo());
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(kcs);
        String ip = ipmiLanCommand.getIP();
        if (ip != null) {
            MessageCenter.getInstance().put("IP = " + ip);
        }
        if ((mac = ipmiLanCommand.getMAC()) != null) {
            MessageCenter.getInstance().put("MAC = " + mac);
        }
        if ((subnetMask = ipmiLanCommand.getSubnetMask()) != null) {
            MessageCenter.getInstance().put("Subnet Mask = " + subnetMask);
        }
        if ((getwayIP = ipmiLanCommand.getGatewayIP()) != null) {
            MessageCenter.getInstance().put("Getway IP = " + getwayIP);
        }
        if ((getwayMAC = ipmiLanCommand.getGatewayMAC()) != null) {
            MessageCenter.getInstance().put("Getway MAC = " + getwayMAC);
        }
        if ((communityString = ipmiLanCommand.getCommunityString()) != null) {
            MessageCenter.getInstance().put("Community String = " + communityString);
        }
        int numberOfDestination = ipmiLanCommand.getNumberOfDestination();
        MessageCenter.getInstance().put("Number of Destination = " + numberOfDestination);
        for (int j2 = 0; j2 < numberOfDestination; ++j2) {
            String dIP = ipmiLanCommand.getDestinationIP((byte)j2);
            String dMAC = ipmiLanCommand.getDestinationMAC((byte)j2);
            if (ip == null) continue;
            MessageCenter.getInstance().put("Destination IP address : " + dIP + ", MAC : " + dMAC);
        }
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(kcs);
        int size = ipmiFRUCommand.getFRUSize();
        System.out.println("FRU size =" + size);
        FRUInfo fruInfo = ipmiFRUCommand.getFRUData();
        System.out.println(fruInfo.toString());
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(kcs);
        SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
        if (sdrInfo != null) {
            MessageCenter.getInstance().put(sdrInfo.toString());
        }
        ArrayList list = ipmiSDRCommand.getSDRs(sdrInfo.getRecordCount());
        for (Object item : list) {
            if (((SDRRecord)item).getSensorType() != 5 && ((SDRRecord)item).getSensorType() != 8) {
                byte value = 0;
                value = ipmiSDRCommand.getSensorReading(((SDRRecord)item).getSensorNumber());
                String reading = ((SDRRecord)item).doubleToString(((SDRRecord)item).calSensorReading(value & 0xFF));
                String hi = ((SDRRecord)item).doubleToString(((SDRRecord)item).getHiLimit());
                String low = ((SDRRecord)item).doubleToString(((SDRRecord)item).getLowLimit());
                System.out.println(((SDRRecord)item).getSensorName() + ",\t" + "value =" + reading + "(" + ((SDRRecord)item).getUnit() + "),\t Low = " + low + ",\t Hi = " + hi + ",\t rawValue = " + value);
                continue;
            }
            byte[] value = ipmiSDRCommand.getFullSensorValue(((SDRRecord)item).getSensorNumber());
            System.out.println(((SDRRecord)item).getSensorName() + ",\t" + "status = " + ByteUtility.bytesToHex(value));
            System.out.println(((SDRRecord)item).toSensorString());
        }
        for (Object item : SDRRecord.sensorNumberToSensorName.keySet()) {
            Object value = SDRRecord.sensorNumberToSensorName.get(item);
            System.out.println(item + " = " + value);
        }
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(kcs);
        sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
        ipmiSDRCommand.getSDRs(sdrInfo.getRecordCount());
        SELInfo selInfo = ipmiSELCommand.getSELInfoModal();
        if (selInfo != null) {
            MessageCenter.getInstance().put(selInfo.toString());
        }
        if (result = ipmiSELCommand.setSELTimeByCalendar(Calendar.getInstance())) {
            System.out.println("set sel time ok");
        } else {
            System.out.println("set sel time failed");
        }
        String selTime = ipmiSELCommand.getSELTimeWithFormat();
        MessageCenter.getInstance().put("SEL Time =" + selTime);
    }
}

