/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.algo;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.algo.IntegrityAlgorithm;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class HMAC_SHA1_128
extends IntegrityAlgorithm {
    @Override
    public byte[] code(byte[] key, byte[] plainText) {
        byte[] result = null;
        try {
            Mac hmacSHA1 = Mac.getInstance("HmacSHA1");
            SecretKeySpec sks = new SecretKeySpec(key, "HmacSHA1");
            hmacSHA1.init(sks);
            result = hmacSHA1.doFinal(plainText);
        }
        catch (IllegalStateException ex) {
        }
        catch (InvalidKeyException ex) {
        }
        catch (NoSuchAlgorithmException ex) {
            // empty catch block
        }
        byte[] b1 = new byte[16];
        System.arraycopy(result, 0, b1, 0, 16);
        return b1;
    }

    public static void main(String[] args) throws Exception {
        HMAC_SHA1_128 sha = new HMAC_SHA1_128();
        String key = "95131";
        String value = "SUPERMICRO";
        byte[] result = sha.code(key.getBytes(), value.getBytes());
        System.out.println("result 1= " + ByteUtility.bytesToHex(result));
        for (int i2 = 0; i2 < 256; ++i2) {
            String macAddress = "0030480000" + String.format("%02X", i2);
            System.out.println("MAC Address = " + macAddress + " getByte() =" + ByteUtility.bytesToHex(macAddress.getBytes()));
            result = sha.code(result, macAddress.getBytes());
            System.out.println("result = " + ByteUtility.bytesToHex(result));
            String s = new BASE64Encoder().encode(result);
            System.out.println("base64 encode = " + s);
            System.out.println("base64 decode = " + ByteUtility.bytesToHex(new BASE64Decoder().decodeBuffer(s)));
        }
    }
}

