/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.Debug;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.LogUtil;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.AbstractMBSensorEntity;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.CMMModuleEntity;
import com.supermicro.ipmi.blade.DisconnectListener;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.FrontLEDEntity;
import com.supermicro.ipmi.blade.GigabitSwitchEntity;
import com.supermicro.ipmi.blade.IBFDREntity;
import com.supermicro.ipmi.blade.IBQDREntity;
import com.supermicro.ipmi.blade.InfiniBandEntity;
import com.supermicro.ipmi.blade.MBSensorEntityFactory;
import com.supermicro.ipmi.blade.PowerSupplyEntity;
import com.supermicro.ipmi.blade.TenGPassThruEntity;
import com.supermicro.ipmi.blade.TenGSwitchEntity;
import com.supermicro.ipmi.lang.L;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class BladeSystemEntity
extends Observable {
    boolean debug = false;
    public boolean isLoginSuccessful = false;
    public boolean isLogoutSuccessful = false;
    public boolean isBladeEntityAvailable = false;
    public boolean isCMMModuleEntityAvailable = false;
    public boolean isGigabitSwitchEntityAvailable = false;
    public boolean isInfiniBandEntityAvailable = false;
    public boolean isPowerSupplyEntityAvailable = false;
    public boolean isMBSensorEntityAvailable = false;
    public boolean isFrontLEDEntityAvailable = false;
    public boolean isBladeMiscEntityAvailable = false;
    public boolean isQueryBladeEntity = true;
    public boolean isQueryCMMModuleEntity = true;
    public boolean isQueryGigabitSwitchEntity = true;
    public boolean isQueryInfiniBandEntity = true;
    public boolean isQueryPowerSupplyEntity = true;
    public boolean isQueryMBSensorEntity = true;
    public boolean isQueryFrontLEDEntity = true;
    public boolean isQueryFanControlMode = true;
    public boolean isGenerateFailureReport = true;
    public boolean isGetPowerConsumptionStatus = true;
    public boolean isQueryBladeMiscEntity = true;
    public static int BLADE_DATA_SIZE = 18;
    public static int CMM_MODULE_DATA_SIZE = 11;
    public static int GIGABIT_SWITCH_MODULE_DATA_SIZE = 19;
    public static int INFINI_BAND_MODULE_DATA_SIZE = 22;
    public static int POWER_SUPPLY_MODULE_DATA_SIZE = 34;
    public static int MOTHER_BOARD_SENSORS_DATA_SIZE = 35;
    public static int FRONT_PANEL_LED_DATA_SIZE = 2;
    public static int MOTHER_BOARD_SENSORS_DATA_SIZE_ORG = MOTHER_BOARD_SENSORS_DATA_SIZE;
    private BladeEntity[] blades;
    private AbstractMBSensorEntity[] mbSensors;
    private CMMModuleEntity[] cmmModules;
    private GigabitSwitchEntity[] gigabitSwitchs;
    private InfiniBandEntity[] infiniBands;
    private PowerSupplyEntity[] powerSupplies;
    private TenGPassThruEntity[] tenGPassThrus;
    private IBQDREntity[] iBQDRs;
    private IBFDREntity[] iBFDRs;
    private TenGSwitchEntity[] tenGSwitches;
    private FrontLEDEntity frontLED;
    private IPMICMMOEMCommand.PowerConsumptionStatus powerConsumptionStatus;
    private ArrayList failures = new ArrayList();
    boolean isMaster;
    ArrayList disconnectListeners = new ArrayList();
    private byte fanControlMode = 0;
    private boolean isSupportIPMB = false;
    public boolean ifCheckOnlyOneTime = false;
    private int poolingInterval = 4;
    Timer poolingTimer;
    private ISessionController sessionController;
    private IPMIInterfaceConfig ipmiInterfaceConfig;
    IPMICMMOEMCommand ipmiCMMOEMCommand;
    boolean useExistConnection = false;
    int count = 0;
    SimpleDateFormat f = new SimpleDateFormat("MM/dd HH:mm:ss");
    int countOfGetData = 0;
    int queryCount = 0;

    public BladeSystemEntity(IPMIInterfaceConfig ipmiInterfaceConfig) {
        int i2;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(ipmiInterfaceConfig.getIp());
        int bladeSize = 10;
        int cmmModuleSize = 2;
        int powerSupplySize = 4;
        int infiniBandSize = 2;
        int gigabitSwitchSize = 2;
        int tenGPassThruSize = 2;
        int iBQDRSize = 2;
        int iBFDRSize = 2;
        int tenGSwitchSize = 2;
        if (guid != null && IPMIMessagingCommand.isCMMGUID(guid)) {
            bladeSize = guid[8];
            cmmModuleSize = guid[9];
            powerSupplySize = guid[10];
            infiniBandSize = guid[11];
            gigabitSwitchSize = guid[12];
        }
        this.ipmiInterfaceConfig = ipmiInterfaceConfig;
        this.blades = new BladeEntity[bladeSize];
        this.mbSensors = new AbstractMBSensorEntity[bladeSize];
        this.cmmModules = new CMMModuleEntity[cmmModuleSize];
        this.gigabitSwitchs = new GigabitSwitchEntity[gigabitSwitchSize];
        this.infiniBands = new InfiniBandEntity[infiniBandSize];
        this.powerSupplies = new PowerSupplyEntity[powerSupplySize];
        this.tenGPassThrus = new TenGPassThruEntity[tenGPassThruSize];
        this.iBQDRs = new IBQDREntity[iBQDRSize];
        this.iBFDRs = new IBFDREntity[iBFDRSize];
        this.tenGSwitches = new TenGSwitchEntity[tenGPassThruSize];
        for (i2 = 0; i2 < bladeSize; ++i2) {
            this.blades[i2] = new BladeEntity();
            this.blades[i2].setModuleIndex(i2 + 1);
        }
        for (i2 = 0; i2 < cmmModuleSize; ++i2) {
            this.cmmModules[i2] = new CMMModuleEntity();
            this.cmmModules[i2].setModuleIndex(i2 + 1);
        }
        for (i2 = 0; i2 < gigabitSwitchSize; ++i2) {
            this.gigabitSwitchs[i2] = new GigabitSwitchEntity();
            this.gigabitSwitchs[i2].setModuleIndex(i2 + 1);
        }
        for (i2 = 0; i2 < infiniBandSize; ++i2) {
            this.infiniBands[i2] = new InfiniBandEntity();
            this.infiniBands[i2].setModuleIndex(i2 + 1);
        }
        for (i2 = 0; i2 < powerSupplySize; ++i2) {
            this.powerSupplies[i2] = new PowerSupplyEntity();
            this.powerSupplies[i2].setModuleIndex(i2 + 1);
        }
        for (i2 = 0; i2 < tenGPassThruSize; ++i2) {
            this.tenGPassThrus[i2] = new TenGPassThruEntity();
            this.tenGPassThrus[i2].setModuleIndex(i2 + 1);
        }
        for (i2 = 0; i2 < iBQDRSize; ++i2) {
            this.iBQDRs[i2] = new IBQDREntity();
            this.iBQDRs[i2].setModuleIndex(i2 + 1);
        }
        for (i2 = 0; i2 < iBFDRSize; ++i2) {
            this.iBFDRs[i2] = new IBFDREntity();
            this.iBFDRs[i2].setModuleIndex(i2 + 1);
        }
        for (i2 = 0; i2 < tenGSwitchSize; ++i2) {
            this.tenGSwitches[i2] = new TenGSwitchEntity();
            this.tenGSwitches[i2].setModuleIndex(i2 + 1);
        }
        this.frontLED = new FrontLEDEntity();
    }

    public BladeSystemEntity(IPMIInterfaceConfig ipmiInterfaceConfig, int bladeSize, int cmmModuleSize, int gigabitSwitchSize, int infiniBandSize, int powerSupplySize) {
        int i2;
        this.ipmiInterfaceConfig = ipmiInterfaceConfig;
        this.blades = new BladeEntity[bladeSize];
        this.mbSensors = new AbstractMBSensorEntity[bladeSize];
        this.cmmModules = new CMMModuleEntity[cmmModuleSize];
        this.gigabitSwitchs = new GigabitSwitchEntity[gigabitSwitchSize];
        this.infiniBands = new InfiniBandEntity[infiniBandSize];
        this.powerSupplies = new PowerSupplyEntity[powerSupplySize];
        for (i2 = 0; i2 < bladeSize; ++i2) {
            this.blades[i2] = new BladeEntity();
            this.blades[i2].setModuleIndex(i2 + 1);
        }
        for (i2 = 0; i2 < cmmModuleSize; ++i2) {
            this.cmmModules[i2] = new CMMModuleEntity();
            this.cmmModules[i2].setModuleIndex(i2 + 1);
        }
        for (i2 = 0; i2 < gigabitSwitchSize; ++i2) {
            this.gigabitSwitchs[i2] = new GigabitSwitchEntity();
            this.gigabitSwitchs[i2].setModuleIndex(i2 + 1);
        }
        for (i2 = 0; i2 < infiniBandSize; ++i2) {
            this.infiniBands[i2] = new InfiniBandEntity();
            this.infiniBands[i2].setModuleIndex(i2 + 1);
        }
        for (i2 = 0; i2 < powerSupplySize; ++i2) {
            this.powerSupplies[i2] = new PowerSupplyEntity();
            this.powerSupplies[i2].setModuleIndex(i2 + 1);
        }
        this.frontLED = new FrontLEDEntity();
    }

    @Override
    public void addObserver(Observer o) {
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] [AddObserver] " + o.getClass().getName());
        }
        super.addObserver(o);
    }

    public void poolingData() {
        TimerTask t = new TimerTask(){

            @Override
            public void run() {
                try {
                    BladeSystemEntity.this.getData();
                }
                catch (Exception ex) {
                    System.out.println("An exception occured in poolingData " + ex.toString());
                    ex.printStackTrace();
                }
            }
        };
        this.poolingTimer = new Timer();
        this.poolingTimer.schedule(t, 0L, (long)(this.poolingInterval * 1000));
    }

    public void stopPooling() {
        if (this.poolingTimer != null) {
            this.poolingTimer.cancel();
            this.poolingTimer = null;
        }
    }

    public void addDisconnectListener(DisconnectListener l) {
        this.disconnectListeners.add(l);
    }

    public void removeDisconnectListener(DisconnectListener l) {
        this.disconnectListeners.remove(l);
    }

    public void removeallDisconnectListener() {
        this.disconnectListeners.clear();
    }

    public void notifyDisconnectListener() {
        for (DisconnectListener item : this.disconnectListeners) {
            item.disconnect(this);
        }
    }

    private boolean helpLogin() {
        this.sessionController = IPMIVersion.getSessionController(this.ipmiInterfaceConfig);
        this.ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        if (this.sessionController == null) {
            return false;
        }
        IPMINetworkInterface rmcp = this.sessionController.startup(this.ipmiInterfaceConfig);
        if (rmcp == null) {
            return false;
        }
        this.ipmiCMMOEMCommand.setIPMIInterface(rmcp);
        return true;
    }

    private boolean helpLogout() {
        return this.sessionController.closeSession();
    }

    private void delayForDebug() {
    }

    public synchronized void getData() {
        this.helpGetData();
        this.notifyUI();
    }

    private void helpGetData() {
        IPMIMessage resMessage;
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 0.Start query");
        }
        ++this.countOfGetData;
        this.isLoginSuccessful = false;
        this.isBladeEntityAvailable = false;
        this.isCMMModuleEntityAvailable = false;
        this.isGigabitSwitchEntityAvailable = false;
        this.isInfiniBandEntityAvailable = false;
        this.isPowerSupplyEntityAvailable = false;
        this.isMBSensorEntityAvailable = false;
        this.isFrontLEDEntityAvailable = false;
        this.isLogoutSuccessful = false;
        this.isBladeMiscEntityAvailable = false;
        Calendar cStart = Calendar.getInstance();
        if (this.useExistConnection) {
            this.isLoginSuccessful = true;
        } else {
            boolean result = false;
            for (int count = 0; count != 2; ++count) {
                result = this.helpLogin();
                if (!result) continue;
            }
            if (!result) {
                this.isLoginSuccessful = false;
                this.notifyDisconnectListener();
                return;
            }
            this.isLoginSuccessful = true;
        }
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 0.Login");
        }
        if (this.isQueryBladeEntity) {
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)1);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    this.divideDataForEachBlade(resMessage.data);
                    this.isBladeEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 1.get Blade ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryCMMModuleEntity) {
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)2);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    this.divideDataForEachCMMModule(resMessage.data);
                    this.isCMMModuleEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 2.CMMModule ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryPowerSupplyEntity) {
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)3);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    this.divideDataForEachPowerSupplyModule(resMessage.data);
                    this.isPowerSupplyEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 3.Power Supply ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryGigabitSwitchEntity) {
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)4);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    this.divideDataForEachGigabitSwitchModule(resMessage.data);
                    this.isGigabitSwitchEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 4.Gigabit ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryInfiniBandEntity) {
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)5);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    this.divideDataForEachInfiniBandModule(resMessage.data);
                    this.isInfiniBandEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 5.Infiniband ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryMBSensorEntity) {
            for (int i2 = 0; i2 < this.blades.length; ++i2) {
                if (this.mbSensors[i2] != null && MBSensorEntityFactory.checkMBSensorType(this.blades[i2].getMBModel(), this.mbSensors[i2])) continue;
                this.mbSensors[i2] = MBSensorEntityFactory.createAbstractMBSensorEntity(this.blades[i2].getMBModel());
                this.mbSensors[i2].setModuleIndex(i2 + 1);
            }
            if (this.ifSensorSizeChanged()) {
                byte[] raw = this.getBladeSensorRaw();
                if (raw != null) {
                    this.divideDataForEachMBSensor(raw);
                    this.isMBSensorEntityAvailable = true;
                }
            } else {
                resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)6);
                if (resMessage != null) {
                    if (resMessage.completionCode == 0) {
                        this.divideDataForEachMBSensor(resMessage.data);
                        this.isMBSensorEntityAvailable = true;
                    }
                } else {
                    return;
                }
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 6.MB Sensors ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryFrontLEDEntity) {
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)7);
            if (resMessage != null) {
                if (resMessage.completionCode == 0 && resMessage.data.length == FRONT_PANEL_LED_DATA_SIZE) {
                    this.frontLED.fromRaw(resMessage.data);
                    this.isFrontLEDEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 7.get front panel ok");
            }
            this.delayForDebug();
        }
        if (this.isQueryFanControlMode) {
            resMessage = this.ipmiCMMOEMCommand.getFanControlModeCommand();
            if (resMessage != null && resMessage.completionCode == 0) {
                this.fanControlMode = resMessage.data[0];
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 8.fan control mode ok");
            }
            this.delayForDebug();
        }
        if (this.isGetPowerConsumptionStatus) {
            try {
                this.powerConsumptionStatus = this.ipmiCMMOEMCommand.getPowerConsumptionStatus();
            }
            catch (IPMIException ex) {
            }
            catch (ArrayIndexOutOfBoundsException exa) {
                // empty catch block
            }
        }
        if (this.isQueryBladeMiscEntity) {
            resMessage = this.ipmiCMMOEMCommand.getSystemInfoCommand((byte)9);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    this.divideDataForEachBladeMisc(resMessage.data);
                    this.isBladeMiscEntityAvailable = true;
                }
            } else {
                return;
            }
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 10.get Blade Misc");
            }
            this.delayForDebug();
        }
        this.tempTestHere();
        if (!this.ifCheckOnlyOneTime) {
            this.helpCheckWhichCMMWeConnected(this.ipmiCMMOEMCommand);
            this.helpCheckIsSupportIPMB(this.ipmiCMMOEMCommand);
            this.ifCheckOnlyOneTime = true;
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 9.one time query ok");
            }
            this.delayForDebug();
        }
        this.checkIsMaster();
        this.isLogoutSuccessful = this.useExistConnection ? true : this.helpLogout();
        if (!this.isLogoutSuccessful) {
            this.notifyDisconnectListener();
            return;
        }
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 10.logout ok");
        }
        this.delayForDebug();
        if (this.debug) {
            this.debugMessage();
        }
        Calendar cMiddle = Calendar.getInstance();
        if (this.isGenerateFailureReport) {
            this.generateFailureReport();
            if (Debug.bladeSystemGetDataDebug) {
                LogUtil.printLog("[BladeSystemEntity] 11.generfailure report ok");
            }
            this.delayForDebug();
        }
        Calendar cEnd = Calendar.getInstance();
        double time1 = cMiddle.getTimeInMillis() - cStart.getTimeInMillis();
        String queryTimeStr = " Query  = " + time1 / 1000.0;
        StringBuffer sb = new StringBuffer();
        sb.append("Login:" + (this.isLoginSuccessful ? "OK" : "X"));
        sb.append(", Blade:" + (this.isBladeEntityAvailable ? "OK" : "X"));
        sb.append(", Blade Misc:" + (this.isBladeMiscEntityAvailable ? "OK" : "X"));
        sb.append(", CMM:" + (this.isCMMModuleEntityAvailable ? "OK" : "X"));
        sb.append(", GB:" + (this.isGigabitSwitchEntityAvailable ? "OK" : "X"));
        sb.append(", IB:" + (this.isInfiniBandEntityAvailable ? "OK" : "X"));
        sb.append(", PW:" + (this.isPowerSupplyEntityAvailable ? "OK" : "X"));
        sb.append(", MBSensor:" + (this.isMBSensorEntityAvailable ? "OK" : "X"));
        sb.append(", FrontLED:" + (this.isFrontLEDEntityAvailable ? "OK" : "X"));
        sb.append(", Logout:" + (this.isLoginSuccessful ? "O" : "X"));
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 12.done");
        }
    }

    private boolean ifSensorSizeChanged() {
        try {
            IPMICMMOEMCommand.DeviceStructureInfoManager infoManager = this.ipmiCMMOEMCommand.getStructureMetaData();
            if (infoManager == null) {
                return false;
            }
            IPMICMMOEMCommand.DeviceStructureInfo info = infoManager.getDeviceStructureInfo((byte)6);
            if (info == null) {
                return false;
            }
            if (info.structureLength != MOTHER_BOARD_SENSORS_DATA_SIZE_ORG) {
                MOTHER_BOARD_SENSORS_DATA_SIZE = info.structureLength;
                return true;
            }
            return false;
        }
        catch (IPMIException ex) {
            return false;
        }
    }

    private byte[] getBladeSensorRaw() {
        int lengthForGet = this.blades.length / 2;
        int type = 6;
        byte[] raw1 = null;
        byte[] raw2 = null;
        try {
            raw1 = this.ipmiCMMOEMCommand.getSystemInfoByBatch((byte)type, 0, lengthForGet);
            raw2 = this.ipmiCMMOEMCommand.getSystemInfoByBatch((byte)type, lengthForGet, lengthForGet);
        }
        catch (IPMIException ex) {
            return null;
        }
        byte[] all = new byte[raw1.length + raw2.length];
        System.arraycopy(raw1, 0, all, 0, raw1.length);
        System.arraycopy(raw2, 0, all, raw1.length, raw2.length);
        return all;
    }

    private void tempTestHere() {
    }

    public void checkB7DCE_SIMBL_Is_ExistViaIPMB() {
        for (int i2 = 0; i2 < this.blades.length; ++i2) {
            boolean result;
            if (!this.getIsMaster() || this.blades[i2].getPresent() == 0 || !this.checkMB(this.blades[i2].getMBModel()) || this.blades[i2].isV3_3v() || !this.blades[i2].isSimCardDetectPin() || !this.isSupportIPMB || (result = this.getSIMBLIPViaIPMB((byte)(i2 + 1)))) continue;
            this.blades[i2].setSimCardDetectPin(true);
        }
    }

    private boolean checkMB(byte mbModel) {
        return mbModel == 3 || mbModel == 4;
    }

    private boolean getSIMBLIPViaIPMB(byte moduleIndex) {
        boolean result = false;
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.ipmiInterfaceConfig, ipmiLanCommand);
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmb.setChannel(moduleIndex);
        if (sessionController != null) {
            String ip = ipmiLanCommand.getIP();
            if (ip != null) {
                result = true;
            }
            sessionController.closeSession();
        }
        return result;
    }

    public void checkIsMaster() {
        this.isMaster = false;
        for (int i2 = 0; i2 < this.cmmModules.length; ++i2) {
            if (!this.cmmModules[i2].isConnected()) continue;
            this.isMaster = this.cmmModules[i2].getMasterSlave() == 0;
            return;
        }
    }

    private void helpCheckWhichCMMWeConnected(IPMICMMOEMCommand ipmiCMMOEMCommand) {
        int slot = 0;
        try {
            slot = ipmiCMMOEMCommand.getCMMSlot();
            this.cmmModules[slot].setConnected(true);
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
    }

    private void helpCheckIsSupportIPMB(IPMICMMOEMCommand ipmiCMMOEMCommand) {
        try {
            this.isSupportIPMB = ipmiCMMOEMCommand.isCMMSupportIPMB();
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
    }

    private void notifyUI() {
        if (!this.isLoginSuccessful || !this.isLogoutSuccessful) {
            return;
        }
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 13.Start Notify");
        }
        Calendar cStart = Calendar.getInstance();
        this.setChanged();
        this.notifyObservers();
        Calendar cEnd = Calendar.getInstance();
        double time = cEnd.getTimeInMillis() - cStart.getTimeInMillis();
        if (Debug.bladeSystemGetDataDebug) {
            LogUtil.printLog("[BladeSystemEntity] 14.End Notify  Notify(" + this.countObservers() + ") = " + time / 1000.0 + "secs");
        }
    }

    private void debugMessage() {
        int i2;
        System.out.println("query count =" + this.queryCount++);
        for (i2 = 0; i2 < this.blades.length; ++i2) {
            System.out.print("================Start  Blade (" + (i2 + 1) + ")================");
            System.out.println(this.blades[i2].toString());
            System.out.println("================End Blade (" + (i2 + 1) + ")================");
        }
        for (i2 = 0; i2 < this.cmmModules.length; ++i2) {
            System.out.println("================Start CMM Module (" + (i2 + 1) + ")================");
            System.out.println(this.cmmModules[i2].toString());
            System.out.println("================End CMM Module (" + (i2 + 1) + ")================");
        }
        for (i2 = 0; i2 < this.powerSupplies.length; ++i2) {
            System.out.println("================Start Power Supply (" + (i2 + 1) + ")================");
            System.out.println(this.powerSupplies[i2].toString());
            System.out.println("================End Power Supply (" + (i2 + 1) + ")================");
        }
        for (i2 = 0; i2 < this.gigabitSwitchs.length; ++i2) {
            System.out.println("================Start gigabit switch (" + (i2 + 1) + ")================");
            System.out.println(this.gigabitSwitchs[i2].toString());
            System.out.println("================End gigabit switch (" + (i2 + 1) + ")================");
        }
        for (i2 = 0; i2 < this.infiniBands.length; ++i2) {
            System.out.println("================Start InfiniBand (" + (i2 + 1) + ")================");
            System.out.println(this.infiniBands[i2].toString());
            System.out.println("================End InfiniBand (" + (i2 + 1) + ")================");
        }
    }

    private void divideDataForEachBlade(byte[] raw) {
        if (raw.length != this.blades.length * BLADE_DATA_SIZE) {
            return;
        }
        for (int i2 = 0; i2 < this.blades.length; ++i2) {
            byte[] aRaw = new byte[BLADE_DATA_SIZE];
            System.arraycopy(raw, i2 * BLADE_DATA_SIZE, aRaw, 0, BLADE_DATA_SIZE);
            this.blades[i2].fromRaw(aRaw);
        }
    }

    private void divideDataForEachBladeMisc(byte[] raw) {
        if (raw.length < 4) {
            return;
        }
        int dataSize = raw[0] + (raw[1] << 8);
        int bladeSize = raw[2] + (raw[3] << 8);
        for (int i2 = 0; i2 < this.blades.length; ++i2) {
            byte[] aRaw = new byte[dataSize];
            System.arraycopy(raw, 4 + i2 * dataSize, aRaw, 0, dataSize);
            this.blades[i2].getMiscEntity().fromRaw(aRaw);
        }
    }

    private void divideDataForEachCMMModule(byte[] raw) {
        if (raw.length != this.cmmModules.length * CMM_MODULE_DATA_SIZE) {
            return;
        }
        for (int i2 = 0; i2 < this.cmmModules.length; ++i2) {
            byte[] aRaw = new byte[CMM_MODULE_DATA_SIZE];
            System.arraycopy(raw, i2 * CMM_MODULE_DATA_SIZE, aRaw, 0, CMM_MODULE_DATA_SIZE);
            this.cmmModules[i2].fromRaw(aRaw);
        }
    }

    private void divideDataForEachPowerSupplyModule(byte[] raw) {
        if (raw.length != this.powerSupplies.length * POWER_SUPPLY_MODULE_DATA_SIZE) {
            return;
        }
        for (int i2 = 0; i2 < this.powerSupplies.length; ++i2) {
            byte[] aRaw = new byte[POWER_SUPPLY_MODULE_DATA_SIZE];
            System.arraycopy(raw, i2 * POWER_SUPPLY_MODULE_DATA_SIZE, aRaw, 0, POWER_SUPPLY_MODULE_DATA_SIZE);
            this.powerSupplies[i2].fromRaw(aRaw);
        }
    }

    private void divideDataForEachGigabitSwitchModule(byte[] raw) {
        if (raw.length != this.gigabitSwitchs.length * GIGABIT_SWITCH_MODULE_DATA_SIZE) {
            return;
        }
        for (int i2 = 0; i2 < this.gigabitSwitchs.length; ++i2) {
            byte[] aRaw = new byte[GIGABIT_SWITCH_MODULE_DATA_SIZE];
            System.arraycopy(raw, i2 * GIGABIT_SWITCH_MODULE_DATA_SIZE, aRaw, 0, GIGABIT_SWITCH_MODULE_DATA_SIZE);
            this.gigabitSwitchs[i2].fromRaw(aRaw);
        }
    }

    private void divideDataForEachInfiniBandModule(byte[] raw) {
        if (raw.length != this.infiniBands.length * INFINI_BAND_MODULE_DATA_SIZE) {
            return;
        }
        for (int i2 = 0; i2 < this.infiniBands.length; ++i2) {
            byte[] aRaw = new byte[INFINI_BAND_MODULE_DATA_SIZE];
            System.arraycopy(raw, i2 * INFINI_BAND_MODULE_DATA_SIZE, aRaw, 0, INFINI_BAND_MODULE_DATA_SIZE);
            this.infiniBands[i2].fromRaw(aRaw);
            this.tenGPassThrus[i2].fromRaw(aRaw);
            this.iBQDRs[i2].fromRaw(aRaw);
            this.tenGSwitches[i2].fromRaw(aRaw);
            this.iBFDRs[i2].fromRaw(aRaw);
        }
    }

    private void divideDataForEachMBSensor(byte[] raw) {
        if (raw.length != this.mbSensors.length * MOTHER_BOARD_SENSORS_DATA_SIZE) {
            return;
        }
        for (int i2 = 0; i2 < this.mbSensors.length; ++i2) {
            byte[] aRaw = new byte[MOTHER_BOARD_SENSORS_DATA_SIZE];
            System.arraycopy(raw, i2 * MOTHER_BOARD_SENSORS_DATA_SIZE, aRaw, 0, MOTHER_BOARD_SENSORS_DATA_SIZE);
            this.mbSensors[i2].fromRaw(aRaw);
        }
    }

    public void setEnableAllQuery(boolean enable) {
        this.isQueryBladeEntity = enable;
        this.isQueryCMMModuleEntity = enable;
        this.isQueryGigabitSwitchEntity = enable;
        this.isQueryInfiniBandEntity = enable;
        this.isQueryPowerSupplyEntity = enable;
        this.isQueryMBSensorEntity = enable;
        this.isQueryFrontLEDEntity = enable;
        this.isQueryFanControlMode = enable;
        this.isGenerateFailureReport = enable;
        this.isGetPowerConsumptionStatus = enable;
        this.isQueryBladeMiscEntity = enable;
    }

    private byte[] getPCA9xxxSlaveAddresses() {
        int size = this.blades.length;
        byte[] slaveAddrs = null;
        boolean bladeCount = true;
        IPMIMessage resMessage = this.ipmiCMMOEMCommand.getPCA9xxxSlaveAddrCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            slaveAddrs = new byte[size];
            for (int i2 = 0; i2 < size; ++i2) {
                slaveAddrs[i2] = resMessage.data[i2 * 11];
            }
        }
        return slaveAddrs;
    }

    private Vector getPCA955Infos(byte index) {
        int i2;
        Vector<byte[]> PCA9555Infos = null;
        if (!this.helpLogin()) {
            return null;
        }
        byte[] slaveAddrs = this.getPCA9xxxSlaveAddresses();
        if (slaveAddrs == null) {
            System.out.println("Get PCA9xxx Slave Addresses failed!");
            System.out.println("Use 0x40 as the slave address.");
            slaveAddrs = new byte[this.blades.length];
            for (i2 = 0; i2 < slaveAddrs.length; ++i2) {
                slaveAddrs[i2] = 32;
            }
        }
        PCA9555Infos = new Vector<byte[]>(this.blades.length);
        if (index == 0) {
            for (i2 = 0; i2 < this.blades.length; ++i2) {
                byte slaveAddr = (byte)(slaveAddrs[i2] * 2);
                IPMIMessage resMessage = this.ipmiCMMOEMCommand.getPCA9xxxInfoCommand((byte)(i2 + 1), slaveAddr);
                if (resMessage == null || resMessage.completionCode != 0) continue;
                PCA9555Infos.add(resMessage.data);
            }
        } else {
            byte slaveAddr = (byte)(slaveAddrs[index - 1] * 2);
            IPMIMessage resMessage = this.ipmiCMMOEMCommand.getPCA9xxxInfoCommand(index, slaveAddr);
            if (resMessage != null && resMessage.completionCode == 0) {
                PCA9555Infos.add(resMessage.data);
            }
        }
        this.helpLogout();
        return PCA9555Infos;
    }

    private Vector getPCA955statistics() {
        Vector<byte[]> statistics = null;
        if (!this.helpLogin()) {
            return null;
        }
        statistics = new Vector<byte[]>(this.blades.length);
        IPMIMessage resMessage = this.ipmiCMMOEMCommand.getPCA955StatisticCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            for (int i2 = 0; i2 < this.blades.length; ++i2) {
                byte[] aRaw = new byte[6];
                System.arraycopy(resMessage.data, i2 * 6, aRaw, 0, 6);
                statistics.add(aRaw);
            }
        }
        this.helpLogout();
        return statistics;
    }

    public void generateFailureReport() {
        double v12HighLimit;
        int i2;
        this.failures.clear();
        for (i2 = 0; i2 < this.blades.length; ++i2) {
            BladeEntity bladeEntity = this.blades[i2];
            AbstractMBSensorEntity mbSensor = this.mbSensors[i2];
            if (bladeEntity.getPresent() == 0) continue;
            if (bladeEntity.isError1LED()) {
                this.failures.add(this.generateBladeErrorLEDFailure(bladeEntity, i2));
            }
            if (bladeEntity.getI2cError() != 0) {
                // empty if block
            }
            this.failures.addAll(mbSensor.generateFailureReport(bladeEntity, i2));
        }
        for (i2 = 0; i2 < this.powerSupplies.length; ++i2) {
            PowerSupplyEntity powerSupplyEntity = this.powerSupplies[i2];
            if (powerSupplyEntity.getPresent() == 0 || powerSupplyEntity.getStatus() == 0) continue;
            if (powerSupplyEntity.getStatus() == 2) {
                this.failures.add(this.generatePowerSupplyPowerFailure(powerSupplyEntity, i2));
            }
            if (powerSupplyEntity.getI2cError() != 0) {
                // empty if block
            }
            int fan1RPM = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan1Speed());
            int fan1RPMLimit = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan1SpeedLowLimit());
            int fan2RPM = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan2Speed());
            int fan2RPMLimit = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan2SpeedLowLimit());
            int fan3RPM = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan3Speed());
            int fan3RPMLimit = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan3SpeedLowLimit());
            int fan4RPM = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan4Speed());
            int fan4RPMLimit = (int)powerSupplyEntity.fanRPMFormula(powerSupplyEntity.getFan4SpeedLowLimit());
            byte temp = powerSupplyEntity.getTemperature();
            byte tempLimit = powerSupplyEntity.getTemperatureHighLimit();
            if (fan1RPM <= fan1RPMLimit) {
                this.failures.add(this.generatePowerSupplyFanFailure(powerSupplyEntity, i2, 1, fan1RPM, fan1RPMLimit));
            }
            if (fan2RPM <= fan2RPMLimit) {
                this.failures.add(this.generatePowerSupplyFanFailure(powerSupplyEntity, i2, 2, fan2RPM, fan2RPMLimit));
            }
            if (fan3RPM <= fan3RPMLimit && powerSupplyEntity.getNumOfFans() == 4) {
                this.failures.add(this.generatePowerSupplyFanFailure(powerSupplyEntity, i2, 3, fan3RPM, fan3RPMLimit));
            }
            if (fan4RPM <= fan4RPMLimit && powerSupplyEntity.getNumOfFans() == 4) {
                this.failures.add(this.generatePowerSupplyFanFailure(powerSupplyEntity, i2, 4, fan4RPM, fan4RPMLimit));
            }
            if (temp >= tempLimit) {
                this.failures.add(this.generatePowerSupplyTemperatureFailure(powerSupplyEntity, i2, temp, tempLimit));
            }
            if (powerSupplyEntity.getDcCurrentLimit() != 0 && (double)powerSupplyEntity.getDcOuputCurrentFormula() > powerSupplyEntity.getDcCurrentLimitFormula()) {
                this.failures.add(this.generatePowerSupplyCurrentFailure(powerSupplyEntity, i2, "DC"));
            }
            if (powerSupplyEntity.getAcCurrentLimit() == 0 || !(powerSupplyEntity.getAcRMSCurrentFormula() > powerSupplyEntity.getAcCurrentLimitFormula())) continue;
            this.failures.add(this.generatePowerSupplyCurrentFailure(powerSupplyEntity, i2, "AC RMS"));
        }
        for (i2 = 0; i2 < this.gigabitSwitchs.length; ++i2) {
            GigabitSwitchEntity gigabitSwitchEntity = this.gigabitSwitchs[i2];
            if (gigabitSwitchEntity.getPresent() == 0 || !gigabitSwitchEntity.isPowerOn() || gigabitSwitchEntity.getP1v25() == 0 || gigabitSwitchEntity.getP2v5() == 0 || gigabitSwitchEntity.getFlag() == 1 || gigabitSwitchEntity.getFlag() == 4) continue;
            if (gigabitSwitchEntity.isError()) {
                this.failures.add(this.generateSwitchErrorLEDFailure(gigabitSwitchEntity, i2));
            }
            if (gigabitSwitchEntity.getInitialized() == 0) {
                this.failures.add(this.generateSwitchInitializedFailure(gigabitSwitchEntity, i2));
            }
            if (gigabitSwitchEntity.getBoardTemperature() >= 80) {
                // empty if block
            }
            if (gigabitSwitchEntity.getSwitchTemperature() >= 80) {
                this.failures.add(this.generateSwitchTemperatureFailure(gigabitSwitchEntity, i2, "Chip Temperature", "Chip temperature out of range "));
            }
            double p2v5 = gigabitSwitchEntity.p2v5Formula();
            double p2v5LowLimit = 2.25;
            double p2v5HighLimit = 2.75;
            double p1v25 = gigabitSwitchEntity.p1v25Formula();
            double p1v25LowLimit = 1.025;
            double p1v25HighLimit = 1.375;
            if (p2v5 <= p2v5LowLimit || p2v5 >= p2v5HighLimit) {
                this.failures.add(this.generateSwitchVoltageFailure(gigabitSwitchEntity, i2, "2.5V", "2.5V out of range"));
            }
            if (p1v25 <= p1v25LowLimit || p1v25 >= p1v25HighLimit) {
                this.failures.add(this.generateSwitchVoltageFailure(gigabitSwitchEntity, i2, "1.25V", "1.25V out of range"));
            }
            if (gigabitSwitchEntity.getI2cError() == 0) continue;
        }
        for (i2 = 0; i2 < this.cmmModules.length; ++i2) {
            CMMModuleEntity cmmModuleEntity = this.cmmModules[i2];
            if (cmmModuleEntity.getPresent() == 0 || cmmModuleEntity.getStatus() == 0) continue;
            this.failures.add(this.generateCMMStatusFailure(cmmModuleEntity, i2));
        }
        for (i2 = 0; i2 < this.infiniBands.length; ++i2) {
            InfiniBandEntity infiniBandEntity = this.infiniBands[i2];
            if (infiniBandEntity.getPresent() == 0 || infiniBandEntity.getFlag() != 1 || !infiniBandEntity.isPowerOn()) continue;
            if (infiniBandEntity.getInitialized() == 0) {
                this.failures.add(this.generateIBInitializedFailure(infiniBandEntity, i2));
            }
            if (infiniBandEntity.getTemperature() >= 80) {
                this.failures.add(this.generateIBTemperatureFailure(infiniBandEntity, i2, "Temperature", "Chip temperature out of range "));
            }
            double v33Aux = infiniBandEntity.getV33AuxFormula();
            double v33AuxLogLimit = 2.9699999999999998;
            double v33AuxHighLimit = 3.63;
            double vvdd = infiniBandEntity.getVvddFormula();
            double vvddLogLimit = 1.4400000000000002;
            double vvddHighLimit = 1.7600000000000002;
            double v33 = infiniBandEntity.getV33Formula();
            double v33LogLimit = 2.9699999999999998;
            double v33HighLimit = 3.63;
            double v18 = infiniBandEntity.getV18Formula();
            double v18LogLimit = 1.62;
            double v18HighLimit = 1.9800000000000002;
            double v12 = infiniBandEntity.getV12Formula();
            double v12LogLimit = 1.08;
            double v12HighLimit2 = 1.32;
            if (v33Aux <= v33AuxLogLimit || v33Aux >= v33AuxHighLimit) {
                this.failures.add(this.generateIBVoltageFailure(infiniBandEntity, i2, "3.3V Aux", "3.3V Aux out of range"));
            }
            if (vvdd <= vvddLogLimit || vvdd >= vvddHighLimit) {
                this.failures.add(this.generateIBVoltageFailure(infiniBandEntity, i2, "VVDD", "VVDD out of range"));
            }
            if (v33 <= v33LogLimit || v33 >= v33HighLimit) {
                this.failures.add(this.generateIBVoltageFailure(infiniBandEntity, i2, "3.3V ", "3.3V out of range"));
            }
            if (v18 <= v18LogLimit || v18 >= v18HighLimit) {
                this.failures.add(this.generateIBVoltageFailure(infiniBandEntity, i2, "1.8V ", "1.8V out of range"));
            }
            if (v12 <= v12LogLimit || v12 >= v12HighLimit2) {
                this.failures.add(this.generateIBVoltageFailure(infiniBandEntity, i2, "1.2V ", "1.2V out of range"));
            }
            if (infiniBandEntity.getI2cError() == 0) continue;
        }
        for (i2 = 0; i2 < this.tenGPassThrus.length; ++i2) {
            TenGPassThruEntity tenGPassThruEntity = this.tenGPassThrus[i2];
            if (tenGPassThruEntity.getPresent() == 0 || tenGPassThruEntity.getType() != 1) continue;
            if (tenGPassThruEntity.getTemp_1v25() >= 80) {
                this.failures.add(this.generate10GTemperatureFailure(tenGPassThruEntity, i2, "Temperature", "Temp. VR1.25V temperature out of range "));
            }
            if (tenGPassThruEntity.getTemp_3v3() >= 80) {
                this.failures.add(this.generate10GTemperatureFailure(tenGPassThruEntity, i2, "Temperature", "Temp. VR3.3V temperature out of range "));
            }
            double v33 = tenGPassThruEntity.getVram_3v3Formula();
            double v33LogLimit = 2.9699999999999998;
            double v33HighLimit = 3.63;
            double v12 = tenGPassThruEntity.getVcore_1v2Formula();
            double v12LogLimit = 1.08;
            v12HighLimit = 1.32;
            if (v33 <= v33LogLimit || v33 >= v33HighLimit) {
                this.failures.add(this.generate10GVoltageFailure(tenGPassThruEntity, i2, "3.3V", "3.3V out of range"));
            }
            if (v12 <= v12LogLimit || v12 >= v12HighLimit) {
                this.failures.add(this.generate10GVoltageFailure(tenGPassThruEntity, i2, "1.2V", "1.2V out of range"));
            }
            if (tenGPassThruEntity.getI2cError() == 0) continue;
        }
        for (i2 = 0; i2 < this.iBQDRs.length; ++i2) {
            IBQDREntity iBQDREntity = this.iBQDRs[i2];
            if (iBQDREntity.getPresent() == 0 || !iBQDREntity.isIBQDR() || !iBQDREntity.isPowerOn()) continue;
            if (iBQDREntity.getSwitchTemp() >= 80) {
                this.failures.add(this.generateIBQDRTemperatureFailure(iBQDREntity, i2, "Temperature", "Temp. Switch temperature out of range "));
            }
            if (iBQDREntity.getBoardTemp() >= 80) {
                this.failures.add(this.generateIBQDRTemperatureFailure(iBQDREntity, i2, "Temperature", "Temp. board temperature out of range "));
            }
            double v33 = iBQDREntity.getP3v3Formula();
            double v33LogLimit = 2.9699999999999998;
            double v33HighLimit = 3.63;
            double v12 = iBQDREntity.getP1v25Formula();
            double v12LogLimit = 1.08;
            v12HighLimit = 1.32;
            if (v33 <= v33LogLimit || v33 >= v33HighLimit) {
                this.failures.add(this.generateIBQDRVoltageFailure(iBQDREntity, i2, "3.3V", "3.3V out of range"));
            }
            if (v12 <= v12LogLimit || v12 >= v12HighLimit) {
                this.failures.add(this.generateIBQDRVoltageFailure(iBQDREntity, i2, "1.25V", "1.25V out of range"));
            }
            if (iBQDREntity.getI2cError() == 0) continue;
        }
        for (i2 = 0; i2 < this.iBFDRs.length; ++i2) {
            IBFDREntity iBFDREntity = this.iBFDRs[i2];
            if (iBFDREntity.getPresent() == 0 || !iBFDREntity.isIBFDR() || !iBFDREntity.isPowerOn()) continue;
            if (iBFDREntity.getSwitchTempFormula() >= 80) {
                this.failures.add(this.generateIBFDRTemperatureFailure(iBFDREntity, i2, "Temperature", "Temp. Switch temperature out of range "));
            }
            if (iBFDREntity.getBoardTempFormula() >= 80) {
                this.failures.add(this.generateIBFDRTemperatureFailure(iBFDREntity, i2, "Temperature", "Temp. board temperature out of range "));
            }
            double v33 = iBFDREntity.getP3v3Formula();
            double v33LogLimit = 2.9699999999999998;
            double v33HighLimit = 3.63;
            double v12 = iBFDREntity.getP1v25Formula();
            double v12LogLimit = 1.08;
            v12HighLimit = 1.32;
            double v09 = iBFDREntity.getP0v9Formula();
            double v09LogLimit = 0.81;
            double v09HighLimit = 0.9900000000000001;
            if (v33 <= v33LogLimit || v33 >= v33HighLimit) {
                this.failures.add(this.generateIBFDRVoltageFailure(iBFDREntity, i2, "3.3V", "3.3V out of range"));
            }
            if (v12 <= v12LogLimit || v12 >= v12HighLimit) {
                this.failures.add(this.generateIBFDRVoltageFailure(iBFDREntity, i2, "1.25V", "1.25V out of range"));
            }
            if (v09 <= v09LogLimit || v09 >= v09HighLimit) {
                this.failures.add(this.generateIBFDRVoltageFailure(iBFDREntity, i2, "1.25V", "1.25V out of range"));
            }
            if (iBFDREntity.getI2cError() == 0) continue;
        }
        for (i2 = 0; i2 < this.tenGSwitches.length; ++i2) {
            TenGSwitchEntity tenGSwitchEntity = this.tenGSwitches[i2];
            if (tenGSwitchEntity.getPresent() == 0 || !tenGSwitchEntity.is10GSwitch()) continue;
            if (tenGSwitchEntity.getBoardTemperature() >= 80) {
                this.failures.add(this.generate10GSWTemperatureFailure(tenGSwitchEntity, i2, "Temperature", "Temp. Board temperature out of range "));
            }
            if (tenGSwitchEntity.getSwitchTemperature() >= 80) {
                this.failures.add(this.generate10GSWTemperatureFailure(tenGSwitchEntity, i2, "Temperature", "Temp. Switch temperature out of range "));
            }
            double v33 = tenGSwitchEntity.p3v3Formula();
            double v33LogLimit = 2.9699999999999998;
            double v33HighLimit = 3.63;
            double v125 = tenGSwitchEntity.p1v25Formula();
            double v125LowLimit = 1.125;
            double v125HighLimit = 1.375;
            if (v33 <= v33LogLimit || v33 >= v33HighLimit) {
                this.failures.add(this.generate10GSWVoltageFailure(tenGSwitchEntity, i2, "3.3V", "3.3V out of range"));
            }
            if (v125 <= v125LowLimit || v125 >= v125HighLimit) {
                this.failures.add(this.generate10GSWVoltageFailure(tenGSwitchEntity, i2, "1.25V", "1.25V out of range"));
            }
            if (tenGSwitchEntity.getI2cError() == 0) continue;
        }
    }

    public String doubleToString(double value) {
        int temp = (int)(value * 100.0);
        double d2 = (double)temp / 100.0;
        return "" + d2;
    }

    private FailureEntity generateBladePowerFailure(BladeEntity bladeEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(bladeEntity);
        failureEntity.setSource("Blade " + (moduleIndex + 1));
        failureEntity.setFailureItem("Power");
        failureEntity.setFailureDetail(L.t("cmm.error.Power_Failure"));
        return failureEntity;
    }

    private FailureEntity generateBladeSensorFailure(BladeEntity bladeEntity, int moduleIndex, String sensor) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(bladeEntity);
        failureEntity.setSource("Blade " + (moduleIndex + 1));
        failureEntity.setFailureItem(sensor);
        failureEntity.setFailureDetail(L.t("cmm.error.Reading_out_of_range"));
        return failureEntity;
    }

    private FailureEntity generateBladeErrorLEDFailure(BladeEntity bladeEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(bladeEntity);
        failureEntity.setSource("Blade " + (moduleIndex + 1));
        failureEntity.setFailureItem(L.t("cmm.error.Error_LED"));
        failureEntity.setFailureDetail(L.t("cmm.error.Error"));
        return failureEntity;
    }

    private FailureEntity generatePowerSupplyPowerFailure(PowerSupplyEntity powerSupplyEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(powerSupplyEntity);
        failureEntity.setSource("Power Supply " + (moduleIndex + 1));
        failureEntity.setFailureItem("Power Supply");
        failureEntity.setFailureDetail(L.t("cmm.error.Power_supply_power_failure"));
        return failureEntity;
    }

    private FailureEntity generatePowerSupplyFanFailure(PowerSupplyEntity powerSupplyEntity, int moduleIndex, int fanIndex, int fanRPM, int fanLowLimitRPM) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(powerSupplyEntity);
        failureEntity.setSource("Power Supply " + (moduleIndex + 1));
        if (fanIndex == 1 || fanIndex == 2) {
            failureEntity.setFailureItem(L.t("cmm.error.Fan") + " " + fanIndex);
            failureEntity.setFailureDetail(L.t("cmm.error.Fan_speed_out_of_range") + " ");
        } else {
            failureEntity.setFailureItem("Fan set");
            failureEntity.setFailureDetail(L.t("cmm.error.Fan_speed_out_of_range") + " ");
        }
        return failureEntity;
    }

    private FailureEntity generatePowerSupplyTemperatureFailure(PowerSupplyEntity powerSupplyEntity, int moduleIndex, int temp, int tempHighLimit) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(powerSupplyEntity);
        failureEntity.setSource("Power Supply " + (moduleIndex + 1));
        failureEntity.setFailureItem(L.t("cmm.error.Temperature") + " ");
        failureEntity.setFailureDetail(L.t("cmm.error.Temperature_out_of_range") + " ");
        return failureEntity;
    }

    private FailureEntity generatePowerSupplyCurrentFailure(PowerSupplyEntity powerSupplyEntity, int moduleIndex, String currentType) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(powerSupplyEntity);
        failureEntity.setSource("Power Supply " + (moduleIndex + 1));
        failureEntity.setFailureItem(currentType);
        failureEntity.setFailureDetail(currentType + " " + L.t("cmm.error.out_of_range"));
        return failureEntity;
    }

    private FailureEntity generateSwitchErrorLEDFailure(GigabitSwitchEntity gigabitSwitchEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(gigabitSwitchEntity);
        failureEntity.setSource("Gigabit Switch " + (moduleIndex + 1));
        failureEntity.setFailureItem(L.t("cmm.error.Error_LED"));
        failureEntity.setFailureDetail(L.t("cmm.error.Error"));
        return failureEntity;
    }

    private FailureEntity generateSwitchInitializedFailure(GigabitSwitchEntity gigabitSwitchEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(gigabitSwitchEntity);
        failureEntity.setSource("Gigabit Switch " + (moduleIndex + 1));
        failureEntity.setFailureItem("Gigabit Switch");
        failureEntity.setFailureDetail(L.t("cmm.error.Initialized_Failed"));
        return failureEntity;
    }

    private FailureEntity generateSwitchVoltageFailure(GigabitSwitchEntity gigabitSwitchEntity, int moduleIndex, String volName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(gigabitSwitchEntity);
        failureEntity.setSource("Gigabit Switch " + (moduleIndex + 1));
        failureEntity.setFailureItem(volName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generateSwitchTemperatureFailure(GigabitSwitchEntity gigabitSwitchEntity, int moduleIndex, String tempName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(gigabitSwitchEntity);
        failureEntity.setSource("Gigabit Switch " + (moduleIndex + 1));
        failureEntity.setFailureItem(tempName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generateCMMStatusFailure(CMMModuleEntity cmmModuleEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(cmmModuleEntity);
        failureEntity.setSource("CMM " + (moduleIndex + 1));
        failureEntity.setFailureItem("CMM");
        failureEntity.setFailureDetail(L.t("cmm.error.failure"));
        return failureEntity;
    }

    private FailureEntity generateI2CFailure(Object moduleEntity, String moduleName, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(1);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(moduleEntity);
        failureEntity.setSource(moduleName + " " + (moduleIndex + 1));
        failureEntity.setFailureItem(moduleName);
        failureEntity.setFailureDetail(L.t("cmm.error.I2C_communcation_failed"));
        return failureEntity;
    }

    private FailureEntity generateIBInitializedFailure(InfiniBandEntity infiniBandEntity, int moduleIndex) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(infiniBandEntity);
        failureEntity.setSource("InfiniBand " + (moduleIndex + 1));
        failureEntity.setFailureItem("InfiniBand");
        failureEntity.setFailureDetail(L.t("cmm.error.Initialized_Failed"));
        return failureEntity;
    }

    private FailureEntity generateIBVoltageFailure(InfiniBandEntity infiniBandEntity, int moduleIndex, String volName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(infiniBandEntity);
        failureEntity.setSource("InfiniBand " + (moduleIndex + 1));
        failureEntity.setFailureItem(volName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generateIBTemperatureFailure(InfiniBandEntity infiniBandEntity, int moduleIndex, String tempName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(infiniBandEntity);
        failureEntity.setSource("InfiniBand " + (moduleIndex + 1));
        failureEntity.setFailureItem(tempName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generate10GTemperatureFailure(TenGPassThruEntity tenGPassThruEntity, int moduleIndex, String tempName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(tenGPassThruEntity);
        failureEntity.setSource("10G Pass Thru " + (moduleIndex + 1));
        failureEntity.setFailureItem(tempName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generate10GVoltageFailure(TenGPassThruEntity tenGPassThruEntity, int moduleIndex, String volName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(tenGPassThruEntity);
        failureEntity.setSource("10G Pass Thru " + (moduleIndex + 1));
        failureEntity.setFailureItem(volName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generate10GSWTemperatureFailure(TenGSwitchEntity tenGSwitchEntity, int moduleIndex, String tempName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(tenGSwitchEntity);
        failureEntity.setSource("10G SW " + (moduleIndex + 1));
        failureEntity.setFailureItem(tempName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generate10GSWVoltageFailure(TenGSwitchEntity tenGSwitchEntity, int moduleIndex, String volName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(tenGSwitchEntity);
        failureEntity.setSource("10G SW " + (moduleIndex + 1));
        failureEntity.setFailureItem(volName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generateIBQDRTemperatureFailure(IBQDREntity iBQDREntity, int moduleIndex, String tempName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(iBQDREntity);
        failureEntity.setSource("IBQDR " + (moduleIndex + 1));
        failureEntity.setFailureItem(tempName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generateIBQDRVoltageFailure(IBQDREntity iBQDREntity, int moduleIndex, String volName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(iBQDREntity);
        failureEntity.setSource("IBQDR " + (moduleIndex + 1));
        failureEntity.setFailureItem(volName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generateIBFDRTemperatureFailure(IBFDREntity iBFDREntity, int moduleIndex, String tempName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(iBFDREntity);
        failureEntity.setSource("IBFDR " + (moduleIndex + 1));
        failureEntity.setFailureItem(tempName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    private FailureEntity generateIBFDRVoltageFailure(IBFDREntity iBFDREntity, int moduleIndex, String volName, String detail) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(iBFDREntity);
        failureEntity.setSource("IBFDR " + (moduleIndex + 1));
        failureEntity.setFailureItem(volName);
        failureEntity.setFailureDetail(detail);
        return failureEntity;
    }

    public String getDataTimeString() {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat f2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
        return f2.format(date);
    }

    public BladeEntity[] getBlades() {
        return this.blades;
    }

    public CMMModuleEntity[] getCmmModules() {
        return this.cmmModules;
    }

    public GigabitSwitchEntity[] getGigabitSwitchs() {
        return this.gigabitSwitchs;
    }

    public InfiniBandEntity[] getInfiniBands() {
        return this.infiniBands;
    }

    public PowerSupplyEntity[] getPowerSupplies() {
        return this.powerSupplies;
    }

    public TenGPassThruEntity[] getTenGPassThrus() {
        return this.tenGPassThrus;
    }

    public IBQDREntity[] getIBQDRs() {
        return this.iBQDRs;
    }

    public IBFDREntity[] getIBFDRs() {
        return this.iBFDRs;
    }

    public TenGSwitchEntity[] getTenGSwitches() {
        return this.tenGSwitches;
    }

    public int getPoolingInterval() {
        return this.poolingInterval;
    }

    public ArrayList getFailures() {
        return this.failures;
    }

    public AbstractMBSensorEntity[] getMbSensors() {
        return this.mbSensors;
    }

    public FrontLEDEntity getFrontLED() {
        return this.frontLED;
    }

    public boolean isIsBladeEntityAvailable() {
        return this.isBladeEntityAvailable;
    }

    public boolean isIsCMMModuleEntityAvailable() {
        return this.isCMMModuleEntityAvailable;
    }

    public boolean isIsFrontLEDEntityAvailable() {
        return this.isFrontLEDEntityAvailable;
    }

    public boolean isIsGigabitSwitchEntityAvailable() {
        return this.isGigabitSwitchEntityAvailable;
    }

    public boolean isIsInfiniBandEntityAvailable() {
        return this.isInfiniBandEntityAvailable;
    }

    public boolean isIsLoginSuccessful() {
        return this.isLoginSuccessful;
    }

    public boolean isIsLogoutSuccessful() {
        return this.isLogoutSuccessful;
    }

    public boolean isIsBladeMiscEntityAvailable() {
        return this.isBladeMiscEntityAvailable;
    }

    public boolean isIsMBSensorEntityAvailable() {
        return this.isMBSensorEntityAvailable;
    }

    public boolean isIsPowerSupplyEntityAvailable() {
        return this.isPowerSupplyEntityAvailable;
    }

    public byte getFanControlMode() {
        return this.fanControlMode;
    }

    public boolean isIsSupportIPMB() {
        return this.isSupportIPMB;
    }

    public boolean getIsMaster() {
        return this.isMaster;
    }

    public boolean isUseExistConnection() {
        return this.useExistConnection;
    }

    public IPMICMMOEMCommand.PowerConsumptionStatus getPowerConsumptionStatus() {
        return this.powerConsumptionStatus;
    }

    public boolean isIfCheckOnlyOneTime() {
        return this.ifCheckOnlyOneTime;
    }

    public void setPoolingInterval(int poolingInterval) {
        this.poolingInterval = poolingInterval;
    }

    public void setIsQueryBladeEntity(boolean isQueryBladeEntity) {
        this.isQueryBladeEntity = isQueryBladeEntity;
    }

    public void setIsQueryCMMModuleEntity(boolean isQueryCMMModuleEntity) {
        this.isQueryCMMModuleEntity = isQueryCMMModuleEntity;
    }

    public void setIsQueryFanControlMode(boolean isQueryFanControlMode) {
        this.isQueryFanControlMode = isQueryFanControlMode;
    }

    public void setIsQueryFrontLEDEntity(boolean isQueryFrontLEDEntity) {
        this.isQueryFrontLEDEntity = isQueryFrontLEDEntity;
    }

    public void setIsQueryGigabitSwitchEntity(boolean isQueryGigabitSwitchEntity) {
        this.isQueryGigabitSwitchEntity = isQueryGigabitSwitchEntity;
    }

    public void setIsQueryInfiniBandEntity(boolean isQueryInfiniBandEntity) {
        this.isQueryInfiniBandEntity = isQueryInfiniBandEntity;
    }

    public void setIsQueryMBSensorEntity(boolean isQueryMBSensorEntity) {
        this.isQueryMBSensorEntity = isQueryMBSensorEntity;
    }

    public void setIsQueryPowerSupplyEntity(boolean isQueryPowerSupplyEntity) {
        this.isQueryPowerSupplyEntity = isQueryPowerSupplyEntity;
    }

    public void setIsGenerateFailureReport(boolean isGenerateFailureReport) {
        this.isGenerateFailureReport = isGenerateFailureReport;
    }

    public void setUseExistConnection(boolean useExistConnection) {
        this.useExistConnection = useExistConnection;
    }

    public void setIpmiCMMOEMCommand(IPMICMMOEMCommand ipmiCMMOEMCommand) {
        this.ipmiCMMOEMCommand = ipmiCMMOEMCommand;
    }

    public void setIfCheckOnlyOneTime(boolean ifCheckOnlyOneTime) {
        this.ifCheckOnlyOneTime = ifCheckOnlyOneTime;
    }

    public void setIsQueryBladeMiscEntity(boolean isQueryBladeMiscEntity) {
        this.isQueryBladeMiscEntity = isQueryBladeMiscEntity;
    }

    public void presentAllForTest() {
        int i2;
        for (i2 = 0; i2 < this.blades.length; ++i2) {
            this.blades[i2].setPresent((byte)1);
        }
        for (i2 = 0; i2 < this.cmmModules.length; ++i2) {
            this.cmmModules[i2].setPresent((byte)1);
        }
        for (i2 = 0; i2 < this.gigabitSwitchs.length; ++i2) {
            this.gigabitSwitchs[i2].setPresent((byte)1);
        }
        for (i2 = 0; i2 < this.infiniBands.length; ++i2) {
            this.infiniBands[i2].setPresent((byte)1);
        }
        for (i2 = 0; i2 < this.powerSupplies.length; ++i2) {
            this.powerSupplies[i2].setPresent((byte)1);
        }
    }

    public String toBladeFormatedString() {
        BladeEntity b2;
        int i2;
        StringBuffer sb = new StringBuffer();
        int bladeCount = 0;
        for (i2 = 0; i2 < this.getBlades().length; ++i2) {
            b2 = this.getBlades()[i2];
            if (b2.getPresent() <= 0) continue;
            ++bladeCount;
        }
        if (bladeCount > 0) {
            sb.append("Blade Module (" + bladeCount + "/" + this.getBlades().length + ")\n");
            sb.append("--------------------\n");
            sb.append(this.getBlades()[0].toFormatedHeader());
            for (i2 = 0; i2 < this.getBlades().length; ++i2) {
                b2 = this.getBlades()[i2];
                sb.append(b2.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String toGigabitSwitchFormatedString() {
        GigabitSwitchEntity g2;
        int i2;
        StringBuffer sb = new StringBuffer();
        int gbCount = 0;
        for (i2 = 0; i2 < this.getGigabitSwitchs().length; ++i2) {
            g2 = this.getGigabitSwitchs()[i2];
            if (g2.getPresent() <= 0 || g2.getInitialized() != 1) continue;
            ++gbCount;
        }
        if (gbCount > 0) {
            sb.append("Gigabit Switch Module (" + gbCount + "/" + this.getGigabitSwitchs().length + ")\n");
            sb.append("------------------------\n");
            sb.append(this.getGigabitSwitchs()[0].toFormatedHeader());
            for (i2 = 0; i2 < this.getGigabitSwitchs().length; ++i2) {
                g2 = this.getGigabitSwitchs()[i2];
                sb.append(g2.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String toPowerSupplyFormatedString() {
        PowerSupplyEntity p;
        int i2;
        StringBuffer sb = new StringBuffer();
        int powerCount = 0;
        for (i2 = 0; i2 < this.getPowerSupplies().length; ++i2) {
            p = this.getPowerSupplies()[i2];
            if (p.getPresent() <= 0) continue;
            ++powerCount;
        }
        if (powerCount > 0) {
            sb.append("Power Supply Module (" + powerCount + "/" + this.getPowerSupplies().length + ")\n");
            sb.append("--------------------------\n");
            sb.append(this.getPowerSupplies()[0].toFormatedHeader());
            for (i2 = 0; i2 < this.getPowerSupplies().length; ++i2) {
                p = this.getPowerSupplies()[i2];
                sb.append(p.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String toInfiniBandFormatedString() {
        TenGSwitchEntity tenGSwitchEntity;
        InfiniBandEntity ib;
        int i2;
        StringBuffer sb = new StringBuffer();
        int ibCount = 0;
        for (i2 = 0; i2 < this.getInfiniBands().length; ++i2) {
            ib = this.getInfiniBands()[i2];
            tenGSwitchEntity = this.getTenGSwitches()[i2];
            if (ib.getPresent() <= 0 || ib.getReserve3() != 0 || (ib.getFlag() & 0xFE) != 0 || tenGSwitchEntity.is10GSwitch() || ib.getInitialized() != 1) continue;
            ++ibCount;
        }
        if (ibCount > 0) {
            sb.append("Infiniband Module (" + ibCount + "/" + this.getInfiniBands().length + ")\n");
            sb.append("------------------------\n");
            sb.append(this.getInfiniBands()[0].toFormatedHeader());
            for (i2 = 0; i2 < this.getInfiniBands().length; ++i2) {
                ib = this.getInfiniBands()[i2];
                tenGSwitchEntity = this.getTenGSwitches()[i2];
                if (ib.getPresent() <= 0 || ib.getReserve3() != 0 || (ib.getFlag() & 0xFE) != 0 || tenGSwitchEntity.is10GSwitch() || ib.getInitialized() != 1) continue;
                sb.append(ib.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String to10gPassThruFormatedString() {
        int i2;
        StringBuffer sb = new StringBuffer();
        int ten10gCount = 0;
        for (i2 = 0; i2 < this.getTenGPassThrus().length; ++i2) {
            TenGPassThruEntity tenGPassThru = this.getTenGPassThrus()[i2];
            if (tenGPassThru.getPresent() <= 0 || tenGPassThru.getType() != 1) continue;
            ++ten10gCount;
        }
        if (ten10gCount > 0) {
            sb.append("10G Pass Thru Module (" + ten10gCount + "/" + this.getTenGPassThrus().length + ")\n");
            sb.append("------------------------\n");
            sb.append(this.getTenGPassThrus()[0].toFormatedHeader());
            for (i2 = 0; i2 < this.getTenGPassThrus().length; ++i2) {
                TenGPassThruEntity e2 = this.getTenGPassThrus()[i2];
                sb.append(e2.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String toIBQDRFormatedString() {
        int i2;
        StringBuffer sb = new StringBuffer();
        int ibQDRCount = 0;
        for (i2 = 0; i2 < this.getIBQDRs().length; ++i2) {
            IBQDREntity ibQDR = this.getIBQDRs()[i2];
            if (ibQDR.getPresent() <= 0 || !ibQDR.isIBQDR() && !ibQDR.isIBQDRPassThru()) continue;
            ++ibQDRCount;
        }
        if (ibQDRCount > 0) {
            sb.append("IBQDR Module (" + ibQDRCount + "/" + this.getIBQDRs().length + ")\n");
            sb.append("------------------------\n");
            sb.append(this.getIBQDRs()[0].toFormatedHeader());
            for (i2 = 0; i2 < this.getIBQDRs().length; ++i2) {
                IBQDREntity e2 = this.getIBQDRs()[i2];
                if ((e2.getFlag() & 4) == 4) {
                    sb.append(e2.toFormatedString());
                    continue;
                }
                if ((e2.getFlag() & 2) != 2) continue;
                sb.append("IB Pass thru\n");
            }
        }
        return sb.toString();
    }

    public String toIBFDRFormatedString() {
        int i2;
        StringBuffer sb = new StringBuffer();
        int ibFDRCount = 0;
        for (i2 = 0; i2 < this.getIBFDRs().length; ++i2) {
            IBFDREntity ibFDR = this.getIBFDRs()[i2];
            if (ibFDR.getPresent() <= 0 || !ibFDR.isIBFDR()) continue;
            ++ibFDRCount;
        }
        if (ibFDRCount > 0) {
            sb.append("IBFDR Module (" + ibFDRCount + "/" + this.getIBFDRs().length + ")\n");
            sb.append("------------------------\n");
            sb.append(this.getIBFDRs()[0].toFormatedHeader());
            for (i2 = 0; i2 < this.getIBFDRs().length; ++i2) {
                IBFDREntity e2 = this.getIBFDRs()[i2];
                sb.append(e2.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String to10gSwitchString() {
        int i2;
        StringBuffer sb = new StringBuffer();
        int tenGSwitchCount = 0;
        for (i2 = 0; i2 < this.getTenGSwitches().length; ++i2) {
            TenGSwitchEntity tenGSwitchEntity = this.getTenGSwitches()[i2];
            if (tenGSwitchEntity.getPresent() <= 0 || !tenGSwitchEntity.is10GSwitch()) continue;
            ++tenGSwitchCount;
        }
        if (tenGSwitchCount > 0) {
            sb.append("10G Switch (" + tenGSwitchCount + "/" + this.getTenGSwitches().length + ")\n");
            sb.append("------------------------\n");
            sb.append(this.getTenGSwitches()[0].toFormatedHeader());
            for (i2 = 0; i2 < this.getTenGSwitches().length; ++i2) {
                TenGSwitchEntity e2 = this.getTenGSwitches()[i2];
                if (e2.getPresent() <= 0 || !e2.is10GSwitch()) continue;
                sb.append(e2.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String toCMMFormatedString() {
        int i2;
        StringBuffer sb = new StringBuffer();
        int cmmCount = 0;
        for (i2 = 0; i2 < this.getCmmModules().length; ++i2) {
            CMMModuleEntity cmm = this.getCmmModules()[i2];
            if (cmm.getPresent() <= 0) continue;
            ++cmmCount;
        }
        if (cmmCount > 0) {
            sb.append("CMM Module(" + cmmCount + "/" + this.getCmmModules().length + ")\n");
            sb.append("----------------\n");
            sb.append(this.getCmmModules()[0].toFormatedHeader());
            for (i2 = 0; i2 < this.getCmmModules().length; ++i2) {
                CMMModuleEntity e2 = this.getCmmModules()[i2];
                sb.append(e2.toFormatedString());
            }
        }
        return sb.toString();
    }

    public String toFormatedString() {
        StringBuffer sb = new StringBuffer();
        String s1 = this.toBladeFormatedString();
        String s2 = this.toGigabitSwitchFormatedString();
        String s3 = this.toPowerSupplyFormatedString();
        String s4 = this.to10gPassThruFormatedString();
        String s5 = this.toInfiniBandFormatedString();
        String s6 = this.toIBQDRFormatedString();
        String s6_1 = this.toIBFDRFormatedString();
        String s7 = this.to10gSwitchString();
        String s8 = this.toCMMFormatedString();
        sb.append(s1 + (s1.length() != 0 ? "\n" : ""));
        sb.append(s2 + (s2.length() != 0 ? "\n" : ""));
        sb.append(s3 + (s3.length() != 0 ? "\n" : ""));
        sb.append(s4 + (s4.length() != 0 ? "\n" : ""));
        sb.append(s5 + (s5.length() != 0 ? "\n" : ""));
        sb.append(s6 + (s6.length() != 0 ? "\n" : ""));
        sb.append(s6_1 + (s6_1.length() != 0 ? "\n" : ""));
        sb.append(s7 + (s7.length() != 0 ? "\n" : ""));
        sb.append(s8);
        return sb.toString();
    }

    public static void main(String[] args) {
        String ip = "";
        String id = "ADMIN";
        String pw = "ADMIN";
        String module = "";
        int index = 0;
        int number = 1;
        boolean infinite = false;
        if (args.length != 5 && args.length != 6) {
            System.out.println("BladeSystemEntity Build:070710");
            System.out.println("Usage: BladeSystemEntity IP USERNAME PASSWORD MODULE_NAME INDEX [number]");
            System.out.println("  IP:          IP address of CMM");
            System.out.println("  USERNAME:    username");
            System.out.println("  PASSWORD:    password");
            System.out.println("  MODULE_NAME: b(Blade),c(CMM),g(Gigabit Switch),");
            System.out.println("               i(Infiniband),p(Power Supply),s(MB sensors),l(front LED),");
            System.out.println("               a(PCA955 informations), t(PCA955 Can't match statistics)");
            System.out.println("  INDEX:       1-based index number of module. Use 0 for all ");
            System.out.println("  number:      run number of this command. Use 0 for infinite times (Ctr-C to stop).");
            System.exit(0);
        }
        ip = args[0];
        id = args[1];
        pw = args[2];
        module = args[3];
        try {
            index = Integer.parseInt(args[4]);
        }
        catch (NumberFormatException ex1) {
            System.out.println("INDEX parameter error");
            System.exit(0);
        }
        if (args.length == 6) {
            try {
                number = Integer.parseInt(args[5]);
            }
            catch (NumberFormatException ex1) {
                System.out.println("[number] parameter error");
                System.exit(0);
            }
        }
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(id);
        config.setPassword(pw);
        config.setPrivilege((byte)4);
        BladeSystemEntity bladeSystem = new BladeSystemEntity(config);
        if (number == 0) {
            number = 2;
            infinite = true;
        }
        int i2 = 0;
        while (i2 < number) {
            bladeSystem.getData();
            if (module.equalsIgnoreCase("b")) {
                if (index != 0) {
                    System.out.print("===== Blade " + index + ":");
                    System.out.println(bladeSystem.blades[index - 1].toString());
                } else {
                    for (int j2 = 0; j2 < bladeSystem.blades.length; ++j2) {
                        System.out.print("===== Blade " + (j2 + 1) + ":");
                        System.out.println(bladeSystem.blades[j2].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("c")) {
                if (index != 0) {
                    System.out.print("===== CMM " + index + ":");
                    System.out.println(bladeSystem.cmmModules[index - 1].toString());
                } else {
                    for (int j3 = 0; j3 < bladeSystem.cmmModules.length; ++j3) {
                        System.out.print("===== CMM " + (j3 + 1) + ":");
                        System.out.println(bladeSystem.cmmModules[j3].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("g")) {
                if (index != 0) {
                    System.out.print("===== Gigabit Switch " + index + ":");
                    System.out.println(bladeSystem.gigabitSwitchs[index - 1].toString());
                } else {
                    for (int j4 = 0; j4 < bladeSystem.gigabitSwitchs.length; ++j4) {
                        System.out.print("===== Gigabit Switch " + (j4 + 1) + ":");
                        System.out.println(bladeSystem.gigabitSwitchs[j4].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("i")) {
                if (index != 0) {
                    System.out.print("===== InfiniBand " + index + ":");
                    System.out.println(bladeSystem.infiniBands[index - 1].toString());
                    System.out.print("===== 10G pass thru " + index + ":");
                    System.out.println(bladeSystem.tenGPassThrus[index - 1].toString());
                    System.out.print("===== 10G Switch " + index + ":");
                    System.out.println(bladeSystem.tenGSwitches[index - 1].toString());
                } else {
                    for (int j5 = 0; j5 < bladeSystem.infiniBands.length; ++j5) {
                        System.out.print("===== InfiniBand " + (j5 + 1) + ":");
                        System.out.println(bladeSystem.infiniBands[j5].toString());
                        System.out.print("===== 10G pass thru " + (j5 + 1) + ":");
                        System.out.println(bladeSystem.tenGPassThrus[j5].toString());
                        System.out.print("===== 10G Switch " + (j5 + 1) + ":");
                        System.out.println(bladeSystem.tenGSwitches[j5].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("p")) {
                if (index != 0) {
                    System.out.print("===== Power Supply " + index + ":");
                    System.out.println(bladeSystem.powerSupplies[index - 1].toString());
                } else {
                    for (int j6 = 0; j6 < bladeSystem.powerSupplies.length; ++j6) {
                        System.out.print("===== Power Supply " + (j6 + 1) + ":");
                        System.out.println(bladeSystem.powerSupplies[j6].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("s")) {
                if (index != 0) {
                    System.out.print("===== Blade " + index + " Sensor:");
                    System.out.println(bladeSystem.mbSensors[index - 1].toString());
                } else {
                    for (int j7 = 0; j7 < bladeSystem.mbSensors.length; ++j7) {
                        System.out.print("===== Blade " + (j7 + 1) + " Sensor:");
                        System.out.println(bladeSystem.mbSensors[j7].toString());
                    }
                }
            } else if (module.equalsIgnoreCase("l")) {
                System.out.print("===== Front Panel LED:");
                System.out.println(bladeSystem.frontLED.toString());
            } else if (module.equalsIgnoreCase("a")) {
                Vector PCA955Infos = bladeSystem.getPCA955Infos((byte)index);
                if (PCA955Infos != null) {
                    if (PCA955Infos.size() != 0) {
                        if (index != 0) {
                            System.out.print("\n=====Blade " + index + " PCA955 Info: ");
                            System.out.println(ByteUtility.bytesToHex((byte[])PCA955Infos.get(0)));
                        } else {
                            for (int j8 = 0; j8 < PCA955Infos.size(); ++j8) {
                                System.out.print("\n=====Blade " + (j8 + 1) + " PCA955 Info: ");
                                System.out.println(ByteUtility.bytesToHex((byte[])PCA955Infos.get(j8)));
                            }
                        }
                    } else {
                        System.out.println("Get PCA955 Infos failed!");
                    }
                } else {
                    System.out.println("Login failed!");
                }
            } else if (module.equalsIgnoreCase("t")) {
                BladeSystemEntity.doGetPCA955Statistics(bladeSystem, index);
            }
            if (i2 != number - 1) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (infinite) continue;
            ++i2;
        }
    }

    private static void doGetPCA955Statistics(BladeSystemEntity bladeSystem, int index) {
        Vector statistics = bladeSystem.getPCA955statistics();
        byte[] statistic = new byte[4];
        byte[] value = new byte[2];
        if (statistics != null) {
            if (statistics.size() != 0) {
                if (index != 0) {
                    System.arraycopy((byte[])statistics.get(index - 1), 0, statistic, 0, 4);
                    System.arraycopy((byte[])statistics.get(index - 1), 4, value, 0, 2);
                    System.out.print("\n=====Blade " + index + " PCA955CanNotMatch: ");
                    System.out.print(ByteUtility.fourBytesToLongByLSBFirst(statistic));
                    System.out.println("\tValue: " + ByteUtility.bytesToHex(value));
                } else {
                    for (int j2 = 0; j2 < statistics.size(); ++j2) {
                        System.arraycopy((byte[])statistics.get(j2), 0, statistic, 0, 4);
                        System.arraycopy((byte[])statistics.get(j2), 4, value, 0, 2);
                        System.out.print("\n=====Blade " + (j2 + 1) + " PCA955CanNotMatch: ");
                        System.out.print(ByteUtility.fourBytesToLongByLSBFirst(statistic));
                        System.out.println("\tValue: " + ByteUtility.bytesToHex(value));
                    }
                }
            } else {
                System.out.println("Get PCA955 statistics failed!");
            }
        } else {
            System.out.println("Login failed!");
        }
    }

    public static void main_poolingTest(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.240");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        BladeSystemEntity bladeSystem = new BladeSystemEntity(config);
        bladeSystem.debug = true;
        bladeSystem.poolingData();
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        bladeSystem.stopPooling();
    }

    public class DeviceStructureInfo {
        public static final byte DEVICE_TYPE_BLADE_SERVER = 1;
        public static final byte DEVICE_TYPE_CMM = 2;
        public static final byte DEVICE_TYPE_PS = 3;
        public static final byte DEVICE_TYPE_GB = 4;
        public static final byte DEVICE_TYPE_IB = 5;
        public static final byte DEVICE_TYPE_BLADESENSOR = 6;
        public static final byte DEVICE_TYPE_10GPASS = 8;
        public static final byte DEVICE_TYPE_BLADE = 9;
        public byte type;
        public int structureSize;
        public int structureNumbers;

        public void fromRaw(byte[] raw) {
            this.type = raw[0];
            byte[] tempByte = new byte[]{raw[1], raw[2]};
            this.structureSize = ByteUtility.twoBytesToIntLSB(tempByte);
            tempByte[0] = raw[3];
            tempByte[1] = raw[4];
            this.structureNumbers = ByteUtility.twoBytesToIntLSB(tempByte);
        }
    }

    public class DeviceStructureInfoManager {
        ArrayList<DeviceStructureInfo> deviceStructureInfos = new ArrayList();

        public void addDeviceStructureInfo(DeviceStructureInfo info) {
            this.deviceStructureInfos.add(info);
        }

        public DeviceStructureInfo getDeviceStructureInfo(byte type) {
            for (DeviceStructureInfo item : this.deviceStructureInfos) {
                if (item.type != type) continue;
                return item;
            }
            return null;
        }
    }
}

