/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.cmtest;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIRaritanOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SOLSessionController;
import com.supermicro.ipmi.cmtest.CMServerP;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;

class IPMIPeppercon
implements CMServerP.Service {
    IPMIPeppercon() {
    }

    @Override
    public void serve(InputStream i2, OutputStream o) throws IOException {
        boolean result = false;
        BufferedReader in = new BufferedReader(new InputStreamReader(i2));
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(o)));
        String str = in.readLine();
        StringTokenizer st = new StringTokenizer(str, ",");
        String ip = null;
        String commandStr = null;
        String para1 = null;
        try {
            ip = st.nextToken();
            commandStr = st.nextToken();
        }
        catch (Exception ex) {
            System.out.println("Parameter error");
            out.print("1");
            out.close();
            in.close();
            return;
        }
        try {
            para1 = st.nextToken();
        }
        catch (Exception ex1) {
            // empty catch block
        }
        int command = Integer.parseInt(commandStr);
        System.out.print("IP = " + ip + " command = " + commandStr);
        switch (command) {
            case 1: {
                result = this.testLogin(ip);
                System.out.println(", result = " + (result ? "0" : "1"));
                out.print(result ? "0" : "1");
                break;
            }
            case 2: {
                result = this.testSOL(ip);
                System.out.println(", result = " + (result ? "0" : "1"));
                out.print(result ? "0" : "1");
                break;
            }
            case 3: {
                int kvmResult = this.testKVM(ip);
                out.print(kvmResult);
                break;
            }
            case 4: {
                int tempResult = this.testSystemTemperature(ip);
                out.print(tempResult);
                break;
            }
            case 5: {
                String firmwareVersion = this.getFirmwareVersion(ip);
                if (firmwareVersion == null) {
                    firmwareVersion = "Error";
                }
                out.print(firmwareVersion);
                break;
            }
            case 6: {
                int acpiState = this.getACPIState(ip);
                out.print(acpiState);
                break;
            }
            case 9: {
                int flashResult = this.flashFirmware(ip, para1);
                out.print(flashResult);
            }
        }
        out.close();
        in.close();
    }

    public boolean testLogin(String ip) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setRetry(0);
        config.setTimeout(10);
        config.setIp(ip);
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setCipherSuiteID((byte)3);
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMINetworkInterface rmcp = null;
        try {
            rmcp = sessionController.startup(config);
        }
        catch (Exception ex) {
            return false;
        }
        if (rmcp != null) {
            boolean result = sessionController.closeSession();
            return result;
        }
        return false;
    }

    public boolean testSOL(String ip) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setRetry(0);
        config.setTimeout(10);
        config.setIp(ip);
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setCipherSuiteID((byte)3);
        config.setPrivilege((byte)4);
        SOLSessionController solSessionController = new SOLSessionController();
        IPMINetworkInterface ipmiInterface = solSessionController.startup(config);
        if (!solSessionController.isSOLActivated) {
            return false;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        byte[] keys = new byte[]{83, 79, 76, 13};
        solSessionController.dropKey(keys);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        boolean result = solSessionController.closeSession();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int testKVM(String host) {
        int result = -2;
        try {
            Runtime rt = Runtime.getRuntime();
            String[] cmd = new String[]{"SIMTestApplication.exe", host};
            System.out.println("\nReady to test ...");
            Process proc = rt.exec(cmd);
            InputStream stderr = proc.getErrorStream();
            InputStreamReader isr = new InputStreamReader(stderr);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            result = proc.waitFor();
            System.out.println("Process exitValue: " + result);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            return result;
        }
    }

    public int flashFirmware(String ip, String firmwareFilename) {
        boolean flashReuslt;
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setRetry(0);
        config.setTimeout(10);
        config.setIp(ip);
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setCipherSuiteID((byte)3);
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        if (sessionController == null) {
            return 5;
        }
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return 1;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiRaritanOEMCommand.setIPMIInterface(rmcp);
        File file = new File(".");
        File[] fileList = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.indexOf(".bin") != -1;
            }
        });
        File firmwareFile = null;
        if (firmwareFilename != null) {
            firmwareFile = new File(firmwareFilename);
            if (!firmwareFile.isFile()) {
                return 2;
            }
        } else {
            firmwareFile = fileList[0];
        }
        if (fileList.length == 0) {
            return 2;
        }
        System.out.println("firmware:" + firmwareFile.getName());
        try {
            flashReuslt = ipmiRaritanOEMCommand.flashFirmware(firmwareFile.getName());
        }
        catch (Exception ex) {
            return 3;
        }
        if (!flashReuslt) {
            return 4;
        }
        return 0;
    }

    public int testSystemTemperature(String ip) {
        int result = 100;
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return 1;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiSDRCommand.setIPMIInterface(rmcp);
        SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
        if (sdrInfo != null) {
            MessageCenter.getInstance().put(sdrInfo.toString());
        }
        ArrayList list = ipmiSDRCommand.getSDRs(sdrInfo.getRecordCount());
        for (SDRRecord item : list) {
            if (item.getSensorName().indexOf("Sys Temp") == -1) continue;
            byte value = ipmiSDRCommand.getSensorReading(item.getSensorNumber());
            String reading = item.doubleToString(item.calSensorReading(value & 0xFF));
            double hiLimit = item.getHiLimit();
            System.out.println("Sys Temp = " + reading + "(" + item.getLowLimit() + " ~ " + item.getHiLimit() + ")");
            if (value == 0) {
                return 3;
            }
            if (value < 30 || (double)value > hiLimit) {
                return 4;
            }
            return 0;
        }
        return 2;
    }

    public String getFirmwareVersion(String ip) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setRetry(0);
        config.setTimeout(10);
        config.setIp(ip);
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setCipherSuiteID((byte)3);
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        if (sessionController == null) {
            return null;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return null;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiRaritanOEMCommand.setIPMIInterface(rmcp);
        String firmwareVersion = ipmiRaritanOEMCommand.getFirmwareVersionFromIPMI();
        return firmwareVersion;
    }

    public int getACPIState(String ip) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setRetry(0);
        config.setTimeout(10);
        config.setIp(ip);
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setCipherSuiteID((byte)3);
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        if (sessionController == null) {
            return 99;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return 99;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiGlobalCommand.setIPMIInterface(rmcp);
        ACPIInfo acpi = ipmiGlobalCommand.getACPI();
        System.out.println(acpi.getSystemStateInfo() + "(" + acpi.getSystemStateDescription() + ")");
        return acpi.getSystemState();
    }
}

