/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;

public class CommandForSetGatewayMAC
extends Command {
    @Override
    public Result execute(Host host) {
        String gatewayMAC = null;
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        Result result = new Result(this, host);
        if (!(this.option instanceof String)) {
            result.booleanResult = false;
            result.description = "Parameter error";
            return result;
        }
        gatewayMAC = (String)this.option;
        if (!IPMILanCommand.isMacAddress(gatewayMAC)) {
            result.booleanResult = false;
            result.description = "MAC format error";
            return result;
        }
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_login_to") + host.getIp();
            return result;
        }
        ipmiLanCommand.setIPMIInterface(rmcp);
        boolean r1 = ipmiLanCommand.setGatewayMAC(gatewayMAC);
        if (r1) {
            result.booleanResult = true;
            result.description = "Set gateway MAC OK";
        } else {
            result.booleanResult = false;
            result.description = L.t("group.Set_gateway_MAC_failed");
        }
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Set Gateway MAC";
    }
}

