/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.group.SnmpDestination;
import com.supermicro.ipmi.lang.L;

public class CommandForSetSNMPDestination
extends Command {
    @Override
    public Result execute(Host host) {
        SnmpDestination snmpDestination = null;
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        Result result = new Result(this, host);
        if (!(this.option instanceof SnmpDestination)) {
            result.booleanResult = false;
            result.description = "Parameter error";
            return result;
        }
        snmpDestination = (SnmpDestination)this.option;
        if (!IPMILanCommand.isIPAddress(snmpDestination.ip)) {
            result.booleanResult = false;
            result.description = L.t("group.IP_format_error");
            return result;
        }
        if (!IPMILanCommand.isMacAddress(snmpDestination.mac)) {
            result.booleanResult = false;
            result.description = L.t("group.MAC_format_error");
            return result;
        }
        if (snmpDestination.index < 1 || snmpDestination.index > 3) {
            result.booleanResult = false;
            result.description = "Index range error (should be 1 to 3)";
            return result;
        }
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_login_to") + host.getIp();
            return result;
        }
        ipmiLanCommand.setIPMIInterface(rmcp);
        boolean r1 = ipmiLanCommand.setDesitnationIPandMAC(snmpDestination.index, snmpDestination.ip, snmpDestination.mac);
        if (r1) {
            result.booleanResult = true;
            result.description = "Set SNMP Desitnation OK";
        } else {
            result.booleanResult = false;
            result.description = L.t("group.Set_SNMP_Desitnation_failed");
        }
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Set SNMP Destination";
    }
}

