/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.sol;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMISOLCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.ProxyConfig;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.algo.AES_CBC_128;
import com.supermicro.ipmi.sol.SOLPanel;
import java.applet.Applet;
import java.awt.BorderLayout;

public class SOLApplet
extends Applet {
    boolean isStandalone = false;
    BorderLayout borderLayout1 = new BorderLayout();
    boolean isEnableProxy;
    String proxyIP;
    int proxyPort;
    SOLPanel solPanel;
    String ip;
    String id;
    String password;
    int power = 1;
    int enc = 0;

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    @Override
    public void init() {
        try {
            this.isEnableProxy = Boolean.valueOf(this.getParameter("isEnableProxy", "false"));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            this.proxyIP = this.getParameter("proxyIP", "");
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        try {
            this.proxyPort = Integer.parseInt(this.getParameter("proxyPort", "0"));
        }
        catch (Exception e4) {
            e4.printStackTrace();
        }
        try {
            this.ip = this.getParameter("ip", "");
            if (this.ip.length() == 0) {
                this.ip = this.getCodeBase().getHost();
                System.out.println("ip = " + this.ip);
            }
        }
        catch (Exception e5) {
            e5.printStackTrace();
        }
        try {
            this.id = this.getParameter("id", "");
        }
        catch (Exception e6) {
            e6.printStackTrace();
        }
        try {
            this.password = this.getParameter("password", "");
        }
        catch (Exception e7) {
            e7.printStackTrace();
        }
        try {
            this.enc = Integer.parseInt(this.getParameter("enc", "0"));
        }
        catch (Exception e8) {
            e8.printStackTrace();
        }
        try {
            this.power = Integer.parseInt(this.getParameter("power", "1"));
        }
        catch (Exception e9) {
            e9.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception e10) {
            e10.printStackTrace();
        }
        this.solPanel = new SOLPanel();
        this.solPanel.setIsApplet(true);
        ProxyConfig proxyConfig = new ProxyConfig();
        proxyConfig.isProxyEnabled = this.isEnableProxy;
        proxyConfig.proxyIP = this.proxyIP;
        proxyConfig.proxyPort = this.proxyPort;
        this.solPanel.setProxyConfig(proxyConfig);
        if (!this.isEnableProxy) {
            this.solPanel.hideLoginInfoForApplet();
            if (this.power == 0) {
                this.solPanel.hidePowerControlPanel();
            }
            this.solPanel.setIP(this.ip);
            this.solPanel.setUsername(this.id);
            byte baudRate = 0;
            if (this.enc == 1) {
                String decryptedPassword = this.decryptPassword(this.password);
                this.solPanel.setPassword(decryptedPassword);
                baudRate = this.getBaudRate(this.ip, this.id, decryptedPassword);
            } else {
                this.solPanel.setPassword(this.password);
                baudRate = this.getBaudRate(this.ip, this.id, this.password);
            }
            if (baudRate >= 6 && baudRate <= 10) {
                this.solPanel.jBaudRateComboBox.setSelectedIndex(baudRate - 6);
            }
        }
        this.add(this.solPanel);
        this.solPanel.statusBar.setText("Ready");
    }

    public byte getBaudRate(String ip, String id, String pw) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(id);
        config.setPassword(pw);
        IPMISOLCommand ipmiSOLCommand = new IPMISOLCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiSOLCommand);
        if (sessionController == null) {
            return 0;
        }
        return ipmiSOLCommand.getSOLBitRateVolatile();
    }

    public String decryptPassword(String encryptedPassword) {
        AES_CBC_128 aes = new AES_CBC_128();
        byte[] key = new byte[]{83, 85, 80, 69, 82, 77, 73, 67, 82, 79, 1, 2, 3, 4, 5, 6};
        byte[] iv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        byte[] input = ByteUtility.toBinArray(encryptedPassword);
        byte[] decrypted = aes.decrypt(iv, key, input);
        return new String(decrypted).trim();
    }

    @Override
    public void start() {
        System.out.println("call applet START");
    }

    @Override
    public void stop() {
        System.out.println("call applet STOP");
        if (this.solPanel.isSOLActivated) {
            this.solPanel.jStopButton_actionPerformed(null);
        }
    }

    private void jbInit() throws Exception {
    }

    @Override
    public String getAppletInfo() {
        return "Applet Information";
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"isEnableProxy", "boolean", ""}, {"proxyIP", "String", ""}, {"proxyPort", "int", ""}};
        return pinfo;
    }
}

