/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.BIOSAbstractCommand;
import com.supermicro.ipmi.text.MOut;

public class BIOSVerCommand
extends BIOSAbstractCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (!this.checkIfSupportBIOSUpdate()) {
            MOut.G(this).println("This device doesn't support BIOS commands");
            MOut.G(this).println("BIOS commands only support X9 series montherboards");
            this.statusCode = 153;
            return;
        }
        ACPIInfo acpiInfo = ipmiGlobalCommand.getACPI();
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        if (acpiInfo.getSystemState() == 0 || acpiInfo.getSystemState() == 1 || acpiInfo.getSystemState() == 2 || acpiInfo.getSystemState() == 3) {
            if (IPMIMessagingCommand.isAMIX9GUID(guid)) {
                MOut.G(this).println("Cannot execute this command when system is On");
                return;
            }
        }
        if (this.checkIfProudctNotActivated()) {
            MOut.G(this).println("The product key needs to be activated for this device");
            this.statusCode = 153;
            return;
        }
        if (!this.getBIOSInfo()) {
            MOut.G(this).println("Get BIOS Info failed");
            this.statusCode = 153;
            return;
        }
        MOut.G(this).println(this.biosInfo.toStringFromBMC());
    }
}

