/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class BladeBurstAbstractCommand
extends SuperBladeCommand {
    byte type;
    byte[] b;

    public boolean getBladeIndexes() {
        int i2;
        int maxBlade = this.getBladeMaxSize();
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (i2 = 0; i2 < this.parameters.length; ++i2) {
            try {
                byte value = Byte.parseByte(this.parameters[i2]);
                if (value <= 0 || value > maxBlade) continue;
                list.add(value);
                continue;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (list.size() == 0) {
            return false;
        }
        this.b = new byte[list.size()];
        for (i2 = 0; i2 < list.size(); ++i2) {
            this.b[i2] = (Byte)list.get(i2);
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        try {
            byte result = this.ipmiCMMOEMCommand.burstPowerControl(this.type, this.b);
            if (result == 0) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else if (result == 1) {
                MOut.G(this).println("No enough power");
                this.statusCode = 149;
            } else {
                MOut.G(this).println("Unknown error (" + ByteUtility.byteToHex(result) + "h)");
                this.statusCode = 149;
            }
        }
        catch (IPMIException ex) {
            MOut.G(this).println("Not a supported command");
            this.statusCode = 153;
        }
    }
}

