/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.HostCenter;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeTool;
import java.io.IOException;
import java.util.StringTokenizer;

public class ChangeHostCommand
extends Command {
    String ip;
    String username;
    String password;

    public boolean preValidate() {
        this.ip = null;
        this.username = null;
        this.password = null;
        boolean passValidate = false;
        if (this.parameters == null) {
            this.listUsageAndHosts();
            return false;
        }
        if (this.parameters.length >= 1) {
            this.ip = this.parameters[0];
            passValidate = true;
        }
        if (this.parameters.length >= 2) {
            this.username = this.parameters[1];
            passValidate = true;
        }
        if (this.parameters.length >= 3) {
            this.password = this.parameters[2];
            passValidate = true;
        }
        if (this.ip.startsWith("-")) {
            int index = -1;
            try {
                index = Integer.parseInt(this.ip.substring(1, this.ip.length()));
            }
            catch (NumberFormatException ex) {
                passValidate = false;
            }
            if (HostCenter.getInstance().size() == 1) {
                MOut.G(this).println("Cannot remove host");
                return false;
            }
            if (index != -1 && index <= HostCenter.getInstance().size()) {
                IPMIInterfaceConfig config = HostCenter.getInstance().getHost(index - 1);
                String ipTemp = config.getIp();
                HostCenter.getInstance().removeHostByIndex(index - 1);
                System.out.println(ipTemp + " removed");
                try {
                    if (HostCenter.getInstance().isDefault() || HostCenter.getInstance().isFound()) {
                        HostCenter.getInstance().save();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return false;
        }
        if (this.ip.startsWith("*")) {
            this.ip = this.replaceIP(this.ip);
        } else if (this.ip.startsWith(".")) {
            this.ip = this.replaceIP(this.ip);
        }
        try {
            int number = Integer.parseInt(this.ip);
            if (number <= HostCenter.getInstance().size()) {
                IPMIInterfaceConfig config = HostCenter.getInstance().getHost(number - 1);
                this.ip = config.getIp();
                MOut.G(this).println(number + " -> " + this.ip);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.ip != null && !SuperBladeTool.validateIP(this.ip)) {
            MOut.G(this).println("IP format erorr !");
            passValidate = false;
        }
        if (!passValidate) {
            MOut.G(this).println("Current setting: ");
            MOut.G(this).println("IP       : " + this.config.getIp());
            MOut.G(this).println("Username : " + this.config.getUserName());
            MOut.G(this).println("Available command: IP [username] [password]");
            return false;
        }
        return true;
    }

    private void listUsageAndHosts() {
        MOut.G(this).println("Current setting: ");
        MOut.G(this).println("IP       : " + this.config.getIp());
        MOut.G(this).println("Username : " + this.config.getUserName());
        MOut.G(this).println("");
        MOut.G(this).println("Current managed system(s):  ");
        MOut.G(this).println("");
        MOut.G(this).println(HostCenter.getInstance().toFormatedStringWithTagLoc());
        MOut.G(this).println("Use \"ch -<#>\" to remove. # is index");
        MOut.G(this).println("Use \"ch\" to change or add managed system (IP)");
        MOut.G(this).println("Use \"<\" or \">\" to switch managed system on shell prompt");
        MOut.G(this).println("");
        MOut.G(this).println("Usage: ch <IP> [username] [password]");
        MOut.G(this).println("Using wild card for IP");
        MOut.G(this).println("ex: 192.168.100.118 change to 192.168.100.9");
        MOut.G(this).println("    CMM>ch *.9");
        MOut.G(this).println("");
    }

    public String replaceIP(String newIP) {
        int foundIndex;
        String ip = this.config.getIp();
        String[] nip = new String[4];
        StringTokenizer st = new StringTokenizer(ip, ".");
        nip[0] = st.nextToken();
        nip[1] = st.nextToken();
        nip[2] = st.nextToken();
        nip[3] = st.nextToken();
        for (int i2 = 3; i2 > 0 && (foundIndex = newIP.lastIndexOf(".")) != -1; --i2) {
            nip[i2] = newIP.substring(foundIndex + 1, newIP.length());
            newIP = newIP.substring(0, foundIndex);
        }
        return "" + nip[0] + "." + nip[1] + "." + nip[2] + "." + nip[3];
    }

    @Override
    public void execute() {
        boolean b2 = this.preValidate();
        if (!b2) {
            return;
        }
        if (!ChangeHostCommand.checkIfConnectable(this.ip)) {
            MOut.G(this).println("Cannot connect to " + this.ip);
            return;
        }
        String usernameFromHistory = null;
        String passwordFromHistory = null;
        IPMIInterfaceConfig c2 = HostCenter.getInstance().findbyIP(this.ip);
        if (c2 != null) {
            usernameFromHistory = c2.getUserName();
            passwordFromHistory = c2.getPassword();
        }
        if (this.ip != null) {
            MOut.G(this).println("Old IP       : " + this.config.getIp());
            this.config.setIp(this.ip);
            MOut.G(this).println("New IP       : " + this.ip);
        }
        if (this.username != null) {
            MOut.G(this).println("Old Username : " + this.config.getUserName());
            this.config.setUserName(this.username);
            MOut.G(this).println("New Username : " + this.username);
        } else if (usernameFromHistory != null) {
            this.config.setUserName(usernameFromHistory);
        }
        if (this.password != null) {
            MOut.G(this).println("Old Password : " + this.config.getPassword());
            this.config.setPassword(this.password);
            MOut.G(this).println("New Password : " + this.password);
        } else if (passwordFromHistory != null) {
            this.config.setPassword(passwordFromHistory);
        }
        HostCenter.getInstance().addHost(this.config);
        try {
            HostCenter.getInstance().save();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.ip = null;
        this.username = null;
        this.password = null;
    }

    public static boolean checkIfConnectable(String ip) {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(ip);
        return guid != null;
    }
}

