/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.HostCenter;
import com.supermicro.ipmi.text.MOut;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class FindCommand
extends Command {
    public static HashMap foundDevice = new LinkedHashMap();
    public static Calendar lastUpdate;

    @Override
    public void execute() {
        if (this.parameters != null) {
            if (this.parameters.length != 3) {
                MOut.G(this).println("parameter error!");
                this.statusCode = 147;
                return;
            }
            String startIP = this.parameters[0];
            String endIP = this.parameters[1];
            String netMask = this.parameters[2];
            this.findIPMIDevice(startIP, endIP, netMask);
        } else {
            this.findLocalIPMIDevice();
        }
        this.statusCode = 0;
    }

    public void findIPMIDevice(String startIP, String endIP, String netMask) {
        try {
            ArrayList<String> list = this.allAddress(startIP, endIP, netMask);
            ArrayList<FindDevice> devices = this.getAllPossibleIPMIDevice(list);
            this.findIPMIDevice(devices);
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            return;
        }
    }

    public void findLocalIPMIDevice() {
        ArrayList<String> list = this.findLocalIPs();
        ArrayList<FindDevice> devices = this.getAllPossibleIPMIDevice(list);
        this.findIPMIDevice(devices);
    }

    public void findIPMIDevice(ArrayList<FindDevice> devices) {
        MOut.G(this).println("Finding IPMI Devices ...");
        for (int i2 = 0; i2 < devices.size(); ++i2) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            devices.get(i2).start();
        }
        try {
            Thread.sleep(18000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        boolean isFoundAny = false;
        int deviceCount = 0;
        for (int i3 = 0; i3 < devices.size(); ++i3) {
            if (!devices.get((int)i3).doneGet) continue;
            ++deviceCount;
            MOut.G(this).println(devices.get(i3).toString());
            foundDevice.put(devices.get((int)i3).ip, devices.get((int)i3).type);
            isFoundAny = true;
            IPMIInterfaceConfig aConfig = new IPMIInterfaceConfig();
            aConfig.setIp(devices.get((int)i3).ip);
            aConfig.setUserName(this.config.getUserName());
            aConfig.setPassword(this.config.getPassword());
            HostCenter.getInstance().getFoundHostBuffer().addHost(aConfig);
        }
        if (!isFoundAny) {
            MOut.G(this).println("No IPMI Device found!");
        } else {
            try {
                HostCenter.getInstance().getFoundHostBuffer().save();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            MOut.G(this).println("" + deviceCount + " IPMI device(s) found. Use \"found\" to list found devices");
        }
        lastUpdate = Calendar.getInstance();
    }

    public ArrayList<FindDevice> getAllPossibleIPMIDevice(ArrayList<String> list) {
        ArrayList<FindDevice> devices = new ArrayList<FindDevice>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FindDevice device = new FindDevice(list.get(i2), 8, 2);
            devices.add(device);
        }
        return devices;
    }

    public ArrayList<String> findLocalIPs() {
        ArrayList<String> ips = new ArrayList<String>();
        InetAddress[] ia = null;
        try {
            ia = this.getAllLocalUsingNetworkInterface();
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        for (int i2 = 0; i2 < ia.length; ++i2) {
            ArrayList<String> l = this.allAddress(ia[i2].getHostAddress());
            ips.addAll(l);
        }
        return ips;
    }

    private InetAddress[] getAllLocalUsingNetworkInterface() throws UnknownHostException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> e2 = null;
        try {
            e2 = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new UnknownHostException("127.0.0.1");
        }
        while (e2.hasMoreElements()) {
            NetworkInterface ni = e2.nextElement();
            Enumeration<InetAddress> e22 = ni.getInetAddresses();
            while (e22.hasMoreElements()) {
                addresses.add(e22.nextElement());
            }
        }
        InetAddress[] iAddresses = new InetAddress[addresses.size()];
        for (int i2 = 0; i2 < iAddresses.length; ++i2) {
            iAddresses[i2] = (InetAddress)addresses.get(i2);
        }
        return iAddresses;
    }

    public ArrayList<String> allAddress(String ip) {
        ArrayList<String> list = new ArrayList<String>();
        if (IPMILanCommand.isIPAddress(ip) && !ip.equals("127.0.0.1")) {
            String cClass = ip.substring(0, ip.lastIndexOf("."));
            for (int i2 = 1; i2 < 255; ++i2) {
                list.add(cClass + "." + i2);
            }
        }
        return list;
    }

    public ArrayList<String> allAddress(String startIP, String endIP, String netmask) throws Exception {
        if (!IPMILanCommand.isIPAddress(startIP)) {
            throw new Exception("Start IP format error!");
        }
        if (!IPMILanCommand.isIPAddress(endIP)) {
            throw new Exception("End IP format error!");
        }
        if (!IPMILanCommand.isIPAddress(netmask)) {
            throw new Exception("NetMask format error!");
        }
        ArrayList<String> list = new ArrayList<String>();
        InetAddress startInet = InetAddress.getByName(startIP);
        InetAddress endInet = InetAddress.getByName(endIP);
        InetAddress maskInet = InetAddress.getByName(netmask);
        if ((startInet.hashCode() & maskInet.hashCode()) != (endInet.hashCode() & maskInet.hashCode())) {
            throw new Exception("Start IP and End IP must locate within same network segment");
        }
        for (int i2 = startInet.hashCode(); i2 <= endInet.hashCode(); ++i2) {
            list.add(this.intToIP(i2));
        }
        return list;
    }

    public String intToIP(int intsrc) {
        String x = new String();
        x = "" + ((byte)(intsrc >> 24) & 0xFF);
        x = x + "." + ((byte)(intsrc >> 16) & 0xFF);
        x = x + "." + ((byte)(intsrc >> 8) & 0xFF);
        x = x + "." + ((byte)intsrc & 0xFF);
        return x;
    }

    public void findTest() {
        FindDevice device = new FindDevice("192.168.10.240", 5, 2);
        device.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (device.doneGet) {
            MOut.G(this).println(device.toString());
        }
    }

    public static void main(String[] args) {
        MessageCenter.getInstance().deleteObservers();
        FindCommand f2 = new FindCommand();
        InetAddress saddress = null;
        try {
            saddress = InetAddress.getByName("192.168.10.1");
            MOut.G().println(f2.intToIP(saddress.hashCode() + 1));
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        System.out.println(saddress.hashCode());
        try {
            ArrayList<String> list = f2.allAddress("192.168.1.1", "192.168.1.24", "255.255.255.0");
            for (int i2 = 0; i2 < list.size(); ++i2) {
                System.out.println((Object)list.get(i2));
            }
        }
        catch (Exception ex1) {
            MOut.G().println(ex1.getMessage());
        }
    }

    class FindDevice
    extends Thread {
        public String ip;
        public String type;
        boolean doneGet = false;
        int timeout;
        int retry;
        IPMIInterfaceConfig config;

        public FindDevice(String ip) {
            this(ip, 5, 1);
        }

        public FindDevice(String ip, int timeout, int retry) {
            this.ip = ip;
            this.timeout = timeout;
            this.retry = retry;
            this.config = new IPMIInterfaceConfig();
            this.config.setIp(ip);
            this.config.setTimeout(timeout);
            this.config.setRetry(retry);
        }

        @Override
        public void run() {
            byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.ip, this.timeout, this.retry);
            if (guid != null) {
                this.type = IPMIMessagingCommand.getFWTypeByGUID(guid);
                this.doneGet = true;
            }
        }

        @Override
        public String toString() {
            String format = "  %-20s \t %-20s";
            String retStr = String.format(format, this.ip, this.type);
            return retStr;
        }
    }
}

