/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.HDDStatusLogical;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIHDDOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class HDDInfoLogicalCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIHDDOEMCommand ipmiHDDOEMCommand = new IPMIHDDOEMCommand(null);
        ipmiHDDOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            IPMIHDDOEMCommand.HDDLogicalMap map = ipmiHDDOEMCommand.getLogicalHDDMap();
            if (map == null) {
                MOut.G(this).println("This device does not support HDD interface");
                this.statusCode = 153;
                return;
            }
            boolean anyData = false;
            for (int i2 = 0; i2 < 64; ++i2) {
                if (!map.isExist(i2)) continue;
                if (!anyData) {
                    MOut.G(this).print(HDDStatusLogical.toTableFormatedHeader());
                    anyData = true;
                }
                HDDStatusLogical status = ipmiHDDOEMCommand.getLogicalHDDInfoStructure((byte)i2);
                status.setIndex(i2);
                MOut.G(this).print(status.toTableFormatedString());
                MOut.G(this).println("PRL: Primary Raid Level");
                MOut.G(this).println("SRL: Secondary Raid Level");
                MOut.G(this).println("RLQ: Raid Level Qualifier");
            }
            if (!anyData) {
                MOut.G(this).println("Empty HDD Info");
            }
        }
        catch (IPMIException ex) {
            MOut.G(this).println("This device does not support HDD interface");
            this.statusCode = 153;
        }
        this.statusCode = 0;
    }
}

