/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.LinkedList;

public class HostBuffer {
    public LinkedList<IPMIInterfaceConfig> hosts = new LinkedList();
    public int currentHostIndex;
    public String filename;

    public void sort() {
        Collections.sort(this.hosts);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int size() {
        return this.hosts.size();
    }

    public void clear() {
        this.hosts.clear();
    }

    public LinkedList<IPMIInterfaceConfig> getHosts() {
        return this.hosts;
    }

    public IPMIInterfaceConfig getHost(int index) {
        return this.hosts.get(index);
    }

    public void removeHostByIndex(int index) {
        this.hosts.remove(index);
    }

    public void appendHost(HostBuffer hostBuffer) {
        for (IPMIInterfaceConfig item : hostBuffer.getHosts()) {
            this.addHost(item);
        }
    }

    public void addHost(IPMIInterfaceConfig config) {
        int index = this.find(config);
        if (index != -1) {
            this.currentHostIndex = index;
            IPMIInterfaceConfig foundConfig = this.hosts.get(index);
            foundConfig.setIp(config.getIp());
            foundConfig.setUserName(config.getUserName());
            foundConfig.setPassword(config.getPassword());
            foundConfig.getTagLocInBackGround();
            return;
        }
        IPMIInterfaceConfig copyConfig = new IPMIInterfaceConfig();
        copyConfig.setIp(config.getIp());
        copyConfig.setUserName(config.getUserName());
        copyConfig.setPassword(config.getPassword());
        copyConfig.getTagLocInBackGround();
        this.hosts.add(copyConfig);
        this.currentHostIndex = this.hosts.size() - 1;
    }

    public void removeHost(IPMIInterfaceConfig config) {
        int index = this.find(config);
        if (index != -1) {
            this.hosts.remove(index);
            if (this.currentHostIndex > this.hosts.size() - 1) {
                this.currentHostIndex = this.hosts.size() - 1;
            }
            return;
        }
    }

    public IPMIInterfaceConfig findbyIP(String ip) {
        for (int i2 = 0; i2 < this.hosts.size(); ++i2) {
            IPMIInterfaceConfig config = this.hosts.get(i2);
            if (!ip.equals(config.getIp())) continue;
            return config;
        }
        return null;
    }

    public int find(IPMIInterfaceConfig c2) {
        for (int i2 = 0; i2 < this.hosts.size(); ++i2) {
            IPMIInterfaceConfig config = this.hosts.get(i2);
            if (!c2.getIp().equals(config.getIp())) continue;
            return i2;
        }
        return -1;
    }

    public IPMIInterfaceConfig PreviousHost() {
        if (this.hosts.size() == 0) {
            return null;
        }
        this.currentHostIndex = this.currentHostIndex == 0 ? this.hosts.size() - 1 : --this.currentHostIndex;
        return this.hosts.get(this.currentHostIndex);
    }

    public IPMIInterfaceConfig nextHost() {
        if (this.hosts.size() == 0) {
            return null;
        }
        this.currentHostIndex = this.currentHostIndex == this.hosts.size() - 1 ? 0 : ++this.currentHostIndex;
        return this.hosts.get(this.currentHostIndex);
    }

    public void save() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.filename);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this.hosts);
        oos.close();
    }

    public void saveAs(String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this.hosts);
        oos.close();
    }

    public void load() throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(this.filename);
        ObjectInputStream ois = new ObjectInputStream(fis);
        this.hosts = (LinkedList)ois.readObject();
        ois.close();
    }

    public void getTagLocInBackGround() {
        for (int i2 = 0; i2 < this.hosts.size(); ++i2) {
            IPMIInterfaceConfig config = this.hosts.get(i2);
            config.getTagLocInBackGround();
        }
    }

    public String toFormatedString() {
        StringBuffer sb = new StringBuffer();
        String formatTemplate = " %5s | %-6s \n";
        StringBuffer formatedString = new StringBuffer();
        formatedString.append(String.format(formatTemplate, "Index", "IP"));
        formatedString.append(String.format(formatTemplate, "-----", "----------------------"));
        for (int i2 = 0; i2 < this.hosts.size(); ++i2) {
            IPMIInterfaceConfig config = this.hosts.get(i2);
            formatedString.append(String.format(formatTemplate, i2 + 1, config.getUserName() + "@" + config.getIp()));
        }
        return formatedString.toString();
    }

    public String toFormatedStringWithTagLoc() {
        String formatTemplateTagLoc = " %5s | %-16s %-14s %4s %4s %4s %4s %4s %-11s | %-10s\n";
        StringBuffer formatedString = new StringBuffer();
        formatedString.append(String.format(formatTemplateTagLoc, "Index", "IP", "Board", "DC", "Room", "Row", "Rack", "Num", "Type", "BMC"));
        formatedString.append(String.format(formatTemplateTagLoc, "-----", "----------------", "-----", "----", "----", "----", "----", "----", "----", "-------"));
        for (int i2 = 0; i2 < this.hosts.size(); ++i2) {
            IPMIInterfaceConfig config = this.hosts.get(i2);
            if (config.tagLocSDR != null) {
                formatedString.append(String.format(formatTemplateTagLoc, i2 + 1, config.getIp(), config.mbName == null ? "" : config.mbName, config.tagLocSDR.tagLoc.dataCenter, config.tagLocSDR.tagLoc.room, config.tagLocSDR.tagLoc.row, config.tagLocSDR.tagLoc.rack, config.tagLocSDR.tagLoc.getNumberString(), config.tagLocSDR.tagLoc.getChassisTypeString(), config.fwType == null ? "" : config.fwType));
                continue;
            }
            formatedString.append(String.format(formatTemplateTagLoc, i2 + 1, config.getIp(), config.mbName == null ? "" : config.mbName, "", "", "", "", "", "", config.fwType == null ? "" : config.fwType));
        }
        return formatedString.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < this.hosts.size(); ++i2) {
            IPMIInterfaceConfig config = this.hosts.get(i2);
            sb.append("" + (i2 + 1) + ":" + config.getUserName() + "@" + config.getIp() + "\n");
        }
        return sb.toString();
    }
}

