/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIFanModeCommand
extends SuperBladeCommand {
    public static final byte STANDARD = 0;
    public static final byte FULL = 1;
    public static final byte OPTIMAL = 2;
    public static final byte PUE_OPTIMAL = 3;
    public static final byte HEAVYIO = 4;
    public byte fanMode = (byte)-1;
    public byte currentFanMode;
    public byte fanModeCapability = (byte)-1;

    @Override
    public boolean preValidate() {
        this.fanMode = (byte)-1;
        this.fanModeCapability = (byte)-1;
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("0")) {
                this.fanMode = 0;
            } else if (this.parameters[0].equalsIgnoreCase("1")) {
                this.fanMode = 1;
            } else if (this.parameters[0].equalsIgnoreCase("2")) {
                this.fanMode = (byte)2;
            } else if (this.parameters[0].equalsIgnoreCase("3")) {
                this.fanMode = (byte)3;
            } else if (this.parameters[0].equalsIgnoreCase("4")) {
                this.fanMode = (byte)4;
            } else {
                MOut.G(this).println("Invalid mode");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            this.currentFanMode = ipmiOEMCommand.getFANSpeedMode();
        }
        catch (Exception ex) {
            MOut.G(this).println("Not a supported device");
            this.statusCode = 153;
            return;
        }
        try {
            this.fanModeCapability = ipmiOEMCommand.getFANSpeedModeCapability();
        }
        catch (Exception ex) {
            // empty catch block
        }
        switch (this.fanMode) {
            case 0: {
                try {
                    ipmiOEMCommand.setFANSpeedMode((byte)0);
                    MOut.G(this).println("done");
                }
                catch (Exception e2) {
                    MOut.G(this).println("This system cannot accept Standard mode");
                }
                break;
            }
            case 1: {
                try {
                    ipmiOEMCommand.setFANSpeedMode((byte)1);
                    MOut.G(this).println("done");
                }
                catch (Exception e3) {
                    MOut.G(this).println("This system cannot accept Full mode");
                }
                break;
            }
            case 2: {
                try {
                    ipmiOEMCommand.setFANSpeedMode((byte)2);
                    MOut.G(this).println("done");
                }
                catch (Exception e4) {
                    MOut.G(this).println("This system cannot accept Optimal mode");
                }
                break;
            }
            case 3: {
                try {
                    ipmiOEMCommand.setFANSpeedMode((byte)3);
                    MOut.G(this).println("done");
                }
                catch (Exception e5) {
                    MOut.G(this).println("This system cannot accept PUE Optimal mode");
                }
                break;
            }
            case 4: {
                try {
                    ipmiOEMCommand.setFANSpeedMode((byte)4);
                    MOut.G(this).println("done");
                }
                catch (Exception e6) {
                    MOut.G(this).println("This system cannot accept Heavy IO mode");
                }
                break;
            }
            default: {
                this.printLANType(this.currentFanMode);
            }
        }
    }

    private void printLANType(byte type) {
        switch (type) {
            case 0: {
                MOut.G(this).println("Current Fan Speed Mode is [ Standard Speed ]");
                break;
            }
            case 1: {
                MOut.G(this).println("Current Fan Speed Mode is [ Full Speed ]");
                break;
            }
            case 2: {
                MOut.G(this).println("Current Fan Speed Mode is [ Optimal Speed ]");
                break;
            }
            case 3: {
                MOut.G(this).println("Current Fan Speed Mode is [ PUE Optimal Speed ]");
                break;
            }
            case 4: {
                MOut.G(this).println("Current Fan Speed Mode is [ Heavy IO Speed ]");
            }
        }
        if (this.fanModeCapability != -1) {
            MOut.G(this).println("\nSupported Fan modes:");
        } else {
            MOut.G(this).println("\nFan Modes:");
        }
        if ((byte)(this.fanModeCapability & 1) == 1) {
            MOut.G(this).println("0: Standard Speed");
        }
        if ((byte)(this.fanModeCapability & 2) == 2) {
            MOut.G(this).println("1: Full Speed");
        }
        if ((byte)(this.fanModeCapability & 4) == 4) {
            MOut.G(this).println("2: Optimal Speed");
        }
        if ((byte)(this.fanModeCapability & 8) == 8) {
            MOut.G(this).println("3: PUE Optimal Speed");
        }
        if ((byte)(this.fanModeCapability & 0x10) == 16) {
            MOut.G(this).println("4: Heavy IO Speed");
        }
    }
}

