/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ATENFlash;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;

public class IPMIFlashASPDATENCommand
extends SuperBladeCommand {
    String options;
    int preserveConfig = 1;

    public void usage() {
        MOut.G(this).println("flasha <filename> [Preserve_opt]");
        MOut.G(this).println("Preserve option (Supported fw v1.04 or later):");
        MOut.G(this).println("0: Do not preserve config");
        MOut.G(this).println("1: Preserve config");
    }

    @Override
    public boolean preValidate() {
        this.options = null;
        if (this.parameters == null) {
            MOut.G(this).println("Firmware filename is needed");
            MOut.G(this).println("");
            this.usage();
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + this.parameters[0] + ") not found");
            return false;
        }
        if (this.parameters.length > 1) {
            String tempPreserveConfig = this.parameters[1];
            try {
                this.preserveConfig = Integer.parseInt(tempPreserveConfig);
            }
            catch (NumberFormatException e2) {
                MOut.G(this).println("Invalid preserve config value [0|1]");
                return false;
            }
            if (this.preserveConfig != 0 && this.preserveConfig != 1) {
                MOut.G(this).println("Invalid preserve config value [0|1]");
                return false;
            }
        }
        if (this.parameters.length > 1) {
            for (int i2 = 1; i2 < this.parameters.length; ++i2) {
                this.options = this.options + this.parameters[i2] + " ";
            }
        }
        return true;
    }

    public boolean checkIfSupportedDevice() {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        return IPMIMessagingCommand.isATENAspeedGUID(guid);
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.checkIfSupportedDevice()) {
            MOut.G(this).println("Not a supported device");
            MOut.G(this).println("This command is used for updating ASPEED X10 BMC firmware (*.bin)");
            this.statusCode = 153;
            return;
        }
        if (this.options != null && this.options.toLowerCase().indexOf("-ver") != -1) {
            this.showFirmwareVer(this.parameters[0]);
            return;
        }
        boolean result = false;
        ATENFlash atenFlash = new ATENFlash();
        MOut.G(this).println("**************************************************************");
        MOut.G(this).println("WARNING!");
        MOut.G(this).println("Firmware upgrade must not be interrupted once it is started.");
        MOut.G(this).println("Once you get error after Upgrading, please use local KCS tool");
        MOut.G(this).println("for recovery.");
        MOut.G(this).println("**************************************************************");
        atenFlash.setMOut(MOut.G(this));
        result = atenFlash.flash(this.config.getIp(), this.config.getUserName(), this.config.getPassword(), this.parameters[0], this.preserveConfig);
        this.statusCode = result ? 0 : 149;
    }

    public void showFirmwareVer(String name) {
        ATENFlash atenFlash = new ATENFlash();
        try {
            String ver = atenFlash.checkFirmwareVersion(name);
            MOut.G(this).println(ver);
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
        }
        this.statusCode = 0;
    }
}

