/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIPEFCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanSNMPCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIPEFCommand ipmiPEFCommand = new IPMIPEFCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        int destCount = ipmiLanCommand.getNumberOfDestination();
        if (this.parameters != null && (this.parameters.length == 2 || this.parameters.length == 3)) {
            byte seq = 0;
            String seqStr = this.parameters[0];
            String ip = this.parameters[1];
            String mac = "00:00:00:00:00:00";
            if (this.parameters.length == 3) {
                mac = this.parameters[2];
            }
            try {
                seq = (byte)Integer.parseInt(seqStr);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println(" destination number format error!");
                this.statusCode = 147;
                return;
            }
            if (seq <= 0 || seq >= destCount) {
                MOut.G(this).println("destination number out of range. destiation size = " + destCount);
                this.statusCode = 147;
                return;
            }
            if (!IPMILanCommand.isIPAddress(ip)) {
                MOut.G(this).println("IP format error!");
                this.statusCode = 147;
                return;
            }
            if (this.parameters.length == 3 && !IPMILanCommand.isMacAddress(mac)) {
                MOut.G(this).println("MAC format error!");
                this.statusCode = 147;
                return;
            }
            byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
            if (guid == null) {
                MOut.G(this).println("Unknown GUID");
                this.statusCode = 149;
            }
            byte policyNumber = 0;
            boolean b2 = false;
            if (IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) || IPMIMessagingCommand.isCMMGUID(guid) || IPMIMessagingCommand.isNormalBladeCMMGUID(guid) || IPMIMessagingCommand.isSIMBL(guid) || IPMIMessagingCommand.isOSAGUID(guid)) {
                b2 = this.setPEFforPeppercon(ipmiLanCommand, ipmiPEFCommand, seq, ip, mac, policyNumber);
            } else if (IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid) || IPMIMessagingCommand.isAMIAspeedGUID(guid)) {
                b2 = this.setPEFForAMI(ipmiLanCommand, ipmiPEFCommand, seq, ip, mac, policyNumber);
            } else if (IPMIMessagingCommand.isATENGUID(guid) || IPMIMessagingCommand.isATENAspeedGUID(guid)) {
                b2 = this.setPEFforATEN(ipmiLanCommand, ipmiPEFCommand, seq, ip, mac, policyNumber);
            }
            if (b2) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
            this.printSNMPList(ipmiLanCommand, destCount);
        } else {
            this.printSNMPList(ipmiLanCommand, destCount);
            this.statusCode = 0;
        }
    }

    private boolean setPEFforPeppercon(IPMILanCommand ipmiLanCommand, IPMIPEFCommand ipmiPEFCommand, byte seq, String ip, String mac, byte policyNumber) {
        boolean b1 = ipmiPEFCommand.setDefaultEventFilterTableEntry((byte)1, policyNumber);
        boolean b2 = ipmiPEFCommand.setDefaultAlertPolicyTableEntry(seq, policyNumber, seq);
        boolean b3 = ipmiLanCommand.setDesitnationIPandMAC(seq, ip, mac);
        boolean b4 = ipmiLanCommand.setDefaultPEFDestinationType(seq);
        boolean b5 = b1 && b2 && b3 && b4;
        return b5;
    }

    private boolean setPEFForAMI(IPMILanCommand ipmiLanCommand, IPMIPEFCommand ipmiPEFCommand, byte seq, String ip, String mac, byte policyNumber) {
        boolean b1 = true;
        boolean b2 = true;
        for (int i2 = 1; i2 <= 4; ++i2) {
            if (!ip.equals("0.0.0.0")) {
                boolean isEnable = false;
                byte channel = 0;
                isEnable = true;
                channel = 1;
                b2 &= ipmiPEFCommand.setAlertPolicyTableEntry((byte)((seq - 1) * 4 + i2), (byte)i2, isEnable, channel, seq);
                continue;
            }
            b2 &= ipmiPEFCommand.setAlertPolicyTableEntry((byte)((seq - 1) * 4 + i2), (byte)i2, false, (byte)0, seq);
        }
        boolean b3 = ipmiLanCommand.setDesitnationIPandMAC(seq, ip, mac);
        boolean b4 = ipmiLanCommand.setDefaultPEFDestinationType(seq);
        boolean b5 = b1 && b2 && b3 && b4;
        return b5;
    }

    private boolean setPEFforATEN(IPMILanCommand ipmiLanCommand, IPMIPEFCommand ipmiPEFCommand, byte seq, String ip, String mac, byte policyNumber) {
        boolean b1 = ip.equals("0.0.0.0") ? ipmiPEFCommand.setDefaultDisableEventFilterTableEntryForATEN((byte)(seq + 1)) : ipmiPEFCommand.setDefaultEventFilterTableEntryForATEN((byte)(seq + 1), (byte)4);
        boolean b2 = ipmiPEFCommand.setDefaultAlertPolicyTableEntry((byte)(seq + 1), (byte)4, seq);
        boolean b3 = ipmiLanCommand.setDesitnationIPandMAC(seq, ip, mac);
        boolean b4 = ipmiLanCommand.setDefaultPEFDestinationType(seq);
        boolean b5 = b1 && b2 && b3 && b4;
        return b5;
    }

    private void printSNMPList(IPMILanCommand ipmiLanCommand, int destCount) {
        String format = "%3s %20s %20s \n";
        MOut.G(this).printf(format, "Seq", "IP", "MAC");
        MOut.G(this).printf(format, "---", "--", "---");
        for (byte i2 = 1; i2 <= destCount; i2 = (byte)(i2 + 1)) {
            String ip = ipmiLanCommand.getDestinationIP(i2);
            String mac = ipmiLanCommand.getDestinationMAC(i2);
            MOut.G(this).printf(format, i2, ip, mac);
        }
    }
}

