/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.AbstractMBSensorEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.GigabitSwitchEntity;
import com.supermicro.ipmi.blade.InfiniBandEntity;
import com.supermicro.ipmi.blade.PowerSupplyEntity;
import com.supermicro.ipmi.blade.TemperatureData;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class ListSystemTemperatureCommand
extends SuperBladeCommand {
    StringBuffer formatedString;
    String formatTemplate = "  %-6s | %-12s | %-20s | %10s | %10s |\n";

    @Override
    public void runCommand() throws Exception {
        int i2;
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystemEntity = this.getBladeSystemEntity();
        if (bladeSystemEntity == null) {
            this.statusCode = 149;
            return;
        }
        this.formatedString = new StringBuffer();
        this.formatedString.append(String.format(this.formatTemplate, "Status", "Module", "Sensor", "Reading", "High Limit"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "------", "------", "-------", "----------"));
        for (i2 = 0; i2 < bladeSystemEntity.getBlades().length; ++i2) {
            AbstractMBSensorEntity mbSensorEntity = bladeSystemEntity.getMbSensors()[i2];
            this.addBladeTemp(mbSensorEntity, i2 + 1);
        }
        for (i2 = 0; i2 < bladeSystemEntity.getPowerSupplies().length; ++i2) {
            PowerSupplyEntity powerSupplyEntity = bladeSystemEntity.getPowerSupplies()[i2];
            this.addPowerTemp(powerSupplyEntity, i2 + 1);
        }
        for (i2 = 0; i2 < bladeSystemEntity.getGigabitSwitchs().length; ++i2) {
            GigabitSwitchEntity gigabitSwitchEntity = bladeSystemEntity.getGigabitSwitchs()[i2];
            this.addGBTemp(gigabitSwitchEntity, i2 + 1);
        }
        for (i2 = 0; i2 < bladeSystemEntity.getInfiniBands().length; ++i2) {
            InfiniBandEntity infiniBandEntity = bladeSystemEntity.getInfiniBands()[i2];
            this.addIBTemp(infiniBandEntity, i2 + 1);
        }
        MOut.G(this).println(this.formatedString.toString());
        this.statusCode = 0;
    }

    private void addBladeTemp(AbstractMBSensorEntity mbSensorEntity, int index) {
        if (mbSensorEntity.getFlag() == 0) {
            return;
        }
        ArrayList<TemperatureData> list = mbSensorEntity.getTemperatures();
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                TemperatureData t = list.get(i2);
                this.addRaw(t.getStatus(), "Blade " + index, t.getSensor(), t.getReading(), t.getHiLimit());
            }
        }
    }

    private void addPowerTemp(PowerSupplyEntity powerSupplyEntity, int index) {
        if (powerSupplyEntity.getPresent() == 0) {
            return;
        }
        String result = "";
        result = powerSupplyEntity.getTemperature() < powerSupplyEntity.getTemperatureHighLimit() ? "OK" : "Fail";
        this.addRaw(result, "Power " + index, "Temp.", this.showCandF(powerSupplyEntity.getTemperature()), this.showCandF(powerSupplyEntity.getTemperatureHighLimit()));
    }

    private void addGBTemp(GigabitSwitchEntity gigabitSwitchEntity, int index) {
        if (gigabitSwitchEntity.getPresent() == 0) {
            return;
        }
        String result = "";
        result = gigabitSwitchEntity.getSwitchTemperature() < 80 ? "OK" : "Fail";
        this.addRaw(result, "GBSW " + index, "Switch", "" + this.showCandF(gigabitSwitchEntity.getSwitchTemperature()), this.showCandF((byte)80));
    }

    private void addIBTemp(InfiniBandEntity infiniBandEntity, int index) {
        if (infiniBandEntity.getPresent() == 0) {
            return;
        }
        String result = "";
        result = infiniBandEntity.getTemperature() < 80 ? "OK" : "Fail";
        this.addRaw(result, "InfiniBand " + index, "Temp.", this.showCandF(infiniBandEntity.getTemperature()), this.showCandF((byte)80));
    }

    protected void addRaw(String checkedResult, String module, String name, String value, String high) {
        this.formatedString.append(String.format(this.formatTemplate, checkedResult, module, name, value, high));
    }

    protected String showCandF(byte c2) {
        if (c2 == -127) {
            return "N/A";
        }
        long f2 = Math.round(1.8 * (double)c2 + 32.0);
        return c2 + "C/" + (f2 < 100L ? " " : "") + f2 + "F";
    }

    public String getBar(byte c2) {
        return null;
    }
}

