/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOutFactory;
import com.supermicro.ipmi.text.Parser;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class MOut {
    public ArrayList<PrintStream> outputs = new ArrayList();
    public PrintStream recordOutStream = null;
    public String recordFilename = null;
    public boolean isPrintToScreen = true;
    public boolean isRecord = false;
    public boolean filterMode = false;
    private String filterString = "";
    private Pattern pattern;
    private static Hashtable<Parser, MOut> mouts = new Hashtable();
    private static MOut instance = new MOut(true);
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private PrintStream bufferPrintStream;
    public static String newline = System.getProperty("line.separator");

    public MOut() {
    }

    public MOut(boolean isGlobal) {
        this.outputs.add(System.out);
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        String isRecord = ca.getProperty("record");
        if ("on".equalsIgnoreCase(isRecord)) {
            try {
                this.recordFilename = "SMCIPMITool-" + this.getDateTime() + ".log";
                this.recordOutStream = new PrintStream(this.recordFilename);
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
            this.enableRecord();
        }
    }

    public String getDateTime() {
        Calendar c2 = Calendar.getInstance();
        SimpleDateFormat f2 = new SimpleDateFormat("yyyy-MM-dd-HH_mm_ss");
        return f2.format(c2.getTime());
    }

    public void enableRecord() {
        this.isRecord = true;
        this.outputs.add(this.recordOutStream);
    }

    public void disableRecord() {
        this.isRecord = false;
        this.outputs.remove(this.recordOutStream);
    }

    public void addPrintStream(PrintStream ps) {
        this.outputs.add(ps);
    }

    public void removePrintStream(PrintStream ps) {
        this.outputs.remove(ps);
    }

    public void print(String x) {
        if (this.filterMode && ((x = this.filter(x)).equals("\n") || x.length() == 0)) {
            return;
        }
        if (x != null) {
            x = x.replaceAll("\n", newline);
        }
        for (int i2 = 0; i2 < this.outputs.size(); ++i2) {
            PrintStream ps = this.outputs.get(i2);
            if (!this.isPrintToScreen && ps == System.out) continue;
            ps.print(x);
        }
    }

    public void printf(String format, Object ... args) {
        String x;
        if (this.filterMode && !this.match(x = String.format(format, args))) {
            return;
        }
        if (format != null) {
            format = format.replaceAll("\n", newline);
        }
        for (int i2 = 0; i2 < this.outputs.size(); ++i2) {
            PrintStream ps = this.outputs.get(i2);
            if (!this.isPrintToScreen && ps == System.out) continue;
            ps.printf(format, args);
        }
    }

    public void println() {
        this.println("\n");
    }

    public void println(String x) {
        if (this.filterMode && ((x = this.filter(x)).equals("\n") || x.length() == 0)) {
            return;
        }
        if (x != null) {
            x = x.replaceAll("\n", newline);
        }
        for (int i2 = 0; i2 < this.outputs.size(); ++i2) {
            PrintStream ps = this.outputs.get(i2);
            if (!this.isPrintToScreen && ps == System.out) continue;
            ps.println(x);
        }
    }

    public boolean match(String x) {
        return x.toUpperCase().indexOf(this.filterString.toUpperCase()) != -1;
    }

    public String filter(String x) {
        ArrayList<String> list = new ArrayList<String>();
        if (x == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(x, "\n", false);
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (!this.match(line)) continue;
            list.add(line);
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String item = (String)list.get(i2);
            sb.append(item);
            if (i2 == list.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setFilterString(String x) {
        this.filterString = x;
        this.pattern = Pattern.compile(x);
    }

    public void setFilterEnabled(boolean flag) {
        this.filterMode = flag;
    }

    public static MOut G() {
        return instance;
    }

    public static MOut G(Parser parser) {
        if (parser == null) {
            return MOut.G();
        }
        MOut aMout = mouts.get(parser);
        if (aMout == null) {
            return MOut.G();
        }
        return aMout;
    }

    public static MOut G(Command command) {
        Parser parser = command.getOriginalParser();
        if (parser == null) {
            return MOut.G();
        }
        return MOut.G(parser);
    }

    public void initLogFile(String filename) {
        this.recordFilename = filename;
        try {
            this.recordOutStream = new PrintStream(this.recordFilename);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        this.enableRecord();
    }

    public void enableBufferOutput() {
        this.bufferPrintStream = new PrintStream(this.buffer);
        this.outputs.add(this.bufferPrintStream);
    }

    public void disableBufferOutput() {
        this.outputs.remove(this.bufferPrintStream);
    }

    public void bufferToFile(String filename) throws IOException {
        FileWriter fw = new FileWriter(filename);
        fw.write(this.buffer.toString());
        fw.close();
    }

    public void resetBuffer() {
        this.buffer.reset();
    }

    public String getBufferContent() {
        return this.buffer.toString();
    }

    public static void addMOut(Parser parser, MOut aMout) {
        mouts.put(parser, aMout);
    }

    public static void removeMOut(Parser parser) {
        mouts.remove(parser);
    }

    public static void removeAllMOut() {
        mouts.clear();
    }

    public static void main(String[] args) {
        Parser p1 = new Parser();
        Parser p2 = new Parser();
        Parser p3 = new Parser();
        MOut.G().print("123");
        MOut.G().println("456");
        MOut m1 = MOutFactory.createMOutInstanceWtihALogFile("c:\\test1.txt");
        MOut.addMOut(p1, m1);
        MOut.G(p1).println("77");
        MOut m2 = MOutFactory.createMOutInstanceWtihALogFile("c:\\test2.txt");
        MOut.addMOut(p2, m2);
        MOut.G(p2).println("88");
        MOut m3 = MOutFactory.createMOutInstanceWtihALogFile("c:\\test3.txt");
        MOut.addMOut(p3, m3);
        MOut.G(p3).println("99");
        m3.enableBufferOutput();
        m3.print("123123123,");
        m3.print("aaaaaaaaa,");
        m3.println("bbbbbbbbb");
        System.out.println("m3 content = " + m3.getBufferContent());
        try {
            m3.bufferToFile("c:\\test4.txt");
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        m3.resetBuffer();
        System.out.println("m3 content after reset =" + m3.getBufferContent());
    }
}

