/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class MultiInteger {
    public static final int INTEGER = 0;
    public static final int STAR = 1;
    public static final int MULTI_INTEGER = 2;
    public static final int UNKNOWN = 99;

    public static boolean isMultiInteger(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        if (value.indexOf(",") == -1) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            String i2 = st.nextToken();
            try {
                Integer.parseInt(i2);
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return true;
    }

    public static int[] parseMultiInteger(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            String i2 = st.nextToken();
            try {
                list.add(Integer.parseInt(i2));
            }
            catch (NumberFormatException ex) {}
        }
        int[] intArray = new int[list.size()];
        for (int i3 = 0; i3 < list.size(); ++i3) {
            intArray[i3] = (Integer)list.get(i3);
        }
        return intArray;
    }

    public static int validateInteger(String value) {
        boolean isInteger = false;
        boolean isStar = false;
        boolean isMultiInteger = false;
        try {
            Integer.parseInt(value);
            return 0;
        }
        catch (NumberFormatException ex) {
            if ("*".equals(value)) {
                return 1;
            }
            if (MultiInteger.isMultiInteger(value)) {
                return 2;
            }
            return 99;
        }
    }

    public static void main(String[] args) {
        String a1 = "1123";
        String a2 = "1,1,2,3";
        String a3 = "1123,a,b";
        System.out.println(MultiInteger.isMultiInteger(a1));
        System.out.println(MultiInteger.isMultiInteger(a2));
        System.out.println(MultiInteger.isMultiInteger(a3));
        int[] intArray = MultiInteger.parseMultiInteger(a3);
        for (int i2 = 0; i2 < intArray.length; ++i2) {
            System.out.println(intArray[i2]);
        }
    }
}

