/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20AddPolicyCommand
extends NM20AbstractCommand {
    @Override
    public void runNM20Command() throws Exception {
        int tl;
        int l;
        byte a2;
        byte aggC;
        byte ptt;
        byte id;
        byte did;
        if (this.parameters == null || this.parameters.length < 9) {
            MOut.G(this).println("addPolicy <dID> <pID> <ptt> <agg> <a> <l> <t> <tl> <p>");
            MOut.G(this).println("dID: Domain ID");
            MOut.G(this).println("  0 \u2013 Entire platform");
            MOut.G(this).println("  1 \u2013 CPU subsystem");
            MOut.G(this).println("  2 \u2013 Memory subsystem");
            MOut.G(this).println("pID: Policy ID");
            MOut.G(this).println("ptt: Policy Trigger Type:");
            MOut.G(this).println("  0 \u2013 No Policy Trigger");
            MOut.G(this).println("  1 \u2013 Inlet Temperature Limit Policy Trigger in [Celsius]");
            MOut.G(this).println("  2 \u2013 Missing Power Reading Timeout in 1/10th of second");
            MOut.G(this).println("  3 \u2013 Time After Host Reset Trigger in 1/10th of second");
            MOut.G(this).println("  4 \u2013 Boot time policy");
            MOut.G(this).println("agg: Aggressive CPU Power Correction:");
            MOut.G(this).println("  0 \u2013 Automatic mode (default).");
            MOut.G(this).println("  1 \u2013 Force non-aggressive mode");
            MOut.G(this).println("  2 \u2013 Force aggressive mode");
            MOut.G(this).println("a: Policy Exception Actions");
            MOut.G(this).println("  1 - send alert");
            MOut.G(this).println("  2 - shutdown system");
            MOut.G(this).println("  3 - send alert & shutdown system");
            MOut.G(this).println("l: Policy Target Limit");
            MOut.G(this).println("t: Correction Time Limit (ms)");
            MOut.G(this).println("tl: Policy Trigger Limit");
            MOut.G(this).println("p: Statistics Reporting Period in seconds");
            return;
        }
        int t = 60000;
        int p = 1;
        try {
            did = Byte.parseByte(this.parameters[0]);
            id = Byte.parseByte(this.parameters[1]);
            ptt = Byte.parseByte(this.parameters[2]);
            aggC = Byte.parseByte(this.parameters[3]);
            a2 = Byte.parseByte(this.parameters[4]);
            l = Integer.parseInt(this.parameters[5]);
            t = Integer.parseInt(this.parameters[6]);
            tl = Integer.parseInt(this.parameters[7]);
            p = Integer.parseInt(this.parameters[8]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            return;
        }
        IPMINM20Command.NodeManagerPolicySetting policySetting = this.ipmiNM20Command.createNodeManagerPolicySetting();
        policySetting.domainID = (byte)(did | 0x10);
        policySetting.policyID = id;
        policySetting.policyConfig = (byte)(aggC << 5 & 0x60 | 0x10 | ptt & 0xF);
        policySetting.PolicyException = a2;
        ByteUtility.intTo2Bytes(policySetting.powerLimit, 0, l);
        ByteUtility.intTo4Bytes(policySetting.correctionTimeLimit, 0, t);
        ByteUtility.intTo2Bytes(policySetting.policyTriggerLimit, 0, tl);
        ByteUtility.intTo2Bytes(policySetting.statisticsReportingPeriod, 0, p);
        try {
            this.ipmiNM20Command.setNodeManagerPolicy(policySetting);
            this.ipmiNM20Command.enableDisableNodeManagerPolicyControl((byte)5, did, id);
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            return;
        }
        MOut.G(this).println("Done");
    }
}

