/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class StatusPrompt {
    public static StatusPrompt instance = new StatusPrompt();
    ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
    private boolean flag_username = true;
    private boolean flag_ip = true;
    private boolean flag_mbName = true;
    private boolean flag_ACPI = true;
    private boolean flag_powerW = true;
    private boolean flag_fwVer = true;
    private boolean flag_fwType = true;
    private boolean flag_time = true;
    String username;
    String ip;
    String mbName;
    String acpi;
    String powerW;
    String fwVer;
    String fwType;
    String time;
    IPMIInterfaceConfig config;

    public static StatusPrompt getInstance() {
        return instance;
    }

    public void setIPMIInterfaceConfig(IPMIInterfaceConfig config) {
        this.config = config;
    }

    public void loadProperties() {
        String temp = "";
        temp = this.ca.getProperty("prompt_username");
        this.flag_username = "on".equals(temp);
        temp = this.ca.getProperty("prompt_ip");
        this.flag_ip = "on".equals(temp);
        temp = this.ca.getProperty("prompt_mb_name");
        this.flag_mbName = "on".equals(temp);
        temp = this.ca.getProperty("prompt_acpi");
        this.flag_ACPI = "on".equals(temp);
        temp = this.ca.getProperty("prompt_powerW");
        this.flag_powerW = "on".equals(temp);
        temp = this.ca.getProperty("prompt_fwVer");
        this.flag_fwVer = "on".equals(temp);
        temp = this.ca.getProperty("prompt_time");
        this.flag_time = "on".equals(temp);
    }

    public String getPromptString() {
        String retStr = "";
        if (this.flag_username && this.flag_ip) {
            retStr = retStr + this.username + "@" + this.ip + " ";
        } else if (this.flag_username) {
            retStr = retStr + this.username + " ";
        } else if (this.flag_ip) {
            retStr = retStr + this.ip + " ";
        }
        if (this.flag_mbName && this.mbName.length() != 0) {
            retStr = retStr + this.mbName + " ";
        }
        String status = "";
        if (this.flag_ACPI && this.acpi.length() != 0) {
            status = status + this.acpi;
        }
        if (this.flag_powerW && this.powerW.length() != 0) {
            status = status.length() == 0 ? status + this.powerW : status + "," + this.powerW;
        }
        if (this.flag_fwVer && this.fwVer.length() != 0) {
            status = status.length() == 0 ? status + this.fwVer : status + "," + this.fwVer;
        }
        if (status.length() != 0) {
            retStr = retStr + "(" + status + ") ";
        }
        if (this.flag_time) {
            retStr = retStr + this.time + " ";
        }
        if (this.fwType.length() != 0) {
            retStr = retStr + this.fwType;
        }
        return retStr;
    }

    public boolean updateStatus() {
        this.username = this.config.getUserName();
        this.ip = this.config.getIp();
        this.mbName = "";
        this.acpi = "";
        this.powerW = "";
        this.fwVer = "";
        this.fwType = "";
        this.time = "";
        this.fwType = this.getFWType();
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        IPMINM20Command ipmiNM20Command = new IPMINM20Command(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(this.config, ipmiSDRCommand);
        if (sessionController == null) {
            return false;
        }
        ipmiSDRCommand.setIPMIInterface(ipmiSDRCommand.getIPMIInterface());
        ipmiOEMCommand.setIPMIInterface(ipmiSDRCommand.getIPMIInterface());
        ipmiMessagingCommand.setIPMIInterface(ipmiSDRCommand.getIPMIInterface());
        ipmiGlobalCommand.setIPMIInterface(ipmiSDRCommand.getIPMIInterface());
        ipmiNM20Command.setIPMIInterface(ipmiSDRCommand.getIPMIInterface());
        this.mbName = ipmiOEMCommand.getBoardModel();
        if (this.mbName == null) {
            this.mbName = "";
        }
        ACPIInfo acpiInfo = ipmiGlobalCommand.getACPI();
        this.acpi = acpiInfo.getSystemStateInfo();
        try {
            int value = ipmiNM20Command.oemGetPowerConsumption();
            if (value != 0) {
                this.powerW = "" + value + "w";
            }
        }
        catch (IPMIException ex) {
            // empty catch block
        }
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        this.fwVer = "v" + deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2);
        SimpleDateFormat f2 = new SimpleDateFormat("HH:mm");
        Calendar c2 = Calendar.getInstance();
        this.time = f2.format(c2.getTime());
        sessionController.closeSession();
        return true;
    }

    public String getFWType() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        String prompt = StatusPrompt.getFWTypeLabel(guid);
        return prompt;
    }

    public static String getFWType(IPMIInterfaceConfig aConfig) {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(aConfig.getIp());
        String prompt = StatusPrompt.getFWTypeLabel(guid);
        return prompt;
    }

    private static String getFWTypeLabel(byte[] guid) {
        String prompt = "";
        prompt = guid == null ? "UNKNOWN" : (IPMIMessagingCommand.isCMMGUID(guid) ? "CMM" : (IPMIMessagingCommand.isPepperconGUID(guid) ? "SIM-KVM-IPMI" : (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) ? "SIM-IPMI" : (IPMIMessagingCommand.isSIMBL(guid) ? "SIMBL" : (IPMIMessagingCommand.isOSAGUID(guid) ? "SUPERO-IPMI" : (IPMIMessagingCommand.isAMIGUID(guid) ? "SIM(W)" : (IPMIMessagingCommand.isAMISIMBLGUID(guid) ? "SIMBL(W)" : (IPMIMessagingCommand.isATENGUID(guid) ? "SIM(WA)" : (IPMIMessagingCommand.isAMIX9GUID(guid) ? "SIM(X9)" : (IPMIMessagingCommand.isATENAspeedGUID(guid) ? "ASPD_T" : (IPMIMessagingCommand.isAMIAspeedGUID(guid) ? "ASPD_M" : "IPMI")))))))))));
        return prompt;
    }

    public void setFlag_All(boolean flag) {
        this.flag_username = flag;
        this.flag_ip = flag;
        this.flag_mbName = flag;
        this.flag_ACPI = flag;
        this.flag_powerW = flag;
        this.flag_fwVer = flag;
        this.flag_time = flag;
        this.ca.setProperty("prompt_username", flag ? "on" : "off");
        this.ca.setProperty("prompt_ip", flag ? "on" : "off");
        this.ca.setProperty("prompt_mb_name", flag ? "on" : "off");
        this.ca.setProperty("prompt_acpi", flag ? "on" : "off");
        this.ca.setProperty("prompt_powerW", flag ? "on" : "off");
        this.ca.setProperty("prompt_fwVer", flag ? "on" : "off");
        this.ca.setProperty("prompt_time", flag ? "on" : "off");
    }

    public void setFlag_username(boolean flag_username) {
        this.flag_username = flag_username;
        this.ca.setProperty("prompt_username", flag_username ? "on" : "off");
    }

    public void setFlag_ip(boolean flag_ip) {
        this.flag_ip = flag_ip;
        this.ca.setProperty("prompt_ip", flag_ip ? "on" : "off");
    }

    public void setFlag_mbName(boolean flag_mbName) {
        this.flag_mbName = flag_mbName;
        this.ca.setProperty("prompt_mb_name", flag_mbName ? "on" : "off");
    }

    public void setFlag_ACPI(boolean flag_ACPI) {
        this.flag_ACPI = flag_ACPI;
        this.ca.setProperty("prompt_acpi", flag_ACPI ? "on" : "off");
    }

    public void setFlag_powerW(boolean flag_powerW) {
        this.flag_powerW = flag_powerW;
        this.ca.setProperty("prompt_powerW", flag_powerW ? "on" : "off");
    }

    public void setFlag_fwVer(boolean flag_fwVer) {
        this.flag_fwVer = flag_fwVer;
        this.ca.setProperty("prompt_fwVer", flag_fwVer ? "on" : "off");
    }

    public void setFlag_fwType(boolean flag_fwType) {
        this.flag_fwType = flag_fwType;
    }

    public void setFlag_time(boolean flag_time) {
        this.flag_time = flag_time;
    }

    public boolean isFlag_username() {
        return this.flag_username;
    }

    public boolean isFlag_ip() {
        return this.flag_ip;
    }

    public boolean isFlag_mbName() {
        return this.flag_mbName;
    }

    public boolean isFlag_ACPI() {
        return this.flag_ACPI;
    }

    public boolean isFlag_powerW() {
        return this.flag_powerW;
    }

    public boolean isFlag_fwVer() {
        return this.flag_fwVer;
    }

    public boolean isFlag_fwType() {
        return this.flag_fwType;
    }

    public boolean isFlag_time() {
        return this.flag_time;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.23.92");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        StatusPrompt sp = new StatusPrompt();
        sp.setIPMIInterfaceConfig(config);
        sp.updateStatus();
        System.out.println(sp.getPromptString());
    }
}

