/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UserListCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        int numberOfAvailableUser = ipmiMessagingCommand.getNumberOfAvailableUser();
        int countOfCurrentEnabledUser = ipmiMessagingCommand.getCountOfCurrentEnabledUser();
        MOut.G(this).println("Maximum number of Users          : " + numberOfAvailableUser);
        MOut.G(this).println("Count of currently enabled Users : " + countOfCurrentEnabledUser);
        String formatTemplate = "%8s | %-14s | %-18s | %-12s \n";
        MOut.G(this).printf(formatTemplate, "User ID", "User Name", "Privilege Level", "Enable");
        MOut.G(this).printf(formatTemplate, "-------", "-----------", "---------------", "------");
        for (int i2 = 2; i2 <= numberOfAvailableUser; ++i2) {
            String name = ipmiMessagingCommand.getUserNameByID((byte)i2);
            if (name == null || name.length() == 0) continue;
            byte privilege = ipmiMessagingCommand.getUserPrivilegeByID((byte)i2);
            boolean isEnabled = ipmiMessagingCommand.isEnableUser((byte)i2);
            MOut.G(this).printf(formatTemplate, "" + i2, name, this.getPriviledgeString(privilege), isEnabled ? "Yes" : "No");
        }
        this.statusCode = 0;
    }

    private String getPriviledgeString(int p) {
        switch (p) {
            case 4: {
                return "Administrator";
            }
            case 3: {
                return "Operator";
            }
            case 2: {
                return "User";
            }
            case 1: {
                return "CallBack";
            }
        }
        return "";
    }
}

