/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.softkeyboard;

import com.supermicro.softkeyboard.Key;
import com.supermicro.softkeyboard.KeyChar;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class KeyButton
extends JLabel {
    public static final int KEY_DISPLAY_STATUS_NORMAL = 0;
    public static final int KEY_DISPLAY_STATUS_MODIFIER = 1;
    public static final int KEY_TYPE_NORMAL = 0;
    public static final int KEY_TYPE_TOGGLE = 1;
    Key key;
    KeyChar keyChar;
    int keyDisplayStatus;
    int keyType = 0;
    boolean keyToggleStatus = false;
    boolean isNumlock = false;
    boolean borderVisible = true;
    Color keyLeftUpColor = Color.WHITE;
    Color keyRightDownColor = Color.DARK_GRAY;
    boolean mouseInVisible = false;
    Color mouseInColor = Color.GRAY;
    boolean mousePressedVisible = false;
    boolean lockVisible = false;
    Color lockColor = Color.YELLOW;

    public KeyButton(Key key, KeyChar keyChar) {
        this.key = key;
        this.keyChar = keyChar;
        this.initial();
    }

    public void initial() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                KeyButton.this.setCursor(new Cursor(12));
                KeyButton.this.setMouseInVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                KeyButton.this.setCursor(new Cursor(0));
                KeyButton.this.setMouseInVisible(false);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                KeyButton.this.setMouseClickVisible(true);
                if (KeyButton.this.keyType == 1) {
                    KeyButton.this.keyToggleStatus = !KeyButton.this.keyToggleStatus;
                    KeyButton.this.setLockVisible(KeyButton.this.keyToggleStatus);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                KeyButton.this.setMouseClickVisible(false);
            }
        });
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.darwBackground(graphics);
        if (this.borderVisible) {
            this.drawBorder(graphics);
        }
        if (this.mouseInVisible) {
            this.drawMouseIn(graphics);
        }
        if (this.mousePressedVisible) {
            this.drawMousePressed(graphics);
        }
        if (this.lockVisible) {
            this.drawLocked(graphics);
        }
        if (this.keyChar.isShow()) {
            this.showKeyChar(graphics);
        }
    }

    private void drawLocked(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.lockColor);
        graphics.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        graphics.setColor(color);
    }

    private void drawMousePressed(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.keyRightDownColor);
        graphics.drawLine(0, 0, this.getWidth() - 1, 0);
        graphics.drawLine(0, 0, 0, this.getHeight() - 1);
        graphics.setColor(this.keyLeftUpColor);
        graphics.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        graphics.setColor(color);
    }

    private void darwBackground(Graphics graphics) {
        this.setOpaque(false);
        Graphics2D graphics2D = (Graphics2D)graphics;
        GradientPaint gradientPaint = new GradientPaint(1.0f, 1.0f, new Color(215, 235, 255), this.getWidth(), this.getHeight(), new Color(140, 198, 255));
        GradientPaint gradientPaint2 = new GradientPaint(1.0f, 1.0f, new Color(170, 199, 246), this.getWidth(), this.getHeight(), new Color(91, 147, 238));
        GradientPaint gradientPaint3 = new GradientPaint(1.0f, 1.0f, new Color(238, 238, 238), this.getWidth(), this.getHeight(), new Color(175, 175, 175));
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(1, 1, this.getWidth() - 1, this.getHeight() - 1);
        graphics2D.setPaint(null);
    }

    private void drawMouseIn(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.mouseInColor);
        graphics.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        graphics.setColor(color);
    }

    private void drawBorder(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.keyLeftUpColor);
        graphics.drawLine(0, 0, this.getWidth() - 1, 0);
        graphics.drawLine(0, 0, 0, this.getHeight() - 1);
        graphics.setColor(this.keyRightDownColor);
        graphics.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        graphics.setColor(color);
    }

    private void showKeyChar(Graphics graphics) {
        String string = "";
        switch (this.keyDisplayStatus) {
            case 0: {
                string = this.keyChar.getKeyNormalChar();
                break;
            }
            case 1: {
                string = this.keyChar.getKeyModifierChar() != null ? this.keyChar.getKeyModifierChar() : this.keyChar.getKeyNormalChar();
            }
        }
        graphics.drawString(string, 2, this.getHeight() - 5);
        if (this.keyChar.getKeyNumLockChar() != null) {
            String string2 = this.keyChar.getKeyNumLockChar();
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.white);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.8f));
            graphics2D.drawString(string2, this.getWidth() / 2 - 3, this.getHeight() - 11);
            graphics2D.setColor(color);
        }
    }

    public void clearToggleStatus() {
        this.keyToggleStatus = false;
        this.setLockVisible(this.keyToggleStatus);
        this.repaint();
    }

    public void setBorderVisible(boolean bl) {
        this.borderVisible = bl;
        this.repaint();
    }

    public void setMouseInVisible(boolean bl) {
        this.mouseInVisible = bl;
        this.repaint();
    }

    public void setMouseClickVisible(boolean bl) {
        this.mousePressedVisible = bl;
        this.repaint();
    }

    public void setKeyDisplayStatus(int n) {
        this.keyDisplayStatus = n;
        this.repaint();
    }

    public void setKeyChar(KeyChar keyChar) {
        this.keyChar = keyChar;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public void setIsNumlock(boolean bl) {
        this.isNumlock = bl;
        this.repaint();
    }

    public void setLockVisible(boolean bl) {
        this.lockVisible = bl;
        this.repaint();
    }

    public void setMousePressedVisible(boolean bl) {
        this.mousePressedVisible = bl;
        this.repaint();
    }

    public void setKeyType(int n) {
        this.keyType = n;
    }

    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    public boolean isMouseInVisible() {
        return this.mouseInVisible;
    }

    public boolean isMouseClickVisible() {
        return this.mousePressedVisible;
    }

    public int getKeyDisplayStatus() {
        return this.keyDisplayStatus;
    }

    public KeyChar getKeyChar() {
        return this.keyChar;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean isIsNumlock() {
        return this.isNumlock;
    }

    public boolean isLockVisible() {
        return this.lockVisible;
    }

    public boolean isMousePressedVisible() {
        return this.mousePressedVisible;
    }

    public int getKeyType() {
        return this.keyType;
    }
}

