/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;

public abstract class FlowText
extends Canvas {
    private Vector lines = new Vector();
    private Dimension minDim = new Dimension(10, 10);
    private Dimension prefDim;
    private int prefWidth = 300;
    private int height;
    private int width = 300;
    private boolean forceSize;
    private boolean optWidth;
    private FontMetrics fm;
    protected static final Object T_NEWLINE = new Object();
    protected static final Object T_HRULE = new Object();
    protected Vector tokens = new Vector();
    protected boolean layoutDirty = true;

    public FlowText() {
    }

    public FlowText(int width) {
        this.width = width;
        this.prefWidth = width;
    }

    @Override
    public Dimension getPreferredSize() {
        this.checkLayout();
        return this.prefDim;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.forceSize) {
            return this.getPreferredSize();
        }
        return this.minDim;
    }

    public void setForceSize(boolean b2) {
        this.forceSize = true;
    }

    public void setOptimizeWidth(boolean b2) {
        this.optWidth = true;
    }

    @Override
    public void update(Graphics g2) {
        this.paint(g2);
    }

    @Override
    public void paint(Graphics g2) {
        this.checkSize();
        this.checkLayout();
        int h2 = this.fm.getHeight();
        int y = this.fm.getMaxAscent();
        int size = this.lines.size();
        Dimension d2 = this.getSize();
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, d2.width, d2.height);
        g2.setColor(this.getForeground());
        for (int i2 = 0; i2 < size; ++i2) {
            Object o = this.lines.elementAt(i2);
            if (o instanceof String) {
                g2.drawString((String)o, 0, y);
            } else if (o == T_HRULE) {
                int liney = y - this.fm.getMaxAscent() / 2;
                g2.drawLine(0, liney, this.width, liney);
            }
            y += h2;
        }
    }

    public void setPreferredWidth(int i2) {
        this.prefWidth = i2;
        this.layoutDirty = true;
    }

    public int getPreferredWidth() {
        return this.prefWidth;
    }

    public abstract void setText(String var1);

    private void checkSize() {
        Dimension dim = this.getSize();
        if (this.width != dim.width || this.height != dim.height) {
            this.width = dim.width;
            this.height = dim.height;
            this.layoutDirty = true;
        }
    }

    private void checkLayout() {
        int maxw = 0;
        if (this.fm == null) {
            this.fm = this.getFontMetrics(this.getFont());
        }
        if (this.layoutDirty) {
            String line = null;
            this.lines.setSize(0);
            int tokSize = this.tokens.size();
            for (int i2 = 0; i2 < tokSize; ++i2) {
                Object token = this.tokens.elementAt(i2);
                if (token == T_NEWLINE) {
                    if (line != null) {
                        this.lines.addElement(line);
                        line = null;
                        continue;
                    }
                    this.lines.addElement("");
                    continue;
                }
                if (token == T_HRULE) {
                    if (line != null) {
                        this.lines.addElement(line);
                        line = null;
                    }
                    this.lines.addElement(T_HRULE);
                    continue;
                }
                if (!(token instanceof String)) continue;
                String testline = line == null ? (String)token : line + ' ' + (String)token;
                int strw = this.fm.stringWidth(testline);
                if (strw > this.width) {
                    this.lines.addElement(line);
                    line = (String)token;
                    continue;
                }
                line = testline;
                if (strw <= maxw) continue;
                maxw = strw;
            }
            if (line != null) {
                this.lines.addElement(line);
            }
            this.layoutDirty = false;
            this.height = this.fm.getHeight() * (this.lines.size() - 1) + this.fm.getMaxAscent() + this.fm.getMaxDescent();
            this.prefDim = this.optWidth ? new Dimension(maxw, this.height) : new Dimension(this.prefWidth, this.height);
        }
    }

    protected void maybeAddToken(StringBuffer token) {
        if (token.length() != 0) {
            this.tokens.addElement(token.toString());
            token.setLength(0);
        }
    }
}

