/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.CheckboxMenuItem;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MenuLabel
extends Label
implements MouseListener,
MouseMotionListener {
    private boolean over = false;
    private PopupMenu menu;

    public MenuLabel(PopupMenu m) {
        super(m.getLabel(), 1);
        m.setLabel(null);
        this.menu = m;
        this.registerActionListener(m, new MenuListener());
        this.add(this.menu);
        this.setBackground(SystemColor.control);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void registerActionListener(Menu m, MenuListener l) {
        for (int i2 = 0; i2 < m.getItemCount(); ++i2) {
            MenuItem it = m.getItem(i2);
            if (it instanceof Menu) {
                this.registerActionListener((Menu)it, l);
                continue;
            }
            if (it instanceof CheckboxMenuItem) {
                ((CheckboxMenuItem)it).addItemListener(l);
                continue;
            }
            it.addActionListener(l);
        }
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        if (this.over) {
            int w = this.getSize().width - 1;
            int h2 = this.getSize().height - 1;
            g2.setColor(SystemColor.controlHighlight);
            g2.drawLine(0, 0, w, 0);
            g2.drawLine(0, 0, 0, h2);
            g2.setColor(SystemColor.controlShadow);
            g2.drawLine(0, h2, w, h2);
            g2.drawLine(w, 0, w, h2);
        }
    }

    @Override
    public void update(Graphics g2) {
        g2.setColor(SystemColor.control);
        g2.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        this.paint(g2);
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        this.over = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.over = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        Label b2 = (Label)e2.getSource();
        this.menu.show(b2, 0, b2.getSize().height);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    class MenuListener
    implements ActionListener,
    ItemListener {
        MenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            MenuLabel.this.over = false;
            MenuLabel.this.repaint();
        }

        @Override
        public void itemStateChanged(ItemEvent e2) {
            MenuLabel.this.over = false;
            MenuLabel.this.repaint();
        }
    }
}

