/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import nn.pp.rc.J14MouseBtnMaskHandler;
import nn.pp.rc.J14WheelHandler;
import nn.pp.rc.JVMVersionInfo;
import nn.pp.rc.RCProto;

public abstract class MouseHandler
implements ActionListener {
    protected Point oldPos = new Point(0, 0);
    protected RCProto proto = null;
    protected Component comp;
    private J14WheelHandler whandler = null;
    private int pointerMask = 0;
    private J14MouseBtnMaskHandler j14_mbtn_handler = null;

    public abstract boolean needMouseHandling();

    public abstract void handleMouseSyncKey();

    public abstract int getPointerMask();

    protected abstract void processMouseEvent(MouseEvent var1);

    public MouseHandler(Component comp) {
        this.comp = comp;
        if (JVMVersionInfo.getJVMVersionInfo().isJava14()) {
            this.whandler = new J14WheelHandler();
            this.j14_mbtn_handler = new J14MouseBtnMaskHandler();
        }
    }

    public void setRCProto(RCProto proto) {
        this.proto = proto;
        if (this.whandler != null) {
            this.whandler.setRCProto(proto);
        }
    }

    public void clearPointerMask() {
        this.pointerMask = 0;
    }

    public int getPointerMask(AWTEvent e2) {
        MouseEvent localme = (MouseEvent)e2;
        if (this.j14_mbtn_handler != null) {
            this.pointerMask = this.j14_mbtn_handler.processMouseBtnEvent(localme, this.pointerMask);
        } else {
            int mods = localme.getModifiers();
            int mask = 0;
            if ((mods & 0x10) != 0) {
                mask = 1;
            } else if ((mods & 4) != 0) {
                mask = 4;
            } else if ((mods & 8) != 0) {
                mask = 2;
            }
            if (localme.getID() == 501) {
                this.pointerMask = mask;
            } else if (localme.getID() == 502) {
                this.pointerMask = 0;
            }
        }
        return this.pointerMask;
    }

    public void handleMouseEvent(MouseEvent me) {
        if (this.whandler != null && this.whandler.processWheelEvent(me, this.getPointerMask())) {
            return;
        }
        this.processMouseEvent(me);
    }
}

