/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.util.Date;

public class SasEvent {
    public static final int ExistingSession = 1;
    public static final int ExistingKvmSession = 2;
    public static final int UserLoginFailure = 3;
    public static final int UserSessionOpened = 4;
    public static final int UserSessionClosed = 5;
    public static final int KvmSessionOpened = 6;
    public static final int KvmSessionClosed = 7;
    public static final int KvmExclusiveOn = 8;
    public static final int KvmExclusiveOff = 9;
    public static final int Input = 10;
    public static final int KvmSwitch = 11;
    public static final int ResetSessions = 12;
    public static final int InputPointer = 1;
    public static final int InputPointerRelative = 2;
    public static final int InputMouseSync = 3;
    public static final int InputKeyboard = 4;
    public int type;
    public Date time;
    public long session;
    public int len;
    public SasInputEvent inputEvent;
    public SasExistingSession exSession;
    public SasExistingKvmSession exKvmSession;
    public SasNewSession newSession;
    public SasUserInfo userInfo;
    public SasKvmSwitchEvent kvmSwitchEvent;
    public long causingKvmSession;

    private int getEventType(int rfbEvent) {
        switch (rfbEvent) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
        }
        return -1;
    }

    public SasEvent(int type, Date time, long session, int len) {
        this.type = this.getEventType(type);
        this.time = time;
        this.session = session;
        this.len = len;
    }

    void setKeyEvent(int type, int keycode) {
        this.inputEvent = new SasInputEvent(type, keycode);
    }

    void setMouseEvent(int type, int buttonMask, int x, int y, int z) {
        this.inputEvent = new SasInputEvent(type, buttonMask, x, y, z);
    }

    void setMouseSyncEvent(int type, int syncType) {
        String syncTypeString;
        switch (syncType) {
            case 0: {
                syncTypeString = "Normal";
                break;
            }
            case 1: {
                syncTypeString = "Hard";
                break;
            }
            case 2: {
                syncTypeString = "Fast";
                break;
            }
            default: {
                syncTypeString = "Unknown";
            }
        }
        this.inputEvent = new SasInputEvent(type, syncTypeString);
    }

    void setExistingSession(boolean self, String user, String ip, Date loginTime) {
        this.exSession = new SasExistingSession(self, user, ip, loginTime);
    }

    void setExistingKvmSession(long kvmSessionId, boolean exclusive, Date loginTime) {
        this.exKvmSession = new SasExistingKvmSession(kvmSessionId, exclusive, loginTime);
    }

    void setNewSession(String user, String ip, Date loginTime) {
        this.newSession = new SasNewSession(user, ip, loginTime);
    }

    void setUserInfo(String user, String ip) {
        this.userInfo = new SasUserInfo(user, ip);
    }

    void setCausingKvmSession(long causingKvmSession) {
        this.causingKvmSession = causingKvmSession;
    }

    void setKvmSwitchEvent(int channel, int unit, int port) {
        this.kvmSwitchEvent = new SasKvmSwitchEvent(channel, unit, port);
    }

    public class SasKvmSwitchEvent {
        public int channel;
        public int unit;
        public int port;

        SasKvmSwitchEvent(int channel, int unit, int port) {
            this.channel = channel;
            this.unit = unit;
            this.port = port;
        }
    }

    public class SasNewSession {
        public String user;
        public String ip;
        public Date loginTime;

        SasNewSession(String user, String ip, Date loginTime) {
            this.user = user;
            this.ip = ip;
            this.loginTime = loginTime;
        }
    }

    public class SasUserInfo {
        public String user;
        public String ip;

        SasUserInfo(String user, String ip) {
            this.user = user;
            this.ip = ip;
        }
    }

    public class SasExistingKvmSession {
        public boolean exclusive;
        public long kvmSessionId;
        public Date loginTime;

        SasExistingKvmSession(long kvmSessionId, boolean exclusive, Date loginTime) {
            this.exclusive = exclusive;
            this.kvmSessionId = kvmSessionId;
            this.loginTime = loginTime;
        }
    }

    public class SasExistingSession {
        public boolean self;
        public String user;
        public String ip;
        public Date loginTime;

        SasExistingSession(boolean self, String user, String ip, Date loginTime) {
            this.self = self;
            this.user = user;
            this.ip = ip;
            this.loginTime = loginTime;
        }
    }

    public class SasInputEvent {
        public int type;
        public int buttonMask;
        public int x;
        public int y;
        public int z;
        public int keycode;
        public String syncType;

        int getInputType(int rfbType) {
            switch (rfbType) {
                case 5: {
                    return 1;
                }
                case 147: {
                    return 2;
                }
                case 134: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
            return 0;
        }

        SasInputEvent(int type, int buttonMask, int x, int y, int z) {
            this.type = this.getInputType(type);
            this.buttonMask = buttonMask;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        SasInputEvent(int type, int keycode) {
            this.type = this.getInputType(type);
            this.keycode = keycode;
        }

        SasInputEvent(int type, String syncType) {
            this.type = this.getInputType(type);
            this.syncType = syncType;
        }
    }
}

