/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;

public class Hex
implements BinaryEncoder,
BinaryDecoder {
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] decodeHex(char[] data) throws DecoderException {
        int l = data.length;
        if ((l & 1) != 0) {
            throw new DecoderException("Odd number of characters.");
        }
        byte[] out = new byte[l >> 1];
        int i2 = 0;
        int j2 = 0;
        while (j2 < l) {
            int f2 = Character.digit(data[j2++], 16) << 4;
            out[i2] = (byte)((f2 |= Character.digit(data[j2++], 16)) & 0xFF);
            ++i2;
        }
        return out;
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j2 = 0;
        for (int i2 = 0; i2 < l; ++i2) {
            out[j2++] = digits[(0xF0 & data[i2]) >>> 4];
            out[j2++] = digits[0xF & data[i2]];
        }
        return out;
    }

    public byte[] decode(byte[] array) throws DecoderException {
        return Hex.decodeHex(new String(array).toCharArray());
    }

    public Object decode(Object object) throws DecoderException {
        try {
            char[] charArray = object instanceof String ? ((String)object).toCharArray() : (char[])object;
            return Hex.decodeHex(charArray);
        }
        catch (ClassCastException e2) {
            throw new DecoderException(e2.getMessage());
        }
    }

    public byte[] encode(byte[] array) {
        return new String(Hex.encodeHex(array)).getBytes();
    }

    public Object encode(Object object) throws EncoderException {
        try {
            byte[] byteArray = object instanceof String ? ((String)object).getBytes() : (byte[])object;
            return Hex.encodeHex(byteArray);
        }
        catch (ClassCastException e2) {
            throw new EncoderException(e2.getMessage());
        }
    }
}

