/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class RefinedSoundex
implements StringEncoder {
    public static final char[] US_ENGLISH_MAPPING = "01360240043788015936020505".toCharArray();
    public static final RefinedSoundex US_ENGLISH = new RefinedSoundex();
    private char[] soundexMapping;

    public RefinedSoundex() {
        this(US_ENGLISH_MAPPING);
    }

    public RefinedSoundex(char[] mapping) {
        this.soundexMapping = mapping;
    }

    public String soundex(String str) {
        if (null == str || str.length() == 0) {
            return str;
        }
        StringBuffer sBuf = new StringBuffer();
        str = str.toUpperCase();
        sBuf.append(str.charAt(0));
        char last = '*';
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char current = this.getMappingCode(str.charAt(i2));
            if (current == last) continue;
            if (current != '\u0000') {
                sBuf.append(current);
            }
            last = current;
        }
        return sBuf.toString();
    }

    public String encode(String pString) {
        return this.soundex(pString);
    }

    public Object encode(Object pObject) throws EncoderException {
        if (!(pObject instanceof String)) {
            throw new EncoderException("Parameter supplied to RefinedSoundex encode is not of type java.lang.String");
        }
        String result = this.soundex((String)pObject);
        return result;
    }

    private char getMappingCode(char c2) {
        if (!Character.isLetter(c2)) {
            return '\u0000';
        }
        return this.soundexMapping[Character.toUpperCase(c2) - 65];
    }
}

