/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;

public class URLCodec
implements BinaryEncoder,
BinaryDecoder,
StringEncoder,
StringDecoder {
    protected String encoding = "US-ASCII";
    protected static final BitSet WWW_FORM_URL;

    public URLCodec() {
    }

    public URLCodec(String encoding) {
        this.encoding = encoding;
    }

    public static final byte[] encodeUrl(BitSet urlsafe, byte[] pArray) {
        if (pArray == null) {
            return null;
        }
        if (urlsafe == null) {
            urlsafe = WWW_FORM_URL;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < pArray.length; ++i2) {
            int b2 = pArray[i2];
            if (b2 >= 0 && urlsafe.get(b2)) {
                if (b2 == 32) {
                    b2 = 43;
                }
                buffer.write(b2);
                continue;
            }
            buffer.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b2 >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b2 & 0xF, 16));
            buffer.write(hex1);
            buffer.write(hex2);
        }
        return buffer.toByteArray();
    }

    public static final byte[] decodeUrl(byte[] pArray) throws DecoderException {
        if (pArray == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < pArray.length; ++i2) {
            byte b2 = pArray[i2];
            if (b2 == 43) {
                buffer.write(32);
                continue;
            }
            if (b2 == 37) {
                try {
                    int u = Character.digit((char)pArray[++i2], 16);
                    int l = Character.digit((char)pArray[++i2], 16);
                    if (u == -1 || l == -1) {
                        throw new DecoderException("Invalid URL encoding");
                    }
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e2) {
                    throw new DecoderException("Invalid URL encoding");
                }
            }
            buffer.write(b2);
        }
        return buffer.toByteArray();
    }

    public byte[] encode(byte[] pArray) {
        return URLCodec.encodeUrl(WWW_FORM_URL, pArray);
    }

    public byte[] decode(byte[] pArray) throws DecoderException {
        return URLCodec.decodeUrl(pArray);
    }

    public String encode(String pString, String charset) throws UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        return new String(this.encode(pString.getBytes(charset)), this.getEncoding());
    }

    public String encode(String pString) throws EncoderException {
        if (pString == null) {
            return null;
        }
        try {
            return new String(this.encode(pString.getBytes()), this.getEncoding());
        }
        catch (UnsupportedEncodingException e2) {
            throw new EncoderException(e2.getMessage());
        }
    }

    public String decode(String pString, String charset) throws DecoderException, UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        return new String(this.decode(pString.getBytes(this.getEncoding())), charset);
    }

    public String decode(String pString) throws DecoderException {
        if (pString == null) {
            return null;
        }
        try {
            return new String(this.decode(pString.getBytes(this.getEncoding())));
        }
        catch (UnsupportedEncodingException e2) {
            throw new DecoderException(e2.getMessage());
        }
    }

    public Object encode(Object pObject) throws EncoderException {
        if (pObject == null) {
            return null;
        }
        if (pObject instanceof byte[]) {
            return this.encode((byte[])pObject);
        }
        if (pObject instanceof String) {
            return this.encode((String)pObject);
        }
        throw new EncoderException("Objects of type " + pObject.getClass().getName() + " cannot be URL encoded");
    }

    public Object decode(Object pObject) throws DecoderException {
        if (pObject == null) {
            return null;
        }
        if (pObject instanceof byte[]) {
            return this.decode((byte[])pObject);
        }
        if (pObject instanceof String) {
            return this.decode((String)pObject);
        }
        throw new DecoderException("Objects of type " + pObject.getClass().getName() + " cannot be URL decoded");
    }

    public String getEncoding() {
        return this.encoding;
    }

    static {
        int i2;
        WWW_FORM_URL = new BitSet(256);
        for (i2 = 97; i2 <= 122; ++i2) {
            WWW_FORM_URL.set(i2);
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            WWW_FORM_URL.set(i2);
        }
        for (i2 = 48; i2 <= 57; ++i2) {
            WWW_FORM_URL.set(i2);
        }
        WWW_FORM_URL.set(45);
        WWW_FORM_URL.set(95);
        WWW_FORM_URL.set(46);
        WWW_FORM_URL.set(42);
        WWW_FORM_URL.set(32);
    }
}

