/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.bean;

import java.util.Hashtable;
import javax.swing.ImageIcon;
import tw.com.aten.bean.ConnInfo;
import tw.com.aten.bean.PlatformInfo;
import tw.com.aten.bean.UserInfo;
import tw.com.aten.bean.VirtualUsbInfo;

public class InfoRepository {
    private static String[] icons = new String[]{"/res/alluser.png", "/res/caps1.png", "/res/caps3.png", "/res/end.png", "/res/Exit.jpg", "/res/fullsize.png", "/res/hotPlug.jpg", "/res/home.png", "/res/katakana.png", "/res/macro.jpg", "/res/menu.png", "/res/MoveOSD.jpg", "/res/nocolor.jpg", "/res/Option.jpg", "/res/pgdn.png", "/res/pgup.png", "/res/ret.png", "/res/ret2.png", "/res/scale.png", "/res/SetHotkey.jpg", "/res/shift.png", "/res/shift3.png", "/res/tab.png", "/res/ToggleUI.jpg", "/res/VirtualKeyboard.jpg", "/res/VirtualStorage.jpg", "/res/wnd.png", "/res/record.png", "/res/play.png"};
    public static final int numUIString = 39;
    private ConnInfo connInfo;
    private UserInfo userInfo;
    private PlatformInfo platformInfo;
    private VirtualUsbInfo vusbInfo;
    private Hashtable<String, ImageIcon> iconMap;
    private int lang_idx = 0;
    private String[] langType = new String[]{"English", "Japanese", "Deutsch", "Fran\u00e7ais", "Espa\u00f1ol", "\ud55c\uad6d\uc5b4", "Italiano"};

    public InfoRepository() {
        this.connInfo = new ConnInfo();
        this.userInfo = new UserInfo();
        this.platformInfo = new PlatformInfo();
        this.vusbInfo = new VirtualUsbInfo();
        this.iconMap = new Hashtable();
        try {
            Class<?> cl = this.getClass();
            cl.getResource(icons[0]);
            int idx = 0;
            while (idx < icons.length) {
                this.iconMap.put(icons[idx], new ImageIcon(cl.getResource(icons[idx])));
                ++idx;
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    public ConnInfo getConnInfo() {
        return this.connInfo;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public PlatformInfo getPlatformInfo() {
        return this.platformInfo;
    }

    public ImageIcon getImageIcon(String id) {
        return this.iconMap.get(id);
    }

    public VirtualUsbInfo getVirtualUsbInfo() {
        return this.vusbInfo;
    }

    public String[] getLangType() {
        return this.langType;
    }

    public String[] getUIString() {
        return UILanguage.UIStringUnion[0];
    }

    public String[] getUIString(int index) {
        return UILanguage.UIStringUnion[index];
    }

    public String[] getVMStatusString() {
        return VMStatusLanguage.VMStringUnion[0];
    }

    public String[] getVMStatusString(int index) {
        return VMStatusLanguage.VMStringUnion[index];
    }

    public int getLangIdx() {
        return this.lang_idx;
    }

    public void setLangIdx(int lang_idx) {
        this.lang_idx = lang_idx;
    }

    public static class UILanguage {
        public static String[] ENUIString = new String[]{"Exit", "Yes", "No", "Are you sure?", "Virtual Device", "Record", "Playback", "Macro", "Options", "Scale", "User List", "Hotkey Settings", "action", "Hotkeys", "Keyboard Monitor", "Start", "Stop", "Assign", "Close", "Input", "Video", "Toggle Event", "Mouse Mode", "Keyboard Mode", "Repeat Key Timeout", "Image Scale", "Image Quality", "Low", "High", "Fit to Window", "Move OSD", "Settings for Device1", "Settings for Device2", "Logical Drive Type", "Connect", "Plug in", "Unplug", "Connection Status History", "Open Image", "Image File Name and Full Path", "Language Setting", "Refresh", "OK", "Open", "Play/Pause", "Preference", "Keyboard Mouse Hotplug", "Show User List", "minute(s)", "Cancel", "Session ID", "User Name", "Hold down", "Press and Release", "disconnnect due to web logout", "Mouse Settings", "Absolute Mouse (Windows, Ubuntu, RHEL 6.x and later)", "Relative Mouse (Rest of the Linux)", "Enable Mouse Input", "Keyboard Settings", "Enable Keyboard Input", "Display", "Performance", "Enable FPS Control", "frame per second (FPS)", "Recording Time", "Enable auto stop after ", "Display Scale", "Virtual Storage", "Virtual Media", "USB Floppy&Flash", "CDROM&ISO", "Plug Out", "IP Address", "Adjust Mouse", "Exit Remote Location", "Full-Screen Mode", "Refresh Window", "Send Ctrl+Alt+Del", "Toggle Mouse Display", "Toggle UI Display", "Hold Right Alt Key", "Hold Left Alt Key", "Right Window Key", "Left Window Key", "Space", "Enter", "Hyphen", "OSD UI Style", "Menubar UI Style", "Leave Full Screen Mode", "Virtual Keyboard", "Normal Mode", "Enhanced Text Mode", "Network Issue", "Connection failed", "Session issue", "The maximum session number has been reached", "EOF(End Of File)", "Refresh screen", "Start recording", "Stop recording", "English keyboard", "Chinese(traditional) keyboard", "Japanese keyboard", "German keyboard", "French keyboard", "Spanish keyboard", "Korean keyboard", "Italian keyboard", "Capture", "Full screen view", "Auto-resize window", "Settings for Device3", "Device1", "Device2", "Device3", "United Kingdom keyboard"};
        public static String[] JPUIString = new String[]{"Exit", "\u306f\u3044", "\u3044\u3044\u3048", "\u672c\u5f53\u306b\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f", "\u30d0\u30fc\u30c1\u30e3\u30eb\u30c7\u30d0\u30a4\u30b9", "\u8a18\u9332", "\u30d7\u30ec\u30a4\u30d0\u30c3\u30af", "\u30de\u30af\u30ed", "\u30aa\u30d7\u30b7\u30e7\u30f3", "\u30b9\u30b1\u30fc\u30eb", "\u30e6\u30fc\u30b6\u30fc\u30ea\u30b9\u30c8", "\u30db\u30c3\u30c8\u30ad\u30fc\u8a2d\u5b9a", "\u30a2\u30af\u30b7\u30e7\u30f3", "\u30db\u30c3\u30c8\u30ad\u30fc", "\u30ad\u30fc\u30dc\u30fc\u30c9\u30e2\u30cb\u30bf\u30fc", "Start", "\u505c\u6b62", "\u30a2\u30b5\u30a4\u30f3", "\u9589\u3058\u308b", "\u5165\u529b", "\u30d3\u30c7\u30aa", "\u30a4\u30d9\u30f3\u30c8\u4ea4\u63db", "\u30de\u30a6\u30b9\u30e2\u30fc\u30c9", "\u30ad\u30fc\u30dc\u30fc\u30c9\u30e2\u30fc\u30c9", "\u30ea\u30d4\u30fc\u30c8\u30ad\u30fc\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8", "\u30a4\u30e1\u30fc\u30b8\u30b9\u30b1\u30fc\u30eb", "\u30a4\u30e1\u30fc\u30b8\u54c1\u8cea", "Low", "High", "\u30a6\u30a3\u30f3\u30c9\u30a6\u306b\u5408\u308f\u305b\u308b", "OSD\u306e\u79fb\u52d5", "\u30c7\u30d0\u30a4\u30b9\u8a2d\u5b9a1", "\u30c7\u30d0\u30a4\u30b9\u8a2d\u5b9a2", "\u8ad6\u7406\u30c9\u30e9\u30a4\u30d6\u30bf\u30a4\u30d7", "\u63a5\u7d9a", "Plug in", "Unplug", "\u63a5\u7d9a\u30b9\u30c6\u30fc\u30bf\u30b9\u5c65\u6b74", "\u30a4\u30e1\u30fc\u30b8\u3092\u958b\u304f", "\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u540d\u3068\u30d5\u30eb\u30d1\u30b9", "\u8a00\u8a9e\u8a2d\u5b9a", "\u518d\u8aad\u8fbc", "OK", "\u30aa\u30fc\u30d7\u30f3", "\u518d\u751f/\u4e00\u6642\u505c\u6b62", "\u304a\u6c17\u306b\u5165\u308a", "\u30ad\u30fc\u30dc\u30fc\u30c9/\u30de\u30a6\u30b9 \u30db\u30c3\u30c8\u30d7\u30e9\u30b0", "\u30e6\u30fc\u30b6\u30fc\u4e00\u89a7\u8868\u793a", "\u5206", "\u30ad\u30e3\u30f3\u30bb\u30eb", "\u30bb\u30c3\u30b7\u30e7\u30f3ID", "\u30e6\u30fc\u30b6\u30fc\u30cd\u30fc\u30e0", "\u9577\u62bc\u3057\u3059\u308b", "\u62bc\u3057\u3066\u96e2\u3059", "\u30ed\u30b0\u30a2\u30a6\u30c8\u306e\u305f\u3081\u306b\u5207\u65ad\u3057\u307e\u3059", "\u30de\u30a6\u30b9\u8a2d\u5b9a", "\u7d76\u5bfe\u5ea7\u6a19\u30de\u30a6\u30b9\n\uff08Windows, Ubuntu, RHEL 6.x and later\uff09", "\u76f8\u5bfe\u5ea7\u6a19\u30de\u30a6\u30b9\n\uff08Rest of the Linux\uff09", "\u30de\u30a6\u30b9\u5165\u529b\u3092\u6709\u52b9\u306b\u3059\u308b", "\u30ad\u30fc\u30dc\u30fc\u30c9\u8a2d\u5b9a", "\u30ad\u30fc\u30dc\u30fc\u30c9\u5165\u529b\u3092\u6709\u52b9\u306b\u3059\u308b", "\u30c7\u30a3\u30b9\u30d7\u30ec\u30a4", "\u30d1\u30d5\u30a9\u30fc\u30de\u30f3\u30b9", "FPS\u5236\u5fa1\u3092\u6709\u52b9\u306b\u3059\u308b", "FPS", "\u30ec\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u6642\u9593", "\u81ea\u52d5\u505c\u6b62\u3092\u6709\u52b9\u306b\u3059\u308b", "\u30c7\u30a3\u30b9\u30d7\u30ec\u30a4\u30b9\u30b1\u30fc\u30eb", "\u4eee\u60f3\u30b9\u30c8\u30ec\u30fc\u30b8", "\u4eee\u60f3\u30e1\u30c7\u30a3\u30a2", "USB\u30d5\u30ed\u30c3\u30d4\u30fc\uff06Flash", "CD-ROM\uff06ISO", "Plug Out", "IP\u30a2\u30c9\u30ec\u30b9", "\u30de\u30a6\u30b9\u540c\u671f", "\u30ea\u30e2\u30fc\u30c8\u30ed\u30b1\u30fc\u30b7\u30e7\u30f3\u304b\u3089\u9000\u51fa", "\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u30e2\u30fc\u30c9", "Refresh Window", "Ctrl+Alt+Del\u3092\u9001\u4fe1", "\u30de\u30a6\u30b9\u8868\u793a\u3092\u5207\u308a\u66ff\u3048\u308b", "UI\u30b9\u30bf\u30a4\u30eb\u5207\u66ff", "\u53f3Alt\u30ad\u30fc\u3092\u30db\u30fc\u30eb\u30c9\u3059\u308b", "\u5de6Alt\u30ad\u30fc\u3092\u30db\u30fc\u30eb\u30c9\u3059\u308b", "\u53f3Windows\u30ad\u30fc", "\u5de6Windows\u30ad\u30fc", "\u30b9\u30da\u30fc\u30b9", "Enter", "\u30cf\u30a4\u30d5\u30f3", "OSD UI\u30b9\u30bf\u30a4\u30eb", "\u30e1\u30cb\u30e5\u30fc\u30d0\u30fcUI\u30b9\u30bf\u30a4\u30eb", "\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u30e2\u30fc\u30c9\u3092\u9000\u51fa", "\u30d0\u30fc\u30c1\u30e3\u30eb\u30ad\u30fc\u30dc\u30fc\u30c9", "\u30ce\u30fc\u30de\u30eb\u30e2\u30fc\u30c9", "\u30a8\u30f3\u30cf\u30f3\u30b9\u30c9\u30c6\u30ad\u30b9\u30c8\u30e2\u30fc\u30c9", "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u30a4\u30b7\u30e5\u30fc", "\u63a5\u7d9a\u5931\u6557", "\u30bb\u30c3\u30b7\u30e7\u30f3\u60c5\u5831", "\u30bb\u30c3\u30b7\u30e7\u30f3\u6570\u306e\u4e0a\u9650\u306b\u9054\u3057\u307e\u3057\u305f", "EOF(End Of File)", "\u30b9\u30af\u30ea\u30fc\u30f3\u306e\u30ea\u30d5\u30ec\u30c3\u30b7\u30e5", "\u8a18\u9332\u958b\u59cb", "\u8a18\u9332\u505c\u6b62", "\u82f1\u8a9e\u30ad\u30fc\u30dc\u30fc\u30c9", "\u4e2d\u56fd\u8a9e\uff08\u7e41\u4f53\u5b57\uff09\u30ad\u30fc\u30dc\u30fc\u30c9", "\u65e5\u672c\u8a9e\u30ad\u30fc\u30dc\u30fc\u30c9", "\u30c9\u30a4\u30c4\u8a9e\u30ad\u30fc\u30dc\u30fc\u30c9", "\u30d5\u30e9\u30f3\u30b9\u8a9e\u30ad\u30fc\u30dc\u30fc\u30c9", "\u30b9\u30da\u30a4\u30f3\u8a9e\u30ad\u30fc\u30dc\u30fc\u30c9", "\u97d3\u56fd\u8a9e\u30ad\u30fc\u30dc\u30fc\u30c9", "\u30a4\u30bf\u30ea\u30a2\u8a9e\u30ad\u30fc\u30dc\u30fc\u30c9", "\u30ad\u30e3\u30d7\u30c1\u30e3\u30fc", "\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u30d3\u30e5\u30fc", "\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u81ea\u52d5\u30ea\u30b5\u30a4\u30ba", "\u30c7\u30d0\u30a4\u30b9\u8a2d\u5b9a3", "\u30c7\u30d0\u30a4\u30b91", "\u30c7\u30d0\u30a4\u30b92", "\u30c7\u30d0\u30a4\u30b93", "United Kingdom\u8a9e\u30ad\u30fc\u30dc\u30fc\u30c9"};
        public static String[] GERUIString = new String[]{"Beenden", "Ja", "Nein", "Sind Sie sicher?", "Virtuelles Ger\u00e4t", "Aufnahme", "Wiedergabe", "Makro", "Optionen", "Skalieren", "Benutzerliste", "Hotkey-Einstellungen", "Aktion", "Hotkeys", "Tastatur\u00fcberwachung", "Start", "Stopp", "Zuordnen", "Schlie\u00dfen", "Eingabe", "Bildschirm", "Ereignis wechseln", "Mausmodus", "Tastaturmodus", "Wartezeit f\u00fcr Doppeltastendruck", "Vergr\u00f6\u00dferungsfaktor", "Grafikqualit\u00e4t", "Niedrig", "Hoch", "Einpassen", "OSD-Men\u00fc verschieben", "Einstellungen f\u00fcr Ger\u00e4t 1", "Einstellungen f\u00fcr Ger\u00e4t 2", "Art des logischen Laufwerks", "Verbinden", "Anschlie\u00dfen", "Trennen", "Verbindungsverlauf", "Bild \u00f6ffnen", "Dateiname und Pfad des Bildes", "Spracheinstellung", "Aktualisieren", "OK", "\u00d6ffnen", "Wiedergabe/Pause", "Voreinstellung", "Tastatur-/Maus-Hotplug", "Benutzerliste anzeigen", "Minute(n)", "Abbrechen", "Sitzungs-ID", "Benutzername", "Gedr\u00fcckt halten", "Dr\u00fccken und los lassen", "Verbindung aufgrund Web-Abmeldung getrennt", "Mauseinstellungen", "Absolute Maus\n(Windows, Ubuntu, RHEL 6.x and later)", "Relative Maus\n(Rest of the Linux)", "Mauseingabe aktivieren", "Tastatureinstellungen", "Tastatureingabe aktivieren", "Anzeige", "Leistung", "FPS-Steuerung aktivieren", "Frames pro Sekunde (fps):", "Aufnahmedauer", "Automatisch stoppen nach ", "Anzeigeskalierung", "Virtuelles Speicherger\u00e4t", "Virtueller Datentr\u00e4ger", "USB Floppy und Flash", "CDROM und ISO", "Trennen", "IP-Adresse", "Maus einstellen", "Steuerung der Gegenstelle beenden", "Vollbildanzeige", "Refresh Window", "Strg+Alt+Entf senden", "Mausanzeige umschalten", "Benutzerschnittstellenanzeige umschalten", "Rechte Alt-Taste gedr\u00fcckt halten", "Linke Alt-Taste gedr\u00fcckt halten", "Rechte Windows-Taste", "Linke Windows-Taste", "Leer", "Enter", "Trennung", "OSD-Benutzerschnittstelle", "Men\u00fcleiste", "Vollbildanzeige beibehalten", "Virtuelle Tastatur", "Normaler Betrieb", "Erweiterter Textmodus", "Netzwerkproblem", "Verbindungsfehler", "Sitzungsproblem", "Die maximale Anzahl Sitzungen wurde erreicht", "Dateiende (EOF)", "Bild aktualisieren", "Aufnahme starten", "Aufnahme beenden", "Englische Tastatur", "Chinesische Tastatur (traditionell)", "Japanische Tastatur", "Deutsche Tastatur", "Franz\u00f6sische Tastatur", "Spanische Tastatur", "Koreanische Tastatur", "Italienische Tastatur", "Aufnahme", "Vollbildansicht", "Fenstergr\u00f6\u00dfe automatisch", "Einstellungen f\u00fcr Ger\u00e4t 3", "Ger\u00e4t 1", "Ger\u00e4t 2", "Ger\u00e4t 3", "United Kingdom Tastatur"};
        public static String[] FRUIString = new String[]{"quitter", "oui", "non", "\u00eates-vous s\u00fbr\u00a0?", "p\u00e9riph\u00e9rique virtuel", "enregistrer", "ex\u00e9cuter", "macro", "options", "redimensionner", "Liste d\u2019utilisateurs", "param\u00e8tres raccourcis", "Action", "raccourcis", "contr\u00f4le clavier", "d\u00e9marrer", "arr\u00eater", "attribuer", "fermer", "entr\u00e9e", "graphique", "\u00e9v\u00e9nement de basculement", "mode souris", "mode clavier", "d\u00e9lai de r\u00e9p\u00e9tition de touche", "\u00e9chelle de l\u2019image", "qualit\u00e9 de l\u2019image", "faible", "\u00e9lev\u00e9e", "ajuster \u00e0 la fen\u00eatre", "d\u00e9placer OSD", "param\u00e8tres pour le p\u00e9riph\u00e9rique 1", "param\u00e8tres pour le p\u00e9riph\u00e9rique 2", "type du disque logique", "connecter", "brancher", "d\u00e9brancher", "historique de l\u2019\u00e9tat de connexion", "ouvrir image", "nom de fichier et chemin d\u2019acc\u00e8s complet de l\u2019image", "Langue", "Actualiser", "OK", "Ouvrir", "Lire/Pause", "Pr\u00e9f\u00e9rences", "Connexion \u00e0 chaud clavier/souris", "Afficher la liste des utilisateurs", "minute(s)", "Annuler", "ID Session", "Nom d\u2019utilisateur", "Maintenir enfonc\u00e9", "Appuyer et rel\u00e2cher", "D\u00e9connexion par terminaison de session web", "Param\u00e8tres de souris", "Souris absolue\n(Windows, Ubuntu, RHEL 6.x and later)", "Souris relative\n(Rest of the Linux)", "Activer l\u2019entr\u00e9e souris", "Param\u00e8tres de clavier", "Activer l\u2019entr\u00e9e clavier", "Affichage", "Performance", "Activer le contr\u00f4le FPS", "cadre par seconde (FPS)", "Temps d\u2019enregistrement", "Activer l\u2019arr\u00eat automatique apr\u00e8s ", "\u00c9chelle d\u2019affichage", "Stockage virtuel", "Support virtuel", "Disquette et Flash USB", "CD-ROM & ISO", "D\u00e9brancher", "Adresse IP", "R\u00e9gler la souris", "Quitter l\u2019emplacement distant", "Mode plein \u00e9cran", "Refresh Window", "Envoyer Ctrl+Alt+Suppr", "Basculer l\u2019affichage de la souris", "Basculer l\u2019affichage de l\u2019interface", "Tenez enfonc\u00e9e la touche Alt de droite", "Tenez enfonc\u00e9e la touche Alt de gauche", "Touche Windows de droite", "Touche Windows de gauche", "Espace", "Entr\u00e9e", "Tiret", "Style d\u2019interface OSD", "Style d\u2019interface barre de menu", "Quitter le mode plein \u00e9cran", "Clavier virtuel", "Mode normal", "Mode de texte am\u00e9lior\u00e9", "Probl\u00e8me r\u00e9seau", "Echec de connexion", "Probl\u00e8me de session", "Le nombre maximum de sessions est atteint", "EOF (Fin du fichier)", "Rafra\u00eechir l\u2019\u00e9cran", "Commencer l\u2019enregistrement", "Arr\u00eater l\u2019enregistrement", "Clavier anglais", "Clavier chinois (traditionnel)", "Clavier japonais", "Clavier allemand", "Clavier fran\u00e7ais", "Clavier espagnol", "Clavier cor\u00e9en", "Clavier italien", "Capturer", "Mode plein \u00e9cran", "Redimensionnement automatique de la fen\u00eatre", "param\u00e8tres pour le p\u00e9riph\u00e9rique 3", "p\u00e9riph\u00e9rique 1", "p\u00e9riph\u00e9rique 2", "p\u00e9riph\u00e9rique 3", "Clavier United Kingdom"};
        public static String[] SPUIString = new String[]{"Salir", "S\u00ed", "No", "\u00bfEst\u00e1 seguro?", "Dispositivo virtual", "Grabar", "Reproducir", "Macro", "Opciones", "Escalar", "Lista de usuarios", "Ajustes de teclas de acceso directo", "Acci\u00f3n", "Teclas de acceso directo", "Monitorizaci\u00f3n del teclado", "Iniciar", "Detener", "Asignar", "Cerrar", "Entrada", "Imagen", "Cambiar evento", "Modo de rat\u00f3n", "Modo de teclado", "Intervalo de repetici\u00f3n de tecla", "Escala de imagen", "Calidad de imagen", "Baja", "Alta", "Ajustar a ventana", "Mover OSD", "Ajustes para dispositivo 1", "Ajustes para dispositivo 2", "Tipo de unidad l\u00f3gica", "Conectar", "Enchufar", "Desenchufar", "Historial del estado de conexi\u00f3n", "Abrir imagen", "Nombre y ruta del archivo de imagen", "Ajustar idioma", "Actualizar", "Aceptar", "Abrir", "Reproducir/Pausa", "Preferencias", "Conexi\u00f3n en caliente de teclado/rat\u00f3n", "Mostrar lista de usuarios", "minuto(s)", "Cancelar", "ID de sesi\u00f3n", "Nombre de usuario", "Mantener pulsada", "Pulsar y soltar", "Desconexi\u00f3n por fin de sesi\u00f3n Web", "Configuraci\u00f3n de rat\u00f3n", "Rat\u00f3n absoluto\n(Windows, Ubuntu, RHEL 6.x and later)", "Rat\u00f3n relativo\n(Rest of the Linux)", "Activar introducci\u00f3n por rat\u00f3n", "Ajustes de teclado", "Activar introducci\u00f3n por teclado", "Dispositivo de visualizaci\u00f3n", "Rendimiento", "Activar control FPS", "fotogramas por segundo (fps)", "Tiempo de grabaci\u00f3n", "Detenci\u00f3n autom\u00e1tica tras ", "Escala de visualizaci\u00f3n", "Almacenamiento virtual", "Soportes virtuales", "Disquetera y flash USB", "CDROM e ISO", "Desconectar", "Direcci\u00f3n IP", "Ajustar rat\u00f3n", "Salir del sitio remoto", "Vista a pantalla completa", "Refresh Window", "Enviar Ctrl+Alt+Supr", "Cambiar aspecto de rat\u00f3n", "Cambiar aspecto de interfaz del usuario", "Mantener tecla Alt derecha pulsada", "Mantener tecla Alt izquierda pulsada", "Tecla Windows derecha", "Tecla Windows izquierda", "Espacio", "Intro", "Gui\u00f3n", "Interfaz del usuario de tipo OSD", "Interfaz del usuario de tipo barra de men\u00fas", "Mantener vista a pantalla completa", "Teclado virtual", "Modo normal", "Modo extendido de texto", "Problema de red", "Error de conexi\u00f3n", "Problema de sesi\u00f3n", "Se ha alcanzado el n\u00famero m\u00e1ximo de sesiones", "Fin de archivo (EOF)", "Actualizar pantalla", "Iniciar grabaci\u00f3n", "Detener grabaci\u00f3n", "Teclado ingl\u00e9s", "Teclado chino (tradicional)", "Teclado japon\u00e9s", "Teclado alem\u00e1n", "Teclado franc\u00e9s", "Teclado espa\u00f1ol", "Teclado coreano", "Teclado italiano", "Capturar", "Vista a pantalla completa", "Redimensionar ventana autom\u00e1ticamente", "Ajustes para dispositivo 3", "dispositivo 1", "dispositivo 2", "dispositivo 3", "Teclado United Kingdom"};
        public static String[] KORUIString = new String[]{"\ub05d\ub0b4\uae30", "\uc608", "\uc544\ub2c8\uc624", "\ud655\uc2e4\ud569\ub2c8\uae4c?", "\uac00\uc0c1 \uc7a5\uce58", "\uae30\ub85d", "\uc7ac\uc0dd", "\ub9e4\ud06c\ub85c", "\uc635\uc158", "\ud06c\uae30", "\uc0ac\uc6a9\uc790 \ubaa9\ub85d", "\ud56b\ud0a4 \uc124\uc815", "\ub3d9\uc791", "\ud56b\ud0a4 ", "\ud0a4\ubcf4\ub4dc \ubaa8\ub2c8\ud130 ", "\uc2dc\uc791", "\uc815\uc9c0", "\ud560\ub2f9", "\ub2eb\uae30", "\uc785\ub825", "\ube44\ub514\uc624", "\ud1a0\uae00 \uc774\ubca4\ud2b8", "\ub9c8\uc6b0\uc2a4 \ubaa8\ub4dc", "\ud0a4\ubcf4\ub4dc \ubaa8\ub4dc", "\ud0a4 \ud0c0\uc784\uc544\uc6c3 \ubc18\ubcf5 \uc2e4\ud589", "\uc774\ubbf8\uc9c0 \ud06c\uae30", "\uc774\ubbf8\uc9c0 \ud488\uc9c8", "\ub0ae\uc74c", "\ub192\uc74c", "\uc708\ub3c4\uc6b0\uc5d0 \ub9de\ucd94\ub2e4", "OSD  \uc774\ub3d9", "\uc7a5\uce58 1 \uc124\uc815", "\uc7a5\uce58 2 \uc124\uc815", "\ub17c\ub9ac \ub4dc\ub77c\uc774\ube0c \uc720\ud615", "\uc811\uc18d", "\uc5f0\uacb0\ub428 ", "\uc5f0\uacb0 \uc548\ub428", "\uc811\uc18d \uc0c1\ud0dc \ud788\uc2a4\ud1a0\ub9ac", "\uc774\ubbf8\uc9c0 \uc5f4\uae30", "\uc774\ubbf8\uc9c0 \ud30c\uc77c\uba85 \ubc0f \uc804\uccb4 \uacbd\ub85c", "\uc5b8\uc5b4 \uc124\uc815", "\uc0c8\ub85c\uace0\uce68", "\ud655\uc778", "\uc5f4\uae30", "\uc7ac\uc0dd/\uc77c\uc2dc\uc815\uc9c0", "\uc120\ud638", "\ud0a4\ubcf4\ub4dc \ub9c8\uc6b0\uc2a4 \ud56b\ud50c\ub7ec\uadf8", "\uc0ac\uc6a9\uc790 \ubaa9\ub85d \ubcf4\uc5ec\uc8fc\uae30", "\ubd84", "\ucde8\uc18c", "\uc138\uc158 ID", "\uc0ac\uc6a9\uc790 \uc774\ub984", "\ub204\ub978 \uc0c1\ud0dc", "\ub20c\ub800\ub2e4 \ub5bc\uc138\uc694. ", "\uc6f9 \ub85c\uadf8\uc544\uc6c3\uc73c\ub85c \uc778\ud574 \uc5f0\uacb0 \ub04a\uae40", "\ub9c8\uc6b0\uc2a4 \uc124\uc815", "Absolute Mouse\n(Windows, Ubuntu, RHEL 6.x and later)", "Relative Mouse\n(Rest of the Linux)", "\ub9c8\uc6b0\uc2a4 \uc785\ub825 \uc0ac\uc6a9", "\ud0a4\ubcf4\ub4dc \uc124\uc815", "\ud0a4\ubcf4\ub4dc \uc785\ub825 \uc0ac\uc6a9", "\ub514\uc2a4\ud50c\ub808\uc774", "\uc2e4\ud589", "FPS \uc81c\uc5b4 \uc0ac\uc6a9", "\ucd08\ub2f9 \ud504\ub808\uc784 \uc218 (FPS)", "\uc2dc\uac04 \uae30\ub85d", "\uc790\ub3d9 \uc815\uc9c0 \uc0ac\uc6a9 ", "\ub514\uc2a4\ud50c\ub808\uc774 \ube44\uc728", "\uac00\uc0c1 \uc2a4\ud1a0\ub9ac\uc9c0", "\uac00\uc0c1 \ubbf8\ub514\uc5b4", "USB \ud50c\ub85c\ud53c & \ud50c\ub798\uc26c", "CDROM&ISO", "\uc804\uc6d0 \ub044\uae30", "IP \uc8fc\uc18c", "\ub9c8\uc6b0\uc2a4 \uc870\uc815", "\uc6d0\uaca9 \uc704\uce58 \ub098\uac00\uae30", "\ud480\uc2a4\ud06c\ub9b0 \ubaa8\ub4dc", "Refresh Window", "Ctrl+Alt+Del \uc785\ub825", "\ub9c8\uc6b0\uc2a4 \ub514\uc2a4\ud50c\ub808\uc774 \ud1a0\uae00", "UI \ub514\uc2a4\ud50c\ub808\uc774 \ud1a0\uae00", "\uc624\ub978\ucabd Alt \ud0a4 \ub204\ub984", "\uc67c\ucabd Alt \ud0a4 \ub204\ub984", "\uc624\ub978\ucabd \uc708\ub3c4\uc6b0 \ud0a4", "\uc67c\ucabd \uc708\ub3c4\uc6b0 \ud0a4", "\uc2a4\ud398\uc774\uc2a4", "\uc5d4\ud130", "\ud558\uc774\ud508", "OSD UI \uc2a4\ud0c0\uc77c", "\uba54\ub274\ubc14 UI \uc2a4\ud0c0\uc77c", "\ud480\uc2a4\ud06c\ub9b0 \ubaa8\ub4dc \ud574\uc81c", "\uac00\uc0c1 \ud0a4\ubcf4\ub4dc", "\uc77c\ubc18 \ubaa8\ub4dc", "\uac15\ud654\ub41c \ud14d\uc2a4\ud2b8 \ubaa8\ub4dc", "\ub124\ud2b8\uc6cc\ud06c \uc774\uc288", "\uc811\uc18d \uc2e4\ud328", "\uc138\uc158 \uc774\uc288", "\uc138\uc158 \uc218\uac00 \uc774\ubbf8 \ucd5c\ub300\uc785\ub2c8\ub2e4.", "EOF (End of File)", "\ud654\uba74 \uc0c8\ub85c\uace0\uce68", "\ub808\ucf54\ub529 \uc2dc\uc791", "\ub808\ucf54\ub529 \uc911\uc9c0", "\uc601\uc5b4 \ud0a4\ubcf4\ub4dc", "\uc911\uad6d\uc5b4 (\ubc88\uccb4) \ud0a4\ubcf4\ub4dc", "\uc77c\uc5b4 \ud0a4\ubcf4\ub4dc", "\ub3c5\uc77c\uc5b4 \ud0a4\ubcf4\ub4dc", "\ud504\ub791\uc2a4\uc5b4 \ud0a4\ubcf4\ub4dc", "\uc2a4\ud398\uc778\uc5b4 \ud0a4\ubcf4\ub4dc", "\ud55c\uad6d\uc5b4 \ud0a4\ubcf4\ub4dc", "\uc774\ud0c8\uc774\uc544\uc5b4 \ud0a4\ubcf4\ub4dc", "\ucea1\uccd0", "\ud480 \uc2a4\ud06c\ub9b0 \ubdf0", "\ud654\uba74\ucc3d \uc790\ub3d9 \ud06c\uae30 \uc870\uc808", "\uc7a5\uce58 3 \uc124\uc815", "\uc7a5\uce58 1 ", "\uc7a5\uce58 2 ", "\uc7a5\uce58 3 ", "United Kingdom keyboard"};
        public static String[] ITAUIString = new String[]{"Esci", "S\u00ec", "No", "Sei sicuro?", "Dispositivo virtuale", "Registrazione", "Riproduzione", "Macro", "Opzioni", "Rappresenta in scala", "Elenco dell\u2019utente", "Impostazioni del tasto di scelta rapida", "Azione", "Tasti di scelta rapida", "Controllo tastiera", "Avvio", "Stop", "Assegna", "Chiudi", "Ingresso", "Video", "Attiva evento", "Modalit\u00e0 mouse", "Modalit\u00e0 tastiera", "Ripeti timeout del tasto", "Rappresenta in scala l\u2019immagine", "Qualit\u00e0 dell\u2019immagine", "Bassa", "Alta", "Adatta alla finestra", "Sposta osd", "Impostazioni del dispositivo 1", "Impostazioni del dispositivo 2", "Tipo di unit\u00e0 logica", "Connetti", "Connetti", "Disconnetti", "Storico del collegamento", "Apri immagine", "Nome del file d\u2019immagine e percorso completo", "Impostazioni lingua", "Aggiorna", "OK", "Apri", "Riproduci/Pausa", "Preferenze", "Collegamento tastiera/mouse a caldo", "Mostra elenco utenti", "minuto/i", "Annulla", "ID sessione", "Nome utente", "Tieni premuto", "Premi e rilascia", "disconnesso per logout web", "Impostazioni mouse", "Mouse assoluto\n(Windows, Ubuntu, RHEL 6.x and later)", "Mouse relativo\n(Rest of the Linux)", "Abilita input mouse", "Impostazioni tastiera", "Abilita input tastiera", "Schermo", "Prestazioni", "Abilita controllo FPS", "fotogrammi al secondo (FPS)", "Tempo di registrazione", "Abilita stop automatico dopo ", "Scala schermo", "Memoria di massa virtuale", "Media virtuali", "Floppy & flash USB", "CDROM&ISO", "Scollega", "Indirizzo IP", "Regola mouse", "Esci da sito remoto", "Modalit\u00e0 schermo intero", "Refresh Window", "Invia Ctrl+Alt+Canc", "(Dis)attiva visualizzazione mouse", "(Dis)attiva visualizzazione interfaccia", "Tieni premuto Alt destro", "Tieni premuto Alt sinistro", "Tasto Windows destro", "Tasto Windows sinistro", "Spazio", "Invio", "Trattino", "Vecchio stile interfaccia OSD", "Stile interfaccia barra dei menu", "Esci dalla modalit\u00e0 schermo intero", "Tastiera virtuale", "Modalit\u00e0 normale", "Modalit\u00e0 testo speciale", "Problema di rete", "Connessione fallita", "Problema sessione", "Raggiunto limite massimo sessioni", "EOF(End Of File)", "Aggiorna schermo", "Avvia registrazione", "Interrompi registrazione", "Tastiera inglese", "Tastiera cinese (tradizionale)", "Tastiera giapponese", "Tastiera tedesca", "Tastiera francese", "Tastiera spagnola", "Tastiera coreana", "Tastiera italiana", "Cattura", "Vista a pieno schermo", "Autoridimensiona finestra", "Impostazioni del dispositivo 3", "dispositivo 1", "dispositivo 2", "dispositivo 3", "Tastiera United Kingdom"};
        public static String[][] UIStringUnion = new String[][]{ENUIString, JPUIString, GERUIString, FRUIString, SPUIString, KORUIString, ITAUIString};
    }

    public static class VMStatusLanguage {
        public static String[] ENVMString = new String[]{"", "Authentication Fail", "System Busy", "Privilege Error", "VM Plug-Out OK!! Stop!!", "The Length of Name is not correct", "The Length of password is not correct", "VM Device is not valid, please click \"Refresh\" button", "The Filename Extension of ISO Image File is not correct", "The Filename Extension of Floppy Image File is not correct", "Can not open ISO Image File", "Can not open Floppy Image File", "Can not connect to Server!!", "VM Plug-In OK!!", "Invalid Device Selection", "Don't access file on Local storage device", "Virtual Media Plug In fail!", "The size of the floppy image is too large", "No response, please try again!", "Response error, please try again!", "Upload Success!", "Plug out Success!", "Exist IMA File on BMC", "Exist an effective Connect from others", "The Device doesn't Match in Client Computer", "The Device Operates Error !!", "Virtual Media is in Detach Mode!!", "Open Exist Device Error!!\nPlease Check if a valid data in the device", "Synchronize Storage Contents!!\nPlease Wait a moment!!", "Mount Web ISO Success!", "UnMount Web ISO Success!", "Media has been unmounted from others", "Session ID is Expired", "BMC is in FW updating", "Session ID is Expired", "VM Process Busy!Please Try again!", "Please Check if any Disc in the Device!"};
        public static String[] JPVMString = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        public static String[] GERVMString = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        public static String[] FRVMString = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        public static String[] SPVMString = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        public static String[] KORVMString = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        public static String[] ITAVMString = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        public static String[] SIMCNVMString = new String[]{"", "\u8ba4\u8bc1\u5931\u8d25", "\u7cfb\u7edf\u5fd9", "\u6743\u9650\u9519\u8bef", "\u865a\u62df\u4ecb\u8d28\u5378\u8f7d\u5b8c\u6210", "\u8d26\u6237\u540d\u957f\u5ea6\u9519\u8bef", "\u5bc6\u7801\u957f\u5ea6\u9519\u8bef", "\u6ca1\u6709\u53d1\u73b0\u53ef\u7528\u7684\u865a\u62df\u4ecb\u8d28\uff0c\u8bf7\u6309\u5237\u65b0\u952e\u91cd\u8bd5", "ISO\u5f71\u50cf\u6587\u4ef6\u6269\u5c55\u540d\u9519\u8bef", "\u8f6f\u76d8\u5f71\u50cf\u6587\u4ef6\u6269\u5c55\u540d\u79f0\u9519\u8bef", "\u65e0\u6cd5\u6253\u5f00ISO\u955c\u50cf", "\u65e0\u6cd5\u6253\u5f00\u8f6f\u76d8\u955c\u50cf", "\u65e0\u6cd5\u8fde\u63a5\u670d\u52a1\u5668", "\u865a\u62df\u4ecb\u8d28\u52a0\u8f7d\u6210\u529f", "\u88c5\u7f6e\u9009\u62e9\u9519\u8bef", "\u8bf7\u4e0d\u8981\u8bbf\u95ee\u8be5\u672c\u5730\u5b58\u50a8\u8bbe\u5907\u7684\u6587\u4ef6", "\u865a\u62df\u4ecb\u8d28\u52a0\u8f7d\u5931\u8d25", "\u8be5\u8f6f\u76d8\u955c\u50cf\u592a\u5927", "\u65e0\u54cd\u5e94\uff0c\u8bf7\u518d\u8bd5\u4e00\u6b21", "\u54cd\u5e94\u9519\u8bef\uff0c\u8bf7\u518d\u8bd5\u4e00\u6b21", "\u4e0a\u8f7d\u5b8c\u6210", "\u5378\u8f7d\u5b8c\u6210", "IMA\u6587\u4ef6\u5df2\u7ecf\u52a0\u8f7d", "\u5df2\u7ecf\u5b58\u5728\u4e00\u4e2a\u6709\u6548\u7684\u8fde\u63a5", "\u8be5\u8bbe\u5907\u4e0e\u5ba2\u6237\u7aef\u7684\u8ba1\u7b97\u673a\u4e0d\u7b26\u5408", "\u8bbe\u5907\u64cd\u4f5c\u9519\u8bef", "\u865a\u62df\u4ecb\u8d28\u5728\u5206\u79bb\u6a21\u5f0f", "\u6253\u5f00\u8bbe\u5907\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u662f\u8bbe\u5907\u4e2d\u662f\u5426\u6709\u6709\u6548\u6570\u636e", "\u6b63\u5728\u540c\u6b65\u5b58\u50a8\u5185\u5bb9\uff0c\u8bf7\u7a0d\u5019", "\u52a0\u8f7d\u7f51\u7edcISO\u955c\u50cf\u6210\u529f", "\u5378\u8f7d\u7f51\u7edcISO\u955c\u50cf\u6210\u529f!", "\u865a\u62df\u4ecb\u8d28\u5df2\u7ecf\u88ab\u5176\u5b83\u5ba2\u6237\u7aef\u5378\u8f09", "\u4f1a\u8bdd\u8fde\u63a5\u5df2\u7ecf\u8fc7\u671f\u5931\u6548", "BMC\u56fa\u4ef6\u6b63\u5728\u66f4\u65b0", "\u4f1a\u8bdd\u8fde\u63a5\u5df2\u7ecf\u8fc7\u671f\u5931\u6548", "\u865a\u62df\u4ecb\u8d28\u5904\u7406\u5fd9\uff0c\u8bf7\u91cd\u8bd5", "\u8bf7\u786e\u8ba4\u5149\u9a71\u4e2d\u662f\u5426\u6709\u5149\u76d8"};
        public static String[][] VMStringUnion = new String[][]{ENVMString, JPVMString, GERVMString, FRVMString, SPVMString, KORVMString, ITAVMString, SIMCNVMString};
    }
}

