/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.ikvm.bean;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import tw.com.aten.ikvm.KVMParam;
import tw.com.aten.ikvm.bean.HotKey;
import tw.com.aten.ikvm.bean.KeyboardMode;
import tw.com.aten.ikvm.bean.MouseMode;
import tw.com.aten.ikvm.bean.UserInterfaceStyle;
import tw.com.aten.ikvm.bean.YUVMode;

public class OptionInfo {
    private boolean optionChanged;
    private boolean imageOptionChanged;
    private boolean recording;
    private boolean playback;
    private boolean recAutoStop = true;
    private int recLength = 2;
    private boolean toogleKeyboard;
    private boolean toogleMouse;
    private boolean fpsControl;
    private int fps;
    private MouseMode mouseMode;
    private KeyboardMode keyboardMode;
    private int repeatKeyTimeout;
    private UserInterfaceStyle uiStyle;
    private HotKey[] hotKeys;
    private boolean autoResizeWindow;
    private Locale kbLayout = Locale.getDefault();
    private int imageScale;
    private int imageQuality;
    private YUVMode yuvMode;
    private HotKey[] defaultKeys;
    private File defaultSettingFile;
    private String defaultFilePath = System.getProperty("user.home");

    public Locale getKbLayout() {
        return this.kbLayout;
    }

    public void setKbLayout(Locale kbLayout) {
        this.kbLayout = kbLayout;
    }

    public OptionInfo() {
        this.defaultSettingFile = new File(String.valueOf(this.defaultFilePath) + "\\kvmViewerSetting");
        this.defaultKeys = new HotKey[KVMParam.DEFAULT_HOST_KEY_KEY_CODE.length];
        this.hotKeys = new HotKey[KVMParam.DEFAULT_HOST_KEY_KEY_CODE.length];
        int i = 0;
        while (i < KVMParam.DEFAULT_HOST_KEY_KEY_CODE.length) {
            this.defaultKeys[i] = new HotKey(KVMParam.DEFAULT_HOST_KEY_KEY_CODE[i], KVMParam.DEFAULT_HOST_KEY_MODIFIER[i]);
            this.hotKeys[i] = new HotKey(0, 0);
            ++i;
        }
        this.fpsControl = false;
        this.fps = 10;
        this.setAllOption(true, true, 100, (short)0, YUVMode.YUV420, MouseMode.UNKNOWN, KeyboardMode.STABLE, 200, UserInterfaceStyle.MENUBAR, this.defaultKeys);
        this.autoResizeWindow = true;
    }

    public void setAllOption(boolean toogleKeyboard, boolean toogleMouse, int imageScale, short imageQuality, YUVMode qualityMode, MouseMode mouseMode, KeyboardMode keyboardMode, int repeatKeyTimeout, UserInterfaceStyle uiStyle, HotKey[] hotKeys) {
        this.toogleKeyboard = toogleKeyboard;
        this.toogleMouse = toogleMouse;
        this.imageScale = imageScale;
        this.imageQuality = imageQuality;
        this.yuvMode = qualityMode;
        this.mouseMode = mouseMode;
        this.keyboardMode = keyboardMode;
        this.repeatKeyTimeout = repeatKeyTimeout;
        this.uiStyle = uiStyle;
        this.hotKeys = (HotKey[])hotKeys.clone();
        this.optionChanged = false;
        this.imageOptionChanged = false;
    }

    public boolean isOptionChanged() {
        return this.optionChanged;
    }

    public void setOptionChanged(boolean optionChanged) {
        this.optionChanged = optionChanged;
    }

    public boolean isImageOptionChanged() {
        return this.imageOptionChanged;
    }

    public void setImageOptionChanged(boolean imageOptionChanged) {
        this.imageOptionChanged = imageOptionChanged;
    }

    public File getDefaultSettingFile() {
        return this.defaultSettingFile;
    }

    public void loadSettingFile(File settingFile) {
        System.out.println("load config file");
        try {
            FileInputStream fis = new FileInputStream(settingFile);
            DataInputStream dis = new DataInputStream(fis);
            this.toogleKeyboard = dis.readBoolean();
            this.toogleMouse = dis.readBoolean();
            this.imageScale = dis.readInt();
            this.imageQuality = dis.readShort();
            this.yuvMode = ((YUVMode[])YUVMode.class.getEnumConstants())[dis.readInt()];
            this.mouseMode = ((MouseMode[])MouseMode.class.getEnumConstants())[dis.readInt()];
            this.keyboardMode = ((KeyboardMode[])KeyboardMode.class.getEnumConstants())[dis.readInt()];
            this.repeatKeyTimeout = dis.readInt();
            this.uiStyle = ((UserInterfaceStyle[])UserInterfaceStyle.class.getEnumConstants())[dis.readInt()];
            int i = 0;
            while (i < this.hotKeys.length) {
                this.hotKeys[i].setKeyCode(dis.readInt());
                this.hotKeys[i].setModifier(dis.readInt());
                ++i;
            }
            dis.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveSettingFile(File fileDestination) {
        System.out.println("save config file");
        try {
            FileOutputStream fos = new FileOutputStream(fileDestination);
            DataOutputStream dos = new DataOutputStream(fos);
            dos.writeBoolean(this.toogleKeyboard);
            dos.writeBoolean(this.toogleMouse);
            dos.writeInt(this.imageScale);
            dos.writeShort(this.imageQuality);
            dos.writeInt(this.yuvMode.ordinal());
            dos.writeInt(this.mouseMode.ordinal());
            dos.writeInt(this.keyboardMode.ordinal());
            dos.writeInt(this.repeatKeyTimeout);
            dos.writeInt(this.uiStyle.ordinal());
            int i = 0;
            while (i < this.hotKeys.length) {
                dos.writeInt(this.hotKeys[i].getKeyCode());
                dos.writeInt(this.hotKeys[i].getModifier());
                ++i;
            }
            dos.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void setRecording(boolean recording) {
        this.recording = recording;
    }

    public boolean isPlayback() {
        return this.playback;
    }

    public void setPlayback(boolean playback) {
        this.playback = playback;
    }

    public boolean isRecAutoStop() {
        return this.recAutoStop;
    }

    public void setRecAutoStop(boolean recAutoStop) {
        this.recAutoStop = recAutoStop;
    }

    public int getRecLength() {
        return this.recLength;
    }

    public void setRecLength(int recLength) {
        this.recLength = recLength;
    }

    public boolean isToogleKeyboard() {
        return this.toogleKeyboard;
    }

    public void setToogleKeyboard(boolean toogleKeyboard) {
        this.toogleKeyboard = toogleKeyboard;
    }

    public boolean isToogleMouse() {
        return this.toogleMouse;
    }

    public void setToogleMouse(boolean toogleMouse) {
        this.toogleMouse = toogleMouse;
    }

    public MouseMode getMouseMode() {
        return this.mouseMode;
    }

    public void setMouseMode(MouseMode mouseMode) {
        this.mouseMode = mouseMode;
    }

    public boolean isFpsControl() {
        return this.fpsControl;
    }

    public void setFpsControl(boolean fpsControl) {
        this.fpsControl = fpsControl;
    }

    public int getFps() {
        return this.fps;
    }

    public void setFps(int fps) {
        this.fps = fps;
    }

    public KeyboardMode getKeyboardMode() {
        return this.keyboardMode;
    }

    public void setKeyboardMode(KeyboardMode keyboardMode) {
        this.keyboardMode = keyboardMode;
    }

    public int getRepeatKeyTimeout() {
        return this.repeatKeyTimeout;
    }

    public void setRepeatKeyTimeout(int repeatKeyTimeout) {
        this.repeatKeyTimeout = repeatKeyTimeout;
    }

    public int getImageQuality() {
        return this.imageQuality;
    }

    public void setImageQuality(int imageQuality) {
        this.imageQuality = imageQuality;
    }

    public YUVMode getYuvMode() {
        return this.yuvMode;
    }

    public void setYuvMode(YUVMode yuvMode) {
        this.yuvMode = yuvMode;
    }

    public int getImageScale() {
        return this.imageScale;
    }

    public void setImageScale(int imageScale) {
        this.imageScale = imageScale;
    }

    public UserInterfaceStyle getUserInterfaceStyle() {
        return this.uiStyle;
    }

    public void setUserInterfaceStyle(UserInterfaceStyle uiStyle) {
        this.uiStyle = uiStyle;
    }

    public HotKey[] getHotKeys() {
        return this.hotKeys;
    }

    public void setHotKeys(HotKey[] hotKeys) {
        if (hotKeys.length == this.hotKeys.length) {
            this.hotKeys = (HotKey[])hotKeys.clone();
        } else {
            System.out.println("Number of hotkeys isn't match");
        }
    }

    public boolean isAutoResizeWindow() {
        return this.autoResizeWindow;
    }

    public void setAutoResizeWindow(boolean autoResizeWindow) {
        this.autoResizeWindow = autoResizeWindow;
    }
}

