/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.ikvm.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tw.com.aten.bean.InfoRepository;
import tw.com.aten.ikvm.bean.KeyboardMode;
import tw.com.aten.ikvm.bean.MouseMode;
import tw.com.aten.ikvm.bean.OptionInfo;
import tw.com.aten.ikvm.bean.YUVMode;
import tw.com.aten.ikvm.ui.OptionFrame;
import tw.com.aten.ikvm.ui.RemoteVideo;
import tw.com.aten.ikvm.ui.SettingPanel;
import tw.com.aten.ikvm.util.NumberOnlyKeyAdapter;

public class AST2050OptionFrame
extends OptionFrame
implements KeyListener,
WindowListener,
ActionListener,
ChangeListener {
    private JTabbedPane tabbedPane;
    private Dimension tmp_dim;
    private JPanel videoPanel;
    private JPanel fpsControlPanel;
    private JCheckBox fpsControlCheckBox;
    private JTextField fpsTextField;
    private JLabel fpsUnitLabel;
    private JPanel recordPanel;
    private JCheckBox autoStopCheckBox;
    private JTextField recordLengthTextField;
    private JLabel recordUnitLabel;
    private JPanel compressionPanel;
    private ButtonGroup qualityModeButtonGroup;
    private JRadioButton yuv420RadioButton;
    private JRadioButton yuv444RadioButton;
    private JPanel qualityPanel;
    private JLabel qualityLowLabel;
    private JLabel qualityHighLabel;
    private JSlider qualitySlider;
    private JPanel scalePanel;
    private JLabel scaleLowLabel;
    private JLabel scaleHighLabel;
    private JSlider scaleSlider;
    private JPanel inputPanel;
    private JPanel tooglePanel;
    private JCheckBox toogleMouseEventCheckBox;
    private JCheckBox toogleKeyboardEventCheckBox;
    private JPanel mouseModePanel;
    private ButtonGroup mouseModeButtonGroup;
    private JRadioButton absRadioButton;
    private JRadioButton norRadioButton;
    private JRadioButton smmRadioButton;
    private GridBagConstraints gridSetting;
    private JPanel keyboardModePanel;
    private JLabel kbLayoutLabel;
    private JCheckBox stableKbCheckBox;
    private JLabel warningLabel;
    private JSlider timeoutSlider;
    private Hashtable LabelTable;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private SettingPanel settingPane;
    private JPanel windowPanel;
    private JCheckBox autoResizeCheckBox;
    public RemoteVideo video;

    public AST2050OptionFrame(JFrame parent, InfoRepository infoRepository, OptionInfo optionInfo, boolean adjustVideo, RemoteVideo video) {
        super(parent, infoRepository, optionInfo, adjustVideo);
        this.video = video;
        this.toogleMouseEventCheckBox = new JCheckBox("Enable Mouse Input");
        this.toogleKeyboardEventCheckBox = new JCheckBox("Enable Keyboard Input");
        this.tooglePanel = new JPanel(new GridLayout(2, 1));
        this.tooglePanel.setBorder(BorderFactory.createTitledBorder(this.tooglePanel.getBorder(), "Toogle Event", 0, 0));
        this.inputPanel = new JPanel(new GridLayout(2, 1));
        this.tabbedPane = new JTabbedPane(1, 1);
        this.tabbedPane.addChangeListener(this);
        this.fpsControlCheckBox = new JCheckBox("Enable FPS control");
        this.fpsTextField = new JTextField(2);
        this.fpsTextField.addKeyListener(this);
        this.fpsTextField.addKeyListener(NumberOnlyKeyAdapter.getInstance());
        this.fpsTextField.setHorizontalAlignment(4);
        this.fpsUnitLabel = new JLabel("frame per second (FPS)", 2);
        this.fpsControlPanel = new JPanel(new FlowLayout(0));
        this.fpsControlPanel.add(this.fpsControlCheckBox);
        this.fpsControlPanel.add(this.fpsTextField);
        this.fpsControlPanel.add(this.fpsUnitLabel);
        this.fpsControlPanel.setBorder(BorderFactory.createTitledBorder(this.fpsControlPanel.getBorder(), "Performance", 0, 0));
        this.autoStopCheckBox = new JCheckBox("Enable auto stop after");
        this.recordLengthTextField = new JTextField(2);
        this.recordLengthTextField.addKeyListener(this);
        this.recordLengthTextField.addKeyListener(NumberOnlyKeyAdapter.getInstance());
        this.recordLengthTextField.setHorizontalAlignment(4);
        this.recordUnitLabel = new JLabel("minute(s)", 2);
        this.recordPanel = new JPanel(new FlowLayout(0));
        this.recordPanel.add(this.autoStopCheckBox);
        this.recordPanel.add(this.recordLengthTextField);
        this.recordPanel.add(this.recordUnitLabel);
        this.recordPanel.setBorder(BorderFactory.createTitledBorder(this.recordPanel.getBorder(), "Recording Time", 0, 0));
        this.scaleLowLabel = new JLabel("Low", 0);
        this.scaleHighLabel = new JLabel("High", 0);
        this.scaleSlider = new JSlider(0, 25, 100, 100);
        this.scaleSlider.setMajorTickSpacing(25);
        this.scaleSlider.setMinorTickSpacing(25);
        this.scaleSlider.setPaintLabels(true);
        this.scaleSlider.setPaintTicks(true);
        Font font = new Font("Serif", 0, 12);
        this.scaleSlider.setFont(font);
        this.scalePanel = new JPanel(new FlowLayout(1));
        this.scalePanel.add(this.scaleLowLabel);
        this.scalePanel.add(this.scaleSlider);
        this.scalePanel.add(this.scaleHighLabel);
        this.scalePanel.setBorder(BorderFactory.createTitledBorder(this.scalePanel.getBorder(), "Display Scale", 0, 0));
        this.videoPanel = new JPanel(new GridLayout(4, 1));
        this.videoPanel.add(this.recordPanel);
        this.videoPanel.add(this.scalePanel);
        if (adjustVideo) {
            this.yuv420RadioButton = new JRadioButton("Normal Mode", false);
            this.yuv444RadioButton = new JRadioButton("Enhanced Text Mode", false);
            this.qualityModeButtonGroup = new ButtonGroup();
            this.qualityModeButtonGroup.add(this.yuv420RadioButton);
            this.qualityModeButtonGroup.add(this.yuv444RadioButton);
            this.compressionPanel = new JPanel(new GridLayout(2, 1));
            this.compressionPanel.add(this.yuv420RadioButton);
            this.compressionPanel.add(this.yuv444RadioButton);
            this.compressionPanel.setBorder(BorderFactory.createTitledBorder(this.compressionPanel.getBorder(), "Compression", 0, 0));
            this.qualityLowLabel = new JLabel("Low", 0);
            this.qualityHighLabel = new JLabel("High", 0);
            this.qualitySlider = new JSlider(0, 0, 11, 0);
            this.qualityPanel = new JPanel(new FlowLayout(1));
            this.qualityPanel.add(this.qualityLowLabel);
            this.qualityPanel.add(this.qualitySlider);
            this.qualityPanel.add(this.qualityHighLabel);
            this.qualityPanel.setBorder(BorderFactory.createTitledBorder(this.qualityPanel.getBorder(), "Image Quality", 0, 0));
            this.videoPanel.add(this.compressionPanel);
            this.videoPanel.add(this.qualityPanel);
            this.tabbedPane.addTab("Display", this.videoPanel);
            this.absRadioButton = new JRadioButton("Absolute Mouse", false);
            this.norRadioButton = new JRadioButton("Relative Mouse", false);
            this.smmRadioButton = new JRadioButton("Single Mouse", false);
            this.gridSetting = new GridBagConstraints();
            this.mouseModeButtonGroup = new ButtonGroup();
            this.mouseModeButtonGroup.add(this.absRadioButton);
            this.mouseModeButtonGroup.add(this.norRadioButton);
            this.mouseModeButtonGroup.add(this.smmRadioButton);
            this.mouseModePanel = new JPanel(new GridBagLayout());
            this.gridSetting.fill = 2;
            this.gridSetting.gridx = 0;
            this.gridSetting.gridy = 0;
            this.mouseModePanel.add((Component)this.toogleMouseEventCheckBox, this.gridSetting);
            ++this.gridSetting.gridy;
            this.mouseModePanel.add((Component)this.absRadioButton, this.gridSetting);
            ++this.gridSetting.gridy;
            this.mouseModePanel.add((Component)this.norRadioButton, this.gridSetting);
            ++this.gridSetting.gridy;
            this.mouseModePanel.add((Component)this.smmRadioButton, this.gridSetting);
            this.mouseModePanel.setBorder(BorderFactory.createTitledBorder(this.mouseModePanel.getBorder(), "Mouse Settings", 0, 0));
            this.inputPanel.add(this.mouseModePanel);
        }
        this.stableKbCheckBox = new JCheckBox("Repeat Key timeout");
        this.stableKbCheckBox.addActionListener(this);
        this.keyboardModePanel = new JPanel(new GridBagLayout());
        this.timeoutSlider = new JSlider(0, 0, 1000, 0);
        this.timeoutSlider.setMajorTickSpacing(500);
        this.timeoutSlider.setMinorTickSpacing(100);
        this.timeoutSlider.setPaintTicks(true);
        this.LabelTable = new Hashtable();
        this.LabelTable.put(0, new JLabel("0ms"));
        this.LabelTable.put(500, new JLabel("500ms"));
        this.LabelTable.put(1000, new JLabel("1000ms"));
        this.timeoutSlider.setLabelTable(this.LabelTable);
        this.timeoutSlider.setPaintLabels(true);
        this.timeoutSlider.setSnapToTicks(true);
        this.timeoutSlider.setPreferredSize(new Dimension(150, 20));
        GridBagConstraints constr = new GridBagConstraints();
        constr.insets.top = 3;
        constr.insets.bottom = 3;
        constr.insets.left = 3;
        constr.insets.right = 3;
        constr.anchor = 22;
        this.keyboardModePanel.add((Component)this.toogleKeyboardEventCheckBox, constr);
        this.kbLayoutLabel = new JLabel("Keyboard layout");
        constr.gridx = 0;
        constr.gridy = 1;
        constr.anchor = 22;
        this.keyboardModePanel.add((Component)this.kbLayoutLabel, constr);
        constr.gridx = 1;
        constr.gridy = 1;
        constr.anchor = 21;
        this.keyboardModePanel.add((Component)this.kbLayoutComboBox, constr);
        constr.gridx = 0;
        constr.gridy = 2;
        constr.anchor = 22;
        this.keyboardModePanel.add((Component)this.stableKbCheckBox, constr);
        constr.gridx = 1;
        constr.anchor = 21;
        constr.fill = 1;
        constr.weighty = 1.0;
        this.keyboardModePanel.add((Component)this.timeoutSlider, constr);
        this.keyboardModePanel.setBorder(BorderFactory.createTitledBorder(this.keyboardModePanel.getBorder(), "Keyboard Settings", 0, 0));
        this.inputPanel.add("Center", this.keyboardModePanel);
        this.tabbedPane.addTab("Input", this.inputPanel);
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.okButton.setName("OK");
        this.cancelButton.setName("Cancel");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.buttonPanel = new JPanel(new FlowLayout(1));
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.settingPane = new SettingPanel(parent, this, optionInfo);
        this.tabbedPane.addTab("Language Settings", this.languageTabPanel);
        this.autoResizeCheckBox = new JCheckBox("Auto-resize window");
        this.windowPanel = new JPanel(new FlowLayout(0));
        this.windowPanel.add(this.autoResizeCheckBox);
        this.tabbedPane.addTab("Window", this.windowPanel);
        this.tabbedPane.addTab("Video Stream Control", this.videoStreamCtrlTabPanel);
        this.processOptionInfo();
        this.add("North", this.tabbedPane);
        this.add("South", this.buttonPanel);
        this.tmp_dim = this.tabbedPane.getPreferredSize();
        this.tmp_dim.setSize(this.tmp_dim.getWidth() + 20.0, this.tmp_dim.getHeight() + 20.0);
        this.tabbedPane.setPreferredSize(this.tmp_dim);
        this.pack();
        this.setLocationRelativeTo(null);
        this.addWindowListener(this);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        if (video.getKMEnabled()) {
            this.absRadioButton.setEnabled(true);
            this.norRadioButton.setEnabled(true);
            this.smmRadioButton.setEnabled(true);
            this.toogleMouseEventCheckBox.setEnabled(true);
            this.toogleKeyboardEventCheckBox.setEnabled(true);
            this.stableKbCheckBox.setEnabled(true);
            this.timeoutSlider.setEnabled(true);
            this.kbLayoutComboBox.setEnabled(true);
        } else {
            this.absRadioButton.setEnabled(false);
            this.norRadioButton.setEnabled(false);
            this.smmRadioButton.setEnabled(false);
            this.toogleMouseEventCheckBox.setEnabled(false);
            this.toogleKeyboardEventCheckBox.setEnabled(false);
            this.stableKbCheckBox.setEnabled(false);
            this.timeoutSlider.setEnabled(false);
            this.kbLayoutComboBox.setEnabled(false);
        }
        this.reloadText();
    }

    @Override
    public void changeUILanguage(String[] UIString) {
        this.scalePanel.setBorder(BorderFactory.createTitledBorder(null, UIString[67], 0, 0));
        this.mouseModePanel.setBorder(BorderFactory.createTitledBorder(null, UIString[55], 0, 0));
        this.keyboardModePanel.setBorder(BorderFactory.createTitledBorder(null, UIString[59], 0, 0));
        this.qualityPanel.setBorder(BorderFactory.createTitledBorder(null, UIString[26], 0, 0));
        this.langSelectionPanel.setBorder(BorderFactory.createTitledBorder(null, UIString[40], 0, 0));
        this.fpsControlPanel.setBorder(BorderFactory.createTitledBorder(null, UIString[62], 0, 0));
        this.recordPanel.setBorder(BorderFactory.createTitledBorder(null, UIString[65], 0, 0));
        this.scaleLowLabel.setText(UIString[27]);
        this.scaleHighLabel.setText(UIString[28]);
        this.stableKbCheckBox.setText(UIString[24]);
        this.okButton.setText(UIString[42]);
        this.cancelButton.setText(UIString[49]);
        this.tabbedPane.setTitleAt(0, UIString[61]);
        this.tabbedPane.setTitleAt(1, UIString[19]);
        this.tabbedPane.setTitleAt(2, UIString[40]);
        this.tabbedPane.setTitleAt(3, "Window");
        this.tabbedPane.setSelectedComponent(this.languageTabPanel);
        this.langLabel.setText(UIString[40]);
        this.recordUnitLabel.setText(UIString[48]);
        this.absRadioButton.setText(UIString[56]);
        this.norRadioButton.setText(UIString[57]);
        this.toogleMouseEventCheckBox.setText(UIString[58]);
        this.toogleKeyboardEventCheckBox.setText(UIString[60]);
        this.fpsControlCheckBox.setText(UIString[63]);
        this.fpsUnitLabel.setText(UIString[64]);
        this.autoStopCheckBox.setText(UIString[66]);
        this.autoResizeCheckBox.setText(UIString[112]);
        this.yuv420RadioButton.setText(UIString[92]);
        this.yuv444RadioButton.setText(UIString[93]);
        this.setTitle(UIString[45]);
        this.pack();
    }

    @Override
    public void processOptionInfo() {
        this.fpsControlCheckBox.setSelected(this.optionInfo.isFpsControl());
        this.fpsTextField.setText(Integer.toString(this.optionInfo.getFps()));
        this.autoStopCheckBox.setEnabled(!this.optionInfo.isRecording());
        this.recordLengthTextField.setEnabled(!this.optionInfo.isRecording());
        this.autoStopCheckBox.setSelected(this.optionInfo.isRecAutoStop());
        this.recordLengthTextField.setText(Integer.toString(this.optionInfo.getRecLength()));
        this.toogleKeyboardEventCheckBox.setSelected(this.optionInfo.isToogleKeyboard());
        this.toogleMouseEventCheckBox.setSelected(this.optionInfo.isToogleMouse());
        if (this.optionInfo.getKeyboardMode() == KeyboardMode.STABLE) {
            this.stableKbCheckBox.setSelected(true);
            this.timeoutSlider.setValue(this.optionInfo.getRepeatKeyTimeout());
            if (this.video.getKMEnabled()) {
                this.timeoutSlider.setEnabled(true);
            }
        } else {
            this.stableKbCheckBox.setSelected(false);
            this.timeoutSlider.setValue(this.optionInfo.getRepeatKeyTimeout());
            if (this.video.getKMEnabled()) {
                this.timeoutSlider.setEnabled(false);
            }
        }
        this.scaleSlider.setValue(this.optionInfo.getImageScale());
        if (this.adjustVideo) {
            this.qualitySlider.setValue(this.optionInfo.getImageQuality());
            switch (this.optionInfo.getYuvMode()) {
                case YUV420: {
                    this.yuv420RadioButton.setSelected(true);
                    break;
                }
                case YUV444: {
                    this.yuv444RadioButton.setSelected(true);
                }
            }
            switch (this.optionInfo.getMouseMode()) {
                case ABSOLUTE: {
                    this.absRadioButton.setSelected(true);
                    break;
                }
                case NORMAL: {
                    this.norRadioButton.setSelected(true);
                    break;
                }
                case SINGLE: {
                    this.smmRadioButton.setSelected(true);
                }
            }
        }
        this.autoResizeCheckBox.setSelected(this.optionInfo.isAutoResizeWindow());
    }

    @Override
    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    @Override
    public JPanel getButtonPane() {
        return this.buttonPanel;
    }

    @Override
    public SettingPanel getSettingPane() {
        return this.settingPane;
    }

    private void closeOpPanelContainer() {
        this.tabbedPane.getParent().getParent().getParent().getParent().setVisible(false);
    }

    @Override
    public void reloadText() {
        String RESOURCE_BUNDLE_NAME = "tw.com.aten.ikvm.impl.huawei.bundle.OptionFrameStrings";
        ResourceBundle bundle = ResourceBundle.getBundle("tw.com.aten.ikvm.impl.huawei.bundle.OptionFrameStrings");
        this.setTitle(bundle.getString("title"));
        this.tabbedPane.setTitleAt(0, bundle.getString("tab.display"));
        this.tabbedPane.setTitleAt(1, bundle.getString("tab.input"));
        this.tabbedPane.setTitleAt(2, bundle.getString("tab.Video"));
        ((TitledBorder)this.recordPanel.getBorder()).setTitle(bundle.getString("panel.recTime"));
        ((TitledBorder)this.scalePanel.getBorder()).setTitle(bundle.getString("panel.displayScale"));
        ((TitledBorder)this.recordPanel.getBorder()).setTitle(bundle.getString("panel.recTime"));
        ((TitledBorder)this.recordPanel.getBorder()).setTitle(bundle.getString("panel.recTime"));
        ((TitledBorder)this.compressionPanel.getBorder()).setTitle(bundle.getString("panel.compression"));
        ((TitledBorder)this.qualityPanel.getBorder()).setTitle(bundle.getString("panel.imageQuality"));
        this.autoStopCheckBox.setText(bundle.getString("checkBox.autoStop.prefix"));
        this.recordUnitLabel.setText(bundle.getString("checkBox.autoStop.suffix"));
        this.qualityLowLabel.setText(bundle.getString("slider.imageQuality.low"));
        this.qualityHighLabel.setText(bundle.getString("slider.imageQuality.high"));
        this.yuv420RadioButton.setText(bundle.getString("radioButton.normalMode"));
        this.yuv444RadioButton.setText(bundle.getString("radioButton.enhancedTextMode"));
        this.scaleLowLabel.setText(bundle.getString("slider.displayScale.low"));
        this.scaleHighLabel.setText(bundle.getString("slider.displayScale.high"));
        ((TitledBorder)this.mouseModePanel.getBorder()).setTitle(bundle.getString("panel.mouseSettings"));
        this.toogleMouseEventCheckBox.setText(bundle.getString("checkBox.enableMouseInput"));
        ((TitledBorder)this.keyboardModePanel.getBorder()).setTitle(bundle.getString("panel.keyboardSettings"));
        this.toogleKeyboardEventCheckBox.setText(bundle.getString("checkBox.enableKeyboardInput"));
        this.stableKbCheckBox.setText(bundle.getString("checkBox.enableRepeatKey"));
        ((TitledBorder)this.videoStreamCtrlTabPanel.getBorder()).setTitle(bundle.getString("panel.flowControl"));
        this.enableLanFlowCtrl.setText(bundle.getString("checkBox.enableFlowControl"));
        this.lanSpeedLabel.setText(bundle.getString("comboBox.speed"));
        this.okButton.setText(bundle.getString("button.ok"));
        this.cancelButton.setText(bundle.getString("button.cancel"));
        String unit = bundle.getString("slider.unit");
        this.LabelTable.put(0, new JLabel("0" + unit));
        this.LabelTable.put(500, new JLabel("500" + unit));
        this.LabelTable.put(1000, new JLabel("1000" + unit));
        this.timeoutSlider.setLabelTable(this.LabelTable);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = "other class";
        if (ae.getSource().getClass() == this.okButton.getClass()) {
            cmd = ((JButton)ae.getSource()).getName();
        }
        if (cmd.equals("OK")) {
            if (Integer.parseInt(this.fpsTextField.getText()) == 0) {
                JOptionPane.showMessageDialog(this.parent, "FPS can NOT be zero", "Error", 0);
                return;
            }
            if (Integer.parseInt(this.recordLengthTextField.getText()) == 0) {
                JOptionPane.showMessageDialog(this.parent, "Record buffer length can not be zero", "Error", 0);
                return;
            }
            this.optionInfo.setFpsControl(this.fpsControlCheckBox.isSelected());
            this.optionInfo.setFps(Integer.parseInt(this.fpsTextField.getText()));
            this.optionInfo.setRecAutoStop(this.autoStopCheckBox.isSelected());
            this.optionInfo.setRecLength(Integer.parseInt(this.recordLengthTextField.getText()));
            this.optionInfo.setToogleKeyboard(this.toogleKeyboardEventCheckBox.isSelected());
            this.optionInfo.setToogleMouse(this.toogleMouseEventCheckBox.isSelected());
            if (this.stableKbCheckBox.isSelected()) {
                this.optionInfo.setKeyboardMode(KeyboardMode.STABLE);
            } else {
                this.optionInfo.setKeyboardMode(KeyboardMode.NORMAL);
            }
            this.optionInfo.setRepeatKeyTimeout(this.timeoutSlider.getValue());
            if (this.adjustVideo) {
                int newImageQuality = this.qualitySlider.getValue();
                int oldImageQuality = this.optionInfo.getImageQuality();
                this.optionInfo.setImageQuality(this.qualitySlider.getValue());
                YUVMode newYuvMode = null;
                YUVMode oldYuvMode = this.optionInfo.getYuvMode();
                if (this.yuv420RadioButton.isSelected()) {
                    newYuvMode = YUVMode.YUV420;
                    this.optionInfo.setYuvMode(YUVMode.YUV420);
                } else if (this.yuv444RadioButton.isSelected()) {
                    newYuvMode = YUVMode.YUV444;
                    this.optionInfo.setYuvMode(YUVMode.YUV444);
                }
                if (newImageQuality != oldImageQuality) {
                    this.optionInfo.setImageOptionChanged(true);
                } else if (!newYuvMode.equals((Object)oldYuvMode)) {
                    this.optionInfo.setImageOptionChanged(true);
                }
                if (this.norRadioButton.isSelected()) {
                    this.optionInfo.setMouseMode(MouseMode.NORMAL);
                } else if (this.absRadioButton.isSelected()) {
                    this.optionInfo.setMouseMode(MouseMode.ABSOLUTE);
                } else if (this.smmRadioButton.isSelected()) {
                    this.optionInfo.setMouseMode(MouseMode.SINGLE);
                }
            }
            switch (this.kbLayoutComboBox.getSelectedIndex()) {
                case 2: {
                    this.optionInfo.setKbLayout(Locale.JAPAN);
                    break;
                }
                case 3: {
                    this.optionInfo.setKbLayout(Locale.GERMANY);
                    break;
                }
                case 8: {
                    this.optionInfo.setKbLayout(Locale.UK);
                    break;
                }
                case 0: {
                    this.optionInfo.setKbLayout(Locale.ENGLISH);
                    break;
                }
                case 1: {
                    this.optionInfo.setKbLayout(Locale.ENGLISH);
                    break;
                }
                case 4: {
                    this.optionInfo.setKbLayout(Locale.FRENCH);
                    break;
                }
                case 5: {
                    this.optionInfo.setKbLayout(Locale.ENGLISH);
                    break;
                }
                case 6: {
                    this.optionInfo.setKbLayout(Locale.ENGLISH);
                    break;
                }
                case 7: {
                    this.optionInfo.setKbLayout(Locale.ENGLISH);
                }
            }
            this.setNewLang();
            this.setVideoStreamSpeed();
            this.optionInfo.setImageScale(this.scaleSlider.getValue());
            this.optionInfo.setAutoResizeWindow(this.autoResizeCheckBox.isSelected());
            this.optionInfo.setOptionChanged(true);
            this.closeOpPanelContainer();
        } else if (cmd.equals("Cancel")) {
            this.BackToCurrentLang();
            this.resotreVideoStreamSpeed();
            this.closeOpPanelContainer();
        } else if (cmd.equals("other class") && ae.getSource() == this.stableKbCheckBox) {
            if (this.stableKbCheckBox.isSelected() && this.video.getKMEnabled()) {
                this.timeoutSlider.setEnabled(true);
            } else {
                this.timeoutSlider.setEnabled(false);
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent we) {
    }

    @Override
    public void windowClosed(WindowEvent we) {
    }

    @Override
    public void windowClosing(WindowEvent we) {
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
    }

    @Override
    public void windowIconified(WindowEvent we) {
    }

    @Override
    public void windowOpened(WindowEvent we) {
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        JTabbedPane tabbedPane = (JTabbedPane)ce.getSource();
        tabbedPane.requestFocus();
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        Object srcObj = ke.getSource();
        JTextField textField = (JTextField)srcObj;
        if (textField.getText().length() > 1) {
            ke.consume();
        }
    }
}

