/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.ikvm.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tw.com.aten.bean.InfoRepository;
import tw.com.aten.ikvm.KVMParam;
import tw.com.aten.ikvm.bean.HotKey;
import tw.com.aten.ikvm.bean.OptionInfo;

public class HotKeyFrame
extends JFrame
implements WindowListener,
KeyListener,
ActionListener,
MouseListener,
ListSelectionListener {
    private JFrame parent;
    private InfoRepository infoRepository;
    private OptionInfo optionInfo;
    public JPanel settingPanel;
    private JPanel actionPanel;
    private JList actionList;
    private String[] hotKeyString = new String[]{"F1", "F2", "F3", "F4", "F5", "F6", "F7"};
    private String[] DefhotKeyString = new String[]{"F1", "F2", "F3", "F4", "F5", "F6", "F7"};
    private String[] BID001_hotKeyString = new String[]{"Ctrl + 1", "Ctrl + 2", "Ctrl + 3", "Ctrl + 4", "Ctrl + 5", "Ctrl + 6", "Ctrl + 7"};
    private JPanel hotKeyPanel;
    private JList hotKeyList;
    public JPanel monitorPanel;
    private JTextField monitorTextField;
    public JPanel buttonPanel;
    private JButton startButton;
    private JButton stopButton;
    private JButton assignButton;
    private JButton closeButton;
    private JButton defaultButton;
    private HotKey[] hotkeys;
    private int keyCode;
    private int modifier;

    public HotKeyFrame(JFrame parent, InfoRepository infoRepository, OptionInfo optionInfo, HotKey[] hotkeys) {
        this.parent = parent;
        this.infoRepository = infoRepository;
        this.optionInfo = optionInfo;
        this.hotkeys = hotkeys;
        this.actionList = new JList<String>(KVMParam.HOT_KEY_STRING);
        this.actionList.addListSelectionListener(this);
        this.actionList.addMouseListener(this);
        this.actionPanel = new JPanel();
        this.actionPanel.setBorder(BorderFactory.createTitledBorder(null, "Actions", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.actionPanel.add(this.actionList);
        this.initHotKeyString();
        this.hotKeyList = new JList<String>(this.hotKeyString);
        this.hotKeyList.setEnabled(false);
        this.hotKeyPanel = new JPanel();
        this.hotKeyPanel.setBorder(BorderFactory.createTitledBorder(null, "Hotkeys", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.hotKeyPanel.add(this.hotKeyList);
        this.settingPanel = new JPanel(new BorderLayout());
        this.settingPanel.setBorder(BorderFactory.createTitledBorder(null, "Hotkey Settings", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.settingPanel.add("West", this.actionPanel);
        this.settingPanel.add("Center", this.hotKeyPanel);
        this.monitorTextField = new JTextField(30);
        this.monitorTextField.addKeyListener(this);
        this.monitorTextField.setEnabled(false);
        this.monitorPanel = new JPanel();
        this.monitorPanel.setBorder(BorderFactory.createTitledBorder(null, "Keyboard Monitor", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.monitorPanel.add(this.monitorTextField);
        this.startButton = new JButton("Start");
        this.stopButton = new JButton("Stop");
        this.assignButton = new JButton("Assign");
        this.closeButton = new JButton("Close");
        this.defaultButton = new JButton("Default");
        this.startButton.setName("Start");
        this.stopButton.setName("Stop");
        this.assignButton.setName("Assign");
        this.closeButton.setName("Close");
        this.defaultButton.setName("Default");
        this.startButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.assignButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.defaultButton.addActionListener(this);
        this.stopButton.setEnabled(false);
        this.assignButton.setEnabled(false);
        this.buttonPanel = new JPanel(new FlowLayout(1, 20, 5));
        this.buttonPanel.add(this.startButton);
        this.buttonPanel.add(this.stopButton);
        this.buttonPanel.add(this.assignButton);
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(this.defaultButton);
        this.add("North", this.settingPanel);
        this.add("Center", this.monitorPanel);
        this.add("South", this.buttonPanel);
        this.pack();
        this.setTitle("Hotkey Settings");
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
    }

    public void changeUILanguage(String[] UIString) {
        this.actionPanel.setBorder(BorderFactory.createTitledBorder(null, UIString[12], 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.hotKeyPanel.setBorder(BorderFactory.createTitledBorder(null, UIString[13], 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.settingPanel.setBorder(BorderFactory.createTitledBorder(null, UIString[11], 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.monitorPanel.setBorder(BorderFactory.createTitledBorder(null, UIString[14], 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.startButton.setText(UIString[15]);
        this.stopButton.setText(UIString[16]);
        this.assignButton.setText(UIString[17]);
        this.closeButton.setText(UIString[18]);
        this.actionList = new JList<String>(new String[]{UIString[74], UIString[75], UIString[76], UIString[99], UIString[78], UIString[79], UIString[80]});
        this.actionList.addListSelectionListener(this);
        this.actionList.addMouseListener(this);
        this.actionPanel.remove(0);
        this.actionPanel.add(this.actionList);
        this.setTitle(UIString[11]);
    }

    private void initHotKeyString() {
        int i = 0;
        while (i < this.hotkeys.length) {
            int keyCode = this.hotkeys[i].getKeyCode();
            int modifier = this.hotkeys[i].getModifier();
            this.hotKeyString[i] = String.valueOf(modifier == 0 ? "" : String.valueOf(KeyEvent.getKeyModifiersText(modifier)) + " + ") + KeyEvent.getKeyText(keyCode);
            ++i;
        }
    }

    private void saveHotKey() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        int i = 0;
        while (i < this.hotkeys.length) {
            String prefix = KVMParam.HOT_KEY_STRING[i];
            int keyCode = this.hotkeys[i].getKeyCode();
            int modifier = this.hotkeys[i].getModifier();
            prefs.putInt(String.valueOf(prefix) + "_KeyCode", keyCode);
            prefs.putInt(String.valueOf(prefix) + "_Modifier", modifier);
            ++i;
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            JOptionPane.showMessageDialog(this.parent, "Could not save hotkey settings", "Error", 0);
            bse.printStackTrace();
        }
    }

    private void closeHotKeyPanelContainer() {
        this.settingPanel.getParent().getParent().getParent().getParent().setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String name = ((JButton)ae.getSource()).getName();
        if (name.equals("Start")) {
            this.keyCode = -1;
            this.modifier = -1;
            this.startButton.setEnabled(false);
            this.stopButton.setEnabled(true);
            this.assignButton.setEnabled(false);
            this.monitorTextField.setText("");
            this.monitorTextField.setEnabled(true);
            this.monitorTextField.requestFocus();
        } else if (name.equals("Stop")) {
            this.startButton.setEnabled(true);
            this.stopButton.setEnabled(false);
            this.assignButton.setEnabled(true);
            this.monitorTextField.setEnabled(false);
        } else if (name.equals("Assign")) {
            this.assignButton.setEnabled(false);
            this.monitorTextField.setText("");
            int idx = this.actionList.getSelectedIndex();
            if (this.modifier != -1) {
                this.updateHotKeyString(idx);
                this.hotKeyList.setListData(this.hotKeyString);
                this.saveHotKey();
            }
        } else if (name.equals("Close")) {
            this.closeHotKeyPanelContainer();
        } else if (name.equals("Default")) {
            int i = 0;
            while (i < this.hotkeys.length) {
                int keyCode = KVMParam.DEFAULT_HOST_KEY_KEY_CODE[i];
                int modifier = KVMParam.DEFAULT_HOST_KEY_MODIFIER[i];
                this.hotkeys[i] = new HotKey(keyCode, modifier);
                this.hotKeyString[i] = this.DefhotKeyString[i];
                ++i;
            }
            this.hotKeyList.setListData(this.hotKeyString);
            this.saveHotKey();
        }
    }

    public void updateHotKeyString(int idx) {
        this.hotkeys[idx].setKeyCode(this.keyCode);
        this.hotkeys[idx].setModifier(this.modifier);
        switch (this.keyCode) {
            case 17: 
            case 18: 
            case 127: {
                this.hotKeyString[idx] = KeyEvent.getKeyModifiersText(this.modifier);
                break;
            }
            default: {
                this.hotKeyString[idx] = String.valueOf(this.modifier == 0 ? "" : String.valueOf(KeyEvent.getKeyModifiersText(this.modifier)) + " + ") + KeyEvent.getKeyText(this.keyCode);
            }
        }
    }

    public void updateApplyAllHotKeyStrings() {
        int i = 0;
        while (i < this.hotkeys.length) {
            this.keyCode = this.optionInfo.getHotKeys()[i].getKeyCode();
            this.modifier = this.optionInfo.getHotKeys()[i].getModifier();
            this.updateHotKeyString(i);
            ++i;
        }
        this.hotKeyList.setListData(this.hotKeyString);
    }

    @Override
    public void windowActivated(WindowEvent we) {
    }

    @Override
    public void windowClosed(WindowEvent we) {
    }

    @Override
    public void windowClosing(WindowEvent we) {
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
    }

    @Override
    public void windowIconified(WindowEvent we) {
    }

    @Override
    public void windowOpened(WindowEvent we) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        this.keyCode = ke.getKeyCode();
        this.modifier = ke.getModifiers();
        switch (this.keyCode) {
            case 17: 
            case 18: 
            case 127: {
                this.monitorTextField.setText(KeyEvent.getKeyModifiersText(this.modifier));
                break;
            }
            default: {
                this.monitorTextField.setText(String.valueOf(this.modifier == 0 ? "" : String.valueOf(KeyEvent.getKeyModifiersText(this.modifier)) + " + ") + KeyEvent.getKeyText(this.keyCode));
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        ke.consume();
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.hotKeyList.setSelectedIndex(this.actionList.getSelectedIndex());
    }
}

