/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.ikvm.ui;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.FontRenderContext;
import java.util.Collections;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.Timer;
import tw.com.aten.bean.InfoRepository;
import tw.com.aten.ikvm.bean.KeyDef;
import tw.com.aten.ikvm.ui.MyTimerActionListener;
import tw.com.aten.ikvm.ui.RemoteVideo;
import tw.com.aten.ikvm.ui.onScreenKeyboard;
import tw.com.aten.ikvm.util.KeyMap;

public class MyKeyboardPanel
extends JPanel {
    private static final long serialVersionUID = -621610345559937542L;
    private static final int SCAN_KEY = 2;
    public static final int ENGLISH = 1;
    public static final int CHINESE_S = 2;
    public static final int CHINESE_C = 3;
    public static final int JAPANESE = 4;
    public static final int GERMANY = 5;
    public static final int FRANCH = 6;
    public static final int SPANISH = 7;
    public static final int KOREAN = 8;
    public static final int ITALIAN = 9;
    public static final int UK = 10;
    public static final int SWISS = 11;
    public static final int KEYEVENTF_KEYUP = 2;
    public JRadioButtonMenuItem rb10;
    public JRadioButtonMenuItem rb12;
    public JRadioButtonMenuItem rb13;
    public JRadioButtonMenuItem rb14;
    public JRadioButtonMenuItem rb15;
    public JRadioButtonMenuItem rb16;
    public JRadioButtonMenuItem rb17;
    public JRadioButtonMenuItem rb18;
    public JRadioButtonMenuItem rb19;
    public JRadioButtonMenuItem rb20;
    public JPopupMenu selectKeyboardMenu;
    public int m_nLanguage;
    public ButtonGroup group;
    public Robot m_robot;
    private boolean m_bLShiftDown;
    private boolean m_bLAltDown;
    private boolean m_bLControlDown;
    private boolean m_bRShiftDown;
    private boolean m_bRControlDown;
    private boolean m_bRMenuDown;
    public static int checkCounter = 0;
    public static int syncCounter = 0;
    public static int syncDelayedTimes = 0;
    public boolean isKeyboardShowing;
    public boolean isKVMhasFocus = false;
    public int m_nOldLedStatus;
    public int m_nSyncNumlock;
    public int m_nSyncCapslock;
    public int m_nSyncScroolLock;
    public int m_nOldKeyboardStatus;
    public Graphics g1;
    public Timer timer;
    public onScreenKeyboard parent;
    Vector<KeyDef> v = new Vector();
    Font m_font = new Font("MingLiU", 0, 15);
    private int EMPTY = 65535;
    private int TRANSPARENT = 65534;
    private String[] UIString;
    public int cCurrentKeyState;
    private boolean m_nKeyPressed = false;
    private KeyDef m_kOldKey = new KeyDef();

    public MyKeyboardPanel(onScreenKeyboard p, InfoRepository infoRepository) {
        this.parent = p;
        this.m_nLanguage = 1;
        this.UIString = infoRepository.getUIString();
        this.m_bLShiftDown = false;
        this.m_bLAltDown = false;
        this.m_bLControlDown = false;
        this.m_bRShiftDown = false;
        this.m_bRControlDown = false;
        this.m_bRMenuDown = false;
        this.m_nSyncNumlock = 0;
        this.m_nSyncCapslock = 0;
        this.m_nSyncScroolLock = 0;
        this.initComponents();
        this.m_nOldKeyboardStatus = this.myGetKeyState();
        this.setFocusTraversalKeysEnabled(false);
        this.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        this.m_robot = null;
        try {
            this.m_robot = new Robot();
        }
        catch (AWTException awte) {
            awte.printStackTrace();
        }
        this.loadKeyboard(this.m_nLanguage);
        this.timer = new Timer(250, new MyTimerActionListener(this));
        this.timer.setRepeats(true);
        this.timer.start();
    }

    private void initComponents() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MyKeyboardPanel.this.selectKeyboardMenu.setVisible(false);
                MyKeyboardPanel.this.rbActionPerformed(ae);
            }
        };
        this.rb10 = new JRadioButtonMenuItem();
        this.rb10.setActionCommand("English");
        this.rb10.setText("English");
        this.rb10.addActionListener(al);
        this.rb10.setSelected(true);
        this.rb12 = new JRadioButtonMenuItem();
        this.rb12.setActionCommand("Chinese(Taiwan)");
        this.rb12.setText("Chinese(Taiwan)");
        this.rb12.addActionListener(al);
        this.rb13 = new JRadioButtonMenuItem();
        this.rb13.setActionCommand("Japanese");
        this.rb13.setText("Japanese");
        this.rb13.addActionListener(al);
        this.rb14 = new JRadioButtonMenuItem();
        this.rb14.setActionCommand("German");
        this.rb14.setText("German(Germany)");
        this.rb14.addActionListener(al);
        this.rb15 = new JRadioButtonMenuItem();
        this.rb15.setActionCommand("French");
        this.rb15.setText("French(France)");
        this.rb15.addActionListener(al);
        this.rb16 = new JRadioButtonMenuItem();
        this.rb16.setActionCommand("Spanish");
        this.rb16.setText("Spanish");
        this.rb16.setBorderPainted(true);
        this.rb16.setContentAreaFilled(false);
        this.rb16.addActionListener(al);
        this.rb17 = new JRadioButtonMenuItem();
        this.rb17.setActionCommand("Korean");
        this.rb17.setText("Korean");
        this.rb17.addActionListener(al);
        this.rb18 = new JRadioButtonMenuItem();
        this.rb18.setActionCommand("Italian");
        this.rb18.setText("Italian");
        this.rb18.addActionListener(al);
        this.rb19 = new JRadioButtonMenuItem();
        this.rb19.setActionCommand("United Kingdom");
        this.rb19.setText("United Kingdom");
        this.rb19.addActionListener(al);
        this.rb20 = new JRadioButtonMenuItem();
        this.rb20.setActionCommand("Swiss");
        this.rb20.setText("Swiss");
        this.rb20.addActionListener(al);
        ButtonGroup lanGroup1 = new ButtonGroup();
        lanGroup1.add(this.rb10);
        lanGroup1.add(this.rb12);
        lanGroup1.add(this.rb13);
        lanGroup1.add(this.rb14);
        lanGroup1.add(this.rb15);
        lanGroup1.add(this.rb16);
        lanGroup1.add(this.rb17);
        lanGroup1.add(this.rb18);
        lanGroup1.add(this.rb19);
        lanGroup1.add(this.rb20);
        this.selectKeyboardMenu = new JPopupMenu();
        this.selectKeyboardMenu.setLabel("Software Keyboard");
        this.selectKeyboardMenu.setLightWeightPopupEnabled(false);
        this.selectKeyboardMenu.add(this.rb10);
        this.selectKeyboardMenu.add(this.rb12);
        this.selectKeyboardMenu.add(this.rb13);
        this.selectKeyboardMenu.add(this.rb14);
        this.selectKeyboardMenu.add(this.rb15);
        this.selectKeyboardMenu.add(this.rb16);
        this.selectKeyboardMenu.add(this.rb17);
        this.selectKeyboardMenu.add(this.rb18);
        this.selectKeyboardMenu.add(this.rb19);
        this.selectKeyboardMenu.add(this.rb20);
        this.setLayout(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MyKeyboardPanel.this.formMousePressed(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                MyKeyboardPanel.this.formMouseMoved(evt);
            }
        });
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent evt) {
                MyKeyboardPanel.this.formComponentAdded(evt);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MyKeyboardPanel.this.formFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MyKeyboardPanel.this.formFocusLost(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MyKeyboardPanel.this.formKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                MyKeyboardPanel.this.formKeyPressed(evt);
            }
        });
    }

    private void formFocusLost(FocusEvent evt) {
        this.resetModifiers();
        this.parent.video.releasePressedKeys();
        this.isKVMhasFocus = false;
        this.parent.video.getLEDstatus();
        System.err.println("keyboard focus lost");
    }

    private void formFocusGained(FocusEvent evt) {
        this.isKVMhasFocus = true;
        System.err.println("Keyboard focus gained");
        this.requestFocus();
        this.parent.video.setLEDstatus();
        this.repaint();
    }

    private void rbActionPerformed(ActionEvent evt) {
        JRadioButtonMenuItem rb = (JRadioButtonMenuItem)evt.getSource();
        String name = rb.getActionCommand();
        if (name.equals("English")) {
            this.m_nLanguage = 1;
        } else if (name.equals("Chinese(Taiwan)")) {
            this.m_nLanguage = 3;
        } else if (name.equals("Japanese")) {
            this.m_nLanguage = 4;
        } else if (name.equals("German")) {
            this.m_nLanguage = 5;
        } else if (name.equals("French")) {
            this.m_nLanguage = 6;
        } else if (name.equals("Spanish")) {
            this.m_nLanguage = 7;
        } else if (name.equals("Korean")) {
            this.m_nLanguage = 8;
        } else if (name.equals("Italian")) {
            this.m_nLanguage = 9;
        } else if (name.equals("United Kingdom")) {
            this.m_nLanguage = 10;
        } else if (name.equals("Swiss")) {
            this.m_nLanguage = 11;
        }
        this.loadKeyboard(this.m_nLanguage);
        if (RemoteVideo.screnMode) {
            this.parent.setVisible(false);
        } else {
            this.parent.setAlwaysOnTop(true);
            this.parent.setVisible(true);
        }
    }

    private void formComponentAdded(ContainerEvent evt) {
        this.loadKeyboard(this.m_nLanguage);
    }

    public void SetModifier(int scanCode, boolean down) {
        switch (scanCode) {
            case 225: {
                this.m_bLShiftDown = down;
                break;
            }
            case 229: {
                this.m_bRShiftDown = down;
                break;
            }
            case 224: {
                this.m_bLControlDown = down;
                break;
            }
            case 228: {
                this.m_bRControlDown = down;
                break;
            }
            case 226: {
                this.m_bLAltDown = down;
                break;
            }
            case 230: {
                this.m_bRMenuDown = down;
                break;
            }
        }
        if ((scanCode == 224 || scanCode == 225 || scanCode == 226 || scanCode == 228 || scanCode == 229 || scanCode == 230) && this.getGraphics() != null) {
            this.drawKeyboard(this.m_nLanguage, this.getGraphics());
        }
    }

    private void formKeyPressed(KeyEvent evt) {
        int hkkeyCode = evt.getKeyCode();
        if (hkkeyCode == 20) {
            this.parent.video.processKeyEvent(evt);
            this.repaint();
        } else if (hkkeyCode == 144) {
            this.parent.video.processKeyEvent(evt);
            this.repaint();
        } else if (hkkeyCode == 145) {
            this.parent.video.processKeyEvent(evt);
        }
        evt.consume();
    }

    public void DisplayKeypress(int vk, boolean down) {
        if (!this.isShowing()) {
            return;
        }
        int i = 0;
        while (i < this.v.size()) {
            KeyDef key = this.v.get(i);
            if (this.getUsbKeyCode(key) == vk) {
                if (!down) {
                    this.drawKey(key, this.getGraphics());
                } else {
                    this.DrawPressedKey(key, this.getGraphics());
                }
                this.SetModifier(key.cShifted, down);
            }
            ++i;
        }
    }

    private void formMousePressed(MouseEvent evt) {
        this.formFocusGained(null);
        this.parent.setAlwaysOnTop(true);
        this.selectKeyboardMenu.setVisible(false);
        if (evt.getButton() == 1) {
            Point point = evt.getPoint();
            int i = 0;
            while (i < this.v.size()) {
                KeyDef key = this.v.get(i);
                if (key.rc.contains(point)) {
                    this.SendKey(key, evt);
                    break;
                }
                ++i;
            }
        } else if (evt.getButton() == 3) {
            this.selectKeyboardMenu.setLocation(evt.getXOnScreen(), evt.getYOnScreen());
            this.selectKeyboardMenu.setVisible(true);
        }
    }

    public void checkDarkKey() {
        Point point = this.getMousePosition();
        if (point == null && (this.m_kOldKey.cNormal != 0 || this.m_kOldKey.cShifted != 0)) {
            this.drawKey(this.m_kOldKey, this.getGraphics());
            this.m_kOldKey.cNormal = 0;
            this.m_kOldKey.cShifted = 0;
        }
    }

    private void formMouseMoved(MouseEvent evt) {
        Point point = evt.getPoint();
        int i = 0;
        while (i < this.v.size()) {
            KeyDef key = this.v.get(i);
            if (key.rc.contains(point)) {
                this.drawKey(this.m_kOldKey, this.getGraphics());
                this.m_kOldKey = (KeyDef)key.clone();
                this.m_nKeyPressed = true;
                this.drawKey(key, this.getGraphics());
                this.m_nKeyPressed = false;
                break;
            }
            ++i;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.g1 = g;
        this.drawKeyboard(this.m_nLanguage, g);
    }

    @Override
    public void paint(Graphics g) {
        this.g1 = g;
        this.drawKeyboard(this.m_nLanguage, g);
    }

    public void drawKeyboard(int Language, Graphics g) {
        g.setColor(new Color(241, 239, 226));
        this.m_kOldKey.cShifted = 0;
        this.m_kOldKey.cNormal = 0;
        int i = 0;
        while (i < this.v.size()) {
            this.drawKey(this.v.get(i), g);
            ++i;
        }
    }

    public void drawKeyboardinfo() {
    }

    public String getKeyString(KeyDef key) {
        String s = key.strDown;
        int led = this.DescribeKeyState();
        if (key.cNormal == 2) {
            if ((led & 2) != 2) {
                if ((led & 8) == 8) {
                    s = key.strUp;
                }
            } else if ((led & 8) != 8) {
                s = key.strUp;
            }
        }
        if (key.cNormal == 1 && (led & 8) == 8) {
            s = key.strUp;
        }
        if (key.cNormal == 4 && (led & 1) == 1) {
            s = key.strUp;
        }
        if (this.m_nLanguage == 3 && key.cNormal == 1 && (led & 2) == 2 && (this.m_bLShiftDown || this.m_bRShiftDown)) {
            s = key.strThird;
        }
        if (this.m_nLanguage == 6 && key.cShifted == 53 && (this.m_bLShiftDown || this.m_bRShiftDown)) {
            s = " ";
        }
        if (key.cShifted == 72) {
            s = "pau";
        }
        if (key.cShifted == 72 && (this.m_bLControlDown || this.m_bRControlDown)) {
            s = "brk";
        }
        if (this.m_nLanguage == 5 || this.m_nLanguage == 6 || this.m_nLanguage == 7 || this.m_nLanguage == 9 || this.m_nLanguage == 10 || this.m_nLanguage == 11) {
            if ((key.cNormal == 1 || key.cNormal == 2) && (this.m_bLAltDown && (this.m_bLControlDown || this.m_bRControlDown) || this.m_bRMenuDown)) {
                s = key.cShifted == 57 || key.cShifted == 71 || key.cShifted == 83 ? key.strDown : key.strThird;
                if (this.m_bLShiftDown || this.m_bRShiftDown) {
                    s = " ";
                }
            }
            if (key.cNormal == 4 && (this.m_bLAltDown && (this.m_bLControlDown || this.m_bRControlDown) || this.m_bRMenuDown) && (led & 1) == 1) {
                s = key.strThird;
            }
            if (key.cNormal == 0 && (this.m_bLAltDown && (this.m_bLControlDown || this.m_bRControlDown) || this.m_bRMenuDown) && key.cShifted >= 84 && key.cShifted <= 87) {
                s = key.strThird;
            }
        }
        return s;
    }

    public void drawKey(KeyDef key, Graphics g) {
        if (key.cNormal == 0 && key.cShifted == 0) {
            return;
        }
        if (key.cNormal == 0 && key.cShifted == this.TRANSPARENT) {
            return;
        }
        if (key.cShifted == this.EMPTY) {
            g.setColor(new Color(241, 239, 226));
            g.fillRect(key.rc.x + 1, key.rc.y + 1, key.rc.width - 1, key.rc.height - 1);
        } else {
            g.setColor(new Color(241, 239, 226));
            g.fillRect(key.rc.x + 1, key.rc.y + 1, key.rc.width - 1, key.rc.height - 1);
            this.drawButton(key, g);
            String s = this.getKeyString(key);
            if (s.contains(".png")) {
                this.drawImgButton(key, g);
            } else {
                this.drawChar(key, g);
            }
        }
    }

    public void drawChar(KeyDef key, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = this.m_nLanguage == 8 && (key.bNormalCode < 112 || key.bNormalCode > 123) ? new Font("serif", 0, 13) : new Font("serif", 0, 12);
        g2.setFont(font);
        String s = this.getKeyString(key);
        float x = key.rc.x;
        float y = key.rc.y;
        FontRenderContext frc = g2.getFontRenderContext();
        float width = (float)font.getStringBounds(s, frc).getWidth();
        float height = (float)font.getStringBounds(s, frc).getHeight();
        float x1 = (x + x + (float)key.rc.width - 2.0f) / 2.0f - width / 2.0f;
        float y1 = (y + y + (float)key.rc.height) / 2.0f + height / 2.0f;
        g2.setPaint(Color.black);
        g2.setPaintMode();
        g2.drawString(s, x1 + 1.0f, y1 - 3.0f);
    }

    public void drawImgButton(KeyDef key, Graphics g) {
        Image image;
        String buf = this.getKeyString(key);
        ImageIcon icon = new ImageIcon(this.getClass().getResource(buf));
        if (icon != null && (image = icon.getImage()) != null) {
            if (this.isButtonDark(key)) {
                g.setXORMode(g.getColor());
            } else {
                g.setPaintMode();
            }
            g.drawImage(image, key.rc.x + 4, key.rc.y + 4, this);
            g.setPaintMode();
        }
    }

    public boolean isButtonDark(KeyDef key) {
        boolean hilight = false;
        int vk = this.getUsbKeyCode(key);
        int led = this.DescribeKeyState();
        if ((led & 2) == 2 && vk == 57) {
            hilight = true;
        }
        if (this.m_bLShiftDown && vk == 225) {
            hilight = true;
        }
        if (this.m_bRShiftDown && vk == 229) {
            hilight = true;
        }
        if (this.m_bLControlDown && vk == 224) {
            hilight = this.m_nLanguage == 5 || this.m_nLanguage == 6 || this.m_nLanguage == 7 || this.m_nLanguage == 9 || this.m_nLanguage == 10 || this.m_nLanguage == 11 ? !(this.m_bLAltDown && (this.m_bLControlDown || this.m_bRControlDown) || this.m_bRMenuDown) : true;
        }
        if (this.m_bRControlDown && vk == 228) {
            hilight = true;
        }
        if ((led & 1) == 1 && vk == 83) {
            hilight = true;
        }
        if ((led & 4) == 4 && vk == 71) {
            hilight = true;
        }
        if (this.m_bLAltDown && vk == 226) {
            hilight = true;
        }
        if (this.m_bRMenuDown && vk == 230) {
            hilight = true;
        }
        if (this.m_nKeyPressed) {
            hilight = this.m_nLanguage == 5 || this.m_nLanguage == 6 || this.m_nLanguage == 7 || this.m_nLanguage == 9 || this.m_nLanguage == 10 || this.m_nLanguage == 11 ? key.cShifted != 224 || (!this.m_bLAltDown || !this.m_bLControlDown && !this.m_bRControlDown) && !this.m_bRMenuDown : true;
        }
        return hilight;
    }

    public void drawButton(KeyDef key, Graphics g) {
        g.setColor(new Color(113, 111, 100));
        g.drawRect(key.rc.x, key.rc.y, key.rc.width, key.rc.height);
        g.setColor(new Color(172, 168, 153));
        g.drawLine(key.rc.x + 1, key.rc.y + 1, key.rc.x + key.rc.width - 1, key.rc.y + 1);
        g.drawLine(key.rc.x + 1, key.rc.y + 1, key.rc.x + 1, key.rc.y + key.rc.height - 1);
        if (this.isButtonDark(key)) {
            g.setColor(new Color(172, 168, 153));
        } else {
            g.setColor(new Color(241, 239, 226));
        }
        g.fillRect(key.rc.x + 2, key.rc.y + 2, key.rc.width - 3, key.rc.height - 3);
        g.setColor(new Color(255, 255, 255));
        g.drawLine(key.rc.x + 3, key.rc.y + 3, key.rc.x + key.rc.width - 2, key.rc.y + 3);
        g.drawLine(key.rc.x + 3, key.rc.y + 3, key.rc.x + 3, key.rc.y + key.rc.height - 2);
    }

    public void loadKeyboard(int nlanguage) {
        this.deleteKeys();
        this.m_nLanguage = nlanguage;
        switch (nlanguage) {
            case 1: {
                this.addEnglish();
                break;
            }
            case 2: {
                this.addChineseSimplified();
                break;
            }
            case 3: {
                this.addChineseTraditional();
                break;
            }
            case 4: {
                this.addJapanese();
                break;
            }
            case 5: {
                this.addGermany();
                break;
            }
            case 6: {
                this.addFranch();
                break;
            }
            case 7: {
                this.addSpanish();
                break;
            }
            case 8: {
                this.addKorean();
                break;
            }
            case 9: {
                this.addItalian();
                break;
            }
            case 10: {
                this.addUK();
                break;
            }
            case 11: {
                this.addSwiss();
                break;
            }
            default: {
                this.addEnglish();
            }
        }
        if (this.getGraphics() != null) {
            this.drawKeyboard(this.m_nLanguage, this.getGraphics());
        }
    }

    private void AddKey(int i, int i0, int i1) {
        this.AddKey(i, i0, i1, this._T(""), this._T(""), 0, 0, 0, 0);
    }

    void AddKey(int pNormal, int pShifted, int pWidth, String Down, String Up, int pNormalCode, int pShiftedCode, int pScanCode, int pExtended) {
        this.AddKey(pNormal, pShifted, pWidth, Down, Up, this._T(""), pNormalCode, pShiftedCode, pScanCode, pExtended);
    }

    void AddKey(int pNormal, int pShifted, int pWidth, String Down, String Up, String Third, int pNormalCode, int pShiftedCode, int pScanCode, int pExtended) {
        KeyDef key = new KeyDef();
        key.cNormal = pNormal;
        key.cShifted = pShifted;
        key.cWidth = pWidth;
        key.strUp = Up;
        key.strDown = Down;
        key.strThird = Third;
        key.bNormalCode = pNormalCode;
        key.bShiftedCode = pShiftedCode;
        key.scankey = pScanCode;
        key.extended = pExtended;
        key.rc = new Rectangle(0, 0, 0, 0);
        this.v.add(key);
    }

    private String _T(String string) {
        return string;
    }

    private void CalcWidthHeight() {
        KeyDef key;
        int pKeyWidth = 0;
        int pKeyHeight = 0;
        int totalWidth = 0;
        int longest = 0;
        int rows = 0;
        int i = 0;
        while (i < this.v.size()) {
            key = this.v.get(i);
            if (key.cNormal == 0 && key.cShifted == 0) {
                ++rows;
                if (totalWidth > longest) {
                    longest = totalWidth;
                }
                totalWidth = 0;
            } else {
                totalWidth = Math.abs(key.cWidth) <= 199 ? (totalWidth += Math.abs(key.cWidth)) : (totalWidth += Math.abs(key.cWidth) - 200);
            }
            ++i;
        }
        if (rows != 0) {
            pKeyHeight = 19;
        }
        pKeyWidth = 18;
        totalWidth = 0;
        longest = 0;
        rows = 0;
        i = 0;
        while (i < this.v.size()) {
            key = this.v.get(i);
            if (key.cNormal == 0 && key.cShifted == 0) {
                ++rows;
                if (totalWidth > longest) {
                    longest = totalWidth;
                }
                totalWidth = 0;
            } else {
                if (Math.abs(key.cWidth) <= 199) {
                    key.SetRect(totalWidth * pKeyWidth / 10, (rows - 1) * pKeyHeight, Math.abs(key.cWidth) * pKeyWidth / 10, pKeyHeight);
                    totalWidth += Math.abs(key.cWidth);
                } else {
                    key.SetRect(totalWidth * pKeyWidth / 10, (rows - 1) * pKeyHeight, (Math.abs(key.cWidth) - 200) * pKeyWidth / 10, pKeyHeight * 2);
                    totalWidth += Math.abs(key.cWidth) - 200;
                }
                this.v.set(i, key);
            }
            ++i;
        }
    }

    public int DescribeKeyState() {
        int led;
        int state = 0;
        state = this.m_nOldLedStatus;
        if (this.m_bLControlDown) {
            state |= 0x20;
        }
        if (this.m_bRControlDown) {
            state |= 0x20;
        }
        if (this.m_bLShiftDown) {
            state |= 8;
        }
        if (this.m_bRShiftDown) {
            state |= 8;
        }
        if (this.m_bLAltDown) {
            state |= 0x10;
        }
        if (this.m_bRMenuDown) {
            state |= 0x40;
        }
        if (((led = this.parent.video.getLEDstatus()) & 4) == 4) {
            state |= 2;
        }
        if ((led & 2) == 2) {
            state |= 1;
        }
        return state;
    }

    private int getUsbKeyCode(KeyDef key) {
        return key.cShifted;
    }

    private void checkModifierUP(int vk) {
        if (vk == 57 && this.getGraphics() != null) {
            this.drawKeyboard(this.m_nLanguage, this.getGraphics());
        }
        if (vk != 224 && vk != 225 && vk != 226 && vk != 228 && vk != 229 && vk != 230) {
            KeyDef key = new KeyDef();
            if (this.m_bLShiftDown) {
                key.scankey = 16;
                key.cShifted = 225;
                key.extended = 0;
                this.my_keybd_event_up(key);
                this.m_bLShiftDown = false;
                if (this.getGraphics() != null) {
                    this.drawKeyboard(this.m_nLanguage, this.getGraphics());
                }
            }
            if (this.m_bRShiftDown) {
                key.scankey = 16;
                key.cShifted = 229;
                key.extended = 0;
                this.my_keybd_event_up(key);
                this.m_bRShiftDown = false;
                if (this.getGraphics() != null) {
                    this.drawKeyboard(this.m_nLanguage, this.getGraphics());
                }
            }
            if (this.m_bLControlDown) {
                key.scankey = 17;
                key.cShifted = 224;
                key.extended = 0;
                this.my_keybd_event_up(key);
                this.m_bLControlDown = false;
            }
            if (this.m_bRControlDown) {
                key.scankey = 17;
                key.cShifted = 228;
                key.extended = 0;
                this.my_keybd_event_up(key);
                this.m_bRControlDown = false;
            }
            if (this.m_bRMenuDown) {
                key.scankey = 18;
                key.cShifted = 230;
                key.extended = 0;
                this.my_keybd_event_up(key);
                this.m_bRMenuDown = false;
            }
            if (this.m_bLAltDown) {
                key.scankey = 18;
                key.cShifted = 226;
                key.extended = 0;
                this.my_keybd_event_up(key);
                this.m_bLAltDown = false;
            }
        }
    }

    public void resetModifiers() {
        this.m_bLShiftDown = false;
        this.m_bLAltDown = false;
        this.m_bLControlDown = false;
        this.m_bRShiftDown = false;
        this.m_bRControlDown = false;
        this.m_bRMenuDown = false;
    }

    private void SendKey(KeyDef key, MouseEvent evt) {
        boolean uptoo = true;
        int vk = this.getUsbKeyCode(key);
        switch (vk) {
            case 225: {
                if (this.m_bLShiftDown) {
                    this.m_bLShiftDown = false;
                    this.my_keybd_event_up(key);
                    return;
                }
                this.m_bLShiftDown = true;
                uptoo = false;
                break;
            }
            case 229: {
                if (this.m_bRShiftDown) {
                    this.m_bRShiftDown = false;
                    this.my_keybd_event_up(key);
                    return;
                }
                this.m_bRShiftDown = true;
                uptoo = false;
                break;
            }
            case 226: {
                if (this.m_bLAltDown) {
                    this.m_bLAltDown = false;
                    this.my_keybd_event_up(key);
                    return;
                }
                this.m_bLAltDown = true;
                uptoo = false;
                break;
            }
            case 224: {
                if (this.m_bLControlDown) {
                    this.m_bLControlDown = false;
                    this.my_keybd_event_up(key);
                    return;
                }
                this.m_bLControlDown = true;
                uptoo = false;
                break;
            }
            case 228: {
                if (this.m_bRControlDown) {
                    this.m_bRControlDown = false;
                    this.my_keybd_event_up(key);
                    return;
                }
                this.m_bRControlDown = true;
                uptoo = false;
                break;
            }
            case 230: {
                if (this.m_bRMenuDown) {
                    this.m_bRMenuDown = false;
                    this.my_keybd_event_up(key);
                    return;
                }
                this.m_bRMenuDown = true;
                uptoo = false;
                break;
            }
            case 0: {
                return;
            }
        }
        if (vk != 0) {
            this.my_keybd_event_down(key);
        }
        if (uptoo) {
            this.my_keybd_event_up(key);
        }
        this.checkModifierUP(vk);
    }

    private void my_keybd_event_down(KeyDef key) {
        int virtualKey = KeyMap.VKtoHID(key.scankey);
        int scanKey = key.cShifted;
        int extended = 0;
        int down = 1;
        switch (key.scankey) {
            case 20: 
            case 144: 
            case 145: {
                this.parent.video.changeLEDstatus(virtualKey, scanKey, extended, down, 0, 0, 0);
                onScreenKeyboard onScreenKeyboard2 = this.parent;
                if (onScreenKeyboard2.video.QueryOS() == '\u0000') break;
            }
            default: {
                this.parent.video.keyboardActionWithHold(virtualKey, scanKey, extended, down, 0, 0, 0);
            }
        }
    }

    private void my_keybd_event_up(KeyDef key) {
        int virtualKey = KeyMap.VKtoHID(key.scankey);
        int scanKey = key.cShifted;
        int extended = 0;
        int down = 0;
        switch (key.scankey) {
            case 20: 
            case 144: 
            case 145: {
                onScreenKeyboard onScreenKeyboard2 = this.parent;
                if (onScreenKeyboard2.video.QueryOS() == '\u0000') break;
            }
            default: {
                this.parent.video.keyboardActionWithHold(virtualKey, scanKey, extended, down, 0, 0, 0);
            }
        }
    }

    private void keybd_event(int keyvalue, int bScan, int dwFlags, int dwExtraInfo) {
        if (this.m_robot == null) {
            return;
        }
        if (dwFlags == 2) {
            this.m_robot.keyRelease(keyvalue);
        } else {
            this.m_robot.keyPress(keyvalue);
        }
    }

    private void deleteKeys() {
        this.v.clear();
        int state = this.DescribeKeyState();
        if ((state & 0x10) == 16) {
            this.keybd_event(18, 0, 2, 0);
        }
        if ((state & 8) == 8) {
            this.keybd_event(16, 0, 2, 0);
        }
        if ((state & 0x20) == 32) {
            this.keybd_event(17, 0, 2, 0);
        }
    }

    private void DrawPressedKey(KeyDef key, Graphics graphics) {
        this.m_nKeyPressed = true;
        this.drawKey(key, graphics);
        this.m_nKeyPressed = false;
    }

    public int checkSyncLedStatus() {
        if (this.getGraphics() != null) {
            this.drawKeyboard(this.m_nLanguage, this.getGraphics());
        }
        int state = this.myGetKeyState();
        syncDelayedTimes = syncCounter <= 100 ? (syncDelayedTimes-- < 0 ? 0 : 0) : ++syncDelayedTimes;
        return 0;
    }

    public int videoCheckSyncLedStatus(int state) {
        syncDelayedTimes = syncCounter <= 100 ? (syncDelayedTimes-- < 0 ? 0 : 0) : ++syncDelayedTimes;
        return 0;
    }

    public int myGetKeyState() {
        int state = 0;
        Toolkit tk = Toolkit.getDefaultToolkit();
        try {
            if (tk.getLockingKeyState(145)) {
                state |= 1;
            }
            if (tk.getLockingKeyState(144)) {
                state |= 2;
            }
            if (tk.getLockingKeyState(20)) {
                state |= 4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    boolean KVMhasFocus() {
        return this.isKVMhasFocus;
    }

    public void getMyKeyboardLedStatus() {
        this.m_nOldKeyboardStatus = this.myGetKeyState();
    }

    public void changeUILanguage(String[] UIString) {
        this.rb10.setText(UIString[102]);
        this.rb12.setText(UIString[103]);
        this.rb13.setText(UIString[104]);
        this.rb14.setText(UIString[105]);
        this.rb15.setText(UIString[106]);
        this.rb16.setText(UIString[107]);
        this.rb17.setText(UIString[108]);
        this.rb18.setText(UIString[109]);
        this.rb19.setText(UIString[117]);
        this.parent.setTitle(UIString[102]);
        this.UIString = (String[])UIString.clone();
    }

    private int addEnglish() {
        if (RemoteVideo.screnMode) {
            this.parent.video.setInteranlFrameTitle(this.UIString[102]);
        } else {
            this.parent.setTitle(this.UIString[102]);
        }
        this.AddKey(0, 0, 0, "", "", 0, 0, 0, 0);
        this.AddKey(0, 41, 10, "esc", "esc", 27, 27, 27, 0);
        this.AddKey(0, this.EMPTY, 10, "", "", 0, 0, 0, 0);
        this.AddKey(0, 58, 10, "F1", "F1", 112, 112, 112, 0);
        this.AddKey(0, 59, 10, "F2", "F2", 113, 113, 113, 0);
        this.AddKey(0, 60, 10, "F3", "F3", 114, 114, 114, 0);
        this.AddKey(0, 61, 10, "F4", "F4", 115, 115, 115, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 62, 10, "F5", "F5", 116, 116, 116, 0);
        this.AddKey(0, 63, 10, "F6", "F6", 117, 117, 117, 0);
        this.AddKey(0, 64, 10, "F7", "F7", 118, 118, 118, 0);
        this.AddKey(0, 65, 10, "F8", "F8", 119, 119, 119, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 66, 10, "F9", "F9", 120, 120, 120, 0);
        this.AddKey(0, 67, 10, "/res/f10.png", "/res/f10.png", 121, 121, 121, 0);
        this.AddKey(0, 68, 10, "/res/f11.png", "/res/f11.png", 122, 122, 122, 0);
        this.AddKey(0, 69, 10, "/res/f12.png", "/res/f12.png", 123, 123, 123, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 70, 30, "psc", "psc", 154, 154, 154, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 71, 20, "slk", "slk", 145, 145, 145, 0);
        this.AddKey(2, 72, 20, "pau", "brk", 3, 19, 19, 0);
        this.AddKey(0, 0, 1);
        this.AddKey(1, 53, 10, "`", "~", 192, 192, 192, 0);
        this.AddKey(1, 30, 10, "1", "!", 49, 49, 49, 0);
        this.AddKey(1, 31, 10, "2", "@", 50, 50, 50, 0);
        this.AddKey(1, 32, 10, "3", "#", 51, 51, 51, 0);
        this.AddKey(1, 33, 10, "4", "$", 52, 52, 52, 0);
        this.AddKey(1, 34, 10, "5", "%", 53, 53, 53, 0);
        this.AddKey(1, 35, 10, "6", "^", 54, 54, 54, 0);
        this.AddKey(1, 36, 10, "7", "&", 55, 55, 55, 0);
        this.AddKey(1, 37, 10, "8", "*", 56, 56, 56, 0);
        this.AddKey(1, 38, 10, "9", "(", 57, 57, 57, 0);
        this.AddKey(1, 39, 10, "0", ")", 48, 48, 48, 0);
        this.AddKey(1, 45, 10, "-", "_", 45, 45, 109, 0);
        this.AddKey(1, 46, 10, "=", "+", 61, 61, 61, 0);
        this.AddKey(0, 42, 20, this._T("/res/bs.png"), this._T("/res/bs.png"), 8, 8, 8, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 73, 10, this._T("ins"), this._T("ins"), 155, 155, 155, 1);
        this.AddKey(0, 74, 10, this._T("/res/home.png"), this._T("/res/home.png"), 36, 36, 36, 1);
        this.AddKey(0, 75, 10, this._T("/res/pgup.png"), this._T("/res/pgup.png"), 33, 33, 33, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 83, 10, this._T("nlk"), this._T("nlk"), 144, 144, 144, 0);
        this.AddKey(0, 84, 10, this._T("/"), this._T("/"), 111, 111, 111, 1);
        this.AddKey(0, 85, 10, "*", "*", 106, 106, 106, 0);
        this.AddKey(0, 86, 10, "-", "-", 109, 109, 109, 0);
        this.AddKey(0, 0, 2);
        this.AddKey(0, 43, 20, this._T("/res/tab.png"), this._T("/res/tab.png"), 9, 9, 9, 0);
        this.AddKey(2, 20, 10, this._T("q"), this._T("Q"), 81, 81, 81, 0);
        this.AddKey(2, 26, 10, this._T("w"), this._T("W"), 87, 87, 87, 0);
        this.AddKey(2, 8, 10, this._T("e"), this._T("E"), 69, 69, 69, 0);
        this.AddKey(2, 21, 10, this._T("r"), this._T("R"), 82, 82, 82, 0);
        this.AddKey(2, 23, 10, this._T("t"), this._T("T"), 84, 84, 84, 0);
        this.AddKey(2, 28, 10, this._T("y"), this._T("Y"), 89, 89, 89, 0);
        this.AddKey(2, 24, 10, this._T("u"), this._T("U"), 85, 85, 85, 0);
        this.AddKey(2, 12, 10, this._T("i"), this._T("I"), 73, 73, 73, 0);
        this.AddKey(2, 18, 10, this._T("o"), this._T("O"), 79, 79, 79, 0);
        this.AddKey(2, 19, 10, this._T("p"), this._T("P"), 80, 80, 80, 0);
        this.AddKey(1, 47, 10, this._T("["), this._T("{"), 91, 91, 91, 0);
        this.AddKey(1, 48, 10, this._T("]"), this._T("}"), 93, 93, 93, 0);
        this.AddKey(1, 49, 10, this._T("\\"), this._T("|"), 92, 92, 92, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 76, 10, this._T("del"), this._T("del"), 127, 127, 127, 1);
        this.AddKey(0, 77, 10, this._T("/res/end.png"), this._T("/res/end.png"), 35, 35, 35, 1);
        this.AddKey(0, 78, 10, this._T("/res/pgdn.png"), this._T("/res/pgdn.png"), 34, 34, 34, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 95, 10, this._T("/res/home.png"), this._T("7"), 36, 103, 103, 0);
        this.AddKey(4, 96, 10, this._T("/res/up.png"), this._T("8"), 38, 104, 104, 0);
        this.AddKey(4, 97, 10, this._T("/res/pgup.png"), this._T("9"), 33, 105, 105, 0);
        this.AddKey(0, 87, 210, this._T("+"), this._T("+"), 107, 107, 107, 0);
        this.AddKey(0, 0, 3);
        this.AddKey(0, 57, 20, this._T("/res/caps1.png"), this._T("/res/caps1.png"), 20, 20, 20, 0);
        this.AddKey(2, 4, 10, "a", "A", 65, 65, 65, 0);
        this.AddKey(2, 22, 10, "s", "S", 83, 83, 83, 0);
        this.AddKey(2, 7, 10, "d", "D", 68, 68, 68, 0);
        this.AddKey(2, 9, 10, "f", "F", 70, 70, 70, 0);
        this.AddKey(2, 10, 10, "g", "G", 71, 71, 71, 0);
        this.AddKey(2, 11, 10, "h", "H", 72, 72, 72, 0);
        this.AddKey(2, 13, 10, "j", "J", 74, 74, 74, 0);
        this.AddKey(2, 14, 10, "k", "K", 75, 75, 75, 0);
        this.AddKey(2, 15, 10, "l", "L", 76, 76, 76, 0);
        this.AddKey(1, 51, 10, ";", ":", 59, 59, 59, 0);
        this.AddKey(1, 52, 10, "'", "\"", 222, 222, 222, 0);
        this.AddKey(0, 40, 20, this._T("/res/ret.png"), this._T("/res/ret.png"), 10, 10, 10, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 92, 10, this._T("/res/left.png"), this._T("4"), 37, 100, 100, 0);
        this.AddKey(4, 93, 10, this._T(" "), this._T("5"), 12, 101, 101, 0);
        this.AddKey(4, 94, 10, this._T("/res/right.png"), this._T("6"), 39, 102, 102, 0);
        this.AddKey(0, 0, 4);
        this.AddKey(0, 225, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(2, 29, 10, this._T("z"), this._T("Z"), 90, 90, 90, 0);
        this.AddKey(2, 27, 10, this._T("x"), this._T("X"), 88, 88, 88, 0);
        this.AddKey(2, 6, 10, this._T("c"), this._T("C"), 67, 67, 67, 0);
        this.AddKey(2, 25, 10, this._T("v"), this._T("V"), 86, 86, 86, 0);
        this.AddKey(2, 5, 10, this._T("b"), this._T("B"), 66, 66, 66, 0);
        this.AddKey(2, 17, 10, this._T("n"), this._T("N"), 78, 78, 78, 0);
        this.AddKey(2, 16, 10, this._T("m"), this._T("M"), 77, 77, 77, 0);
        this.AddKey(1, 54, 10, this._T(","), this._T("<"), 44, 44, 44, 0);
        this.AddKey(1, 55, 10, this._T("."), this._T(">"), 46, 46, 46, 0);
        this.AddKey(1, 56, 10, this._T("/"), this._T("?"), 47, 47, 47, 0);
        this.AddKey(0, 229, 30, this._T("/res/shift3.png"), this._T("/res/shift3.png"), 16, 16, 16, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, 82, 10, this._T("/res/up.png"), this._T("/res/up.png"), 38, 38, 38, 1);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 89, 10, this._T("/res/end.png"), this._T("1"), 35, 97, 97, 0);
        this.AddKey(4, 90, 10, this._T("/res/down.png"), this._T("2"), 40, 98, 98, 0);
        this.AddKey(4, 91, 10, this._T("/res/pgdn.png"), this._T("3"), 34, 99, 99, 0);
        this.AddKey(0, 88, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), 10, 10, 10, 1);
        this.AddKey(0, 0, 5);
        this.AddKey(0, 224, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, 227, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 226, 20, this._T("alt"), this._T("alt"), 18, 18, 18, 0);
        this.AddKey(0, 44, 40, this._T(" "), this._T(" "), 32, 32, 32, 0);
        this.AddKey(0, 230, 20, this._T("alt"), this._T("alt"), 18, 18, 18, 0);
        this.AddKey(0, 231, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 101, 10, this._T("/res/menu.png"), this._T("/res/menu.png"), 525, 525, 525, 1);
        this.AddKey(0, 228, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 80, 10, this._T("/res/left.png"), this._T("/res/left.png"), 37, 37, 37, 1);
        this.AddKey(0, 81, 10, this._T("/res/down.png"), this._T("/res/down.png"), 40, 40, 40, 1);
        this.AddKey(0, 79, 10, this._T("/res/right.png"), this._T("/res/right.png"), 39, 39, 39, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 98, 20, this._T("ins"), this._T("0"), 155, 96, 96, 0);
        this.AddKey(4, 99, 10, this._T("del"), this._T("."), 127, 110, 110, 0);
        this.CalcWidthHeight();
        return 0;
    }

    private int addChineseSimplified() {
        if (RemoteVideo.screnMode) {
            this.parent.video.setInteranlFrameTitle("Chinese(PRC) Keyboard");
        } else {
            this.parent.setTitle("Chinese(PRC) Keyboard");
        }
        this.AddKey(0, 0, 0, "", "", 0, 0, 0, 0);
        this.AddKey(0, 41, 10, "esc", "esc", 27, 27, 27, 0);
        this.AddKey(0, this.EMPTY, 10, "", "", 0, 0, 0, 0);
        this.AddKey(0, 58, 10, "F1", "F1", 112, 112, 112, 0);
        this.AddKey(0, 59, 10, "F2", "F2", 113, 113, 113, 0);
        this.AddKey(0, 60, 10, "F3", "F3", 114, 114, 114, 0);
        this.AddKey(0, 61, 10, "F4", "F4", 115, 115, 115, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 62, 10, "F5", "F5", 116, 116, 116, 0);
        this.AddKey(0, 63, 10, "F6", "F6", 117, 117, 117, 0);
        this.AddKey(0, 64, 10, "F7", "F7", 118, 118, 118, 0);
        this.AddKey(0, 65, 10, "F8", "F8", 119, 119, 119, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 66, 10, "F9", "F9", 120, 120, 120, 0);
        this.AddKey(0, 67, 10, "/res/f10.png", "/res/f10.png", 121, 121, 121, 0);
        this.AddKey(0, 68, 10, "/res/f11.png", "/res/f11.png", 122, 122, 122, 0);
        this.AddKey(0, 69, 10, "/res/f12.png", "/res/f12.png", 123, 123, 123, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 70, 30, "psc", "psc", 154, 154, 154, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 71, 20, "slk", "slk", 145, 145, 145, 0);
        this.AddKey(2, 72, 20, "pau", "brk", 3, 19, 19, 1);
        this.AddKey(0, 0, 1);
        this.AddKey(1, 53, 10, "`", "~", 192, 192, 192, 0);
        this.AddKey(1, 30, 10, "1", "!", 49, 49, 49, 0);
        this.AddKey(1, 31, 10, "2", "@", 50, 50, 50, 0);
        this.AddKey(1, 32, 10, "3", "#", 51, 51, 51, 0);
        this.AddKey(1, 33, 10, "4", "$", 52, 52, 52, 0);
        this.AddKey(1, 34, 10, "5", "%", 53, 53, 53, 0);
        this.AddKey(1, 35, 10, "6", "^", 54, 54, 54, 0);
        this.AddKey(1, 36, 10, "7", "&", 55, 55, 55, 0);
        this.AddKey(1, 37, 10, "8", "*", 56, 56, 56, 0);
        this.AddKey(1, 38, 10, "9", "(", 57, 57, 57, 0);
        this.AddKey(1, 39, 10, "0", ")", 48, 48, 48, 0);
        this.AddKey(1, 45, 10, "-", "_", 45, 45, 109, 0);
        this.AddKey(1, 46, 10, "=", "+", 61, 61, 61, 0);
        this.AddKey(0, 42, 20, this._T("/res/bs.png"), this._T("/res/bs.png"), 8, 8, 8, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 73, 10, this._T("ins"), this._T("ins"), 155, 155, 155, 0);
        this.AddKey(0, 74, 10, this._T("/res/home.png"), this._T("/res/home.png"), 36, 36, 36, 1);
        this.AddKey(0, 75, 10, this._T("/res/pgup.png"), this._T("/res/pgup.png"), 33, 33, 33, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 83, 10, this._T("nlk"), this._T("nlk"), 144, 144, 144, 0);
        this.AddKey(0, 84, 10, this._T("/"), this._T("/"), 111, 111, 111, 1);
        this.AddKey(0, 85, 10, "*", "*", 106, 106, 106, 0);
        this.AddKey(0, 86, 10, "-", "-", 109, 109, 109, 0);
        this.AddKey(0, 0, 2);
        this.AddKey(0, 43, 20, this._T("/res/tab.png"), this._T("/res/tab.png"), 9, 9, 9, 0);
        this.AddKey(2, 20, 10, this._T("q"), this._T("Q"), 81, 81, 81, 0);
        this.AddKey(2, 26, 10, this._T("w"), this._T("W"), 87, 87, 87, 0);
        this.AddKey(2, 8, 10, this._T("e"), this._T("E"), 69, 69, 69, 0);
        this.AddKey(2, 21, 10, this._T("r"), this._T("R"), 82, 82, 82, 0);
        this.AddKey(2, 23, 10, this._T("t"), this._T("T"), 84, 84, 84, 0);
        this.AddKey(2, 28, 10, this._T("y"), this._T("Y"), 89, 89, 89, 0);
        this.AddKey(2, 24, 10, this._T("u"), this._T("U"), 85, 85, 85, 0);
        this.AddKey(2, 12, 10, this._T("i"), this._T("I"), 73, 73, 73, 0);
        this.AddKey(2, 18, 10, this._T("o"), this._T("O"), 79, 79, 79, 0);
        this.AddKey(2, 19, 10, this._T("p"), this._T("P"), 80, 80, 80, 0);
        this.AddKey(1, 47, 10, this._T("["), this._T("{"), 91, 91, 91, 0);
        this.AddKey(1, 48, 10, this._T("]"), this._T("}"), 93, 93, 93, 0);
        this.AddKey(1, 49, 10, this._T("\\"), this._T("|"), 92, 92, 92, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 76, 10, this._T("del"), this._T("del"), 127, 127, 127, 1);
        this.AddKey(0, 77, 10, this._T("/res/end.png"), this._T("/res/end.png"), 35, 35, 35, 1);
        this.AddKey(0, 78, 10, this._T("/res/pgdn.png"), this._T("/res/pgdn.png"), 34, 34, 34, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 95, 10, this._T("/res/home.png"), this._T("7"), 36, 103, 103, 0);
        this.AddKey(4, 96, 10, this._T("/res/up.png"), this._T("8"), 38, 104, 104, 0);
        this.AddKey(4, 97, 10, this._T("/res/pgup.png"), this._T("9"), 33, 105, 105, 0);
        this.AddKey(0, 87, 210, this._T("+"), this._T("+"), 107, 107, 107, 0);
        this.AddKey(0, 0, 3);
        this.AddKey(0, 57, 20, this._T("/res/caps1.png"), this._T("/res/caps1.png"), 20, 20, 20, 0);
        this.AddKey(2, 4, 10, "a", "A", 65, 65, 65, 0);
        this.AddKey(2, 22, 10, "s", "S", 83, 83, 83, 0);
        this.AddKey(2, 7, 10, "d", "D", 68, 68, 68, 0);
        this.AddKey(2, 9, 10, "f", "F", 70, 70, 70, 0);
        this.AddKey(2, 10, 10, "g", "G", 71, 71, 71, 0);
        this.AddKey(2, 11, 10, "h", "H", 72, 72, 72, 0);
        this.AddKey(2, 13, 10, "j", "J", 74, 74, 74, 0);
        this.AddKey(2, 14, 10, "k", "K", 75, 75, 75, 0);
        this.AddKey(2, 15, 10, "l", "L", 76, 76, 76, 0);
        this.AddKey(1, 51, 10, ";", ":", 59, 59, 59, 0);
        this.AddKey(1, 52, 10, "'", "\"", 222, 222, 222, 0);
        this.AddKey(0, 40, 20, this._T("/res/ret.png"), this._T("/res/ret.png"), 10, 10, 10, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 92, 10, this._T("/res/left.png"), this._T("4"), 37, 100, 100, 0);
        this.AddKey(4, 93, 10, this._T(" "), this._T("5"), 12, 101, 101, 0);
        this.AddKey(4, 94, 10, this._T("/res/right.png"), this._T("6"), 39, 102, 102, 0);
        this.AddKey(0, 0, 4);
        this.AddKey(0, 225, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(2, 29, 10, this._T("z"), this._T("Z"), 90, 90, 90, 0);
        this.AddKey(2, 27, 10, this._T("x"), this._T("X"), 88, 88, 88, 0);
        this.AddKey(2, 6, 10, this._T("c"), this._T("C"), 67, 67, 67, 0);
        this.AddKey(2, 25, 10, this._T("v"), this._T("V"), 86, 86, 86, 0);
        this.AddKey(2, 5, 10, this._T("b"), this._T("B"), 66, 66, 66, 0);
        this.AddKey(2, 17, 10, this._T("n"), this._T("N"), 78, 78, 78, 0);
        this.AddKey(2, 16, 10, this._T("m"), this._T("M"), 77, 77, 77, 0);
        this.AddKey(1, 54, 10, this._T(","), this._T("<"), 44, 44, 44, 0);
        this.AddKey(1, 55, 10, this._T("."), this._T(">"), 46, 46, 46, 0);
        this.AddKey(1, 56, 10, this._T("/"), this._T("?"), 47, 47, 47, 0);
        this.AddKey(0, 229, 30, this._T("/res/shift3.png"), this._T("/res/shift3.png"), 16, 16, 16, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, 82, 10, this._T("/res/up.png"), this._T("/res/up.png"), 38, 38, 38, 1);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 89, 10, this._T("/res/end.png"), this._T("1"), 35, 97, 97, 0);
        this.AddKey(4, 90, 10, this._T("/res/down.png"), this._T("2"), 40, 98, 98, 0);
        this.AddKey(4, 91, 10, this._T("/res/pgdn.png"), this._T("3"), 34, 99, 99, 0);
        this.AddKey(0, 88, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), 10, 10, 10, 0);
        this.AddKey(0, 0, 5);
        this.AddKey(0, 224, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, 227, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 226, 20, this._T("alt"), this._T("alt"), 18, 18, 18, 0);
        this.AddKey(0, 44, 40, this._T(" "), this._T(" "), 32, 32, 57, 0);
        this.AddKey(0, 230, 20, this._T("alt"), this._T("alt"), 18, 18, 18, 0);
        this.AddKey(0, 231, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 101, 10, this._T("/res/menu.png"), this._T("/res/menu.png"), 525, 525, 525, 1);
        this.AddKey(0, 228, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 80, 10, this._T("/res/left.png"), this._T("/res/left.png"), 37, 37, 37, 1);
        this.AddKey(0, 81, 10, this._T("/res/down.png"), this._T("/res/down.png"), 40, 40, 40, 1);
        this.AddKey(0, 79, 10, this._T("/res/right.png"), this._T("/res/right.png"), 39, 39, 39, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 98, 20, this._T("ins"), this._T("0"), 155, 96, 96, 0);
        this.AddKey(4, 99, 10, this._T("del"), this._T("."), 127, 110, 110, 0);
        this.CalcWidthHeight();
        return 0;
    }

    private int addChineseTraditional() {
        if (RemoteVideo.screnMode) {
            this.parent.video.setInteranlFrameTitle(this.UIString[103]);
        } else {
            this.parent.setTitle(this.UIString[103]);
        }
        this.AddKey(0, 0, 0, "", "", 0, 0, 0, 0);
        this.AddKey(0, 41, 10, "esc", "esc", 27, 27, 27, 0);
        this.AddKey(0, this.EMPTY, 10, "", "", 0, 0, 0, 0);
        this.AddKey(0, 58, 10, "F1", "F1", 112, 112, 112, 0);
        this.AddKey(0, 59, 10, "F2", "F2", 113, 113, 113, 0);
        this.AddKey(0, 60, 10, "F3", "F3", 114, 114, 114, 0);
        this.AddKey(0, 61, 10, "F4", "F4", 115, 115, 115, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 62, 10, "F5", "F5", 116, 116, 116, 0);
        this.AddKey(0, 63, 10, "F6", "F6", 117, 117, 117, 0);
        this.AddKey(0, 64, 10, "F7", "F7", 118, 118, 118, 0);
        this.AddKey(0, 65, 10, "F8", "F8", 119, 119, 119, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 66, 10, "F9", "F9", 120, 120, 120, 0);
        this.AddKey(0, 67, 10, "/res/f10.png", "/res/f10.png", 121, 121, 121, 0);
        this.AddKey(0, 68, 10, "/res/f11.png", "/res/f11.png", 122, 122, 122, 0);
        this.AddKey(0, 69, 10, "/res/f12.png", "/res/f12.png", 123, 123, 123, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 70, 30, "psc", "psc", 154, 154, 154, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 71, 20, "slk", "slk", 145, 145, 145, 0);
        this.AddKey(2, 72, 20, "pau", "brk", 3, 19, 19, 1);
        this.AddKey(0, 0, 1);
        this.AddKey(1, 53, 10, "`", "`", "~", 192, 192, 192, 0);
        this.AddKey(1, 30, 10, "/res/tw1.png", "1", "!", 49, 49, 49, 0);
        this.AddKey(1, 31, 10, "/res/tw2.png", "2", "@", 50, 50, 50, 0);
        this.AddKey(1, 32, 10, "/res/tw3.png", "3", "#", 51, 51, 51, 0);
        this.AddKey(1, 33, 10, "/res/tw4.png", "4", "$", 52, 52, 52, 0);
        this.AddKey(1, 34, 10, "/res/tw5.png", "5", "%", 53, 53, 53, 0);
        this.AddKey(1, 35, 10, "/res/tw6.png", "6", "^", 54, 54, 54, 0);
        this.AddKey(1, 36, 10, "/res/tw7.png", "7", "&", 55, 55, 55, 0);
        this.AddKey(1, 37, 10, "/res/tw8.png", "8", "*", 56, 56, 56, 0);
        this.AddKey(1, 38, 10, "/res/tw9.png", "9", "(", 57, 57, 57, 0);
        this.AddKey(1, 39, 10, "/res/tw0.png", "0", ")", 48, 48, 48, 0);
        this.AddKey(1, 45, 10, "/res/tw-.png", "-", "_", 45, 45, 45, 0);
        this.AddKey(1, 46, 10, "=", "+", "+", 61, 61, 61, 0);
        this.AddKey(0, 42, 20, this._T("/res/bs.png"), this._T("/res/bs.png"), 8, 8, 8, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 73, 10, this._T("ins"), this._T("ins"), 155, 155, 155, 1);
        this.AddKey(0, 74, 10, this._T("/res/home.png"), this._T("/res/home.png"), 36, 36, 36, 1);
        this.AddKey(0, 75, 10, this._T("/res/pgup.png"), this._T("/res/pgup.png"), 33, 33, 33, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 83, 10, this._T("nlk"), this._T("nlk"), 144, 144, 144, 0);
        this.AddKey(0, 84, 10, this._T("/"), this._T("/"), 111, 111, 111, 1);
        this.AddKey(0, 85, 10, "*", "*", 106, 106, 106, 0);
        this.AddKey(0, 86, 10, "-", "-", 109, 109, 109, 0);
        this.AddKey(0, 0, 2);
        this.AddKey(0, 43, 20, this._T("/res/tab.png"), this._T("/res/tab.png"), 9, 9, 9, 0);
        this.AddKey(1, 20, 10, this._T("/res/twq.png"), "q", this._T("Q"), 81, 81, 81, 0);
        this.AddKey(1, 26, 10, this._T("/res/tww.png"), "w", this._T("W"), 87, 87, 87, 0);
        this.AddKey(1, 8, 10, this._T("/res/twe.png"), "e", this._T("E"), 69, 69, 69, 0);
        this.AddKey(1, 21, 10, this._T("/res/twr.png"), "r", this._T("R"), 82, 82, 82, 0);
        this.AddKey(1, 23, 10, this._T("/res/twt.png"), "t", this._T("T"), 84, 84, 84, 0);
        this.AddKey(1, 28, 10, this._T("/res/twy.png"), "y", this._T("Y"), 89, 89, 89, 0);
        this.AddKey(1, 24, 10, this._T("/res/twu.png"), "u", this._T("U"), 85, 85, 85, 0);
        this.AddKey(1, 12, 10, this._T("/res/twi.png"), "i", this._T("I"), 73, 73, 73, 0);
        this.AddKey(1, 18, 10, this._T("/res/two.png"), "o", this._T("O"), 79, 79, 79, 0);
        this.AddKey(1, 19, 10, this._T("/res/twp.png"), "p", this._T("P"), 80, 80, 80, 0);
        this.AddKey(1, 47, 10, this._T("["), "{", this._T("{"), 91, 91, 91, 0);
        this.AddKey(1, 48, 10, this._T("]"), "}", this._T("}"), 93, 93, 93, 0);
        this.AddKey(1, 49, 10, this._T("\\"), "|", this._T("|"), 92, 92, 92, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 76, 10, this._T("del"), this._T("del"), 127, 127, 127, 1);
        this.AddKey(0, 77, 10, this._T("/res/end.png"), this._T("/res/end.png"), 35, 35, 35, 1);
        this.AddKey(0, 78, 10, this._T("/res/pgdn.png"), this._T("/res/pgdn.png"), 34, 34, 34, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 95, 10, this._T("/res/home.png"), this._T("7"), 36, 103, 103, 0);
        this.AddKey(4, 96, 10, this._T("/res/up.png"), this._T("8"), 38, 104, 104, 0);
        this.AddKey(4, 97, 10, this._T("/res/pgup.png"), this._T("9"), 33, 105, 105, 0);
        this.AddKey(0, 87, 210, this._T("+"), this._T("+"), 107, 107, 107, 0);
        this.AddKey(0, 0, 3);
        this.AddKey(0, 57, 20, this._T("/res/caps1.png"), this._T("/res/caps1.png"), 20, 20, 20, 0);
        this.AddKey(1, 4, 10, "/res/twa.png", "a", "A", 65, 65, 65, 0);
        this.AddKey(1, 22, 10, "/res/tws.png", "s", "S", 83, 83, 83, 0);
        this.AddKey(1, 7, 10, "/res/twd.png", "d", "D", 68, 68, 68, 0);
        this.AddKey(1, 9, 10, "/res/twf.png", "f", "F", 70, 70, 70, 0);
        this.AddKey(1, 10, 10, "/res/twg.png", "g", "G", 71, 71, 71, 0);
        this.AddKey(1, 11, 10, "/res/twh.png", "h", "H", 72, 72, 72, 0);
        this.AddKey(1, 13, 10, "/res/twj.png", "j", "J", 74, 74, 74, 0);
        this.AddKey(1, 14, 10, "/res/twk.png", "k", "K", 75, 75, 75, 0);
        this.AddKey(1, 15, 10, "/res/twl.png", "l", "L", 76, 76, 76, 0);
        this.AddKey(1, 51, 10, "/res/twcolon.png", ";", ":", 59, 59, 59, 0);
        this.AddKey(1, 52, 10, "'", "\"", "\"", 222, 222, 222, 0);
        this.AddKey(0, 40, 20, this._T("/res/ret.png"), this._T("/res/ret.png"), 10, 10, 10, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 92, 10, this._T("/res/left.png"), this._T("4"), 37, 100, 100, 0);
        this.AddKey(4, 93, 10, this._T(" "), this._T("5"), 12, 101, 101, 0);
        this.AddKey(4, 94, 10, this._T("/res/right.png"), this._T("6"), 39, 102, 102, 0);
        this.AddKey(0, 0, 4);
        this.AddKey(0, 225, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(1, 29, 10, this._T("/res/twz.png"), "z", this._T("Z"), 90, 90, 90, 0);
        this.AddKey(1, 27, 10, this._T("/res/twx.png"), "x", this._T("X"), 88, 88, 88, 0);
        this.AddKey(1, 6, 10, this._T("/res/twc.png"), "c", this._T("C"), 67, 67, 67, 0);
        this.AddKey(1, 25, 10, this._T("/res/twv.png"), "v", this._T("V"), 86, 86, 86, 0);
        this.AddKey(1, 5, 10, this._T("/res/twb.png"), "b", this._T("B"), 66, 66, 66, 0);
        this.AddKey(1, 17, 10, this._T("/res/twn.png"), "n", this._T("N"), 78, 78, 78, 0);
        this.AddKey(1, 16, 10, this._T("/res/twm.png"), "m", this._T("M"), 77, 77, 77, 0);
        this.AddKey(1, 54, 10, this._T("/res/twcomma.png"), ",", this._T("<"), 44, 44, 44, 0);
        this.AddKey(1, 55, 10, this._T("/res/twperiod.png"), ".", this._T(">"), 46, 46, 46, 0);
        this.AddKey(1, 56, 10, this._T("/res/twslash.png"), "/", this._T("?"), 47, 47, 47, 0);
        this.AddKey(0, 229, 30, this._T("/res/shift3.png"), this._T("/res/shift3.png"), 16, 16, 16, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, 82, 10, this._T("\u2191"), this._T("\u2191"), 38, 38, 38, 1);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 89, 10, this._T("/res/end.png"), this._T("1"), 35, 97, 97, 0);
        this.AddKey(4, 90, 10, this._T("/res/down.png"), this._T("2"), 40, 98, 98, 0);
        this.AddKey(4, 91, 10, this._T("/res/pgdn.png"), this._T("3"), 34, 99, 99, 0);
        this.AddKey(0, 88, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), 10, 10, 10, 1);
        this.AddKey(0, 0, 5);
        this.AddKey(0, 224, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, 227, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 226, 20, this._T("alt"), this._T("alt"), 18, 18, 18, 0);
        this.AddKey(0, 44, 40, this._T(" "), this._T(" "), 32, 32, 32, 0);
        this.AddKey(0, 230, 20, this._T("alt"), this._T("alt"), 18, 18, 18, 0);
        this.AddKey(0, 231, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 101, 10, this._T("/res/menu.png"), this._T("/res/menu.png"), 525, 525, 525, 0);
        this.AddKey(0, 228, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 80, 10, this._T("/res/left.png"), this._T("/res/left.png"), 37, 37, 37, 1);
        this.AddKey(0, 81, 10, this._T("/res/down.png"), this._T("/res/down.png"), 40, 40, 40, 0);
        this.AddKey(0, 79, 10, this._T("/res/right.png"), this._T("/res/right.png"), 39, 39, 39, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 98, 20, this._T("ins"), this._T("0"), 155, 96, 96, 0);
        this.AddKey(4, 99, 10, this._T("del"), this._T("."), 127, 110, 110, 0);
        this.CalcWidthHeight();
        return 0;
    }

    private int addJapanese() {
        this.setLocale(Locale.JAPANESE);
        this.getInputContext().selectInputMethod(Locale.JAPANESE);
        if (RemoteVideo.screnMode) {
            this.parent.video.setInteranlFrameTitle(this.UIString[104]);
        } else {
            this.parent.setTitle(this.UIString[104]);
        }
        this.AddKey(0, 0, 0, "", "", 0, 0, 0, 0);
        this.AddKey(0, 41, 10, "esc", "esc", 27, 27, 27, 0);
        this.AddKey(0, this.EMPTY, 10, "", "", 0, 0, 0, 0);
        this.AddKey(0, 58, 10, "F1", "F1", 112, 112, 112, 0);
        this.AddKey(0, 59, 10, "F2", "F2", 113, 113, 113, 0);
        this.AddKey(0, 60, 10, "F3", "F3", 114, 114, 114, 0);
        this.AddKey(0, 61, 10, "F4", "F4", 115, 115, 115, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 62, 10, "F5", "F5", 116, 116, 116, 0);
        this.AddKey(0, 63, 10, "F6", "F6", 117, 117, 117, 0);
        this.AddKey(0, 64, 10, "F7", "F7", 118, 118, 118, 0);
        this.AddKey(0, 65, 10, "F8", "F8", 119, 119, 119, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 66, 10, "F9", "F9", 120, 120, 120, 0);
        this.AddKey(0, 67, 10, "/res/f10.png", "/res/f10.png", 121, 121, 121, 0);
        this.AddKey(0, 68, 10, "/res/f11.png", "/res/f11.png", 122, 122, 122, 0);
        this.AddKey(0, 69, 10, "/res/f12.png", "/res/f12.png", 123, 123, 123, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 70, 30, "psc", "psc", 154, 154, 154, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 71, 20, "slk", "slk", 145, 145, 145, 0);
        this.AddKey(2, 72, 20, "pau", "brk", 3, 19, 19, 1);
        this.AddKey(0, 0, 1);
        this.AddKey(0, 53, 10, this._T("/res/fullsize.png"), this._T("/res/fullsize.png"), 192, 192, 192, 2);
        this.AddKey(0, 30, 10, "/res/jp1.png", "!", 49, 49, 49, 0);
        this.AddKey(0, 31, 10, "/res/jp2.png", "@", 50, 50, 50, 0);
        this.AddKey(0, 32, 10, "/res/jp3.png", "#", 51, 51, 51, 0);
        this.AddKey(0, 33, 10, "/res/jp4.png", "$", 52, 52, 52, 0);
        this.AddKey(0, 34, 10, "/res/jp5.png", "%", 53, 53, 53, 0);
        this.AddKey(0, 35, 10, "/res/jp6.png", "^", 54, 54, 54, 0);
        this.AddKey(0, 36, 10, "/res/jp7.png", "&", 55, 55, 55, 0);
        this.AddKey(0, 37, 10, "/res/jp8.png", "*", 56, 56, 56, 0);
        this.AddKey(0, 38, 10, "/res/jp9.png", "(", 57, 57, 57, 0);
        this.AddKey(0, 39, 10, "/res/jp0.png", ")", 48, 48, 48, 0);
        this.AddKey(0, 45, 10, "/res/jp-.png", "_", 45, 45, 45, 0);
        this.AddKey(0, 46, 10, "/res/jp^.png", "+", 61, 61, 61, 0);
        this.AddKey(0, 137, 10, "/res/jp__.png", "`", 61451, 61451, 61451, 2);
        this.AddKey(0, 42, 10, this._T("/res/left.png"), this._T("/res/left.png"), 8, 8, 8, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 73, 10, this._T("ins"), this._T("ins"), 155, 155, 155, 1);
        this.AddKey(0, 74, 10, this._T("/res/home.png"), this._T("/res/home.png"), 36, 36, 36, 1);
        this.AddKey(0, 75, 10, this._T("/res/pgup.png"), this._T("/res/pgup.png"), 33, 33, 33, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 83, 10, this._T("nlk"), this._T("nlk"), 144, 144, 144, 0);
        this.AddKey(0, 84, 10, this._T("/"), this._T("/"), 111, 111, 111, 1);
        this.AddKey(0, 85, 10, "*", "*", 106, 106, 106, 0);
        this.AddKey(0, 86, 10, "-", "-", 109, 109, 109, 0);
        this.AddKey(0, 0, 2);
        this.AddKey(0, 43, 20, this._T("/res/tab.png"), this._T("/res/tab.png"), 9, 9, 9, 0);
        this.AddKey(0, 20, 10, this._T("/res/jpq.png"), this._T("Q"), 81, 81, 81, 0);
        this.AddKey(0, 26, 10, this._T("/res/jpw.png"), this._T("W"), 87, 87, 87, 0);
        this.AddKey(0, 8, 10, this._T("/res/jpe.png"), this._T("E"), 69, 69, 69, 0);
        this.AddKey(0, 21, 10, this._T("/res/jpr.png"), this._T("R"), 82, 82, 82, 0);
        this.AddKey(0, 23, 10, this._T("/res/jpt.png"), this._T("T"), 84, 84, 84, 0);
        this.AddKey(0, 28, 10, this._T("/res/jpy.png"), this._T("Y"), 89, 89, 89, 0);
        this.AddKey(0, 24, 10, this._T("/res/jpu.png"), this._T("U"), 85, 85, 85, 0);
        this.AddKey(0, 12, 10, this._T("/res/jpi.png"), this._T("I"), 73, 73, 73, 0);
        this.AddKey(0, 18, 10, this._T("/res/jpo.png"), this._T("O"), 79, 79, 79, 0);
        this.AddKey(0, 19, 10, this._T("/res/jpp.png"), this._T("P"), 80, 80, 80, 0);
        this.AddKey(0, 47, 10, this._T("/res/jp[.png"), this._T("{"), 219, 219, 91, 2);
        this.AddKey(0, 48, 10, this._T("/res/jp].png"), this._T("}"), 221, 221, 93, 2);
        this.AddKey(0, 40, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), 10, 10, 10, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 76, 10, this._T("del"), this._T("del"), 127, 127, 127, 1);
        this.AddKey(0, 77, 10, this._T("/res/end.png"), this._T("/res/end.png"), 35, 35, 35, 1);
        this.AddKey(0, 78, 10, this._T("/res/pgdn.png"), this._T("/res/pgdn.png"), 34, 34, 34, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 95, 10, this._T("/res/home.png"), this._T("7"), 36, 103, 103, 0);
        this.AddKey(4, 96, 10, this._T("/res/up.png"), this._T("8"), 38, 104, 104, 0);
        this.AddKey(4, 97, 10, this._T("/res/pgup.png"), this._T("9"), 33, 105, 105, 0);
        this.AddKey(0, 87, 210, this._T("+"), this._T("+"), 107, 107, 107, 0);
        this.AddKey(0, 0, 3);
        this.AddKey(0, 57, 20, this._T("/res/caps1.png"), this._T("/res/caps1.png"), 20, 20, 20, 0);
        this.AddKey(0, 4, 10, "/res/jpa.png", "A", 65, 65, 65, 0);
        this.AddKey(0, 22, 10, "/res/jps.png", "S", 83, 83, 83, 0);
        this.AddKey(0, 7, 10, "/res/jpd.png", "D", 68, 68, 68, 0);
        this.AddKey(0, 9, 10, "/res/jpf.png", "F", 70, 70, 70, 0);
        this.AddKey(0, 10, 10, "/res/jpg.png", "G", 71, 71, 71, 0);
        this.AddKey(0, 11, 10, "/res/jph.png", "H", 72, 72, 72, 0);
        this.AddKey(0, 13, 10, "/res/jpj.png", "J", 74, 74, 74, 0);
        this.AddKey(0, 14, 10, "/res/jpk.png", "K", 75, 75, 75, 0);
        this.AddKey(0, 15, 10, "/res/jpl.png", "L", 76, 76, 76, 0);
        this.AddKey(0, 51, 10, "/res/jp;.png", ":", 186, 186, 59, 2);
        this.AddKey(0, 52, 10, "/res/jpcolon.png", "\"", 222, 222, 222, 2);
        this.AddKey(0, 49, 10, "/res/jp'.png", "]", 220, 220, 61449, 2);
        this.AddKey(0, this.TRANSPARENT, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 92, 10, this._T("/res/left.png"), this._T("4"), 37, 100, 100, 0);
        this.AddKey(4, 93, 10, this._T(" "), this._T("5"), 12, 101, 101, 0);
        this.AddKey(4, 94, 10, this._T("/res/right.png"), this._T("6"), 39, 102, 102, 0);
        this.AddKey(0, 0, 4);
        this.AddKey(0, 225, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(0, 29, 10, this._T("/res/jpz.png"), this._T("Z"), 90, 90, 90, 0);
        this.AddKey(0, 27, 10, this._T("/res/jpx.png"), this._T("X"), 88, 88, 88, 0);
        this.AddKey(0, 6, 10, this._T("/res/jpc.png"), this._T("C"), 67, 67, 67, 0);
        this.AddKey(0, 25, 10, this._T("/res/jpv.png"), this._T("V"), 86, 86, 86, 0);
        this.AddKey(0, 5, 10, this._T("/res/jpb.png"), this._T("B"), 66, 66, 66, 0);
        this.AddKey(0, 17, 10, this._T("/res/jpn.png"), this._T("N"), 78, 78, 78, 0);
        this.AddKey(0, 16, 10, this._T("/res/jpm.png"), this._T("M"), 77, 77, 77, 0);
        this.AddKey(0, 54, 10, this._T("/res/jpcomma.png"), this._T("<"), 188, 188, 44, 2);
        this.AddKey(0, 55, 10, this._T("/res/jpperiod.png"), this._T(">"), 190, 190, 46, 2);
        this.AddKey(0, 56, 10, this._T("/res/jpslash.png"), this._T("?"), 191, 191, 47, 2);
        this.AddKey(0, 135, 10, this._T("/res/jpbackslash.png"), this._T("_"), 61450, 61450, 61450, 2);
        this.AddKey(0, 225, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, 82, 10, this._T("\u2191"), this._T("\u2191"), 38, 38, 38, 1);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 89, 10, this._T("/res/end.png"), this._T("1"), 35, 97, 97, 0);
        this.AddKey(4, 90, 10, this._T("/res/down.png"), this._T("2"), 40, 98, 98, 0);
        this.AddKey(4, 91, 10, this._T("/res/pgdn.png"), this._T("3"), 34, 99, 99, 0);
        this.AddKey(0, 88, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), 10, 10, 10, 1);
        this.AddKey(0, 0, 5);
        this.AddKey(0, 224, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, 227, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 226, 20, this._T("alt"), this._T("alt"), 18, 18, 18, 0);
        this.AddKey(0, 139, 20, this._T("/res/jpnoconvert.png"), this._T("\u7121\u5909"), 29, 29, 29, 2);
        this.AddKey(0, 44, 30, this._T(" "), this._T(" "), 32, 32, 32, 0);
        this.AddKey(0, 138, 20, this._T("/res/jpconvert.png"), this._T("\u5909\u63db"), 28, 28, 28, 2);
        this.AddKey(0, 136, 20, this._T("/res/katakana.png"), this._T("/res/katakana.png"), 21, 21, 21, 2);
        this.AddKey(0, 101, 10, this._T("/res/menu.png"), this._T("/res/menu.png"), 18, 18, 525, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 80, 10, this._T("/res/left.png"), this._T("/res/left.png"), 37, 37, 37, 1);
        this.AddKey(0, 81, 10, this._T("/res/down.png"), this._T("/res/down.png"), 40, 40, 40, 1);
        this.AddKey(0, 79, 10, this._T("/res/right.png"), this._T("/res/right.png"), 39, 39, 39, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 98, 20, this._T("ins"), this._T("0"), 155, 96, 96, 0);
        this.AddKey(4, 99, 10, this._T("del"), this._T("."), 127, 110, 110, 0);
        this.CalcWidthHeight();
        return 0;
    }

    private int addGermany() {
        this.setLocale(Locale.GERMANY);
        this.getInputContext().selectInputMethod(Locale.GERMAN);
        if (RemoteVideo.screnMode) {
            this.parent.video.setInteranlFrameTitle(this.UIString[105]);
        } else {
            this.parent.setTitle(this.UIString[105]);
        }
        this.AddKey(0, 0, 0, "", "", 0, 0, 0, 0);
        this.AddKey(0, 41, 10, "esc", "esc", 27, 27, 27, 0);
        this.AddKey(0, this.EMPTY, 10, "", "", 0, 0, 0, 0);
        this.AddKey(0, 58, 10, "F1", "F1", 112, 112, 112, 0);
        this.AddKey(0, 59, 10, "F2", "F2", 113, 113, 113, 0);
        this.AddKey(0, 60, 10, "F3", "F3", 114, 114, 114, 0);
        this.AddKey(0, 61, 10, "F4", "F4", 115, 115, 115, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 62, 10, "F5", "F5", 116, 116, 116, 0);
        this.AddKey(0, 63, 10, "F6", "F6", 117, 117, 117, 0);
        this.AddKey(0, 64, 10, "F7", "F7", 118, 118, 118, 0);
        this.AddKey(0, 65, 10, "F8", "F8", 119, 119, 119, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 66, 10, "F9", "F9", 120, 120, 120, 0);
        this.AddKey(0, 67, 10, "/res/f10.png", "/res/f10.png", 121, 121, 121, 0);
        this.AddKey(0, 68, 10, "/res/f11.png", "/res/f11.png", 122, 122, 122, 0);
        this.AddKey(0, 69, 10, "/res/f12.png", "/res/f12.png", 123, 123, 123, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 70, 30, "psc", "psc", 154, 154, 154, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 71, 20, "slk", "slk", 145, 145, 145, 0);
        this.AddKey(2, 72, 20, "pau", "brk", 3, 19, 19, 1);
        this.AddKey(0, 0, 1);
        this.AddKey(1, 53, 10, "^", "\u00b0", 130, 130, 192, 0);
        this.AddKey(1, 30, 10, "1", "!", 49, 49, 49, 0);
        this.AddKey(1, 31, 10, "2", "\"", this._T("\u00b2"), 50, 50, 50, 0);
        this.AddKey(1, 32, 10, "3", "\u00a7", this._T("\u00b3"), 51, 51, 51, 0);
        this.AddKey(1, 33, 10, "4", "$", 52, 52, 52, 0);
        this.AddKey(1, 34, 10, "5", "%", 53, 53, 53, 0);
        this.AddKey(1, 35, 10, "6", "&", 54, 54, 54, 0);
        this.AddKey(1, 36, 10, this._T("7"), this._T("/"), this._T("{"), 55, 55, 55, 0);
        this.AddKey(1, 37, 10, this._T("8"), this._T("("), this._T("["), 56, 56, 56, 0);
        this.AddKey(1, 38, 10, this._T("9"), this._T(")"), this._T("]"), 57, 57, 57, 0);
        this.AddKey(1, 39, 10, this._T("0"), this._T("="), this._T("}"), 48, 48, 48, 0);
        this.AddKey(1, 45, 10, this._T("\u00df"), this._T("?"), this._T("\\"), 189, 189, 45, 0);
        this.AddKey(1, 46, 10, "\u00b8", "`", 187, 187, 61, 0);
        this.AddKey(2, 42, 20, this._T("/res/bs.png"), this._T("/res/bs.png"), " ", 8, 8, 8, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 73, 10, this._T("ins"), this._T("ins"), 155, 155, 155, 0);
        this.AddKey(0, 74, 10, this._T("/res/home.png"), this._T("/res/home.png"), 36, 36, 36, 1);
        this.AddKey(0, 75, 10, this._T("/res/pgup.png"), this._T("/res/pgup.png"), 33, 33, 33, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 83, 10, this._T("nlk"), this._T("nlk"), 144, 144, 144, 0);
        this.AddKey(0, 84, 10, this._T("/"), this._T("/"), 111, 111, 111, 1);
        this.AddKey(0, 85, 10, "*", "*", 106, 106, 106, 0);
        this.AddKey(0, 86, 10, "-", "-", 109, 109, 109, 0);
        this.AddKey(0, 0, 2);
        this.AddKey(0, 43, 20, this._T("/res/tab.png"), this._T("/res/tab.png"), 9, 9, 9, 0);
        this.AddKey(2, 20, 10, this._T("q"), this._T("Q"), this._T("@"), 81, 81, 81, 0);
        this.AddKey(2, 26, 10, this._T("w"), this._T("W"), 87, 87, 87, 0);
        this.AddKey(2, 8, 10, this._T("e"), this._T("E"), this._T("\ufffd"), 69, 69, 69, 0);
        this.AddKey(2, 21, 10, this._T("r"), this._T("R"), 82, 82, 82, 0);
        this.AddKey(2, 23, 10, this._T("t"), this._T("T"), 84, 84, 84, 0);
        this.AddKey(2, 28, 10, this._T("z"), this._T("Z"), 89, 89, 89, 0);
        this.AddKey(2, 24, 10, this._T("u"), this._T("U"), 85, 85, 85, 0);
        this.AddKey(2, 12, 10, this._T("i"), this._T("I"), 73, 73, 73, 0);
        this.AddKey(2, 18, 10, this._T("o"), this._T("O"), 79, 79, 79, 0);
        this.AddKey(2, 19, 10, this._T("p"), this._T("P"), 80, 80, 80, 0);
        this.AddKey(2, 47, 10, this._T("\u00fc"), this._T("\u00fc"), 219, 219, 91, 0);
        this.AddKey(1, 48, 10, this._T("+"), this._T("*"), this._T("~"), 221, 221, 93, 0);
        this.AddKey(2, 40, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), "", 10, 10, 10, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 76, 10, this._T("del"), this._T("del"), 127, 127, 127, 1);
        this.AddKey(0, 77, 10, this._T("/res/end.png"), this._T("/res/end.png"), 35, 35, 35, 1);
        this.AddKey(0, 78, 10, this._T("/res/pgdn.png"), this._T("/res/pgdn.png"), 34, 34, 34, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 95, 10, this._T("/res/home.png"), this._T("7"), 36, 103, 103, 0);
        this.AddKey(4, 96, 10, this._T("/res/up.png"), this._T("8"), 38, 104, 104, 0);
        this.AddKey(4, 97, 10, this._T("/res/pgup.png"), this._T("9"), 33, 105, 105, 0);
        this.AddKey(0, 87, 210, this._T("+"), this._T("+"), 107, 107, 107, 0);
        this.AddKey(0, 0, 3);
        this.AddKey(0, 57, 20, this._T("/res/caps1.png"), this._T("/res/caps1.png"), "/res/caps1.png", 20, 20, 20, 0);
        this.AddKey(2, 4, 10, "a", "A", 65, 65, 65, 0);
        this.AddKey(2, 22, 10, "s", "S", 83, 83, 83, 0);
        this.AddKey(2, 7, 10, "d", "D", 68, 68, 68, 0);
        this.AddKey(2, 9, 10, "f", "F", 70, 70, 70, 0);
        this.AddKey(2, 10, 10, "g", "G", 71, 71, 71, 0);
        this.AddKey(2, 11, 10, "h", "H", 72, 72, 72, 0);
        this.AddKey(2, 13, 10, "j", "J", 74, 74, 74, 0);
        this.AddKey(2, 14, 10, "k", "K", 75, 75, 75, 0);
        this.AddKey(2, 15, 10, "l", "L", 76, 76, 76, 0);
        this.AddKey(2, 51, 10, "\u00f6", "\u00f6", 186, 186, 59, 0);
        this.AddKey(2, 52, 10, "\u00c4", "\u00c4", 222, 222, 222, 0);
        this.AddKey(1, 50, 10, "#", "'", 220, 220, 92, 0);
        this.AddKey(0, this.TRANSPARENT, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 92, 10, this._T("\u2190"), this._T("4"), 37, 100, 100, 0);
        this.AddKey(4, 93, 10, this._T(" "), this._T("5"), 12, 101, 101, 0);
        this.AddKey(4, 94, 10, this._T("\u2192"), this._T("6"), 39, 102, 102, 0);
        this.AddKey(0, 0, 4);
        this.AddKey(0, 225, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(1, 100, 10, this._T("<"), this._T(">"), this._T("|"), 153, 153, 61448, 0);
        this.AddKey(2, 29, 10, this._T("y"), this._T("Y"), 89, 89, 90, 0);
        this.AddKey(2, 27, 10, this._T("x"), this._T("X"), 88, 88, 88, 0);
        this.AddKey(2, 6, 10, this._T("c"), this._T("C"), 67, 67, 67, 0);
        this.AddKey(2, 25, 10, this._T("v"), this._T("V"), 86, 86, 86, 0);
        this.AddKey(2, 5, 10, this._T("b"), this._T("B"), 66, 66, 66, 0);
        this.AddKey(2, 17, 10, this._T("n"), this._T("N"), 78, 78, 78, 0);
        this.AddKey(2, 16, 10, this._T("m"), this._T("M"), this._T("\u00b5"), 77, 77, 77, 0);
        this.AddKey(1, 54, 10, this._T(","), this._T(";"), 188, 188, 44, 0);
        this.AddKey(1, 55, 10, this._T("."), this._T(":"), 190, 190, 46, 0);
        this.AddKey(1, 56, 10, this._T("-"), this._T("_"), 191, 191, 47, 0);
        this.AddKey(0, 229, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, 82, 10, this._T("\u2191"), this._T("\u2191"), 38, 38, 38, 1);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 89, 10, this._T("/res/end.png"), this._T("1"), 35, 97, 97, 0);
        this.AddKey(4, 90, 10, this._T("/res/down.png"), this._T("2"), 40, 98, 98, 0);
        this.AddKey(4, 91, 10, this._T("/res/pgdn.png"), this._T("3"), 34, 99, 99, 0);
        this.AddKey(2, 88, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), " ", 10, 10, 10, 1);
        this.AddKey(0, 0, 5);
        this.AddKey(0, 224, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, 227, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 226, 20, this._T("alt"), this._T("alt"), 18, 18, 18, 0);
        this.AddKey(0, 44, 40, this._T(" "), this._T(" "), 32, 32, 32, 0);
        this.AddKey(0, 230, 20, this._T("alt gr"), this._T("alt gr"), "alt gr", 65406, 65406, 65406, 0);
        this.AddKey(0, 231, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 1);
        this.AddKey(0, 101, 10, this._T("/res/menu.png"), this._T("/res/menu.png"), 525, 525, 525, 1);
        this.AddKey(0, 228, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 80, 10, this._T("/res/left.png"), this._T("/res/left.png"), 37, 37, 37, 1);
        this.AddKey(0, 81, 10, this._T("/res/down.png"), this._T("/res/down.png"), 40, 40, 40, 0);
        this.AddKey(0, 79, 10, this._T("/res/right.png"), this._T("/res/right.png"), 39, 39, 39, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 98, 20, this._T("ins"), this._T("0"), 155, 96, 96, 0);
        this.AddKey(4, 99, 10, this._T("del"), this._T("."), 127, 110, 110, 0);
        this.CalcWidthHeight();
        return 0;
    }

    private int addFranch() {
        this.setLocale(Locale.FRENCH);
        this.getInputContext().selectInputMethod(Locale.FRENCH);
        if (RemoteVideo.screnMode) {
            this.parent.video.setInteranlFrameTitle(this.UIString[106]);
        } else {
            this.parent.setTitle(this.UIString[106]);
        }
        this.AddKey(0, 0, 0, "", "", 0, 0, 0, 0);
        this.AddKey(0, 41, 10, "esc", "esc", 27, 27, 27, 0);
        this.AddKey(0, this.EMPTY, 10, "", "", 0, 0, 0, 0);
        this.AddKey(0, 58, 10, "F1", "F1", 112, 112, 112, 0);
        this.AddKey(0, 59, 10, "F2", "F2", 113, 113, 113, 0);
        this.AddKey(0, 60, 10, "F3", "F3", 114, 114, 114, 0);
        this.AddKey(0, 61, 10, "F4", "F4", 115, 115, 115, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 62, 10, "F5", "F5", 116, 116, 116, 0);
        this.AddKey(0, 63, 10, "F6", "F6", 117, 117, 117, 0);
        this.AddKey(0, 64, 10, "F7", "F7", 118, 118, 118, 0);
        this.AddKey(0, 65, 10, "F8", "F8", 119, 119, 119, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 66, 10, "F9", "F9", 120, 120, 120, 0);
        this.AddKey(0, 67, 10, "/res/f10.png", "/res/f10.png", 121, 121, 121, 0);
        this.AddKey(0, 68, 10, "/res/f11.png", "/res/f11.png", 122, 122, 122, 0);
        this.AddKey(0, 69, 10, "/res/f12.png", "/res/f12.png", 123, 123, 123, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 70, 30, "psc", "psc", 154, 154, 154, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 71, 20, "slk", "slk", 145, 145, 145, 0);
        this.AddKey(2, 72, 20, "pau", "brk", 3, 19, 19, 1);
        this.AddKey(0, 0, 1);
        this.AddKey(0, 53, 10, "\u00b2", "\u00b2", 192, 192, 192, 0);
        this.AddKey(1, 30, 10, "&", "1", 49, 49, 49, 0);
        this.AddKey(1, 31, 10, this._T("\u00e9"), this._T("2"), this._T("~"), 50, 50, 50, 0);
        this.AddKey(1, 32, 10, this._T("\""), this._T("3"), this._T("#"), 51, 51, 51, 0);
        this.AddKey(1, 33, 10, this._T("'"), this._T("4"), this._T("{"), 52, 52, 52, 0);
        this.AddKey(1, 34, 10, this._T("("), this._T("5"), this._T("["), 53, 53, 53, 0);
        this.AddKey(1, 35, 10, this._T("-"), this._T("6"), this._T("|"), 54, 54, 54, 0);
        this.AddKey(1, 36, 10, this._T("\u00e8"), this._T("7"), this._T("`"), 55, 55, 55, 0);
        this.AddKey(1, 37, 10, this._T("_"), this._T("8"), this._T("\\"), 56, 56, 56, 0);
        this.AddKey(1, 38, 10, this._T("\u00e7"), this._T("9"), this._T("^"), 57, 57, 57, 0);
        this.AddKey(1, 39, 10, this._T("\u00e0"), this._T("0"), this._T("@"), 48, 48, 48, 0);
        this.AddKey(1, 45, 10, this._T(")"), this._T("\u00b0"), this._T("]"), 189, 189, 45, 0);
        this.AddKey(1, 46, 10, this._T("="), this._T("+"), this._T("}"), 187, 187, 61, 0);
        this.AddKey(2, 42, 20, this._T("/res/bs.png"), this._T("/res/bs.png"), " ", 8, 8, 8, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 73, 10, this._T("ins"), this._T("ins"), 155, 155, 155, 1);
        this.AddKey(0, 74, 10, this._T("/res/home.png"), this._T("/res/home.png"), 36, 36, 36, 1);
        this.AddKey(0, 75, 10, this._T("/res/pgup.png"), this._T("/res/pgup.png"), 33, 33, 33, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 83, 10, this._T("nlk"), this._T("nlk"), 144, 144, 144, 0);
        this.AddKey(0, 84, 10, this._T("/"), this._T("/"), 111, 111, 111, 1);
        this.AddKey(0, 85, 10, "*", "*", 106, 106, 106, 0);
        this.AddKey(0, 86, 10, "-", "-", 109, 109, 109, 0);
        this.AddKey(0, 0, 2);
        this.AddKey(0, 43, 20, this._T("/res/tab.png"), this._T("/res/tab.png"), 9, 9, 9, 0);
        this.AddKey(2, 20, 10, this._T("a"), this._T("A"), 81, 81, 81, 0);
        this.AddKey(2, 26, 10, this._T("z"), this._T("Z"), 87, 87, 87, 0);
        this.AddKey(2, 8, 10, this._T("e"), this._T("E"), this._T("\u20ac"), 69, 69, 69, 0);
        this.AddKey(2, 21, 10, this._T("r"), this._T("R"), 82, 82, 82, 0);
        this.AddKey(2, 23, 10, this._T("t"), this._T("T"), 84, 84, 84, 0);
        this.AddKey(2, 28, 10, this._T("y"), this._T("Y"), 89, 89, 89, 0);
        this.AddKey(2, 24, 10, this._T("u"), this._T("U"), 85, 85, 85, 0);
        this.AddKey(2, 12, 10, this._T("i"), this._T("I"), 73, 73, 73, 0);
        this.AddKey(2, 18, 10, this._T("o"), this._T("O"), 79, 79, 79, 0);
        this.AddKey(2, 19, 10, this._T("p"), this._T("P"), 80, 80, 80, 0);
        this.AddKey(1, 47, 10, this._T("^"), this._T("\u00a8"), 219, 219, 91, 0);
        this.AddKey(1, 48, 10, this._T("$"), this._T("\u00a3"), 221, 221, 93, 0);
        this.AddKey(2, 40, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), " ", 10, 10, 10, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 76, 10, this._T("del"), this._T("del"), 127, 127, 127, 1);
        this.AddKey(0, 77, 10, this._T("/res/end.png"), this._T("/res/end.png"), 35, 35, 35, 1);
        this.AddKey(0, 78, 10, this._T("/res/pgdn.png"), this._T("/res/pgdn.png"), 34, 34, 34, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 95, 10, this._T("/res/home.png"), this._T("7"), 36, 103, 103, 0);
        this.AddKey(4, 96, 10, this._T("/res/up.png"), this._T("8"), 38, 104, 104, 0);
        this.AddKey(4, 97, 10, this._T("/res/pgup.png"), this._T("9"), 33, 105, 105, 0);
        this.AddKey(0, 87, 210, this._T("+"), this._T("+"), 107, 107, 107, 0);
        this.AddKey(0, 0, 3);
        this.AddKey(0, 57, 20, this._T("/res/caps1.png"), this._T("/res/caps1.png"), "/res/caps1.png", 20, 20, 20, 0);
        this.AddKey(2, 4, 10, "q", "Q", 65, 65, 65, 0);
        this.AddKey(2, 22, 10, "s", "S", 83, 83, 83, 0);
        this.AddKey(2, 7, 10, "d", "D", 68, 68, 68, 0);
        this.AddKey(2, 9, 10, "f", "F", 70, 70, 70, 0);
        this.AddKey(2, 10, 10, "g", "G", 71, 71, 71, 0);
        this.AddKey(2, 11, 10, "h", "H", 72, 72, 72, 0);
        this.AddKey(2, 13, 10, "j", "J", 74, 74, 74, 0);
        this.AddKey(2, 14, 10, "k", "K", 75, 75, 75, 0);
        this.AddKey(2, 15, 10, "l", "L", 76, 76, 76, 0);
        this.AddKey(2, 51, 10, "m", "M", 186, 186, 59, 0);
        this.AddKey(1, 52, 10, "\u00f9", "%", 222, 222, 222, 0);
        this.AddKey(1, 50, 10, "*", "\u00b5", 220, 220, 92, 0);
        this.AddKey(0, this.TRANSPARENT, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 92, 10, this._T("\u2190"), this._T("4"), 37, 100, 100, 0);
        this.AddKey(4, 93, 10, this._T(" "), this._T("5"), 12, 101, 101, 0);
        this.AddKey(4, 94, 10, this._T("\u2192"), this._T("6"), 39, 102, 102, 0);
        this.AddKey(0, 0, 4);
        this.AddKey(0, 225, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(1, 100, 10, this._T("<"), this._T(">"), 153, 153, 61448, 0);
        this.AddKey(2, 29, 10, this._T("w"), this._T("W"), 90, 90, 90, 0);
        this.AddKey(2, 27, 10, this._T("x"), this._T("X"), 88, 88, 88, 0);
        this.AddKey(2, 6, 10, this._T("c"), this._T("C"), 67, 67, 67, 0);
        this.AddKey(2, 25, 10, this._T("v"), this._T("V"), 86, 86, 86, 0);
        this.AddKey(2, 5, 10, this._T("b"), this._T("B"), 66, 66, 66, 0);
        this.AddKey(2, 17, 10, this._T("n"), this._T("N"), 78, 78, 78, 0);
        this.AddKey(1, 16, 10, this._T(","), this._T("?"), 77, 77, 77, 0);
        this.AddKey(1, 54, 10, this._T(";"), this._T("."), 188, 188, 44, 0);
        this.AddKey(1, 55, 10, this._T(":"), this._T("/"), 190, 190, 46, 0);
        this.AddKey(1, 56, 10, this._T("!"), this._T("\ufffd"), 191, 191, 47, 0);
        this.AddKey(0, 229, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, 82, 10, this._T("/res/up.png"), this._T("/res/up.png"), 38, 38, 38, 1);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 89, 10, this._T("/res/end.png"), this._T("1"), 35, 97, 97, 0);
        this.AddKey(4, 90, 10, this._T("/res/down.png"), this._T("2"), 40, 98, 98, 0);
        this.AddKey(4, 91, 10, this._T("/res/pgdn.png"), this._T("3"), 34, 99, 99, 0);
        this.AddKey(2, 88, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), " ", 10, 10, 10, 1);
        this.AddKey(0, 0, 5);
        this.AddKey(0, 224, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, 227, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 226, 20, this._T("alt"), this._T("alt"), 18, 18, 18, 0);
        this.AddKey(0, 44, 40, this._T(" "), this._T(" "), 32, 32, 32, 0);
        this.AddKey(0, 230, 20, this._T("alt gr"), this._T("alt gr"), "alt gr", 65406, 65406, 65406, 0);
        this.AddKey(0, 231, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 1);
        this.AddKey(0, 101, 10, this._T("/res/menu.png"), this._T("/res/menu.png"), 525, 525, 525, 1);
        this.AddKey(0, 228, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 80, 10, this._T("/res/left.png"), this._T("/res/left.png"), 37, 37, 37, 1);
        this.AddKey(0, 81, 10, this._T("/res/down.png"), this._T("/res/down.png"), 40, 40, 40, 1);
        this.AddKey(0, 79, 10, this._T("/res/right.png"), this._T("/res/right.png"), 39, 39, 39, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 98, 20, this._T("ins"), this._T("0"), 155, 96, 96, 0);
        this.AddKey(4, 99, 10, this._T("del"), this._T("."), 127, 110, 110, 0);
        this.CalcWidthHeight();
        return 0;
    }

    private int addSpanish() {
        this.setLocale(Locale.GERMAN);
        this.getInputContext().selectInputMethod(Locale.GERMAN);
        if (RemoteVideo.screnMode) {
            this.parent.video.setInteranlFrameTitle(this.UIString[107]);
        } else {
            this.parent.setTitle(this.UIString[107]);
        }
        this.AddKey(0, 0, 0, "", "", 0, 0, 0, 0);
        this.AddKey(0, 41, 10, "esc", "esc", 27, 27, 27, 0);
        this.AddKey(0, this.EMPTY, 10, "", "", 0, 0, 0, 0);
        this.AddKey(0, 58, 10, "F1", "F1", 112, 112, 112, 0);
        this.AddKey(0, 59, 10, "F2", "F2", 113, 113, 113, 0);
        this.AddKey(0, 60, 10, "F3", "F3", 114, 114, 114, 0);
        this.AddKey(0, 61, 10, "F4", "F4", 115, 115, 115, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 62, 10, "F5", "F5", 116, 116, 116, 0);
        this.AddKey(0, 63, 10, "F6", "F6", 117, 117, 117, 0);
        this.AddKey(0, 64, 10, "F7", "F7", 118, 118, 118, 0);
        this.AddKey(0, 65, 10, "F8", "F8", 119, 119, 119, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 66, 10, "F9", "F9", 120, 120, 120, 0);
        this.AddKey(0, 67, 10, "/res/f10.png", "/res/f10.png", 121, 121, 121, 0);
        this.AddKey(0, 68, 10, "/res/f11.png", "/res/f11.png", 122, 122, 122, 0);
        this.AddKey(0, 69, 10, "/res/f12.png", "/res/f12.png", 123, 123, 123, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 70, 30, "psc", "psc", 154, 154, 154, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 71, 20, "slk", "slk", 145, 145, 145, 0);
        this.AddKey(2, 72, 20, "pau", "brk", 3, 19, 19, 1);
        this.AddKey(0, 0, 1);
        this.AddKey(1, 53, 10, this._T("\u00ba"), this._T("\u00aa"), this._T("\\"), 0, 0, 192, 0);
        this.AddKey(1, 30, 10, this._T("1"), this._T("!"), this._T("|"), 49, 49, 49, 0);
        this.AddKey(1, 31, 10, this._T("2"), this._T("\""), this._T("@"), 50, 50, 50, 0);
        this.AddKey(1, 32, 10, this._T("3"), this._T("\ufffd"), this._T("#"), 51, 51, 51, 0);
        this.AddKey(1, 33, 10, this._T("4"), this._T("$"), this._T("~"), 52, 52, 52, 0);
        this.AddKey(1, 34, 10, this._T("5"), this._T("%"), this._T("\ufffd"), 53, 53, 53, 0);
        this.AddKey(1, 35, 10, this._T("6"), this._T("&"), this._T("\ufffd"), 54, 54, 54, 0);
        this.AddKey(1, 36, 10, "7", "/", 55, 55, 55, 0);
        this.AddKey(1, 37, 10, "8", "(", 56, 56, 56, 0);
        this.AddKey(1, 38, 10, "9", ")", 57, 57, 57, 0);
        this.AddKey(1, 39, 10, "0", "=", 48, 48, 48, 0);
        this.AddKey(1, 45, 10, "'", "?", 189, 189, 45, 0);
        this.AddKey(1, 46, 10, "\u00a1", "\u00bf", 187, 187, 61, 0);
        this.AddKey(2, 42, 20, this._T("/res/bs.png"), this._T("/res/bs.png"), " ", 8, 8, 8, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 73, 10, this._T("ins"), this._T("ins"), 155, 155, 155, 1);
        this.AddKey(0, 74, 10, this._T("/res/home.png"), this._T("/res/home.png"), 36, 36, 36, 1);
        this.AddKey(0, 75, 10, this._T("/res/pgup.png"), this._T("/res/pgup.png"), 33, 33, 33, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 83, 10, this._T("nlk"), this._T("nlk"), 144, 144, 144, 0);
        this.AddKey(0, 84, 10, this._T("/"), this._T("/"), 111, 111, 111, 0);
        this.AddKey(0, 85, 10, "*", "*", 106, 106, 106, 0);
        this.AddKey(0, 86, 10, "-", "-", 109, 109, 109, 0);
        this.AddKey(0, 0, 2);
        this.AddKey(0, 43, 20, this._T("/res/tab.png"), this._T("/res/tab.png"), 9, 9, 9, 0);
        this.AddKey(2, 20, 10, this._T("q"), this._T("Q"), 81, 81, 81, 0);
        this.AddKey(2, 26, 10, this._T("w"), this._T("W"), 87, 87, 87, 0);
        this.AddKey(2, 8, 10, this._T("e"), this._T("E"), this._T("\ufffd"), 69, 69, 69, 0);
        this.AddKey(2, 21, 10, this._T("r"), this._T("R"), 82, 82, 82, 0);
        this.AddKey(2, 23, 10, this._T("t"), this._T("T"), 84, 84, 84, 0);
        this.AddKey(2, 28, 10, this._T("y"), this._T("Y"), 89, 89, 89, 0);
        this.AddKey(2, 24, 10, this._T("u"), this._T("U"), 85, 85, 85, 0);
        this.AddKey(2, 12, 10, this._T("i"), this._T("I"), 73, 73, 73, 0);
        this.AddKey(2, 18, 10, this._T("o"), this._T("O"), 79, 79, 79, 0);
        this.AddKey(2, 19, 10, this._T("p"), this._T("P"), 80, 80, 80, 0);
        this.AddKey(1, 47, 10, this._T("`"), this._T("^"), this._T("["), 219, 219, 91, 0);
        this.AddKey(1, 48, 10, this._T("+"), this._T("*"), this._T("]"), 221, 221, 93, 0);
        this.AddKey(2, 40, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), " ", 10, 10, 10, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 76, 10, this._T("del"), this._T("del"), 127, 127, 127, 1);
        this.AddKey(0, 77, 10, this._T("/res/end.png"), this._T("/res/end.png"), 35, 35, 35, 1);
        this.AddKey(0, 78, 10, this._T("/res/pgdn.png"), this._T("/res/pgdn.png"), 34, 34, 34, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 95, 10, this._T("/res/home.png"), this._T("7"), 36, 103, 103, 0);
        this.AddKey(4, 96, 10, this._T("/res/up.png"), this._T("8"), 38, 104, 104, 0);
        this.AddKey(4, 97, 10, this._T("/res/pgup.png"), this._T("9"), 33, 105, 105, 0);
        this.AddKey(0, 87, 210, this._T("+"), this._T("+"), 107, 107, 107, 0);
        this.AddKey(0, 0, 3);
        this.AddKey(0, 57, 20, this._T("/res/caps1.png"), this._T("/res/caps1.png"), "/res/caps1.png", 20, 20, 20, 0);
        this.AddKey(2, 4, 10, "a", "A", 65, 65, 65, 0);
        this.AddKey(2, 22, 10, "s", "S", 83, 83, 83, 0);
        this.AddKey(2, 7, 10, "d", "D", 68, 68, 68, 0);
        this.AddKey(2, 9, 10, "f", "F", 70, 70, 70, 0);
        this.AddKey(2, 10, 10, "g", "G", 71, 71, 71, 0);
        this.AddKey(2, 11, 10, "h", "H", 72, 72, 72, 0);
        this.AddKey(2, 13, 10, "j", "J", 74, 74, 74, 0);
        this.AddKey(2, 14, 10, "k", "K", 75, 75, 75, 0);
        this.AddKey(2, 15, 10, "l", "L", 76, 76, 76, 0);
        this.AddKey(2, 51, 10, "\u00d1", "\u00d1", 186, 186, 59, 0);
        this.AddKey(1, 52, 10, this._T(","), this._T("\u00a8"), this._T("{"), 222, 222, 222, 0);
        this.AddKey(2, 50, 10, this._T("\u00c7"), this._T("\u00c7"), this._T("}"), 220, 220, 61449, 0);
        this.AddKey(0, this.TRANSPARENT, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 92, 10, this._T("/res/up.png"), this._T("4"), 37, 100, 100, 0);
        this.AddKey(4, 93, 10, this._T(" "), this._T("5"), 12, 101, 101, 0);
        this.AddKey(4, 94, 10, this._T("/res/right.png"), this._T("6"), 39, 102, 102, 0);
        this.AddKey(0, 0, 4);
        this.AddKey(0, 225, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(1, 100, 10, this._T("<"), this._T(">"), 153, 153, 61448, 0);
        this.AddKey(2, 29, 10, this._T("z"), this._T("Z"), 90, 90, 90, 0);
        this.AddKey(2, 27, 10, this._T("x"), this._T("X"), 88, 88, 88, 0);
        this.AddKey(2, 6, 10, this._T("c"), this._T("C"), 67, 67, 67, 0);
        this.AddKey(2, 25, 10, this._T("v"), this._T("V"), 86, 86, 86, 0);
        this.AddKey(2, 5, 10, this._T("b"), this._T("B"), 66, 66, 66, 0);
        this.AddKey(2, 17, 10, this._T("n"), this._T("N"), 78, 78, 78, 0);
        this.AddKey(2, 16, 10, this._T("m"), this._T("M"), 77, 77, 77, 0);
        this.AddKey(1, 54, 10, this._T(","), this._T(";"), 188, 188, 44, 0);
        this.AddKey(1, 55, 10, this._T("."), this._T(":"), 190, 190, 46, 0);
        this.AddKey(1, 56, 10, this._T("-"), this._T("_"), 191, 191, 47, 0);
        this.AddKey(0, 229, 20, this._T("/res/shift.png"), this._T("/res/shift2.png"), 16, 16, 16, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, 82, 10, this._T("/res/up.png"), this._T("/res/up.png"), 38, 38, 38, 0);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 89, 10, this._T("/res/end.png"), this._T("1"), 35, 97, 97, 0);
        this.AddKey(4, 90, 10, this._T("/res/down.png"), this._T("2"), 40, 98, 98, 0);
        this.AddKey(4, 91, 10, this._T("/res/pgdn.png"), this._T("3"), 34, 99, 99, 0);
        this.AddKey(2, 88, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), " ", 10, 10, 10, 1);
        this.AddKey(0, 0, 5);
        this.AddKey(0, 224, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, 227, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 226, 20, this._T("alt"), this._T("alt"), "alt gr", 18, 18, 18, 0);
        this.AddKey(0, 44, 40, this._T(" "), this._T(" "), 32, 32, 32, 0);
        this.AddKey(0, 230, 20, this._T("alt gr"), this._T("alt gr"), 65406, 65406, 65406, 0);
        this.AddKey(0, 231, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 1);
        this.AddKey(0, 101, 10, this._T("/res/menu.png"), this._T("/res/menu.png"), 525, 525, 525, 1);
        this.AddKey(0, 228, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 80, 10, this._T("/res/left.png"), this._T("/res/left.png"), 37, 37, 37, 1);
        this.AddKey(0, 81, 10, this._T("/res/down.png"), this._T("/res/down.png"), 40, 40, 40, 1);
        this.AddKey(0, 79, 10, this._T("/res/right.png"), this._T("/res/right.png"), 39, 39, 39, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 98, 20, this._T("ins"), this._T("0"), 155, 96, 96, 0);
        this.AddKey(4, 99, 10, this._T("del"), this._T("."), 127, 110, 110, 0);
        this.CalcWidthHeight();
        return 0;
    }

    private int addKorean() {
        this.setLocale(Locale.KOREAN);
        this.getInputContext().selectInputMethod(Locale.KOREAN);
        if (RemoteVideo.screnMode) {
            this.parent.video.setInteranlFrameTitle(this.UIString[108]);
        } else {
            this.parent.setTitle(this.UIString[108]);
        }
        this.AddKey(0, 0, 0, "", "", 0, 0, 0, 0);
        this.AddKey(0, 41, 10, "esc", "esc", 27, 27, 27, 0);
        this.AddKey(0, this.EMPTY, 10, "", "", 0, 0, 0, 0);
        this.AddKey(0, 58, 10, "F1", "F1", 112, 112, 112, 0);
        this.AddKey(0, 59, 10, "F2", "F2", 113, 113, 113, 0);
        this.AddKey(0, 60, 10, "F3", "F3", 114, 114, 114, 0);
        this.AddKey(0, 61, 10, "F4", "F4", 115, 115, 115, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 62, 10, "F5", "F5", 116, 116, 116, 0);
        this.AddKey(0, 63, 10, "F6", "F6", 117, 117, 117, 0);
        this.AddKey(0, 64, 10, "F7", "F7", 118, 118, 118, 0);
        this.AddKey(0, 65, 10, "F8", "F8", 119, 119, 119, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 66, 10, "F9", "F9", 120, 120, 120, 0);
        this.AddKey(0, 67, 10, "/res/f10.png", "/res/f10.png", 121, 121, 121, 0);
        this.AddKey(0, 68, 10, "/res/f11.png", "/res/f11.png", 122, 122, 122, 0);
        this.AddKey(0, 69, 10, "/res/f12.png", "/res/f12.png", 123, 123, 123, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 70, 30, "psc", "psc", 154, 154, 154, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 71, 20, "slk", "slk", 145, 145, 145, 0);
        this.AddKey(2, 72, 20, "pau", "brk", 3, 19, 19, 1);
        this.AddKey(0, 0, 1);
        this.AddKey(1, 53, 10, "`", "~", 192, 192, 192, 0);
        this.AddKey(1, 30, 10, "1", "!", 49, 49, 49, 0);
        this.AddKey(1, 31, 10, "2", "@", 50, 50, 50, 0);
        this.AddKey(1, 32, 10, "3", "#", 51, 51, 51, 0);
        this.AddKey(1, 33, 10, "4", "$", 52, 52, 52, 0);
        this.AddKey(1, 34, 10, "5", "%", 53, 53, 53, 0);
        this.AddKey(1, 35, 10, "6", "^", 54, 54, 54, 0);
        this.AddKey(1, 36, 10, "7", "&", 55, 55, 55, 0);
        this.AddKey(1, 37, 10, "8", "*", 56, 56, 56, 0);
        this.AddKey(1, 38, 10, "9", "(", 57, 57, 57, 0);
        this.AddKey(1, 39, 10, "0", ")", 48, 48, 48, 0);
        this.AddKey(1, 45, 10, "-", "_", 45, 45, 45, 0);
        this.AddKey(1, 46, 10, "=", "+", 61, 61, 61, 0);
        this.AddKey(1, 49, 10, this._T("\\"), this._T("|"), 220, 220, 92, 0);
        this.AddKey(0, 42, 10, this._T("/res/bs.png"), this._T("/res/bs.png"), 8, 8, 8, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 73, 10, this._T("ins"), this._T("ins"), 155, 155, 155, 1);
        this.AddKey(0, 74, 10, this._T("/res/home.png"), this._T("/res/home.png"), 36, 36, 36, 1);
        this.AddKey(0, 75, 10, this._T("/res/pgup.png"), this._T("/res/pgup.png"), 33, 33, 33, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 83, 10, this._T("nlk"), this._T("nlk"), 144, 144, 144, 0);
        this.AddKey(0, 84, 10, this._T("/"), this._T("/"), 111, 111, 111, 0);
        this.AddKey(0, 85, 10, "*", "*", 106, 106, 106, 0);
        this.AddKey(0, 86, 10, "-", "-", 109, 109, 109, 0);
        this.AddKey(0, 0, 2);
        this.AddKey(0, 43, 20, this._T("/res/tab.png"), this._T("/res/tab.png"), 9, 9, 9, 0);
        this.AddKey(1, 20, 10, this._T("/res/krq.png"), this._T("/res/krq.png"), 81, 81, 81, 0);
        this.AddKey(1, 26, 10, this._T("/res/krw.png"), this._T("/res/krw.png"), 87, 87, 87, 0);
        this.AddKey(1, 8, 10, this._T("/res/kre.png"), this._T("/res/kre.png"), 69, 69, 69, 0);
        this.AddKey(1, 21, 10, this._T("/res/krr.png"), this._T("/res/krr.png"), 82, 82, 82, 0);
        this.AddKey(1, 23, 10, this._T("/res/krt.png"), this._T("/res/krt.png"), 84, 84, 84, 0);
        this.AddKey(1, 28, 10, this._T("/res/kry.png"), this._T("/res/kry.png"), 89, 89, 89, 0);
        this.AddKey(1, 24, 10, this._T("/res/kru.png"), this._T("/res/kru.png"), 85, 85, 85, 0);
        this.AddKey(1, 12, 10, this._T("/res/kri.png"), this._T("/res/kri.png"), 73, 73, 73, 0);
        this.AddKey(1, 18, 10, this._T("/res/kro.png"), this._T("/res/kro.png"), 79, 79, 79, 0);
        this.AddKey(1, 19, 10, this._T("/res/krp.png"), this._T("/res/krp.png"), 80, 80, 80, 0);
        this.AddKey(1, 47, 10, this._T("["), this._T("{"), 91, 91, 91, 0);
        this.AddKey(1, 48, 10, this._T("]"), this._T("}"), 93, 93, 93, 0);
        this.AddKey(0, 40, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), 10, 10, 10, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 76, 10, this._T("del"), this._T("del"), 127, 127, 127, 1);
        this.AddKey(0, 77, 10, this._T("/res/end.png"), this._T("/res/end.png"), 35, 35, 35, 1);
        this.AddKey(0, 78, 10, this._T("/res/pgdn.png"), this._T("/res/pgdn.png"), 34, 34, 34, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 95, 10, this._T("/res/home.png"), this._T("7"), 36, 103, 103, 0);
        this.AddKey(4, 96, 10, this._T("/res/up.png"), this._T("8"), 38, 104, 104, 0);
        this.AddKey(4, 97, 10, this._T("/res/pgup.png"), this._T("9"), 33, 105, 105, 0);
        this.AddKey(0, 87, 210, this._T("+"), this._T("+"), 107, 107, 107, 0);
        this.AddKey(0, 0, 3);
        this.AddKey(0, 57, 30, this._T("/res/caps3.png"), this._T("/res/caps3.png"), 20, 20, 20, 0);
        this.AddKey(2, 4, 10, "/res/kra.png", "/res/kra.png", 65, 65, 65, 0);
        this.AddKey(2, 22, 10, "/res/krs.png", "/res/krs.png", 83, 83, 83, 0);
        this.AddKey(2, 7, 10, "/res/krd.png", "/res/krd.png", 68, 68, 68, 0);
        this.AddKey(2, 9, 10, "/res/krf.png", "/res/krf.png", 70, 70, 70, 0);
        this.AddKey(2, 10, 10, "/res/krg.png", "/res/krg.png", 71, 71, 71, 0);
        this.AddKey(2, 11, 10, "/res/krh.png", "/res/krh.png", 72, 72, 72, 0);
        this.AddKey(2, 13, 10, "/res/krj.png", "/res/krj.png", 74, 74, 74, 0);
        this.AddKey(2, 14, 10, "/res/krk.png", "/res/krk.png", 75, 75, 75, 0);
        this.AddKey(2, 15, 10, "/res/krl.png", "/res/krl.png", 76, 76, 76, 0);
        this.AddKey(1, 51, 10, this._T(";"), ":", 186, 186, 59, 0);
        this.AddKey(1, 52, 10, this._T("'"), "\"", 222, 222, 222, 0);
        this.AddKey(0, this.TRANSPARENT, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 92, 10, this._T("/res/left.png"), this._T("4"), 37, 100, 100, 0);
        this.AddKey(4, 93, 10, this._T(" "), this._T("5"), 12, 101, 101, 0);
        this.AddKey(4, 94, 10, this._T("/res/right.png"), this._T("6"), 39, 102, 102, 0);
        this.AddKey(0, 0, 4);
        this.AddKey(0, 225, 30, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(2, 29, 10, this._T("/res/krz.png"), this._T("/res/krz.png"), 90, 90, 90, 0);
        this.AddKey(2, 27, 10, this._T("/res/krx.png"), this._T("/res/krx.png"), 88, 88, 88, 0);
        this.AddKey(2, 6, 10, this._T("/res/krc.png"), this._T("/res/krc.png"), 67, 67, 67, 0);
        this.AddKey(2, 25, 10, this._T("/res/krv.png"), this._T("/res/krv.png"), 86, 86, 86, 0);
        this.AddKey(2, 5, 10, this._T("/res/krb.png"), this._T("/res/krb.png"), 66, 66, 66, 0);
        this.AddKey(2, 17, 10, this._T("/res/krn.png"), this._T("/res/krn.png"), 78, 78, 78, 0);
        this.AddKey(2, 16, 10, this._T("/res/krm.png"), this._T("/res/krm.png"), 77, 77, 77, 0);
        this.AddKey(1, 54, 10, this._T(","), this._T("<"), 44, 44, 44, 0);
        this.AddKey(1, 55, 10, this._T("."), this._T(">"), 46, 46, 46, 0);
        this.AddKey(1, 56, 10, this._T("/"), this._T("?"), 47, 47, 47, 0);
        this.AddKey(0, 229, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, 82, 10, this._T("/res/up.png"), this._T("/res/up.png"), 38, 38, 38, 1);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 89, 10, this._T("/res/end.png"), this._T("1"), 35, 97, 97, 0);
        this.AddKey(4, 90, 10, this._T("/res/down.png"), this._T("2"), 40, 98, 98, 0);
        this.AddKey(4, 91, 10, this._T("/res/pgdn.png"), this._T("3"), 34, 99, 99, 0);
        this.AddKey(0, 88, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), 10, 10, 10, 1);
        this.AddKey(0, 0, 5);
        this.AddKey(0, 224, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, 227, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 226, 20, this._T("alt"), this._T("alt"), 18, 18, 18, 0);
        this.AddKey(0, 145, 20, this._T("/res/krhanja.png"), this._T("/res/krhanja.png"), 25, 25, 25, 2);
        this.AddKey(0, 44, 40, this._T(" "), this._T(" "), 32, 32, 32, 0);
        this.AddKey(0, 144, 20, this._T("/res/krkanji.png"), this._T("/res/krkanji.png"), 21, 21, 21, 2);
        this.AddKey(0, 231, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 1);
        this.AddKey(0, 101, 10, this._T("/res/menu.png"), this._T("/res/menu.png"), 525, 525, 525, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 80, 10, this._T("/res/left.png"), this._T("/res/left.png"), 37, 37, 37, 1);
        this.AddKey(0, 81, 10, this._T("/res/down.png"), this._T("/res/down.png"), 40, 40, 40, 1);
        this.AddKey(0, 79, 10, this._T("/res/right.png"), this._T("/res/right.png"), 39, 39, 39, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 98, 20, this._T("ins"), this._T("0"), 155, 96, 96, 0);
        this.AddKey(4, 99, 10, this._T("del"), this._T("."), 127, 110, 110, 0);
        this.CalcWidthHeight();
        return 0;
    }

    private int addItalian() {
        this.setLocale(Locale.ITALY);
        this.getInputContext().selectInputMethod(Locale.ITALIAN);
        if (RemoteVideo.screnMode) {
            this.parent.video.setInteranlFrameTitle(this.UIString[109]);
        } else {
            this.parent.setTitle(this.UIString[109]);
        }
        this.AddKey(0, 0, 0, "", "", 0, 0, 0, 0);
        this.AddKey(0, 41, 10, "esc", "esc", 27, 27, 27, 0);
        this.AddKey(0, this.EMPTY, 10, "", "", 0, 0, 0, 0);
        this.AddKey(0, 58, 10, "F1", "F1", 112, 112, 112, 0);
        this.AddKey(0, 59, 10, "F2", "F2", 113, 113, 113, 0);
        this.AddKey(0, 60, 10, "F3", "F3", 114, 114, 114, 0);
        this.AddKey(0, 61, 10, "F4", "F4", 115, 115, 115, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 62, 10, "F5", "F5", 116, 116, 116, 0);
        this.AddKey(0, 63, 10, "F6", "F6", 117, 117, 117, 0);
        this.AddKey(0, 64, 10, "F7", "F7", 118, 118, 118, 0);
        this.AddKey(0, 65, 10, "F8", "F8", 119, 119, 119, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 66, 10, "F9", "F9", 120, 120, 120, 0);
        this.AddKey(0, 67, 10, "/res/f10.png", "/res/f10.png", 121, 121, 121, 0);
        this.AddKey(0, 68, 10, "/res/f11.png", "/res/f11.png", 122, 122, 122, 0);
        this.AddKey(0, 69, 10, "/res/f12.png", "/res/f12.png", 123, 123, 123, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 70, 30, "psc", "psc", 154, 154, 154, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 71, 20, "slk", "slk", 145, 145, 145, 0);
        this.AddKey(2, 72, 20, "pau", "brk", 3, 19, 19, 1);
        this.AddKey(0, 0, 1);
        this.AddKey(1, 53, 10, "\\", "|", 92, 92, 192, 0);
        this.AddKey(1, 30, 10, "1", "!", 49, 49, 49, 0);
        this.AddKey(1, 31, 10, "2", "\"", 50, 50, 50, 0);
        this.AddKey(1, 32, 10, "3", "\u00a3", 51, 51, 51, 0);
        this.AddKey(1, 33, 10, "4", "$", 52, 52, 52, 0);
        this.AddKey(1, 34, 10, "5", "%", this._T("%"), 53, 53, 53, 0);
        this.AddKey(1, 35, 10, "6", "&", 54, 54, 54, 0);
        this.AddKey(1, 36, 10, "7", "/", 55, 55, 55, 0);
        this.AddKey(1, 37, 10, "8", "(", 56, 56, 56, 0);
        this.AddKey(1, 38, 10, "9", ")", 57, 57, 57, 0);
        this.AddKey(1, 39, 10, "0", "=", 48, 48, 48, 0);
        this.AddKey(1, 45, 10, "'", "?", 189, 189, 45, 0);
        this.AddKey(1, 46, 10, "\u00ec", "^", 187, 187, 61, 0);
        this.AddKey(2, 42, 20, this._T("/res/bs.png"), this._T("/res/bs.png"), " ", 8, 8, 8, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 73, 10, this._T("ins"), this._T("ins"), 155, 155, 155, 1);
        this.AddKey(0, 74, 10, this._T("/res/home.png"), this._T("/res/home.png"), 36, 36, 36, 1);
        this.AddKey(0, 75, 10, this._T("/res/pgup.png"), this._T("/res/pgup.png"), 33, 33, 33, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 83, 10, this._T("nlk"), this._T("nlk"), 144, 144, 144, 0);
        this.AddKey(0, 84, 10, this._T("/"), this._T("/"), 111, 111, 111, 0);
        this.AddKey(0, 85, 10, "*", "*", 106, 106, 106, 0);
        this.AddKey(0, 86, 10, "-", "-", 109, 109, 109, 0);
        this.AddKey(0, 0, 2);
        this.AddKey(0, 43, 20, this._T("/res/tab.png"), this._T("/res/tab.png"), 9, 9, 9, 0);
        this.AddKey(2, 20, 10, this._T("q"), this._T("Q"), 81, 81, 81, 0);
        this.AddKey(2, 26, 10, this._T("w"), this._T("W"), 87, 87, 87, 0);
        this.AddKey(2, 8, 10, this._T("e"), this._T("E"), this._T("\ufffd"), 69, 69, 69, 0);
        this.AddKey(2, 21, 10, this._T("r"), this._T("R"), 82, 82, 82, 0);
        this.AddKey(2, 23, 10, this._T("t"), this._T("T"), 84, 84, 84, 0);
        this.AddKey(2, 28, 10, this._T("y"), this._T("Y"), 89, 89, 89, 0);
        this.AddKey(2, 24, 10, this._T("u"), this._T("U"), 85, 85, 85, 0);
        this.AddKey(2, 12, 10, this._T("i"), this._T("I"), 73, 73, 73, 0);
        this.AddKey(2, 18, 10, this._T("o"), this._T("O"), 79, 79, 79, 0);
        this.AddKey(2, 19, 10, this._T("p"), this._T("P"), 80, 80, 80, 0);
        this.AddKey(1, 47, 10, this._T("\u00e8"), this._T("\u00e9"), this._T("["), 219, 219, 91, 0);
        this.AddKey(1, 48, 10, this._T("+"), this._T("*"), this._T("]"), 221, 221, 93, 0);
        this.AddKey(2, 40, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), " ", 10, 10, 10, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 76, 10, this._T("del"), this._T("del"), 127, 127, 127, 1);
        this.AddKey(0, 77, 10, this._T("/res/end.png"), this._T("/res/end.png"), 35, 35, 35, 1);
        this.AddKey(0, 78, 10, this._T("/res/pgdn.png"), this._T("/res/pgdn.png"), 34, 34, 34, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 95, 10, this._T("/res/home.png"), this._T("7"), 36, 103, 103, 0);
        this.AddKey(4, 96, 10, this._T("/res/up.png"), this._T("8"), 38, 104, 104, 0);
        this.AddKey(4, 97, 10, this._T("/res/pgup.png"), this._T("9"), 33, 105, 105, 0);
        this.AddKey(0, 87, 210, this._T("+"), this._T("+"), 107, 107, 107, 0);
        this.AddKey(0, 0, 3);
        this.AddKey(0, 57, 20, this._T("/res/caps1.png"), this._T("/res/caps1.png"), "/res/caps1.png", 20, 20, 20, 0);
        this.AddKey(2, 4, 10, "a", "A", 65, 65, 65, 0);
        this.AddKey(2, 22, 10, "s", "S", 83, 83, 83, 0);
        this.AddKey(2, 7, 10, "d", "D", 68, 68, 68, 0);
        this.AddKey(2, 9, 10, "f", "F", 70, 70, 70, 0);
        this.AddKey(2, 10, 10, "g", "G", 71, 71, 71, 0);
        this.AddKey(2, 11, 10, "h", "H", 72, 72, 72, 0);
        this.AddKey(2, 13, 10, "j", "J", 74, 74, 74, 0);
        this.AddKey(2, 14, 10, "k", "K", 75, 75, 75, 0);
        this.AddKey(2, 15, 10, "l", "L", 76, 76, 76, 0);
        this.AddKey(1, 51, 10, "\u00f2", "\u00ba", this._T("@"), 186, 186, 59, 0);
        this.AddKey(1, 52, 10, "\u00e0", "\u00ba", this._T("#"), 222, 222, 222, 0);
        this.AddKey(1, 50, 10, "\u00f9", "\u00a7", 220, 220, 92, 0);
        this.AddKey(0, this.TRANSPARENT, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 92, 10, this._T("/res/left.png"), this._T("4"), 37, 100, 100, 0);
        this.AddKey(4, 93, 10, this._T(" "), this._T("5"), 12, 101, 101, 0);
        this.AddKey(4, 94, 10, this._T("/res/right.png"), this._T("6"), 39, 102, 102, 0);
        this.AddKey(0, 0, 4);
        this.AddKey(0, 225, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(1, 100, 10, this._T("<"), this._T(">"), 153, 153, 61448, 0);
        this.AddKey(2, 29, 10, this._T("z"), this._T("Z"), 90, 90, 90, 0);
        this.AddKey(2, 27, 10, this._T("x"), this._T("X"), 88, 88, 88, 0);
        this.AddKey(2, 6, 10, this._T("c"), this._T("C"), 67, 67, 67, 0);
        this.AddKey(2, 25, 10, this._T("v"), this._T("V"), 86, 86, 86, 0);
        this.AddKey(2, 5, 10, this._T("b"), this._T("B"), 66, 66, 66, 0);
        this.AddKey(2, 17, 10, this._T("n"), this._T("N"), 78, 78, 78, 0);
        this.AddKey(2, 16, 10, this._T("m"), this._T("M"), 77, 77, 77, 0);
        this.AddKey(1, 54, 10, this._T(","), this._T(";"), 188, 188, 44, 0);
        this.AddKey(1, 55, 10, this._T("."), this._T(":"), 190, 190, 46, 0);
        this.AddKey(1, 56, 10, this._T("-"), this._T("_"), 191, 191, 47, 0);
        this.AddKey(0, 229, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, 82, 10, this._T("/res/up.png"), this._T("/res/up.png"), 38, 38, 38, 1);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 89, 10, this._T("/res/end.png"), this._T("1"), 35, 97, 97, 0);
        this.AddKey(4, 90, 10, this._T("/res/down.png"), this._T("2"), 40, 98, 98, 0);
        this.AddKey(4, 91, 10, this._T("/res/pgdn.png"), this._T("3"), 34, 99, 99, 0);
        this.AddKey(2, 88, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), " ", 10, 10, 10, 1);
        this.AddKey(0, 0, 5);
        this.AddKey(0, 224, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, 227, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 226, 20, this._T("alt"), this._T("alt"), 18, 18, 18, 0);
        this.AddKey(0, 44, 40, this._T(" "), this._T(" "), 32, 32, 32, 0);
        this.AddKey(0, 230, 20, this._T("alt gr"), this._T("alt gr"), "alt gr", 18, 18, 18, 1);
        this.AddKey(0, 231, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 1);
        this.AddKey(0, 101, 10, this._T("/res/menu.png"), this._T("/res/menu.png"), 525, 525, 525, 1);
        this.AddKey(0, 228, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 80, 10, this._T("/res/left.png"), this._T("/res/left.png"), 37, 37, 37, 1);
        this.AddKey(0, 81, 10, this._T("/res/down.png"), this._T("/res/down.png"), 40, 40, 40, 1);
        this.AddKey(0, 79, 10, this._T("/res/right.png"), this._T("/res/right.png"), 39, 39, 39, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 98, 20, this._T("ins"), this._T("0"), 155, 96, 96, 0);
        this.AddKey(4, 99, 10, this._T("del"), this._T("."), 127, 110, 110, 0);
        this.CalcWidthHeight();
        return 0;
    }

    private int addUK() {
        this.setLocale(Locale.UK);
        this.getInputContext().selectInputMethod(Locale.UK);
        if (RemoteVideo.screnMode) {
            this.parent.video.setInteranlFrameTitle(this.UIString[117]);
        } else {
            this.parent.setTitle(this.UIString[117]);
        }
        this.AddKey(0, 0, 0, "", "", 0, 0, 0, 0);
        this.AddKey(0, 41, 10, "esc", "esc", 27, 27, 27, 0);
        this.AddKey(0, this.EMPTY, 10, "", "", 0, 0, 0, 0);
        this.AddKey(0, 58, 10, "F1", "F1", 112, 112, 112, 0);
        this.AddKey(0, 59, 10, "F2", "F2", 113, 113, 113, 0);
        this.AddKey(0, 60, 10, "F3", "F3", 114, 114, 114, 0);
        this.AddKey(0, 61, 10, "F4", "F4", 115, 115, 115, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 62, 10, "F5", "F5", 116, 116, 116, 0);
        this.AddKey(0, 63, 10, "F6", "F6", 117, 117, 117, 0);
        this.AddKey(0, 64, 10, "F7", "F7", 118, 118, 118, 0);
        this.AddKey(0, 65, 10, "F8", "F8", 119, 119, 119, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 66, 10, "F9", "F9", 120, 120, 120, 0);
        this.AddKey(0, 67, 10, "/res/f10.png", "/res/f10.png", 121, 121, 121, 0);
        this.AddKey(0, 68, 10, "/res/f11.png", "/res/f11.png", 122, 122, 122, 0);
        this.AddKey(0, 69, 10, "/res/f12.png", "/res/f12.png", 123, 123, 123, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 70, 30, "psc", "psc", 154, 154, 154, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 71, 20, "slk", "slk", 145, 145, 145, 0);
        this.AddKey(2, 72, 20, "pau", "brk", 3, 19, 19, 1);
        this.AddKey(0, 0, 1);
        this.AddKey(1, 53, 10, "`", this._T("\u00ac"), this._T("\u00a6"), 0, 0, 192, 0);
        this.AddKey(1, 30, 10, this._T("1"), this._T("!"), this._T(" "), 49, 49, 49, 0);
        this.AddKey(1, 31, 10, this._T("2"), this._T("\""), 50, 50, 50, 0);
        this.AddKey(1, 32, 10, this._T("3"), this._T("\u00a3"), 51, 51, 51, 0);
        this.AddKey(1, 33, 10, this._T("4"), this._T("$"), this._T("\u20ac"), 52, 52, 52, 0);
        this.AddKey(1, 34, 10, this._T("5"), this._T("%"), 53, 53, 53, 0);
        this.AddKey(1, 35, 10, this._T("6"), this._T("^"), 54, 54, 54, 0);
        this.AddKey(1, 36, 10, "7", "&", 55, 55, 55, 0);
        this.AddKey(1, 37, 10, "8", "*", 56, 56, 56, 0);
        this.AddKey(1, 38, 10, "9", "(", 57, 57, 57, 0);
        this.AddKey(1, 39, 10, "0", ")", 48, 48, 48, 0);
        this.AddKey(1, 45, 10, "-", "_", 189, 189, 45, 0);
        this.AddKey(1, 46, 10, "=", "+", 187, 187, 61, 0);
        this.AddKey(2, 42, 20, this._T("/res/bs.png"), this._T("/res/bs.png"), " ", 8, 8, 8, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 73, 10, this._T("ins"), this._T("ins"), 155, 155, 155, 1);
        this.AddKey(0, 74, 10, this._T("/res/home.png"), this._T("/res/home.png"), 36, 36, 36, 1);
        this.AddKey(0, 75, 10, this._T("/res/pgup.png"), this._T("/res/pgup.png"), 33, 33, 33, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 83, 10, this._T("nlk"), this._T("nlk"), 144, 144, 144, 0);
        this.AddKey(0, 84, 10, this._T("/"), this._T("/"), 111, 111, 111, 0);
        this.AddKey(0, 85, 10, "*", "*", 106, 106, 106, 0);
        this.AddKey(0, 86, 10, "-", "-", 109, 109, 109, 0);
        this.AddKey(0, 0, 2);
        this.AddKey(0, 43, 20, this._T("/res/tab.png"), this._T("/res/tab.png"), 9, 9, 9, 0);
        this.AddKey(2, 20, 10, this._T("q"), this._T("Q"), 81, 81, 81, 0);
        this.AddKey(2, 26, 10, this._T("w"), this._T("W"), 87, 87, 87, 0);
        this.AddKey(2, 8, 10, this._T("e"), this._T("E"), this._T("\u00e9"), 69, 69, 69, 0);
        this.AddKey(2, 21, 10, this._T("r"), this._T("R"), 82, 82, 82, 0);
        this.AddKey(2, 23, 10, this._T("t"), this._T("T"), 84, 84, 84, 0);
        this.AddKey(2, 28, 10, this._T("y"), this._T("Y"), 89, 89, 89, 0);
        this.AddKey(2, 24, 10, this._T("u"), this._T("U"), this._T("\u00fa"), 85, 85, 85, 0);
        this.AddKey(2, 12, 10, this._T("i"), this._T("I"), this._T("\u00ed"), 73, 73, 73, 0);
        this.AddKey(2, 18, 10, this._T("o"), this._T("O"), this._T("\u00f3"), 79, 79, 79, 0);
        this.AddKey(2, 19, 10, this._T("p"), this._T("P"), 80, 80, 80, 0);
        this.AddKey(1, 47, 10, this._T("["), this._T("{"), 219, 219, 91, 0);
        this.AddKey(1, 48, 10, this._T("]"), this._T("}"), 221, 221, 93, 0);
        this.AddKey(2, 40, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), " ", 10, 10, 10, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 76, 10, this._T("del"), this._T("del"), 127, 127, 127, 1);
        this.AddKey(0, 77, 10, this._T("/res/end.png"), this._T("/res/end.png"), 35, 35, 35, 1);
        this.AddKey(0, 78, 10, this._T("/res/pgdn.png"), this._T("/res/pgdn.png"), 34, 34, 34, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 95, 10, this._T("/res/home.png"), this._T("7"), 36, 103, 103, 0);
        this.AddKey(4, 96, 10, this._T("/res/up.png"), this._T("8"), 38, 104, 104, 0);
        this.AddKey(4, 97, 10, this._T("/res/pgup.png"), this._T("9"), 33, 105, 105, 0);
        this.AddKey(0, 87, 210, this._T("+"), this._T("+"), 107, 107, 107, 0);
        this.AddKey(0, 0, 3);
        this.AddKey(0, 57, 20, this._T("/res/caps1.png"), this._T("/res/caps1.png"), "/res/caps1.png", 20, 20, 20, 0);
        this.AddKey(2, 4, 10, "a", "A", this._T("\u00e1"), 65, 65, 65, 0);
        this.AddKey(2, 22, 10, "s", "S", 83, 83, 83, 0);
        this.AddKey(2, 7, 10, "d", "D", 68, 68, 68, 0);
        this.AddKey(2, 9, 10, "f", "F", 70, 70, 70, 0);
        this.AddKey(2, 10, 10, "g", "G", 71, 71, 71, 0);
        this.AddKey(2, 11, 10, "h", "H", 72, 72, 72, 0);
        this.AddKey(2, 13, 10, "j", "J", 74, 74, 74, 0);
        this.AddKey(2, 14, 10, "k", "K", 75, 75, 75, 0);
        this.AddKey(2, 15, 10, "l", "L", 76, 76, 76, 0);
        this.AddKey(1, 51, 10, ";", ":", 58, 58, 59, 0);
        this.AddKey(1, 52, 10, this._T("'"), this._T("@"), 64, 64, 222, 0);
        this.AddKey(1, 50, 10, this._T("#"), this._T("~"), 126, 126, 61449, 0);
        this.AddKey(0, this.TRANSPARENT, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 92, 10, this._T("/res/up.png"), this._T("4"), 37, 100, 100, 0);
        this.AddKey(4, 93, 10, this._T(" "), this._T("5"), 12, 101, 101, 0);
        this.AddKey(4, 94, 10, this._T("/res/right.png"), this._T("6"), 39, 102, 102, 0);
        this.AddKey(0, 0, 4);
        this.AddKey(0, 225, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(1, 100, 10, this._T("\\"), this._T("|"), 92, 92, 92, 0);
        this.AddKey(2, 29, 10, this._T("z"), this._T("Z"), 90, 90, 90, 0);
        this.AddKey(2, 27, 10, this._T("x"), this._T("X"), 88, 88, 88, 0);
        this.AddKey(2, 6, 10, this._T("c"), this._T("C"), 67, 67, 67, 0);
        this.AddKey(2, 25, 10, this._T("v"), this._T("V"), 86, 86, 86, 0);
        this.AddKey(2, 5, 10, this._T("b"), this._T("B"), 66, 66, 66, 0);
        this.AddKey(2, 17, 10, this._T("n"), this._T("N"), 78, 78, 78, 0);
        this.AddKey(2, 16, 10, this._T("m"), this._T("M"), 77, 77, 77, 0);
        this.AddKey(1, 54, 10, this._T(","), this._T("<"), 44, 44, 44, 0);
        this.AddKey(1, 55, 10, this._T("."), this._T(">"), 46, 46, 46, 0);
        this.AddKey(1, 56, 10, this._T("/"), this._T("?"), 47, 47, 47, 0);
        this.AddKey(0, 229, 20, this._T("/res/shift.png"), this._T("/res/shift2.png"), 16, 16, 16, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, 82, 10, this._T("/res/up.png"), this._T("/res/up.png"), 38, 38, 38, 0);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 89, 10, this._T("/res/end.png"), this._T("1"), 35, 97, 97, 0);
        this.AddKey(4, 90, 10, this._T("/res/down.png"), this._T("2"), 40, 98, 98, 0);
        this.AddKey(4, 91, 10, this._T("/res/pgdn.png"), this._T("3"), 34, 99, 99, 0);
        this.AddKey(2, 88, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), " ", 10, 10, 10, 1);
        this.AddKey(0, 0, 5);
        this.AddKey(0, 224, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, 227, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 226, 20, this._T("alt"), this._T("alt"), "alt gr", 18, 18, 18, 0);
        this.AddKey(0, 44, 40, this._T(" "), this._T(" "), 32, 32, 32, 0);
        this.AddKey(0, 230, 20, this._T("alt gr"), this._T("alt gr"), 65406, 65406, 65406, 0);
        this.AddKey(0, 231, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 1);
        this.AddKey(0, 101, 10, this._T("/res/menu.png"), this._T("/res/menu.png"), 525, 525, 525, 1);
        this.AddKey(0, 228, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 80, 10, this._T("/res/left.png"), this._T("/res/left.png"), 37, 37, 37, 1);
        this.AddKey(0, 81, 10, this._T("/res/down.png"), this._T("/res/down.png"), 40, 40, 40, 1);
        this.AddKey(0, 79, 10, this._T("/res/right.png"), this._T("/res/right.png"), 39, 39, 39, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 98, 20, this._T("ins"), this._T("0"), 155, 96, 96, 0);
        this.AddKey(4, 99, 10, this._T("del"), this._T("."), 127, 110, 110, 0);
        this.CalcWidthHeight();
        return 0;
    }

    private int addSwiss() {
        if (RemoteVideo.screnMode) {
            this.parent.video.setInteranlFrameTitle("Swiss keyboard");
        } else {
            this.parent.setTitle("Swiss keyboard");
        }
        this.AddKey(0, 0, 0, "", "", 0, 0, 0, 0);
        this.AddKey(0, 41, 10, "esc", "esc", 27, 27, 27, 0);
        this.AddKey(0, this.EMPTY, 10, "", "", 0, 0, 0, 0);
        this.AddKey(0, 58, 10, "F1", "F1", 112, 112, 112, 0);
        this.AddKey(0, 59, 10, "F2", "F2", 113, 113, 113, 0);
        this.AddKey(0, 60, 10, "F3", "F3", 114, 114, 114, 0);
        this.AddKey(0, 61, 10, "F4", "F4", 115, 115, 115, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 62, 10, "F5", "F5", 116, 116, 116, 0);
        this.AddKey(0, 63, 10, "F6", "F6", 117, 117, 117, 0);
        this.AddKey(0, 64, 10, "F7", "F7", 118, 118, 118, 0);
        this.AddKey(0, 65, 10, "F8", "F8", 119, 119, 119, 0);
        this.AddKey(0, this.EMPTY, 5, "", "", 0, 0, 0, 0);
        this.AddKey(0, 66, 10, "F9", "F9", 120, 120, 120, 0);
        this.AddKey(0, 67, 10, "/res/f10.png", "/res/f10.png", 121, 121, 121, 0);
        this.AddKey(0, 68, 10, "/res/f11.png", "/res/f11.png", 122, 122, 122, 0);
        this.AddKey(0, 69, 10, "/res/f12.png", "/res/f12.png", 123, 123, 123, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 70, 30, "psc", "psc", 154, 154, 154, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 71, 20, "slk", "slk", 145, 145, 145, 0);
        this.AddKey(2, 72, 20, "pau", "brk", 3, 19, 19, 1);
        this.AddKey(0, 0, 1);
        this.AddKey(1, 53, 10, "\u00a7", "\u00b0", 130, 130, 192, 0);
        this.AddKey(1, 30, 10, "1", "+", this._T("|"), 49, 49, 49, 0);
        this.AddKey(1, 31, 10, "2", "\"", this._T("@"), 50, 50, 50, 0);
        this.AddKey(1, 32, 10, "3", "*", this._T("#"), 51, 51, 51, 0);
        this.AddKey(1, 33, 10, "4", "\u00e7", 52, 52, 52, 0);
        this.AddKey(1, 34, 10, "5", "%", 53, 53, 53, 0);
        this.AddKey(1, 35, 10, "6", "&", this._T("\u00ac"), 54, 54, 54, 0);
        this.AddKey(1, 36, 10, this._T("7"), this._T("/"), "\u00a6", 55, 55, 55, 0);
        this.AddKey(1, 37, 10, this._T("8"), this._T("("), "\u00a2", 56, 56, 56, 0);
        this.AddKey(1, 38, 10, this._T("9"), this._T(")"), 57, 57, 57, 0);
        this.AddKey(1, 39, 10, this._T("0"), this._T("="), 48, 48, 48, 0);
        this.AddKey(1, 45, 10, this._T("'"), this._T("?"), "\u00b8", 189, 189, 45, 0);
        this.AddKey(1, 46, 10, "^", "`", "~", 187, 187, 61, 0);
        this.AddKey(2, 42, 20, this._T("/res/bs.png"), this._T("/res/bs.png"), " ", 8, 8, 8, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 73, 10, this._T("ins"), this._T("ins"), 155, 155, 155, 0);
        this.AddKey(0, 74, 10, this._T("/res/home.png"), this._T("/res/home.png"), 36, 36, 36, 1);
        this.AddKey(0, 75, 10, this._T("/res/pgup.png"), this._T("/res/pgup.png"), 33, 33, 33, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 83, 10, this._T("nlk"), this._T("nlk"), 144, 144, 144, 0);
        this.AddKey(0, 84, 10, this._T("/"), this._T("/"), 111, 111, 111, 1);
        this.AddKey(0, 85, 10, "*", "*", 106, 106, 106, 0);
        this.AddKey(0, 86, 10, "-", "-", 109, 109, 109, 0);
        this.AddKey(0, 0, 2);
        this.AddKey(0, 43, 20, this._T("/res/tab.png"), this._T("/res/tab.png"), 9, 9, 9, 0);
        this.AddKey(2, 20, 10, this._T("q"), this._T("Q"), 81, 81, 81, 0);
        this.AddKey(2, 26, 10, this._T("w"), this._T("W"), 87, 87, 87, 0);
        this.AddKey(2, 8, 10, this._T("e"), this._T("E"), this._T("\ufffd"), 69, 69, 69, 0);
        this.AddKey(2, 21, 10, this._T("r"), this._T("R"), 82, 82, 82, 0);
        this.AddKey(2, 23, 10, this._T("t"), this._T("T"), 84, 84, 84, 0);
        this.AddKey(2, 28, 10, this._T("z"), this._T("Z"), 89, 89, 89, 0);
        this.AddKey(2, 24, 10, this._T("u"), this._T("U"), 85, 85, 85, 0);
        this.AddKey(2, 12, 10, this._T("i"), this._T("I"), 73, 73, 73, 0);
        this.AddKey(2, 18, 10, this._T("o"), this._T("O"), 79, 79, 79, 0);
        this.AddKey(2, 19, 10, this._T("p"), this._T("P"), 80, 80, 80, 0);
        this.AddKey(2, 47, 10, this._T("\u00fc"), this._T("\u00e8"), this._T("["), 219, 219, 91, 0);
        this.AddKey(1, 48, 10, this._T("\u00af"), this._T("!"), this._T("]"), 221, 221, 93, 0);
        this.AddKey(2, 40, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), "", 10, 10, 10, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 76, 10, this._T("del"), this._T("del"), 127, 127, 127, 1);
        this.AddKey(0, 77, 10, this._T("/res/end.png"), this._T("/res/end.png"), 35, 35, 35, 1);
        this.AddKey(0, 78, 10, this._T("/res/pgdn.png"), this._T("/res/pgdn.png"), 34, 34, 34, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 95, 10, this._T("/res/home.png"), this._T("7"), 36, 103, 103, 0);
        this.AddKey(4, 96, 10, this._T("/res/up.png"), this._T("8"), 38, 104, 104, 0);
        this.AddKey(4, 97, 10, this._T("/res/pgup.png"), this._T("9"), 33, 105, 105, 0);
        this.AddKey(0, 87, 210, this._T("+"), this._T("+"), 107, 107, 107, 0);
        this.AddKey(0, 0, 3);
        this.AddKey(0, 57, 20, this._T("/res/caps1.png"), this._T("/res/caps1.png"), "/res/caps1.png", 20, 20, 20, 0);
        this.AddKey(2, 4, 10, "a", "A", 65, 65, 65, 0);
        this.AddKey(2, 22, 10, "s", "S", 83, 83, 83, 0);
        this.AddKey(2, 7, 10, "d", "D", 68, 68, 68, 0);
        this.AddKey(2, 9, 10, "f", "F", 70, 70, 70, 0);
        this.AddKey(2, 10, 10, "g", "G", 71, 71, 71, 0);
        this.AddKey(2, 11, 10, "h", "H", 72, 72, 72, 0);
        this.AddKey(2, 13, 10, "j", "J", 74, 74, 74, 0);
        this.AddKey(2, 14, 10, "k", "K", 75, 75, 75, 0);
        this.AddKey(2, 15, 10, "l", "L", 76, 76, 76, 0);
        this.AddKey(2, 51, 10, "\u00f6", "\u00e9", 186, 186, 59, 0);
        this.AddKey(2, 52, 10, "\u00e4", "\u00e0", this._T("{"), 222, 222, 222, 0);
        this.AddKey(1, 50, 10, "$", "\u00a3", this._T("}"), 220, 220, 92, 0);
        this.AddKey(0, this.TRANSPARENT, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 92, 10, this._T("\u2190"), this._T("4"), 37, 100, 100, 0);
        this.AddKey(4, 93, 10, this._T(" "), this._T("5"), 12, 101, 101, 0);
        this.AddKey(4, 94, 10, this._T("\u2192"), this._T("6"), 39, 102, 102, 0);
        this.AddKey(0, 0, 4);
        this.AddKey(0, 225, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(1, 100, 10, this._T("<"), this._T(">"), this._T("\\"), 153, 153, 61448, 0);
        this.AddKey(2, 29, 10, this._T("y"), this._T("Y"), 89, 89, 90, 0);
        this.AddKey(2, 27, 10, this._T("x"), this._T("X"), 88, 88, 88, 0);
        this.AddKey(2, 6, 10, this._T("c"), this._T("C"), 67, 67, 67, 0);
        this.AddKey(2, 25, 10, this._T("v"), this._T("V"), 86, 86, 86, 0);
        this.AddKey(2, 5, 10, this._T("b"), this._T("B"), 66, 66, 66, 0);
        this.AddKey(2, 17, 10, this._T("n"), this._T("N"), 78, 78, 78, 0);
        this.AddKey(2, 16, 10, this._T("m"), this._T("M"), 77, 77, 77, 0);
        this.AddKey(1, 54, 10, this._T(","), this._T(";"), 188, 188, 44, 0);
        this.AddKey(1, 55, 10, this._T("."), this._T(":"), 190, 190, 46, 0);
        this.AddKey(1, 56, 10, this._T("-"), this._T("_"), 191, 191, 47, 0);
        this.AddKey(0, 229, 20, this._T("/res/shift.png"), this._T("/res/shift.png"), 16, 16, 16, 0);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, 82, 10, this._T("\u2191"), this._T("\u2191"), 38, 38, 38, 1);
        this.AddKey(0, this.EMPTY, 10);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 89, 10, this._T("/res/end.png"), this._T("1"), 35, 97, 97, 0);
        this.AddKey(4, 90, 10, this._T("/res/down.png"), this._T("2"), 40, 98, 98, 0);
        this.AddKey(4, 91, 10, this._T("/res/pgdn.png"), this._T("3"), 34, 99, 99, 0);
        this.AddKey(2, 88, 210, this._T("/res/ret2.png"), this._T("/res/ret2.png"), " ", 10, 10, 10, 1);
        this.AddKey(0, 0, 5);
        this.AddKey(0, 224, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 0);
        this.AddKey(0, 227, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 0);
        this.AddKey(0, 226, 20, this._T("alt"), this._T("alt"), 18, 18, 18, 0);
        this.AddKey(0, 44, 40, this._T(" "), this._T(" "), 32, 32, 32, 0);
        this.AddKey(0, 230, 20, this._T("alt gr"), this._T("alt gr"), "alt gr", 65406, 65406, 65406, 0);
        this.AddKey(0, 231, 10, this._T("/res/wnd.png"), this._T("/res/wnd.png"), 524, 524, 524, 1);
        this.AddKey(0, 101, 10, this._T("/res/menu.png"), this._T("/res/menu.png"), 525, 525, 525, 1);
        this.AddKey(0, 228, 20, this._T("ctrl"), this._T("ctrl"), 17, 17, 17, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(0, 80, 10, this._T("/res/left.png"), this._T("/res/left.png"), 37, 37, 37, 1);
        this.AddKey(0, 81, 10, this._T("/res/down.png"), this._T("/res/down.png"), 40, 40, 40, 0);
        this.AddKey(0, 79, 10, this._T("/res/right.png"), this._T("/res/right.png"), 39, 39, 39, 1);
        this.AddKey(0, this.EMPTY, 2);
        this.AddKey(4, 98, 20, this._T("ins"), this._T("0"), 155, 96, 96, 0);
        this.AddKey(4, 99, 10, this._T("del"), this._T("."), 127, 110, 110, 0);
        this.CalcWidthHeight();
        return 0;
    }

    public void releaseKeyboardPopMenu() {
        this.selectKeyboardMenu.setVisible(false);
    }
}

