/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.ikvm.ui;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import tw.com.aten.bean.InfoRepository;
import tw.com.aten.ikvm.bean.OptionInfo;
import tw.com.aten.ikvm.ui.SettingPanel;
import tw.com.aten.ikvm.ui.Viewer;

public class OptionFrame
extends JFrame {
    JFrame parent;
    InfoRepository infoRepository;
    OptionInfo optionInfo;
    boolean adjustVideo;
    JPanel languageTabPanel;
    JPanel langSelectionPanel;
    JComboBox langBox;
    JLabel langLabel;
    String[] UIString;
    boolean langChanged;
    int saveLangSelectedIndex;
    public int kbLayoutSelect;
    private JPanel speedPanel;
    private JPanel streamSelectionPanel;
    JPanel videoStreamCtrlTabPanel;
    private JComboBox lanSpeedBox;
    protected JLabel lanSpeedLabel;
    protected JCheckBox enableLanFlowCtrl;
    int saveVideoStreamSpeedIndex;
    public int org_lang_type_idx = 255;
    public int org_kb_lang_idx;
    private boolean isLanFlowCtrl;
    private String[] lanSpeedType = new String[]{"256K Cable/DSL", "T1", "T2"};
    public JComboBox kbLayoutComboBox;
    int k_nLanguage;

    OptionFrame(JFrame parent, InfoRepository infoRepository, OptionInfo optionInfo, boolean adjustVideo) {
        this.setTitle("Options");
        this.parent = parent;
        this.infoRepository = infoRepository;
        this.optionInfo = optionInfo;
        this.adjustVideo = adjustVideo;
        this.kbLayoutComboBox = new JComboBox<String>(new String[]{"English", "Chinese (traditional)", "Japanese", "Germany", "French", "Spanish", "Korean", "Italian", "United Kingdom", "Swiss"});
        this.constructLangPanel();
        this.constructVideoStreamCtrlPanel();
    }

    public void SetLangTypeIdxFromServer(int lang_idx, int kb_lang_idx) {
        this.org_lang_type_idx = lang_idx;
        this.org_kb_lang_idx = kb_lang_idx;
    }

    public void processOptionInfo() {
    }

    public JTabbedPane getTabbedPane() {
        return new JTabbedPane();
    }

    public JPanel getButtonPane() {
        return new JPanel();
    }

    public SettingPanel getSettingPane() {
        return new SettingPanel(this.parent, this, this.optionInfo);
    }

    public boolean isFrameVisible() {
        return false;
    }

    public void changeUILanguage(String[] UIString) {
    }

    private void constructLangPanel() {
        this.langChanged = false;
        this.languageTabPanel = new JPanel(new GridLayout(3, 1));
        this.langSelectionPanel = new JPanel();
        this.langSelectionPanel.setBorder(BorderFactory.createTitledBorder(null, "Language Settings", 0, 0));
        this.langBox = new JComboBox<String>(this.infoRepository.getLangType());
        this.langBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OptionFrame.this.langChanged = true;
            }
        });
        this.langLabel = new JLabel("Language Setting");
        this.langSelectionPanel.add(this.langLabel);
        this.langSelectionPanel.add(this.langBox);
        this.languageTabPanel.add(this.langSelectionPanel);
    }

    public void setNewLang() {
        if (this.org_lang_type_idx != this.langBox.getSelectedIndex()) {
            this.org_lang_type_idx = this.langBox.getSelectedIndex();
            this.UIString = this.infoRepository.getUIString(this.langBox.getSelectedIndex());
            this.saveLangSelectedIndex = this.langBox.getSelectedIndex();
            ((Viewer)this.parent).getVideoPane().SetUILanguage(this.UIString, this.langBox.getSelectedIndex());
            ((Viewer)this.parent).getVideoPane().sendScreenUILang(this.saveLangSelectedIndex, this.org_kb_lang_idx);
        }
    }

    public void BackToCurrentLang() {
        this.langBox.setSelectedIndex(this.saveLangSelectedIndex);
    }

    public void updateLangSelect(int selectedIdx) {
        this.saveLangSelectedIndex = selectedIdx;
        this.langBox.setSelectedIndex(selectedIdx);
    }

    public String[] getCurrentUIString() {
        return this.infoRepository.getUIString(this.langBox.getSelectedIndex());
    }

    private void constructVideoStreamCtrlPanel() {
        this.isLanFlowCtrl = false;
        this.videoStreamCtrlTabPanel = new JPanel();
        this.videoStreamCtrlTabPanel.setBorder(BorderFactory.createTitledBorder(null, "LAN Flow Control", 0, 0));
        this.streamSelectionPanel = new JPanel(new GridLayout(2, 1));
        this.lanSpeedBox = new JComboBox<String>(this.lanSpeedType);
        this.lanSpeedBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        });
        this.enableLanFlowCtrl = new JCheckBox("Enable Flow Control");
        this.lanSpeedLabel = new JLabel("Speed");
        this.speedPanel = new JPanel(new FlowLayout(0));
        this.speedPanel.add(this.lanSpeedLabel);
        this.speedPanel.add(this.lanSpeedBox);
        this.streamSelectionPanel.add(this.enableLanFlowCtrl);
        this.streamSelectionPanel.add(this.speedPanel);
        this.videoStreamCtrlTabPanel.add(this.streamSelectionPanel);
        this.enableLanFlowCtrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ae.getSource().equals(OptionFrame.this.enableLanFlowCtrl)) {
                    if (OptionFrame.this.enableLanFlowCtrl.isSelected()) {
                        OptionFrame.this.lanSpeedBox.enable();
                        OptionFrame.this.lanSpeedBox.repaint();
                    } else {
                        OptionFrame.this.lanSpeedBox.disable();
                        OptionFrame.this.lanSpeedBox.repaint();
                    }
                }
            }
        });
        if (this.enableLanFlowCtrl.isEnabled()) {
            this.lanSpeedBox.disable();
        }
    }

    public void setVideoStreamSpeed() {
        int outgo = 0;
        this.isLanFlowCtrl = this.enableLanFlowCtrl.isSelected();
        this.enableLanFlowCtrl.setSelected(this.isLanFlowCtrl);
        if (this.enableLanFlowCtrl.isSelected()) {
            this.lanSpeedBox.enable();
            this.lanSpeedBox.repaint();
        } else {
            this.lanSpeedBox.disable();
            this.lanSpeedBox.repaint();
        }
        if (this.enableLanFlowCtrl.isSelected()) {
            this.saveVideoStreamSpeedIndex = this.lanSpeedBox.getSelectedIndex();
            switch (this.saveVideoStreamSpeedIndex) {
                case 0: {
                    outgo = 32768;
                    break;
                }
                case 1: {
                    outgo = 197632;
                    break;
                }
                case 2: {
                    outgo = 403456;
                    break;
                }
                default: {
                    outgo = 0;
                }
            }
            ((Viewer)this.parent).getVideoPane().setQosEvent(outgo, 0, 10);
            System.out.println("setVideoStreamSpeed in Enabel");
        } else {
            outgo = 0;
            ((Viewer)this.parent).getVideoPane().setQosEvent(outgo, 0, 10);
            System.out.println("setVideoStreamSpeed in Disabel");
        }
    }

    public void resotreVideoStreamSpeed() {
        this.enableLanFlowCtrl.setSelected(this.isLanFlowCtrl);
        if (this.isLanFlowCtrl) {
            this.lanSpeedBox.enable();
            System.out.println("resotreVideoStreamSpeed to Enable");
        } else {
            this.lanSpeedBox.disable();
            System.out.println("resotreVideoStreamSpeed to Disable");
        }
    }

    public void BackToCurrentVideoStreamSpeed() {
        this.lanSpeedBox.setSelectedIndex(this.saveVideoStreamSpeedIndex);
    }

    public void reloadText() {
    }

    public void setkbLayoutComboBox(int k_nLanguage) {
        if (k_nLanguage == 1) {
            this.kbLayoutComboBox.setSelectedIndex(0);
        } else if (k_nLanguage == 3) {
            this.kbLayoutComboBox.setSelectedIndex(1);
        } else if (k_nLanguage == 4) {
            this.kbLayoutComboBox.setSelectedIndex(2);
        } else if (k_nLanguage == 5) {
            this.kbLayoutComboBox.setSelectedIndex(3);
        } else if (k_nLanguage == 6) {
            this.kbLayoutComboBox.setSelectedIndex(4);
        } else if (k_nLanguage == 7) {
            this.kbLayoutComboBox.setSelectedIndex(5);
        } else if (k_nLanguage == 8) {
            this.kbLayoutComboBox.setSelectedIndex(6);
        } else if (k_nLanguage == 9) {
            this.kbLayoutComboBox.setSelectedIndex(7);
        } else if (k_nLanguage == 10) {
            this.kbLayoutComboBox.setSelectedIndex(8);
        } else if (k_nLanguage == 11) {
            this.kbLayoutComboBox.setSelectedIndex(9);
        }
    }
}

