/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.ikvm.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tw.com.aten.ikvm.bean.OptionInfo;
import tw.com.aten.ikvm.ui.OptionFrame;
import tw.com.aten.ikvm.ui.Viewer;

public class SettingPanel
extends JPanel
implements KeyListener,
ActionListener,
MouseListener {
    private JPanel basePane;
    private JPanel topPane;
    private JPanel middlePane;
    private JPanel buttomPane;
    private JLabel exportLabel;
    private JButton exportButton;
    private JTextField importTextField;
    private JButton importButton;
    private JLabel defaultLabel;
    private JButton defaultButton;
    private JButton applyButton;
    private JFileChooser fileChooser;
    private File selectedFile;
    private JFrame normalFrame;
    private JInternalFrame internalFrame;
    private Viewer parentFrame;
    private OptionInfo viewerOption;
    private OptionFrame optionFrame;

    public SettingPanel(JFrame parent, OptionFrame optionFrame, OptionInfo optionInfo) {
        super(new GridBagLayout());
        GridBagConstraints constraint = new GridBagConstraints();
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        this.fileChooser.addActionListener(this);
        this.normalFrame = new JFrame();
        this.normalFrame.setVisible(false);
        this.internalFrame = new JInternalFrame(null, false, true, false, false);
        this.internalFrame.setLocation(20, 20);
        this.internalFrame.setVisible(false);
        if (parent.getClass().equals(Viewer.class)) {
            this.parentFrame = (Viewer)parent;
            this.parentFrame.getVideoPane().add(this.internalFrame);
        }
        this.viewerOption = optionInfo;
        this.optionFrame = optionFrame;
        this.basePane = new JPanel(new BorderLayout());
        this.basePane.setBorder(BorderFactory.createTitledBorder(this.basePane.getBorder(), "Import Settings", 0, 0));
        this.topPane = new JPanel(new FlowLayout(4, 5, 5));
        this.exportLabel = new JLabel("Export current settings to file");
        this.exportButton = new JButton("Browse");
        this.exportButton.addActionListener(this);
        this.topPane.add(this.exportLabel);
        this.topPane.add(this.exportButton);
        this.topPane.setBorder(BorderFactory.createTitledBorder(this.topPane.getBorder(), "Export Settings", 0, 0));
        constraint.fill = 2;
        constraint.gridx = 0;
        constraint.gridy = 0;
        this.add((Component)this.topPane, constraint);
        this.middlePane = new JPanel(new FlowLayout(4, 0, 5));
        this.importTextField = new JTextField();
        this.importTextField.setPreferredSize(new Dimension(200, 21));
        this.importTextField.setEditable(false);
        this.importButton = new JButton("Browse");
        this.importButton.addActionListener(this);
        this.middlePane.add(this.importTextField);
        this.middlePane.add(this.importButton);
        this.basePane.add("North", this.middlePane);
        this.buttomPane = new JPanel(new FlowLayout(4, 0, 5));
        this.defaultButton = new JButton("Default setting");
        this.defaultButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.buttomPane.add(this.defaultButton);
        this.buttomPane.add(this.applyButton);
        this.basePane.add("South", this.buttomPane);
        constraint.gridheight = 2;
        constraint.gridx = 0;
        constraint.gridy = 1;
        this.add((Component)this.basePane, constraint);
        this.selectedFile = new File(this.viewerOption.getDefaultSettingFile().getPath());
    }

    public boolean isFrameVisible() {
        return this.normalFrame.isVisible() || this.internalFrame.isVisible();
    }

    public void showProperUI() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        if (gs.getFullScreenWindow() == null) {
            this.internalFrame.setVisible(false);
            this.normalFrame.add(this.fileChooser);
            this.normalFrame.pack();
            this.normalFrame.setVisible(true);
        } else {
            this.normalFrame.setVisible(false);
            this.internalFrame.add(this.fileChooser);
            this.internalFrame.pack();
            this.internalFrame.setVisible(true);
        }
    }

    private void closeProperUI() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        if (gs.getFullScreenWindow() == null) {
            this.normalFrame.setVisible(false);
        } else {
            this.internalFrame.setVisible(false);
        }
    }

    public void applyAllSettings() {
        this.optionFrame.processOptionInfo();
        this.viewerOption.setOptionChanged(true);
        if (this.parentFrame != null) {
            this.parentFrame.getVideoPane().updateSettings();
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        ke.consume();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("ApproveSelection")) {
            System.out.println(this.fileChooser.getSelectedFile().getPath());
            if (this.fileChooser.getDialogType() == 1) {
                this.viewerOption.saveSettingFile(this.fileChooser.getSelectedFile());
            } else if (this.fileChooser.getDialogType() == 0) {
                this.selectedFile = new File(this.fileChooser.getSelectedFile().getPath());
                this.importTextField.setText(this.selectedFile.getPath());
            }
            this.closeProperUI();
        } else if (ae.getActionCommand().equals("CancelSelection")) {
            this.closeProperUI();
        } else if ((JButton)ae.getSource() == this.exportButton) {
            this.fileChooser.setDialogType(1);
            this.fileChooser.rescanCurrentDirectory();
            this.showProperUI();
        } else if ((JButton)ae.getSource() == this.importButton) {
            this.fileChooser.setDialogType(0);
            this.fileChooser.rescanCurrentDirectory();
            this.showProperUI();
        } else if ((JButton)ae.getSource() == this.applyButton) {
            if (!this.selectedFile.getPath().equals("")) {
                this.viewerOption.loadSettingFile(this.selectedFile);
                this.applyAllSettings();
            }
        } else {
            this.selectedFile = this.viewerOption.getDefaultSettingFile();
            this.importTextField.setText(this.selectedFile.getPath());
            System.out.println("load default");
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }
}

