/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.ikvm.ui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import tw.com.aten.bean.InfoRepository;
import tw.com.aten.ikvm.ui.RemoteVideo;

public class UserListFrame
extends JFrame
implements WindowListener,
KeyListener,
ActionListener,
MouseListener,
ListSelectionListener {
    private boolean DEBUG = false;
    private JFrame parent;
    private InfoRepository infoRepository;
    private JPanel tablePanel;
    private JPanel buttonPanel;
    private JTable userTable;
    private JScrollPane scrollPane;
    private JButton kickButton;
    private JButton updateButton;
    private JButton closeButton;
    private DefaultTableModel model;

    public UserListFrame(JFrame parent, InfoRepository infoRepository) {
        this.parent = parent;
        this.infoRepository = infoRepository;
        this.tablePanel = new JPanel();
        this.tablePanel.setBorder(BorderFactory.createTitledBorder(null, "User list", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.model = new DefaultTableModel(){

            public Class getColumnClass(int col) {
                return this.getValueAt(0, col).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col >= 3;
            }
        };
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Session ID");
        columnNames.add("User Name");
        columnNames.add("IP Address");
        Vector data = new Vector();
        this.model.setDataVector(data, columnNames);
        this.userTable = new JTable(this.model);
        this.scrollPane = new JScrollPane(this.userTable);
        this.userTable.setFillsViewportHeight(true);
        this.tablePanel.add(this.scrollPane);
        this.buttonPanel = new JPanel(new FlowLayout(4, 20, 5));
        this.buttonPanel.setBorder(BorderFactory.createTitledBorder(null, "Actions", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.kickButton = new JButton("Kick user");
        this.updateButton = new JButton("Update user privilege");
        this.closeButton = new JButton("Close");
        this.kickButton.setName("Kick user");
        this.updateButton.setName("Update user privilege");
        this.closeButton.setName("Close");
        this.kickButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.kickButton);
        this.kickButton.setVisible(false);
        this.buttonPanel.add(this.closeButton);
        this.add("North", this.tablePanel);
        this.add("Center", this.buttonPanel);
        this.pack();
        this.setTitle("User list");
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
    }

    public void changeUILanguage(String[] UIString) {
        this.tablePanel.setBorder(BorderFactory.createTitledBorder(null, UIString[10], 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.buttonPanel.setBorder(BorderFactory.createTitledBorder(null, UIString[12], 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(UIString[50]);
        columnNames.add(UIString[51]);
        columnNames.add(UIString[73]);
        this.model.setColumnIdentifiers(columnNames);
        this.closeButton.setText(UIString[18]);
        this.setTitle(UIString[10]);
    }

    public void addNewRow(Vector newRow) {
        DefaultTableModel model = (DefaultTableModel)this.userTable.getModel();
        model.addRow(newRow);
    }

    public void removeRow(int id) {
        boolean rowExist = false;
        DefaultTableModel model = (DefaultTableModel)this.userTable.getModel();
        int rowCount = model.getRowCount();
        int i = rowCount - 1;
        while (i >= 0) {
            if ((Integer)model.getValueAt(i, 0) == id) {
                System.out.println((Integer)model.getValueAt(i, 0));
                model.removeRow(i);
                rowExist = true;
            }
            --i;
        }
        if (!rowExist) {
            System.out.println("Target session is not exist");
        }
    }

    public void kickUserDisable() {
        this.kickButton.setEnabled(false);
        this.validate();
    }

    public JPanel getTablePanel() {
        return this.tablePanel;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    private void closeUserListPanelContainer() {
        this.tablePanel.getParent().getParent().getParent().getParent().setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String name = ((JButton)ae.getSource()).getName();
        byte[] m = new byte[64];
        if (name.equals("Kick user")) {
            int selectedRow = this.userTable.getSelectedRow();
            if (selectedRow >= 0) {
                int selectedID = (Integer)this.userTable.getValueAt(selectedRow, 0);
                RemoteVideo.sendPrivilegeCtrl(selectedID, 0, m);
            }
        } else if (name.equals("Close")) {
            this.closeUserListPanelContainer();
        }
    }

    @Override
    public void windowActivated(WindowEvent we) {
    }

    @Override
    public void windowClosed(WindowEvent we) {
    }

    @Override
    public void windowClosing(WindowEvent we) {
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
    }

    @Override
    public void windowIconified(WindowEvent we) {
    }

    @Override
    public void windowOpened(WindowEvent we) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        ke.consume();
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }
}

