/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.ikvm.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class FullScreenFileChooser {
    private static String getFileName(JFileChooser jf) {
        String str = null;
        LinkedList<Component> queue = new LinkedList<Component>();
        queue.add(jf);
        while (queue.size() != 0) {
            Component[] c = ((Container)queue.removeFirst()).getComponents();
            int i = 0;
            while (i < c.length) {
                queue.add(c[i]);
                if (c[i] instanceof JTextField) {
                    JTextField jtf = (JTextField)c[i];
                    str = jtf.getText();
                }
                ++i;
            }
        }
        return str;
    }

    public static String showOpenDialog(JFrame normalFrame, JFrame fullFrame) {
        return FullScreenFileChooser.showOpenDialog(normalFrame, fullFrame, null);
    }

    public static String showOpenDialog(JFrame normalFrame, JFrame fullFrame, FileFilter filter) {
        String path = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        JFileChooser fileChooser = new JFileChooser();
        if (filter != null) {
            fileChooser.setFileFilter(filter);
        }
        if (normalFrame == null) {
            return path;
        }
        if (gs.getFullScreenWindow() == null) {
            int ret = fileChooser.showOpenDialog(normalFrame);
            if (ret == 0) {
                File f = fileChooser.getSelectedFile();
                if (f.getAbsolutePath().indexOf(":", 2) != -1) {
                    JOptionPane.showMessageDialog(null, "Invalid path or file name", null, 0);
                    path = null;
                } else {
                    path = f.getPath();
                }
            }
        } else {
            fileChooser.setControlButtonsAreShown(false);
            int ret = JOptionPane.showInternalConfirmDialog(fullFrame.getContentPane(), fileChooser, "Open File", 2, -1);
            switch (ret) {
                case 0: {
                    File f = fileChooser.getSelectedFile();
                    if (f != null) {
                        if (f.getAbsolutePath().indexOf(":", 2) != -1) {
                            JOptionPane.showInternalMessageDialog(fullFrame.getContentPane(), "Invalid path or file name", null, 0);
                            path = null;
                            break;
                        }
                        path = f.getPath();
                        break;
                    }
                    path = fileChooser.getCurrentDirectory() + System.getProperty("file.separator") + FullScreenFileChooser.getFileName(fileChooser);
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
        return path;
    }

    public static String showSaveDialog(JFrame normalFrame, JFrame fullFrame) {
        return FullScreenFileChooser.showSaveDialog(normalFrame, fullFrame, null);
    }

    public static String showSaveDialog(JFrame normalFrame, JFrame fullFrame, FileFilter filter) {
        String path = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        JFileChooser fileChooser = new JFileChooser();
        if (filter != null) {
            fileChooser.setFileFilter(filter);
        }
        if (normalFrame == null) {
            return path;
        }
        if (gs.getFullScreenWindow() == null) {
            int ret = fileChooser.showSaveDialog(normalFrame);
            if (ret == 0) {
                File f = fileChooser.getSelectedFile();
                if (f.getAbsolutePath().indexOf(":", 2) != -1) {
                    JOptionPane.showMessageDialog(null, "Invalid path or file name", null, 0);
                    path = null;
                } else {
                    path = f.getPath();
                }
            }
        } else {
            fileChooser.setControlButtonsAreShown(false);
            fileChooser.setDialogType(1);
            int ret = JOptionPane.showInternalConfirmDialog(fullFrame.getContentPane(), fileChooser, "Save", 2, -1);
            switch (ret) {
                case 0: {
                    File f = fileChooser.getSelectedFile();
                    if (f != null) {
                        if (f.getAbsolutePath().indexOf(":", 2) != -1) {
                            JOptionPane.showInternalMessageDialog(fullFrame.getContentPane(), "Invalid path or file name", null, 0);
                            path = null;
                            break;
                        }
                        path = f.getPath();
                        break;
                    }
                    path = fileChooser.getCurrentDirectory() + System.getProperty("file.separator") + FullScreenFileChooser.getFileName(fileChooser);
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
        return path;
    }
}

