/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.RedirProtocolException;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.CDROMProtocol;
import com.ami.iusb.protocol.IUSBHeader;
import com.ami.iusb.protocol.IUSBSCSI;
import com.ami.iusb.protocol.PacketMaster;
import com.ami.iusb.vCDMonitorThread;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import supermicro.jviewer.SMCUtil;

public class CDROMRedir
extends Thread {
    private PacketMaster packetMaster;
    private CDROMProtocol protocol;
    private ByteBuffer packetReadBuffer;
    private ByteBuffer packetWriteBuffer;
    private boolean physicalDrive;
    private int CDDevice_no;
    private boolean running = false;
    private boolean stopRunning = false;
    private long nativeReaderPointer = -1L;
    private Thread redirThread;
    private String sourceCDROM = null;
    private int nBytesRedirected = 0;
    private static final int DEVICE_REDIRECTION_ACK = 241;
    private static final int AUTH_CMD = 242;
    private static final int CONNECTION_ACCEPTED = 1;
    private static final int MAX_READ_SECTORS = 64;
    private static final int MAX_READ_SIZE = 131072;
    private static final int MAX_READ_DATA_SIZE = 1024;
    private static final String IOERRMSG = "CDROM Redirection has lost connectivity to the host.\n Please check the Network connectivity or\n VMedia Devices Configuration could be modified. Retry after 2 Minutes.\n Closing the active media redirections\n";
    public boolean Ejectcdimage = false;
    public boolean ImageRedirectionCD = false;
    private vCDMonitorThread vMThread = null;
    private static Object syncObj = new Object();
    private boolean confModified = false;

    private native String[] listCDROMDrives();

    private native void newCDROMReader(boolean var1);

    private native void deleteCDROMReader();

    private native boolean openCDROM(byte[] var1);

    private native void closeCDROM();

    private native int executeCDROMSCSICmd(ByteBuffer var1, ByteBuffer var2);

    private native String getVersion();

    public CDROMRedir(boolean physicalDrive) {
        this.physicalDrive = physicalDrive;
        this.protocol = new CDROMProtocol();
        this.packetReadBuffer = ByteBuffer.allocateDirect(1024);
        this.packetWriteBuffer = ByteBuffer.allocateDirect(131134);
    }

    private void cdromConnect(String host, int port, boolean bVMUseSSL) throws IOException {
        this.packetMaster = new PacketMaster(host, port, false, this.protocol, bVMUseSSL);
        this.packetMaster.setupBuffers(this.packetReadBuffer, this.packetWriteBuffer);
        this.packetMaster.setBufferEndianness(ByteOrder.LITTLE_ENDIAN, ByteOrder.LITTLE_ENDIAN);
        this.packetMaster.connectVmedia(bVMUseSSL);
    }

    private void cdromDisconnect() {
        try {
            this.packetMaster.VmediaSockclose();
        }
        catch (IOException e) {
            System.err.println("Error closing CDROM connection: " + e.getMessage());
        }
    }

    public boolean startRedirection(String host, String cdromDrive, int cddevice_no, String token, int port, boolean bVMuseSSL) throws RedirectionException {
        block12: {
            if (this.running) {
                return true;
            }
            this.CDDevice_no = cddevice_no;
            try {
                this.cdromConnect(host, port, bVMuseSSL);
                this.SendAuth_SessionToken(token);
                IUSBSCSI request = this.recvRequest();
                if (request.opcode == 241) {
                    if (request.connectionStatus != 1) {
                        this.cdromDisconnect();
                        if (request.m_otherIP != null) {
                            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Virtual Media redirection", "Virtual Media Redirection is already in use.\nIf the client that is doing Virtual Media redirection has\nlost connectivity to the card, it may take upto 3 minutes\nfor the card to discard the old connection and\naccept a new connection.\nVirtual Media redirection is on from client with IP : " + request.m_otherIP);
                        }
                        return false;
                    }
                    break block12;
                }
                this.cdromDisconnect();
                throw new RedirProtocolException("Got unexpected opcode: " + request.opcode);
            }
            catch (IOException e) {
                Debug.out.println(e);
                throw new RedirectionException(e.getMessage());
            }
        }
        if (this.nativeReaderPointer == -1L) {
            this.newCDROMReader(this.physicalDrive);
        }
        this.sourceCDROM = cdromDrive;
        File Drive = new File(this.sourceCDROM);
        if (!this.physicalDrive && !Drive.exists()) {
            JViewerApp.getInstance().getMainWindow().generalErrorMessage("CDROM redirection", "Unable to open specified CD device. Unable to continue CD redirection.");
            this.deleteCDROMReader();
            this.cdromDisconnect();
            return false;
        }
        try {
            if (!this.openCDROM(cdromDrive.getBytes("UTF-8"))) {
                System.err.println("Cannot open CDROM!");
                this.deleteCDROMReader();
                this.cdromDisconnect();
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Path UTF-8 encoding error!");
        }
        JViewerApp.getInstance().getKVMClient().MediaRedirectionState((byte)1);
        this.nBytesRedirected = 0;
        this.redirThread = new Thread(this);
        this.redirThread.start();
        if (JViewerApp.getInstance().getM_IUSBSession().isCDROMPhysicalDrive(cddevice_no)) {
            this.vMThread = new vCDMonitorThread(this.CDDevice_no);
            this.vMThread.startCDROMMonitor();
        }
        this.running = true;
        return true;
    }

    public boolean stopRedirection() {
        if (this.running) {
            this.stopRunning = true;
            this.cdromDisconnect();
            try {
                this.redirThread.join();
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted while joining floppy thread");
            }
            JViewerApp.getInstance().getKVMClient().MediaRedirectionState((byte)0);
            this.running = false;
            this.stopRunning = false;
            this.closeCDROM();
            this.deleteCDROMReader();
        }
        this.nBytesRedirected = 0;
        return true;
    }

    private IUSBSCSI recvRequest() throws IOException, RedirectionException {
        return (IUSBSCSI)this.packetMaster.receivePacket();
    }

    public boolean isRedirActive() {
        return this.running;
    }

    public void stopRedirectionAbnormal() {
        if (this.running) {
            this.stopRunning = true;
            this.cdromDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeCDROM();
            this.deleteCDROMReader();
            JViewerApp.getInstance().reportCDROMAbnormal(this.CDDevice_no);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int nTempLen = 0;
        while (!this.stopRunning) {
            try {
                this.packetWriteBuffer.rewind();
                IUSBSCSI request = this.recvRequest();
                if (request == null) continue;
                int dataLen = this.executeCDROMSCSICmd(this.packetReadBuffer, this.packetWriteBuffer);
                this.packetWriteBuffer.limit(dataLen);
                if (request.opcode == 27 && request.Lba == 2) {
                    this.Ejectcdimage = true;
                }
                IUSBSCSI response = new IUSBSCSI(this.packetWriteBuffer, true);
                this.packetMaster.sendPacket(response);
                this.nBytesRedirected += (nTempLen += dataLen) / 1024;
                nTempLen %= 1024;
            }
            catch (IOException e) {
                if (this.stopRunning) continue;
                Object object = CDROMRedir.getSyncObj();
                synchronized (object) {
                    try {
                        CDROMRedir.getSyncObj().wait(10000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                if (!this.confModified) {
                    this.handleError(IOERRMSG);
                } else {
                    this.confModified = false;
                }
                this.stopRedirectionAbnormal();
                return;
            }
            catch (RedirectionException e) {
                if (this.stopRunning) continue;
                Object object = CDROMRedir.getSyncObj();
                synchronized (object) {
                    try {
                        CDROMRedir.getSyncObj().wait(10000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                if (!this.confModified) {
                    this.handleError(IOERRMSG);
                } else {
                    this.confModified = false;
                }
                this.stopRedirectionAbnormal();
                return;
            }
        }
        Debug.out.println("Exiting the CDROM/ISO Redirection thread");
    }

    public String[] getCDROMList() throws RedirectionException {
        if (!this.physicalDrive) {
            this.DisplayErrorMsg("Cannot get CDROM list from ISO redirection session");
            return null;
        }
        if (this.nativeReaderPointer == -1L) {
            this.newCDROMReader(true);
        }
        String[] cdromlist = this.listCDROMDrives();
        if (this.nativeReaderPointer == -1L) {
            this.deleteCDROMReader();
        }
        return cdromlist;
    }

    public String getLIBCDROMVersion() {
        String version;
        if (this.nativeReaderPointer == -1L) {
            this.newCDROMReader(false);
            version = this.getVersion();
            this.deleteCDROMReader();
        } else {
            version = this.getVersion();
        }
        return version;
    }

    public void DisplayErrorMsg(String str) {
        JViewerApp.getInstance().getMainWindow().generalErrorMessage("Device Redirection", str);
    }

    public void handleError(String str) {
        this.DisplayErrorMsg(str);
    }

    public String getSourceDrive() {
        return this.sourceCDROM;
    }

    public boolean isPhysicalDevice() {
        return this.physicalDrive;
    }

    public void SendAuth_SessionToken(String session_token) throws RedirectionException, IOException {
        int dataLen = 128;
        this.packetWriteBuffer.clear();
        this.packetWriteBuffer.limit(160);
        IUSBHeader AuthPktIUSBHeader = IUSBHeader.createCDROMHeader(dataLen);
        AuthPktIUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-14);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.put((byte)0);
        this.packetWriteBuffer.put(session_token.getBytes());
        this.packetWriteBuffer.position(23);
        this.packetWriteBuffer.put((byte)this.CDDevice_no);
        this.packetWriteBuffer.position(0);
        IUSBSCSI pkt = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(pkt);
    }

    public int getBytesRedirected() {
        return this.nBytesRedirected;
    }

    public static Object getSyncObj() {
        return syncObj;
    }

    public boolean isConfModified() {
        return this.confModified;
    }

    public void setConfModified(boolean confModified) {
        this.confModified = confModified;
    }

    static {
        try {
            if (!JViewer.isdownloadapp() && !JViewer.isplayerapp()) {
                if (JViewer.isStandalone()) {
                    SMCUtil.loadLib("javacdromwrapper");
                } else {
                    String jarPath = System.getProperty("os.name").startsWith("Windows") ? System.getProperty("user.dir") + "\\Jar\\" + JViewer.getIp() + "\\lib\\javacdromwrapper.dll" : (System.getProperty("os.name").startsWith("Linux") ? System.getProperty("user.dir") + "\\Jar\\" + JViewer.getIp() + "\\lib\\libjavacdromwrapper.so" : System.getProperty("user.dir") + "\\Jar\\" + JViewer.getIp() + "\\lib\\libjavacdromwrapper.jnilib");
                    System.load(jarPath);
                }
            }
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Cannot find cdrom wrapper library");
        }
        catch (IOException e) {
            System.err.println("Cannot find cdrom wrapper library");
        }
    }
}

