/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.FloppyProtocol;
import com.ami.iusb.protocol.IUSBHeader;
import com.ami.iusb.protocol.IUSBSCSI;
import com.ami.iusb.protocol.PacketMaster;
import com.ami.iusb.vFlpyMonitorThread;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import supermicro.jviewer.SMCUtil;

public class FloppyRedir
extends Thread {
    private PacketMaster packetMaster;
    private FloppyProtocol protocol;
    private ByteBuffer packetReadBuffer;
    private ByteBuffer packetWriteBuffer;
    private boolean physicalDevice;
    private int FDDevice_no;
    private boolean running = false;
    private boolean stopRunning = false;
    private long nativeReaderPointer = -1L;
    private Thread redirThread;
    private String sourceFloppy = null;
    private int nBytesRedirected = 0;
    private static final int DEVICE_REDIRECTION_ACK = 241;
    private static final int AUTH_CMD = 242;
    private static final int CONNECTION_ACCEPTED = 1;
    private static final int MAX_READ_SECTORS = 256;
    private static final int MAX_READ_SIZE = 131072;
    private static final String IOERRMSG = "Floppy Redirection has lost connectivity to the host.\n Please check the Network connectivity or\n VMedia Devices Configuration could be modified. Retry after 2 Minutes.\n Closing the active media redirections\n";
    public boolean ImageRedirectionfloppy = false;
    public boolean Ejectfloppyimage = false;
    private vFlpyMonitorThread vMThread = null;
    private static Object syncObj = new Object();
    private boolean confModified = false;

    private native String[] listFloppyDrives();

    private native void newFloppyReader(boolean var1);

    private native void deleteFloppyReader();

    private native boolean openFloppy(byte[] var1);

    private native void closeFloppy();

    private native int executeFloppySCSICmd(ByteBuffer var1, ByteBuffer var2);

    private native String GetKeyboardName();

    private native byte GetLEDStatus();

    private native String getVersion();

    public FloppyRedir(boolean physicalDevice) {
        this.physicalDevice = physicalDevice;
        this.protocol = new FloppyProtocol();
        this.packetReadBuffer = ByteBuffer.allocateDirect(131134);
        this.packetWriteBuffer = ByteBuffer.allocateDirect(131134);
    }

    private void floppyConnect(String host, int port, boolean bVMUseSSL) throws IOException {
        this.packetMaster = new PacketMaster(host, port, false, this.protocol, bVMUseSSL);
        this.packetMaster.setupBuffers(this.packetReadBuffer, this.packetWriteBuffer);
        this.packetMaster.setBufferEndianness(ByteOrder.LITTLE_ENDIAN, ByteOrder.LITTLE_ENDIAN);
        this.packetMaster.connectVmedia(bVMUseSSL);
    }

    private void floppyDisconnect() {
        try {
            this.packetMaster.VmediaSockclose();
        }
        catch (IOException e) {
            System.err.println("Error closing floppy connection: " + e.getMessage());
        }
    }

    public boolean startRedirection(String host, String floppyDrive, int device_no, String token, int port, boolean bVMuseSSL) throws RedirectionException {
        block11: {
            if (this.running) {
                return true;
            }
            this.FDDevice_no = device_no;
            try {
                this.floppyConnect(host, port, bVMuseSSL);
                this.SendAuth_SessionToken(token);
                IUSBSCSI request = this.recvRequest();
                if (request.opcode == 241) {
                    if (request.connectionStatus != 1) {
                        this.floppyDisconnect();
                        if (request.m_otherIP != null) {
                            JViewerApp.getInstance().getMainWindow().generalErrorMessage("Virtual Media redirection", "Virtual Media Redirection is already in use.\nIf the client that is doing Virtual Media redirection has\nlost connectivity to the card, it may take upto 3 minutes\nfor the card to discard the old connection and\naccept a new connection.\nVirtual Media redirection is on from client with IP : " + request.m_otherIP);
                        }
                        return false;
                    }
                    break block11;
                }
                this.floppyDisconnect();
                throw new RedirectionException("Got unexpected opcode: " + request.opcode);
            }
            catch (IOException e) {
                throw new RedirectionException(e.getMessage());
            }
        }
        if (this.nativeReaderPointer == -1L) {
            this.newFloppyReader(this.physicalDevice);
        }
        this.sourceFloppy = floppyDrive;
        try {
            if (!this.openFloppy(floppyDrive.getBytes("UTF-8"))) {
                System.err.println("Cannot open floppy!");
                this.deleteFloppyReader();
                this.floppyDisconnect();
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Path UTF-8 encoding error!");
        }
        JViewerApp.getInstance().getKVMClient().MediaRedirectionState((byte)1);
        this.nBytesRedirected = 0;
        this.redirThread = new Thread(this);
        this.redirThread.start();
        if (JViewerApp.getInstance().getM_IUSBSession().isFloppyPhysicalDrive(this.FDDevice_no)) {
            this.vMThread = new vFlpyMonitorThread(this.FDDevice_no);
            this.vMThread.startFloppyMonitor();
        }
        this.running = true;
        return true;
    }

    public boolean stopRedirection() {
        if (this.running) {
            this.stopRunning = true;
            this.floppyDisconnect();
            try {
                this.redirThread.join();
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted while joining floppy thread");
            }
            JViewerApp.getInstance().getKVMClient().MediaRedirectionState((byte)0);
            this.floppyDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeFloppy();
            this.deleteFloppyReader();
        }
        this.nBytesRedirected = 0;
        return true;
    }

    private IUSBSCSI recvRequest() throws IOException, RedirectionException {
        return (IUSBSCSI)this.packetMaster.receivePacket();
    }

    public boolean isRedirActive() {
        return this.running;
    }

    public String getSourceDrive() {
        return this.sourceFloppy;
    }

    public void stopRedirectionAbnormal() {
        if (this.running) {
            this.stopRunning = true;
            this.floppyDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeFloppy();
            this.deleteFloppyReader();
            JViewerApp.getInstance().reportFloppyAbnormal(this.FDDevice_no);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int nTempLen = 0;
        while (!this.stopRunning) {
            try {
                this.packetWriteBuffer.rewind();
                IUSBSCSI request = this.recvRequest();
                if (request == null) continue;
                int dataLen = this.executeFloppySCSICmd(this.packetReadBuffer, this.packetWriteBuffer);
                this.packetWriteBuffer.limit(dataLen);
                if (request.opcode == 27 && request.Lba == 2) {
                    this.Ejectfloppyimage = true;
                }
                IUSBSCSI response = new IUSBSCSI(this.packetWriteBuffer, true);
                this.packetMaster.sendPacket(response);
                this.nBytesRedirected += (nTempLen += dataLen) / 1024;
                nTempLen %= 1024;
            }
            catch (IOException e) {
                if (this.stopRunning) continue;
                Object object = FloppyRedir.getSyncObj();
                synchronized (object) {
                    try {
                        FloppyRedir.getSyncObj().wait(10000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                if (this.confModified) {
                    this.handleError(IOERRMSG);
                } else {
                    this.confModified = false;
                }
                this.stopRedirectionAbnormal();
                return;
            }
            catch (RedirectionException e) {
                if (this.stopRunning) continue;
                Object object = FloppyRedir.getSyncObj();
                synchronized (object) {
                    try {
                        FloppyRedir.getSyncObj().wait(10000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                if (this.confModified) {
                    this.handleError(IOERRMSG);
                } else {
                    this.confModified = false;
                }
                this.stopRedirectionAbnormal();
                return;
            }
        }
    }

    public String[] getFloppyList() {
        if (!this.physicalDevice) {
            this.DisplayErrorMsg("Cannot get Floppy drive list during Floppy IMAGE redirection");
            return null;
        }
        if (this.nativeReaderPointer == -1L) {
            this.newFloppyReader(true);
        }
        Object[] ListDrive_original = this.listFloppyDrives();
        String[] ListDrive_filter = null;
        if (ListDrive_original != null) {
            Arrays.sort(ListDrive_original);
            int k = 0;
            for (int i = 0; i < ListDrive_original.length; ++i) {
                if (i > 0 && ((String)ListDrive_original[i]).equals(ListDrive_original[i - 1])) continue;
                ListDrive_original[k++] = ListDrive_original[i];
            }
            ListDrive_filter = new String[k];
            System.arraycopy(ListDrive_original, 0, ListDrive_filter, 0, k);
        }
        return ListDrive_filter;
    }

    public String getLIBFLOPPYVersion() {
        String version;
        if (this.nativeReaderPointer == -1L) {
            this.newFloppyReader(false);
            version = this.getVersion();
            this.deleteFloppyReader();
        } else {
            version = this.getVersion();
        }
        return version;
    }

    public void DisplayErrorMsg(String str) {
        JViewerApp.getInstance().getMainWindow().generalErrorMessage("Device Redirection", str);
    }

    public void handleError(String str) {
        this.DisplayErrorMsg(str);
    }

    public boolean isPhysicalDevice() {
        return this.physicalDevice;
    }

    public void SendAuth_SessionToken(String session_token) throws RedirectionException, IOException {
        int dataLen = 128;
        this.packetWriteBuffer.clear();
        this.packetWriteBuffer.limit(160);
        IUSBHeader AuthPktIUSBHeader = IUSBHeader.createCDROMHeader(dataLen);
        AuthPktIUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-14);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.put((byte)0);
        this.packetWriteBuffer.put(session_token.getBytes());
        this.packetWriteBuffer.position(23);
        this.packetWriteBuffer.put((byte)this.FDDevice_no);
        this.packetWriteBuffer.position(0);
        IUSBSCSI pkt = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(pkt);
    }

    public byte ReadKeybdLEDStatus() {
        return this.GetLEDStatus();
    }

    public int getBytesRedirected() {
        return this.nBytesRedirected;
    }

    public static Object getSyncObj() {
        return syncObj;
    }

    public boolean isConfModified() {
        return this.confModified;
    }

    public void setConfModified(boolean confModified) {
        this.confModified = confModified;
    }

    public String ReadKeybdType() {
        return this.GetKeyboardName();
    }

    static {
        try {
            if (!JViewer.isdownloadapp() && !JViewer.isplayerapp()) {
                if (JViewer.isStandalone()) {
                    SMCUtil.loadLib("javafloppywrapper");
                } else {
                    String jarPath = System.getProperty("os.name").startsWith("Windows") ? System.getProperty("user.dir") + "\\Jar\\" + JViewer.getIp() + "\\lib\\javafloppywrapper.dll" : (System.getProperty("os.name").startsWith("Linux") ? System.getProperty("user.dir") + "\\Jar\\" + JViewer.getIp() + "\\lib\\libjavacdromwrapper.so" : System.getProperty("user.dir") + "\\Jar\\" + JViewer.getIp() + "\\lib\\libjavafloppywrapper.jnilib");
                    System.load(jarPath);
                }
            }
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Cannot find floppy wrapper library");
        }
        catch (IOException e) {
            System.err.println("Cannot find floppy wrapper library");
        }
    }
}

