/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.FSMenuBar;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.VideoRecord;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public abstract class JVFrame
extends JInternalFrame {
    protected JScrollPane m_viewSP;
    protected static String m_serverIP;
    private FSMenuBar m_fsMenuBr = new FSMenuBar();
    public JDialog videoStopError = null;

    public JVFrame() {
        super("KVM Remote Console", true, true, true, true);
    }

    public abstract JVMenu getMenu();

    public abstract void setStatus(String var1);

    public abstract void resetStatus();

    public abstract void exitApp();

    public abstract void setWndLabel(String var1);

    public abstract void refreshTitle();

    public static void setServerIP(byte[] servIP, int m_RedirectionState) {
        try {
            m_serverIP = servIP == null && m_RedirectionState == JViewerApp.REDIR_PAUSING ? "Video Rediretction Paused" : (servIP == null && m_RedirectionState == JViewerApp.REDIR_STOPPING ? "Video Rediretction Stopped" : (servIP == null && JViewer.isplayerapp() ? "Player" : (servIP == null && JViewer.isdownloadapp() ? "Download and Save" : InetAddress.getByAddress(servIP).getHostAddress())));
        }
        catch (UnknownHostException e) {
            m_serverIP = "Not connected";
        }
    }

    public static String getServerIP() {
        if (m_serverIP != null && !m_serverIP.equalsIgnoreCase(new String("Not connected"))) {
            return m_serverIP;
        }
        return null;
    }

    public void attachView() {
        this.m_viewSP = new JScrollPane(JViewerApp.getInstance().getRCView());
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        if (JViewer.isStandalone()) {
            JVFrame.setUndecorated(true, this);
        }
        if (JViewerApp.getInstance().isM_wndMode()) {
            this.m_viewSP.getHorizontalScrollBar().setUnitIncrement(10);
            this.m_viewSP.getVerticalScrollBar().setUnitIncrement(10);
            JViewerApp.getInstance().getMainWindow().getContentPane().add(this.m_viewSP);
            this.getContentPane().setMaximumSize(sd);
            if (JViewer.isStandalone()) {
                JViewer.getMainFrame().setExtendedState(6);
            }
            this.setVisible(true);
        }
        if (!JViewerApp.getInstance().isM_wndMode()) {
            if (JViewerApp.getInstance().getSocframeHdr().getresX() == sd.width) {
                this.m_viewSP.setHorizontalScrollBarPolicy(31);
            } else {
                this.m_viewSP.setHorizontalScrollBarPolicy(30);
            }
            if (JViewerApp.getInstance().getSocframeHdr().getresY() == sd.height) {
                this.m_viewSP.setVerticalScrollBarPolicy(21);
            } else {
                this.m_viewSP.setVerticalScrollBarPolicy(20);
            }
            JViewerApp.getInstance().getMainWindow().getContentPane().add(this.m_viewSP);
            if (JViewer.isStandalone()) {
                JViewer.getMainFrame().setExtendedState(6);
            }
            this.setVisible(true);
        }
    }

    public static void setUndecorated(boolean undecorated, JInternalFrame frame) {
        BasicInternalFrameUI ui = (BasicInternalFrameUI)frame.getUI();
        if (undecorated) {
            frame.putClientProperty("titlePane", ui.getNorthPane());
            frame.putClientProperty("border", frame.getBorder());
            ui.setNorthPane(null);
            frame.setBorder(null);
        }
    }

    public void detachView() {
        this.m_fsMenuBr.cancelTimer();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException ie) {
            Debug.out.println(ie);
        }
        this.getContentPane().remove(this.m_viewSP);
        this.dispose();
    }

    public boolean windowClosed() {
        if (JViewer.isdownloadapp() || JViewer.isplayerapp()) {
            JViewerApp.getInstance().getVideorecordapp().Ondeletetmpfile();
        }
        if (JViewerApp.getInstance().IsCDROMRedirRunning() || JViewerApp.getInstance().IsFloppyRedirRunning() || JViewerApp.getInstance().IsHarddiskRedirRunning()) {
            int ret = JOptionPane.showConfirmDialog(JViewer.getMainFrame(), "Virtual Media redirection is in use. Closing this window will cancel Virtual Media redirection.\nDo you want to continue?", "Confirm", 0);
            if (ret == -1) {
                return false;
            }
            if (ret == 1) {
                Debug.out.println("Returning false\n");
                return false;
            }
        }
        try {
            int h;
            for (h = 0; h < JViewerApp.getInstance().getM_cdNum(); ++h) {
                if (JViewerApp.getInstance().getUSBRedirSession().cdromSession[h] == null) continue;
                JViewerApp.getInstance().getUSBRedirSession().cdromSession[h].stopRedirection();
            }
            for (h = 0; h < JViewerApp.getInstance().getM_fdNum(); ++h) {
                if (JViewerApp.getInstance().getUSBRedirSession().floppySession[h] == null) continue;
                JViewerApp.getInstance().getUSBRedirSession().floppySession[h].stopRedirection();
            }
            for (h = 0; h < JViewerApp.getInstance().getM_hdNum(); ++h) {
                if (JViewerApp.getInstance().getUSBRedirSession().harddiskSession[h] == null) continue;
                JViewerApp.getInstance().getUSBRedirSession().harddiskSession[h].stopRedirection();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (JViewerApp.getInstance().getM_videorecord() != null) {
            if (VideoRecord.Recording_Started) {
                JViewerApp.getInstance().getM_videorecord().OnVideoRecordStop();
            }
            if (VideoRecord.Record_Processing) {
                if (JViewer.isdownloadapp()) {
                    JViewerApp.getInstance().getVideorecordapp().disposeInformationDialog();
                }
                this.showVideoStopError();
                while (VideoRecord.Record_Processing) {
                    this.videoStopError.setVisible(true);
                }
            }
        }
        try {
            JViewerApp.getInstance().OnVideoStopRedirection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (JViewer.isStandalone()) {
            System.exit(0);
        } else {
            JViewerApp.getInstance().getMainWindow().dispose();
        }
        return true;
    }

    public void generalErrorMessage(String title, String message) {
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    public JScrollPane getM_viewSP() {
        return this.m_viewSP;
    }

    public void setM_viewSP(JScrollPane m_viewsp) {
        this.m_viewSP = m_viewsp;
    }

    private void showVideoStopError() {
        if (this.videoStopError == null) {
            JFrame owner = JViewer.getMainFrame();
            this.videoStopError = new JDialog((Frame)owner, true);
            this.videoStopError.setUndecorated(true);
            this.videoStopError.setSize(550, 100);
            this.videoStopError.setLocationRelativeTo(owner);
            this.videoStopError.setTitle("Video Record");
            this.videoStopError.add(this.getVideoStopError());
            this.videoStopError.setVisible(true);
        }
    }

    private JPanel getVideoStopError() {
        JPanel msgPanel = new JPanel();
        msgPanel.setLayout(new FlowLayout(1, 2, 30));
        msgPanel.setSize(550, 100);
        JLabel errorMsg = new JLabel("Video recording under progress. JViewer will close automatically once the video file is created.");
        msgPanel.add(errorMsg);
        return msgPanel;
    }
}

