/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.AutoKeyboardLayout;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.hid.USBMouseRep;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.KeyStroke;

public abstract class JVMenu {
    public static boolean INITIAL_MENU_STATUS = true;
    public static final String VIDEO = "Video";
    public static final String VIDEO_PAUSE_REDIRECTION = "VideoPauseRedirection";
    public static final String VIDEO_RESUME_REDIRECTION = "VideoResumeRedirection";
    public static final String VIDEO_REFRESH = "VideoRefresh";
    public static final String VIDEO_FULL_SCREEN = "VideoFullScreen";
    public static final String VIDEO_EXIT = "VideoExit";
    public static final String KEYBOARD = "Keyboard";
    public static final String KEYBOARD_RIGHT_CTRL_KEY = "KeyboardHoldRightCtrlKey";
    public static final String KEYBOARD_RIGHT_ALT_KEY = "KeyboardHoldRightAltKey";
    public static final String KEYBOARD_LEFT_CTRL_KEY = "KeyboardHoldLeftCtrlKey";
    public static final String KEYBOARD_LEFT_ALT_KEY = "KeyboardHoldLeftAltKey";
    public static final String KEYBOARD_LEFT_WINKEY_PRESSHOLD = "KeyboardLeftWindowsKeyHoldDown";
    public static final String KEYBOARD_LEFT_WINKEY_PRESSRELEASE = "KeyboardLeftWindowsKeyPressRelease";
    public static final String KEYBOARD_RIGHT_WINKEY_PRESSHOLD = "KeyboardRightWindowsKeyHoldDown";
    public static final String KEYBOARD_RIGHT_WINKEY_PRESSRELEASE = "KeyboardRightWindowsKeyPressRelease";
    public static final String KEYBOARD_CTRL_ALT_DEL = "KeyboardCtrlAltDel";
    public static final String KEYBOARD_CONTEXT_MENU = "KeyboardContextMenu";
    public static final String AUTOMAIC_LANGUAGE = "Auto detect";
    public static final String KEYBOARD_LAYOUT = "Keyboard Layout";
    public static final String SOFTKEYBOARD = "SoftKeyboard";
    public static final String SKBRD_LANGUAGE_ENGLISH_US = "English(United States)";
    public static final String SKBRD_LANGUAGE_ENGLISH_UK = "English(United Kingdom)";
    public static final String SKBRD_LANGUAGE_SPANISH = "Spanish";
    public static final String SKBRD_LANGUAGE_FRENCH = "French";
    public static final String SKBRD_LANGUAGE_GERMAN_GER = "German(Germany)";
    public static final String SKBRD_LANGUAGE_ITALIAN = "Italian";
    public static final String SKBRD_LANGUAGE_DANISH = "Danish";
    public static final String SKBRD_LANGUAGE_FINNISH = "Finnish";
    public static final String SKBRD_LANGUAGE_GERMAN_SWITZ = "German(Switzerland)";
    public static final String SKBRD_LANGUAGE_NORWEGIAN_NOR = "Norwegian(Norway)";
    public static final String SKBRD_LANGUAGE_PORTUGUESE = "Portuguese(Portugal)";
    public static final String SKBRD_LANGUAGE_SWEDISH = "Swedish";
    public static final String SKBRD_LANGUAGE_HEBREW = "Hebrew";
    public static final String SKBRD_LANGUAGE_FRENCH_BELGIUM = "French(Belgium)";
    public static final String SKBRD_LANGUAGE_DUTCH = "Dutch";
    public static final String SKBRD_LANGUAGE_RUSSIAN = "Russian";
    public static final String SKBRD_LANGUAGE_JAPANESE = "Japanese";
    public static final int LANGUAGE_ENGLISH_US = 0;
    public static final int LANGUAGE_ENGLISH_UK = 1;
    public static final int LANGUAGE_SPANISH = 2;
    public static final int LANGUAGE_FRENCH = 3;
    public static final int LANGUAGE_GERMAN_GER = 4;
    public static final int LANGUAGE_ITALIAN = 5;
    public static final int LANGUAGE_DANISH = 6;
    public static final int LANGUAGE_FINNISH = 7;
    public static final int LANGUAGE_GERMAN_SWITZ = 8;
    public static final int LANGUAGE_NORWEGIAN_NOR = 9;
    public static final int LANGUAGE_PORTUGUESE = 10;
    public static final int LANGUAGE_SWEDISH = 11;
    public static final int LANGUAGE_HEBREW = 12;
    public static final int LANGUAGE_FRENCH_BELGIUM = 13;
    public static final int LANGUAGE_DUTCH = 14;
    public static final int LANGUAGE_RUSSIAN = 15;
    public static final int LANGUAGE_JAPANESE = 16;
    public static final byte RELATIVE_MODE = 1;
    public static final byte ABSOLUTE_MODE = 2;
    public static final String OPTION = "Options";
    public static final String MOUSE = "Mouse";
    public static final String MOUSE_CLIENTCURSOR_CONTROL = "MouseShowCursor";
    public static final String CALIBRATEMOUSETHRESHOLD = "Calibrate Mouse Threshold";
    public static final String MOUSE_MODE = "MouseMode";
    public static final String MOUSE_RELATIVE_MODE = "Relative";
    public static final String MOUSE_ABSOLUTE_MODE = "Absolute";
    public static final String OPTIONS_BANDWIDTH = "Bandwidth";
    public static final String OPTIONS_BANDWIDTH_AUTO_DETECT = "OptionsBandwidthAutoDetect";
    public static final String OPTIONS_BANDWIDTH_256KBPS = "OptionsBandwidth256Kbps";
    public static final String OPTIONS_BANDWIDTH_512KBPS = "OptionsBandwidth512Kbps";
    public static final String OPTIONS_BANDWIDTH_1MBPS = "OptionsBandwidth1Mbps";
    public static final String OPTIONS_BANDWIDTH_10MBPS = "OptionsBandwidth10Mbps";
    public static final String OPTIONS_BANDWIDTH_100MBPS = "OptionsBandwidth100Mbps";
    public static final String OPTIONS_KEYBOARD_MOUSE_ENCRYPTION = "OptionsKeyboardMouseEncryption";
    public static final String ZOOM = "Video Zoom";
    public static final String ZOOM_IN = "Zoom In";
    public static final String ZOOM_OUT = "Zoom Out";
    public static final String MEDIA = "Media";
    public static final String DEVICE_MEDIA_DIALOG = "DeviceMediaDialog";
    public static final String HELP_ABOUT_RCONSOLE = "HelpAboutJViewer";
    public static final String VIDEO_RECORD = "VideoRecord";
    public static final String VIDEO_RECORD_SETTINGS = "VideoRecordSettings";
    public static final String VIDEO_RECORD_START = "VideoRecordStart";
    public static final String VIDEO_RECORD_STOP = "VideoRecordStop";
    public static final String POWER_CONTROL = "Power";
    public static final String POWER_RESET_SERVER = "Reset Server";
    public static final String POWER_OFF_IMMEDIATE = "Immediate Shutdown";
    public static final String POWER_OFF_ORDERLY = "Orderly Shutdown";
    public static final String POWER_ON_SERVER = "Power On Server";
    public static final String POWER_CYCLE_SERVER = "Power Cycle Server";
    public JLabel menu_string;
    protected JVMenuListener m_menuListener = new JVMenuListener();
    protected static JVMenuStatusListener m_menuStatus = new JVMenuStatusListener();
    protected Hashtable<String, JMenuItem> m_menuItems = new Hashtable();
    protected Hashtable<String, JMenu> m_menu = new Hashtable();
    protected static Hashtable<String, Boolean> m_menuItems_setselected = new Hashtable();
    protected static Hashtable<String, Boolean> m_menuItems_setenabled = new Hashtable();
    protected static Hashtable<String, String> m_menustatusbar_text = new Hashtable();
    public static String previous_bandwidth = "OptionsBandwidth100Mbps";
    public static int m_mouseMode = USBMouseRep.ABSOLUTE_MOUSE_MODE;
    public AutoKeyboardLayout autokeylayout;
    protected static JComboBox combo;
    public JSlider slider;
    public JLabel label_size;
    public JLabel label_Text;
    public static double m_scale;
    public static int keyBoardLayout;

    public JMenuItem getMenuItem(String name) {
        return this.m_menuItems.get(name);
    }

    public JMenu getMenu(String name) {
        return this.m_menu.get(name);
    }

    public Boolean getMenuEnable(String name) {
        return m_menuItems_setenabled.get(name);
    }

    public Boolean SetMenuEnable(String name, Boolean state) {
        return m_menuItems_setenabled.put(name, state);
    }

    public Boolean getMenuSelected(String name) {
        return m_menuItems_setselected.get(name);
    }

    public Boolean SetMenuSelected(String name, Boolean state) {
        return m_menuItems_setselected.put(name, state);
    }

    public void notifyMenuStateEnable(String name, boolean redir) {
        if (this.getMenuItem(name) != null) {
            this.getMenuItem(name).setEnabled(redir);
            this.SetMenuEnable(name, redir);
        }
    }

    public void notifyMenuEnable(String name, boolean redir) {
        this.getMenu(name).setEnabled(redir);
        this.SetMenuEnable(name, redir);
    }

    public void notifyMenuStateSelected(String name, boolean redir) {
        this.getMenuItem(name).setSelected(redir);
        this.SetMenuSelected(name, redir);
    }

    public void notifyMouseMode(int mousemode) {
        if (mousemode == USBMouseRep.RELATIVE_MOUSE_MODE) {
            JViewerApp.getInstance().getJVMenu().getMenuItem(CALIBRATEMOUSETHRESHOLD).setEnabled(true);
        } else {
            JViewerApp.getInstance().getJVMenu().getMenuItem(CALIBRATEMOUSETHRESHOLD).setEnabled(false);
        }
    }

    public void refreshMenu() {
        Boolean state;
        Map.Entry<String, Boolean> me;
        Set<Map.Entry<String, Boolean>> st = m_menuItems_setselected.entrySet();
        Iterator<Map.Entry<String, Boolean>> itr = st.iterator();
        Set<Map.Entry<String, Boolean>> st2 = m_menuItems_setenabled.entrySet();
        Iterator<Map.Entry<String, Boolean>> itr2 = st2.iterator();
        String keyvalue = null;
        boolean state_bool = false;
        while (itr.hasNext()) {
            try {
                me = itr.next();
                keyvalue = me.getKey();
                state = me.getValue();
                state_bool = state;
            }
            catch (Exception e) {
                Debug.out.println(e);
            }
            this.notifyMenuStateSelected(keyvalue, state_bool);
        }
        while (itr2.hasNext()) {
            try {
                me = itr2.next();
                keyvalue = me.getKey();
                state = me.getValue();
                state_bool = state;
            }
            catch (Exception e) {
                Debug.out.println(e);
            }
            try {
                this.notifyMenuStateEnable(keyvalue, state_bool);
            }
            catch (Exception e) {
                this.notifyMenuEnable(keyvalue, state_bool);
            }
        }
    }

    public void enableMenu(String[] except_menu, boolean menu_state) {
        Set<Map.Entry<String, Boolean>> st = m_menuItems_setenabled.entrySet();
        Iterator<Map.Entry<String, Boolean>> itr = st.iterator();
        String keyvalue = null;
        boolean state_bool = false;
        boolean match = false;
        while (itr.hasNext()) {
            try {
                Map.Entry<String, Boolean> me = itr.next();
                keyvalue = me.getKey();
                Boolean state = me.getValue();
                state_bool = state;
            }
            catch (Exception e) {
                Debug.out.println(e);
            }
            try {
                state_bool = menu_state;
                match = false;
                for (int index = 0; index < except_menu.length; ++index) {
                    if (!keyvalue.equals(except_menu[index])) continue;
                    match = true;
                }
                if (match) continue;
                this.notifyMenuStateEnable(keyvalue, state_bool);
            }
            catch (Exception e) {
                this.notifyMenuEnable(keyvalue, state_bool);
            }
        }
    }

    private JMenuItem createMenuItem(String menuName, char mnemonic, int keyCode, int modifiers, String actionCommand, String status) {
        JMenuItem menuItem = new JMenuItem(menuName);
        menuItem.addActionListener(this.m_menuListener);
        menuItem.addMouseListener(m_menuStatus);
        if (mnemonic != ' ') {
            menuItem.setMnemonic(mnemonic);
        }
        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyCode, modifiers));
        menuItem.setActionCommand(actionCommand);
        this.m_menuItems.put(actionCommand, menuItem);
        m_menustatusbar_text.put(actionCommand, status);
        if (INITIAL_MENU_STATUS) {
            m_menuItems_setenabled.put(actionCommand, true);
        }
        return menuItem;
    }

    private JMenuItem createMenuItem(String menuName, char mnemonic, String actionCommand, String status) {
        JMenuItem menuItem = new JMenuItem(menuName);
        menuItem.addActionListener(this.m_menuListener);
        menuItem.addMouseListener(m_menuStatus);
        if (mnemonic != ' ') {
            menuItem.setMnemonic(mnemonic);
        }
        menuItem.setActionCommand(actionCommand);
        this.m_menuItems.put(actionCommand, menuItem);
        m_menustatusbar_text.put(actionCommand, status);
        if (INITIAL_MENU_STATUS) {
            m_menuItems_setenabled.put(actionCommand, true);
        }
        return menuItem;
    }

    private JMenuItem createMenuItem(String menuName, char mnemonic, String actionCommand, String status, boolean state) {
        JMenuItem menuItem = new JMenuItem(menuName);
        menuItem.addActionListener(this.m_menuListener);
        menuItem.addMouseListener(m_menuStatus);
        if (mnemonic != ' ') {
            menuItem.setMnemonic(mnemonic);
        }
        menuItem.setActionCommand(actionCommand);
        menuItem.setEnabled(state);
        this.m_menuItems.put(actionCommand, menuItem);
        m_menustatusbar_text.put(actionCommand, status);
        return menuItem;
    }

    private JCheckBoxMenuItem createCheckBocMenuItem(String menuName, char mnemonic, int keyCode, int modifiers, String actionCommand, String status) {
        JCheckBoxMenuItem checkBoxMenuItem = new JCheckBoxMenuItem(menuName);
        checkBoxMenuItem.addActionListener(this.m_menuListener);
        checkBoxMenuItem.addMouseListener(m_menuStatus);
        if (mnemonic != ' ') {
            checkBoxMenuItem.setMnemonic(mnemonic);
        }
        checkBoxMenuItem.setActionCommand(actionCommand);
        checkBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(keyCode, modifiers));
        this.m_menuItems.put(actionCommand, checkBoxMenuItem);
        m_menustatusbar_text.put(actionCommand, status);
        if (INITIAL_MENU_STATUS) {
            m_menuItems_setselected.put(actionCommand, false);
            m_menuItems_setenabled.put(actionCommand, true);
        }
        return checkBoxMenuItem;
    }

    private JCheckBoxMenuItem createCheckBoxMenuItem(String menuName, char mnemonic, String actionCommand, String status) {
        JCheckBoxMenuItem checkBoxMenuItem = new JCheckBoxMenuItem(menuName);
        checkBoxMenuItem.addActionListener(this.m_menuListener);
        checkBoxMenuItem.addMouseListener(m_menuStatus);
        if (mnemonic != ' ') {
            checkBoxMenuItem.setMnemonic(mnemonic);
        }
        checkBoxMenuItem.setActionCommand(actionCommand);
        this.m_menuItems.put(actionCommand, checkBoxMenuItem);
        m_menustatusbar_text.put(actionCommand, status);
        if (INITIAL_MENU_STATUS) {
            m_menuItems_setselected.put(actionCommand, false);
            m_menuItems_setenabled.put(actionCommand, true);
        }
        return checkBoxMenuItem;
    }

    private JRadioButtonMenuItem createRadioButtonMenu(String menuName, String actionCommand, String status) {
        JRadioButtonMenuItem radioButtonMenu = new JRadioButtonMenuItem(menuName);
        radioButtonMenu.addActionListener(this.m_menuListener);
        radioButtonMenu.addMouseListener(m_menuStatus);
        radioButtonMenu.setActionCommand(actionCommand);
        this.m_menuItems.put(actionCommand, radioButtonMenu);
        m_menustatusbar_text.put(actionCommand, status);
        if (INITIAL_MENU_STATUS) {
            m_menuItems_setselected.put(actionCommand, false);
            m_menuItems_setenabled.put(actionCommand, true);
        }
        return radioButtonMenu;
    }

    protected JMenu constructVideoMenu() {
        JMenu menu = new JMenu(VIDEO);
        menu.addMouseListener(m_menuStatus);
        menu.setMnemonic('V');
        this.m_menu.put(VIDEO, menu);
        m_menustatusbar_text.put(VIDEO, "Video commands");
        JMenuItem menuItem = this.createMenuItem("Pause Redirection", 'P', 80, 8, VIDEO_PAUSE_REDIRECTION, "Pause Video Redirection");
        menu.add(menuItem);
        menuItem = this.createMenuItem("Resume Redirection", 'R', 82, 8, VIDEO_RESUME_REDIRECTION, "Resume video redirection");
        menu.add(menuItem);
        menuItem = this.createMenuItem("Refresh Video", 'e', 69, 8, VIDEO_REFRESH, "Refresh video redirection");
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = this.createCheckBocMenuItem("Full Screen", 'F', 70, 8, VIDEO_FULL_SCREEN, "Change to full screen or regular mode");
        if (JViewer.isStandalone()) {
            menu.add(menuItem);
        }
        menuItem.setEnabled(false);
        menu.addSeparator();
        menuItem = this.createMenuItem("Exit", ' ', VIDEO_EXIT, "Exit KVM remote console");
        menu.add(menuItem);
        return menu;
    }

    protected JMenu constructKeyboardMenu() {
        JMenu menu = new JMenu(KEYBOARD);
        menu.addMouseListener(m_menuStatus);
        m_menustatusbar_text.put(KEYBOARD, "Keyboard commands");
        menu.setMnemonic('K');
        this.m_menu.put(KEYBOARD, menu);
        JMenuItem menuItem = this.createCheckBoxMenuItem("Hold Right Ctrl Key", 'C', KEYBOARD_RIGHT_CTRL_KEY, "Hold down right control key");
        menu.add(menuItem);
        menuItem = this.createCheckBoxMenuItem("Hold Right Alt Key", 'A', KEYBOARD_RIGHT_ALT_KEY, "Hold down right alt key");
        menu.add(menuItem);
        menuItem = this.createCheckBoxMenuItem("Hold Left Ctrl Key", 't', KEYBOARD_LEFT_CTRL_KEY, "Hold down left control key");
        menuItem.setDisplayedMnemonicIndex(11);
        menu.add(menuItem);
        menuItem = this.createCheckBoxMenuItem("Hold Left Alt Key", 'l', KEYBOARD_LEFT_ALT_KEY, "Hold down left alt key");
        menuItem.setDisplayedMnemonicIndex(11);
        menu.add(menuItem);
        menu.addSeparator();
        JMenu subMenu = new JMenu("Left Windows Key");
        subMenu.addMouseListener(m_menuStatus);
        menuItem = this.createCheckBoxMenuItem("Hold Down", ' ', KEYBOARD_LEFT_WINKEY_PRESSHOLD, "Hold down left windows key");
        subMenu.add(menuItem);
        menuItem = this.createMenuItem("Press and Release", ' ', KEYBOARD_LEFT_WINKEY_PRESSRELEASE, "Press and release left windows key");
        subMenu.add(menuItem);
        menu.add(subMenu);
        subMenu = new JMenu("Right Windows Key");
        subMenu.addMouseListener(m_menuStatus);
        menuItem = this.createCheckBoxMenuItem("Hold Down", ' ', KEYBOARD_RIGHT_WINKEY_PRESSHOLD, "Hold down right windows key");
        subMenu.add(menuItem);
        menuItem = this.createMenuItem("Press and Release", ' ', KEYBOARD_RIGHT_WINKEY_PRESSRELEASE, "Press and release right windows key");
        subMenu.add(menuItem);
        menu.add(subMenu);
        menuItem = this.createMenuItem("Ctrl+Alt+Del", ' ', KEYBOARD_CTRL_ALT_DEL, "Press Alt + Ctrl + Del key combination");
        menu.add(menuItem);
        menuItem = this.createMenuItem("Context Menu", ' ', KEYBOARD_CONTEXT_MENU, "Press Context Menu key Event");
        menu.add(menuItem);
        return menu;
    }

    protected JMenu constructMouseMenu() {
        JMenu menu = new JMenu(MOUSE);
        this.m_menu.put(MOUSE, menu);
        menu.addMouseListener(m_menuStatus);
        m_menustatusbar_text.put(MOUSE, "Mouse commands");
        menu.setMnemonic('u');
        JMenuItem menuItem = this.createCheckBocMenuItem("Show Cursor", ' ', 67, 8, MOUSE_CLIENTCURSOR_CONTROL, "Show mouse cursor");
        menu.add(menuItem);
        menuItem = this.createCheckBocMenuItem("Mouse Calibration", ' ', 84, 8, CALIBRATEMOUSETHRESHOLD, "Caliberating the Mouse");
        menu.add(menuItem);
        JMenu subMenu = new JMenu(MOUSE_MODE);
        subMenu.addMouseListener(m_menuStatus);
        ButtonGroup group = new ButtonGroup();
        menuItem = this.createRadioButtonMenu("Absolute mouse mode", MOUSE_ABSOLUTE_MODE, "Select absolute mouse mode");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu("Relative mouse mode", MOUSE_RELATIVE_MODE, "Select relative mouse mode ");
        group.add(menuItem);
        subMenu.add(menuItem);
        menu.add(subMenu);
        return menu;
    }

    protected JMenu constructOptionsMenu() {
        JMenu menu = new JMenu(OPTION);
        menu.addMouseListener(m_menuStatus);
        this.m_menu.put(OPTION, menu);
        m_menustatusbar_text.put(OPTION, "Options setting");
        menu.setMnemonic('O');
        JMenu subMenu = new JMenu(OPTIONS_BANDWIDTH);
        subMenu.addMouseListener(m_menuStatus);
        m_menustatusbar_text.put(OPTIONS_BANDWIDTH, "Bandwidth selection");
        this.m_menu.put(OPTIONS_BANDWIDTH, subMenu);
        JMenuItem menuItem = this.createMenuItem("Auto Detect", ' ', OPTIONS_BANDWIDTH_AUTO_DETECT, "Auto detect bandwidth");
        subMenu.add(menuItem);
        subMenu.addSeparator();
        ButtonGroup group = new ButtonGroup();
        menuItem = this.createRadioButtonMenu("256 Kbps", OPTIONS_BANDWIDTH_256KBPS, "Select 256 Kbps bandwidth");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu("512 Kbps", OPTIONS_BANDWIDTH_512KBPS, "Select 512 Kbps bandwidth");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu("1 Mbps", OPTIONS_BANDWIDTH_1MBPS, "Select 1 Mbps bandwidth");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu("10 Mbps", OPTIONS_BANDWIDTH_10MBPS, "Select 10 Mbps bandwidth");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu("100 Mbps", OPTIONS_BANDWIDTH_100MBPS, "Select 100 Mbps bandwidth");
        group.add(menuItem);
        subMenu.add(menuItem);
        menu.add(subMenu);
        menuItem = this.createCheckBoxMenuItem("Keyboard/Mouse Encryption", ' ', OPTIONS_KEYBOARD_MOUSE_ENCRYPTION, "Enable/disable keyboard/mouse messages encryption");
        menu.add(menuItem);
        subMenu = new JMenu("Zoom");
        subMenu.addMouseListener(m_menuStatus);
        m_menustatusbar_text.put("Zoom", "Video Zooming");
        this.m_menu.put(ZOOM, subMenu);
        menuItem = this.createMenuItem(ZOOM_IN, ' ', ZOOM_IN, "Press to Zoom In the Video");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createMenuItem(ZOOM_OUT, ' ', ZOOM_OUT, "Press to Zoom out the Video");
        group.add(menuItem);
        subMenu.add(menuItem);
        menu.add(subMenu);
        return menu;
    }

    protected JMenu constructDeviceRedirMenu() {
        JMenu menu = new JMenu(MEDIA);
        menu.addMouseListener(m_menuStatus);
        menu.setMnemonic('d');
        this.m_menu.put(MEDIA, menu);
        m_menustatusbar_text.put(MEDIA, "Redirecting the Devices From client to host");
        JMenuItem menuItem = this.createMenuItem("Virtual Media Wizard...", 'V', DEVICE_MEDIA_DIALOG, "Redirecting the Devices CD/FD/HD to host");
        menu.add(menuItem);
        return menu;
    }

    protected JMenu constructHelpMenu() {
        JMenu menu = new JMenu("Help");
        menu.setMnemonic('H');
        menu.addMouseListener(m_menuStatus);
        this.m_menu.put(HELP_ABOUT_RCONSOLE, menu);
        m_menustatusbar_text.put("Help", "About KVM Remote Console application");
        JMenuItem menuItem = this.createMenuItem("About JViewer...", ' ', 112, 2, HELP_ABOUT_RCONSOLE, "About KVM Remote Console application");
        menu.add(menuItem);
        return menu;
    }

    protected JMenu constructSoftKeyboardMenu() {
        JMenu menu = new JMenu(KEYBOARD_LAYOUT);
        menu.setMnemonic('L');
        menu.addMouseListener(m_menuStatus);
        this.m_menu.put(KEYBOARD_LAYOUT, menu);
        m_menustatusbar_text.put(KEYBOARD_LAYOUT, "Select required keyboard layouts");
        JMenuItem menuItem = this.createCheckBoxMenuItem("Auto Detect", ' ', AUTOMAIC_LANGUAGE, "Auto detect the client system keyboard ");
        menu.add(menuItem);
        JMenu subMenu = new JMenu(SOFTKEYBOARD);
        subMenu.addActionListener(this.m_menuListener);
        subMenu.addMouseListener(m_menuStatus);
        this.m_menu.put(SOFTKEYBOARD, subMenu);
        m_menustatusbar_text.put(SOFTKEYBOARD, "Softkeyboard");
        ButtonGroup group = new ButtonGroup();
        if (INITIAL_MENU_STATUS) {
            m_menuItems_setenabled.put(SOFTKEYBOARD, true);
        }
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_ENGLISH_US, SKBRD_LANGUAGE_ENGLISH_US, "Invoke the English(US) softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu("English(UKingdom)", SKBRD_LANGUAGE_ENGLISH_UK, "Invoke the English(UK) softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_SPANISH, SKBRD_LANGUAGE_SPANISH, "Invoke the Spanish softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_FRENCH, SKBRD_LANGUAGE_FRENCH, "Invoke the French softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_GERMAN_GER, SKBRD_LANGUAGE_GERMAN_GER, "Invoke the Germany softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_ITALIAN, SKBRD_LANGUAGE_ITALIAN, "Invoke the Italian softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_DANISH, SKBRD_LANGUAGE_DANISH, "Invoke the Danish softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_FINNISH, SKBRD_LANGUAGE_FINNISH, "Invoke the Finnish softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_GERMAN_SWITZ, SKBRD_LANGUAGE_GERMAN_SWITZ, "Invoke the German softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_NORWEGIAN_NOR, SKBRD_LANGUAGE_NORWEGIAN_NOR, "Invoke the Norwegian softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_PORTUGUESE, SKBRD_LANGUAGE_PORTUGUESE, "Invoke the Portuguese softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_SWEDISH, SKBRD_LANGUAGE_SWEDISH, "Invoke the Swedish softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_HEBREW, SKBRD_LANGUAGE_HEBREW, "Invoke the Herbrew softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_FRENCH_BELGIUM, SKBRD_LANGUAGE_FRENCH_BELGIUM, "Invoke the French(Belgium) softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu("Dutch(Belgium)", SKBRD_LANGUAGE_DUTCH, "Invoke the Dutch softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu("Russian(Rusia)", SKBRD_LANGUAGE_RUSSIAN, "Invoke the Russian softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menuItem = this.createRadioButtonMenu(SKBRD_LANGUAGE_JAPANESE, SKBRD_LANGUAGE_JAPANESE, "Invoke the Japanese softkeyboard layout");
        group.add(menuItem);
        subMenu.add(menuItem);
        menu.add(subMenu);
        return menu;
    }

    protected JMenu constructVideoRecordMenu() {
        JMenu menu = new JMenu(VIDEO_RECORD);
        menu.addMouseListener(m_menuStatus);
        menu.setMnemonic('i');
        this.m_menu.put(VIDEO_RECORD, menu);
        m_menustatusbar_text.put(VIDEO_RECORD, "Video recording options");
        JMenuItem menuItem = this.createMenuItem("Start Record", ' ', VIDEO_RECORD_START, "Start video recording", false);
        menu.add(menuItem);
        menuItem = this.createMenuItem("Stop Record", ' ', VIDEO_RECORD_STOP, "Stop video recording", false);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = this.createMenuItem("Settings", ' ', VIDEO_RECORD_SETTINGS, "Vedio record settings");
        menu.add(menuItem);
        return menu;
    }

    protected JMenu constructPowerMenu() {
        JMenu menu = new JMenu(POWER_CONTROL);
        menu.addMouseListener(m_menuStatus);
        menu.setMnemonic('w');
        this.m_menu.put(POWER_CONTROL, menu);
        m_menustatusbar_text.put(POWER_CONTROL, "Server power control");
        JMenuItem menuItem = this.createMenuItem(POWER_RESET_SERVER, ' ', POWER_RESET_SERVER, POWER_RESET_SERVER);
        menu.add(menuItem);
        menuItem = this.createMenuItem(POWER_OFF_IMMEDIATE, ' ', POWER_OFF_IMMEDIATE, "Immediate shutdown");
        menu.add(menuItem);
        menuItem = this.createMenuItem(POWER_OFF_ORDERLY, ' ', POWER_OFF_ORDERLY, "Orderly shutdown");
        menu.add(menuItem);
        menuItem = this.createMenuItem(POWER_ON_SERVER, ' ', POWER_ON_SERVER, "Power On server");
        menu.add(menuItem);
        menuItem = this.createMenuItem(POWER_CYCLE_SERVER, ' ', POWER_CYCLE_SERVER, POWER_CYCLE_SERVER);
        menu.add(menuItem);
        return menu;
    }

    protected JLabel constructZoomLabelText() {
        this.label_Text = new JLabel("Zoom Size : 100%");
        return this.label_Text;
    }

    public Hashtable<String, JMenuItem> getM_menuItems() {
        return this.m_menuItems;
    }

    public void setM_menuItems(Hashtable<String, JMenuItem> items) {
        this.m_menuItems = items;
    }

    protected JLabel constructString() {
        this.menu_string = null;
        this.menu_string = new JLabel();
        this.menu_string.setVisible(true);
        return this.menu_string;
    }

    protected int RemoveString() {
        this.menu_string = null;
        return 0;
    }

    public AutoKeyboardLayout getAutokeylayout() {
        return this.autokeylayout;
    }

    public void setAutokeylayout(AutoKeyboardLayout autokeylayout) {
        this.autokeylayout = autokeylayout;
    }

    public Hashtable<String, JMenu> getM_menu() {
        return this.m_menu;
    }

    public void setM_menu(Hashtable<String, JMenu> m_menu) {
        this.m_menu = m_menu;
    }

    static {
        m_scale = 1.0;
        keyBoardLayout = -1;
    }

    private static class JVMenuStatusListener
    extends MouseAdapter {
        private JVMenuStatusListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            String menuBarLabel;
            try {
                JMenu evtSrcItem = (JMenu)e.getSource();
                menuBarLabel = evtSrcItem.getText();
            }
            catch (Exception ex) {
                menuBarLabel = ((JMenuItem)e.getSource()).getActionCommand();
            }
            JViewerApp RCApp = JViewerApp.getInstance();
            String test = m_menustatusbar_text.get(menuBarLabel);
            RCApp.setStatus(test);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JViewerApp.getInstance().resetStatus();
        }
    }

    private class JVMenuListener
    implements ActionListener {
        private JVMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmdStr = e.getActionCommand();
            JViewerApp RCApp = JViewerApp.getInstance();
            if (cmdStr.equals(JVMenu.VIDEO_PAUSE_REDIRECTION)) {
                RCApp.setM_userPause(true);
                RCApp.OnVideoPauseRedirection();
            } else if (cmdStr.equals(JVMenu.VIDEO_RESUME_REDIRECTION)) {
                RCApp.OnVideoResumeRedirection();
            } else if (cmdStr.equals(JVMenu.VIDEO_REFRESH)) {
                RCApp.OnVideoRefreshRedirection();
            } else if (cmdStr.equals(JVMenu.VIDEO_FULL_SCREEN)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                RCApp.OnVideoFullScreen(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.VIDEO_EXIT)) {
                RCApp.OnVideoExit();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_RIGHT_CTRL_KEY)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                RCApp.OnKeyboardHoldRightCtrlKey(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.KEYBOARD_RIGHT_ALT_KEY)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                RCApp.OnKeyboardHoldRightAltKey(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.KEYBOARD_LEFT_CTRL_KEY)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                RCApp.OnKeyboardHoldLeftCtrlKey(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.KEYBOARD_LEFT_ALT_KEY)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                RCApp.OnKeyboardHoldLeftAltKey(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.KEYBOARD_LEFT_WINKEY_PRESSHOLD)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                RCApp.OnKeyboardLeftWindowsKeyHoldDown(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.KEYBOARD_LEFT_WINKEY_PRESSRELEASE)) {
                RCApp.OnKeyboardLeftWindowsKeyPressRelease();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_RIGHT_WINKEY_PRESSHOLD)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                RCApp.OnKeyboardRightWindowsKeyHoldDown(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.KEYBOARD_RIGHT_WINKEY_PRESSRELEASE)) {
                RCApp.OnKeyboardRightWindowsKeyPressRelease();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_CTRL_ALT_DEL)) {
                if ((RCApp.getJVMenu().getMenuSelected(JVMenu.KEYBOARD_LEFT_CTRL_KEY).booleanValue() || RCApp.getJVMenu().getMenuSelected(JVMenu.KEYBOARD_RIGHT_CTRL_KEY).booleanValue()) && (RCApp.getJVMenu().getMenuSelected(JVMenu.KEYBOARD_LEFT_ALT_KEY).booleanValue() || RCApp.getJVMenu().getMenuSelected(JVMenu.KEYBOARD_RIGHT_ALT_KEY).booleanValue())) {
                    return;
                }
                RCApp.OnKeyboardAltCtrlDel();
            } else if (cmdStr.equals(JVMenu.KEYBOARD_CONTEXT_MENU)) {
                RCApp.OnKeyboardContextMenu();
            } else if (cmdStr.equals(JVMenu.MOUSE_CLIENTCURSOR_CONTROL)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                RCApp.OnShowCursor(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.CALIBRATEMOUSETHRESHOLD)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                if (JViewerApp.getInstance().GetRedirectionState() == JViewerApp.REDIR_STARTED) {
                    RCApp.OnCalibareteMouse(evtSrc.getState());
                } else {
                    JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected(JVMenu.CALIBRATEMOUSETHRESHOLD, false);
                }
            } else if (cmdStr.equals(JVMenu.MOUSE_ABSOLUTE_MODE)) {
                if (m_mouseMode != 2) {
                    RCApp.OnSendMouseMode((byte)2);
                }
            } else if (cmdStr.equals(JVMenu.MOUSE_RELATIVE_MODE)) {
                if (m_mouseMode != 1) {
                    RCApp.OnSendMouseMode((byte)1);
                }
            } else if (cmdStr.equals(JVMenu.OPTIONS_BANDWIDTH_AUTO_DETECT)) {
                RCApp.OnOptionsBandwidthAutoDetect();
            } else if (cmdStr.equals(JVMenu.OPTIONS_BANDWIDTH_256KBPS)) {
                RCApp.OnOptionsBandwidth(32768);
            } else if (cmdStr.equals(JVMenu.OPTIONS_BANDWIDTH_512KBPS)) {
                RCApp.OnOptionsBandwidth(65536);
            } else if (cmdStr.equals(JVMenu.OPTIONS_BANDWIDTH_1MBPS)) {
                RCApp.OnOptionsBandwidth(131072);
            } else if (cmdStr.equals(JVMenu.OPTIONS_BANDWIDTH_10MBPS)) {
                RCApp.OnOptionsBandwidth(0x140000);
            } else if (cmdStr.equals(JVMenu.OPTIONS_BANDWIDTH_100MBPS)) {
                RCApp.OnOptionsBandwidth(0xC80000);
            } else if (cmdStr.equals(JVMenu.OPTIONS_KEYBOARD_MOUSE_ENCRYPTION)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                RCApp.OnOptionsKeyboardMouseEncryption(evtSrc.getState());
            } else if (cmdStr.equals(JVMenu.HELP_ABOUT_RCONSOLE)) {
                RCApp.OnHelpAboutJViewer();
            } else if (cmdStr.equals(JVMenu.DEVICE_MEDIA_DIALOG)) {
                RCApp.OnvMedia();
            } else if (cmdStr.equals(JVMenu.AUTOMAIC_LANGUAGE)) {
                JCheckBoxMenuItem evtSrc = (JCheckBoxMenuItem)e.getSource();
                if (evtSrc.getState()) {
                    keyBoardLayout *= -1;
                    JVMenu.this.autokeylayout = new AutoKeyboardLayout();
                    JVMenu.this.getMenu(JVMenu.SOFTKEYBOARD).setEnabled(false);
                    JVMenu.this.notifyMenuStateSelected(JVMenu.AUTOMAIC_LANGUAGE, true);
                    JVMenu.this.SetMenuEnable(JVMenu.SOFTKEYBOARD, false);
                    m_menuItems_setenabled.put(JVMenu.SOFTKEYBOARD, false);
                    RCApp.OnSkbrdDisplay(-1);
                } else {
                    if (keyBoardLayout != -1) {
                        keyBoardLayout *= -1;
                    }
                    JVMenu.this.getMenu(JVMenu.SOFTKEYBOARD).setEnabled(true);
                    JVMenu.this.autokeylayout = null;
                    JVMenu.this.notifyMenuStateSelected(JVMenu.AUTOMAIC_LANGUAGE, false);
                    JVMenu.this.SetMenuEnable(JVMenu.SOFTKEYBOARD, true);
                    m_menuItems_setenabled.put(JVMenu.SOFTKEYBOARD, true);
                    JViewerApp.getInstance().getM_USBKeyRep().setM_USBKeyProcessor(JViewerApp.getInstance().getKeyprocesssor());
                }
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_ENGLISH_US)) {
                RCApp.OnSkbrdDisplay(0);
                keyBoardLayout = 0;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_ENGLISH_UK)) {
                RCApp.OnSkbrdDisplay(1);
                keyBoardLayout = 1;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_SPANISH)) {
                RCApp.OnSkbrdDisplay(2);
                keyBoardLayout = 2;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_FRENCH)) {
                RCApp.OnSkbrdDisplay(3);
                keyBoardLayout = 3;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_GERMAN_GER)) {
                RCApp.OnSkbrdDisplay(4);
                keyBoardLayout = 4;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_ITALIAN)) {
                RCApp.OnSkbrdDisplay(5);
                keyBoardLayout = 5;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_DANISH)) {
                RCApp.OnSkbrdDisplay(6);
                keyBoardLayout = 6;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_FINNISH)) {
                RCApp.OnSkbrdDisplay(7);
                keyBoardLayout = 7;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_GERMAN_SWITZ)) {
                RCApp.OnSkbrdDisplay(8);
                keyBoardLayout = 8;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_NORWEGIAN_NOR)) {
                RCApp.OnSkbrdDisplay(9);
                keyBoardLayout = 9;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_PORTUGUESE)) {
                RCApp.OnSkbrdDisplay(10);
                keyBoardLayout = 10;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_SWEDISH)) {
                RCApp.OnSkbrdDisplay(11);
                keyBoardLayout = 11;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_HEBREW)) {
                RCApp.OnSkbrdDisplay(12);
                keyBoardLayout = 12;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_FRENCH_BELGIUM)) {
                RCApp.OnSkbrdDisplay(13);
                keyBoardLayout = 13;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_DUTCH)) {
                RCApp.OnSkbrdDisplay(14);
                keyBoardLayout = 14;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_RUSSIAN)) {
                RCApp.OnSkbrdDisplay(15);
                keyBoardLayout = 15;
            } else if (cmdStr.equals(JVMenu.SKBRD_LANGUAGE_JAPANESE)) {
                RCApp.OnSkbrdDisplay(16);
                keyBoardLayout = 16;
            } else if (cmdStr.equals(JVMenu.VIDEO_RECORD_START)) {
                RCApp.getM_videorecord().OnVideoRecordStart();
            } else if (cmdStr.equals(JVMenu.VIDEO_RECORD_STOP)) {
                RCApp.getM_videorecord().OnVideoRecordStop();
            } else if (cmdStr.equals(JVMenu.VIDEO_RECORD_SETTINGS)) {
                RCApp.OnVideoRecordSettings();
            } else if (cmdStr.equals(JVMenu.ZOOM_IN)) {
                RCApp.OnVideoZoomIn();
            } else if (cmdStr.equals(JVMenu.ZOOM_OUT)) {
                RCApp.OnVideoZoomOut();
            } else if (cmdStr.equals(JVMenu.POWER_RESET_SERVER)) {
                RCApp.onSendPowerControlCommand(JVMenu.POWER_RESET_SERVER);
            } else if (cmdStr.equals(JVMenu.POWER_OFF_IMMEDIATE)) {
                RCApp.onSendPowerControlCommand(JVMenu.POWER_OFF_IMMEDIATE);
            } else if (cmdStr.equals(JVMenu.POWER_OFF_ORDERLY)) {
                RCApp.onSendPowerControlCommand(JVMenu.POWER_OFF_ORDERLY);
            } else if (cmdStr.equals(JVMenu.POWER_ON_SERVER)) {
                RCApp.onSendPowerControlCommand(JVMenu.POWER_ON_SERVER);
            } else if (cmdStr.equals(JVMenu.POWER_CYCLE_SERVER)) {
                RCApp.onSendPowerControlCommand(JVMenu.POWER_CYCLE_SERVER);
            } else {
                RCApp.getSoc_App().SOC_Menu_ActionMethod(e);
            }
        }
    }
}

