/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.AutoKeyboardLayout;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.KVMShareDialog;
import com.ami.kvm.jviewer.gui.KVMSharing;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JVToolBar
extends JToolBar
implements MouseListener {
    private JButton altTab;
    private JToolBar m_toolbar = new JToolBar();
    public JButton mouseBtn;
    public JButton cdBtn;
    public JButton floppyBtn;
    public JButton hardddiskBtn;
    public JButton kbdBtn;
    public JButton playBtn;
    public JButton pauseBtn;
    public JButton fullScreenBtn;
    public JButton videoRecordBtn;
    public JButton powerBtn;
    public JSlider slider_zoom;
    public JLabel textlabel;
    private JPopupMenu m_popupMenu;
    public JButton m_hotKeyBtn;
    private JMenuItem altCtrlDelBtn;
    public static final String CLT_ALT_DEL_BUTTON = "Ctr + Alt + Del";

    protected JButton createButton(String iconPath, String tooltip, int prefX, int prefY, int maxX, int maxY) {
        URL imageURL = iconPath == null ? null : JViewer.class.getResource(iconPath);
        JButton button = new JButton(){

            @Override
            public Point getToolTipLocation(MouseEvent event) {
                return new Point(this.getWidth(), this.getHeight() - 40);
            }
        };
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL));
        }
        button.setToolTipText(tooltip);
        button.setPreferredSize(new Dimension(maxX, maxY));
        button.setMaximumSize(new Dimension(maxX, maxY));
        button.setMinimumSize(new Dimension(maxX, maxY));
        button.setVisible(true);
        button.setRequestFocusEnabled(false);
        button.addMouseListener(this);
        return button;
    }

    public JVToolBar() {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        this.mouseBtn = this.createButton("res/Mouse2Btn.png", "Show Cursor is enabled", 23, 23, 33, 33);
        this.cdBtn = this.createButton("res/CD.png", "CD ROM is not Connected to the session", 23, 23, 33, 33);
        this.floppyBtn = this.createButton("res/Floppy.png", "Floppy is not Connected to the session", 23, 23, 33, 33);
        this.hardddiskBtn = this.createButton("res/HD.png", "Hard disk/USB Redirection is not Connected to the session", 23, 23, 33, 33);
        this.kbdBtn = this.createButton("res/keyboard.png", "Displays a Softkeyboard", 23, 23, 33, 33);
        this.fullScreenBtn = this.createButton("res/Maxi.png", "Shows FullScreen", 23, 23, 33, 33);
        this.altTab = this.createButton(null, "Send Alt+Tab", 100, 20, 120, 20);
        this.videoRecordBtn = this.createButton("res/videoRecord.png", "Video Record", 23, 23, 33, 33);
        this.pauseBtn = this.createButton("res/pause.png", "Pause Redirection", 23, 23, 33, 33);
        this.playBtn = this.createButton("res/play.png", "Playing  Redirection", 23, 23, 33, 33);
        this.m_hotKeyBtn = this.createButton("res/Hot-keys.png", "HotKeys", 23, 23, 33, 33);
        this.powerBtn = this.createButton("res/poweroff.png", "Server Power Status", 23, 23, 33, 33);
        this.altCtrlDelBtn = new JMenuItem("Alt+Ctrl+Del");
        this.altCtrlDelBtn.setToolTipText(" Send Alt+Ctrl+Del Keys");
        this.altCtrlDelBtn.setVisible(true);
        this.altCtrlDelBtn.setRequestFocusEnabled(false);
        this.altCtrlDelBtn.addMouseListener(this);
        this.m_popupMenu = new JPopupMenu();
        this.m_popupMenu.add(this.altCtrlDelBtn);
        this.textlabel = new JLabel();
        this.textlabel.setText("");
        this.textlabel.setVisible(true);
        this.m_toolbar.add(this.playBtn);
        this.m_toolbar.add(this.pauseBtn);
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.fullScreenBtn);
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.hardddiskBtn);
        this.m_toolbar.add(this.floppyBtn);
        this.m_toolbar.add(this.cdBtn);
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.mouseBtn);
        this.m_toolbar.add(this.kbdBtn);
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.videoRecordBtn);
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.m_hotKeyBtn);
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.constructZoomMenu());
        this.m_toolbar.addSeparator();
        this.m_toolbar.add(this.textlabel);
        this.m_toolbar.add(Box.createHorizontalGlue());
        this.m_toolbar.add(this.powerBtn);
        EtchedBorder m_raised = new EtchedBorder(1);
        this.m_toolbar.setBorder(m_raised);
        this.m_toolbar.setFloatable(false);
        this.m_toolbar.repaint();
    }

    protected JSlider constructZoomMenu() {
        if (this.slider_zoom == null) {
            this.slider_zoom = new JSlider(50, 150);
            this.slider_zoom.setValue(100);
            this.slider_zoom.setMaximumSize(new Dimension(200, Short.MAX_VALUE));
            this.slider_zoom.setMinimumSize(new Dimension(200, Short.MAX_VALUE));
            this.slider_zoom.setBorder(null);
            this.slider_zoom.setPaintLabels(true);
            this.slider_zoom.setMajorTickSpacing(50);
            this.slider_zoom.setMaximum(150);
            this.slider_zoom.setMinimum(50);
            this.slider_zoom.setMinorTickSpacing(0);
            this.slider_zoom.setToolTipText("100%");
            this.slider_zoom.setFocusable(false);
            this.slider_zoom.addChangeListener(new MyChangeAction());
            this.slider_zoom.setRequestFocusEnabled(false);
        }
        return this.slider_zoom;
    }

    public void setZoomLabel(int value) {
        String str = Integer.toString(value);
        JViewerApp.getInstance().getM_wndFrame().getMenu().label_Text.setText("Zoom Size :" + str + "%");
        this.slider_zoom.setToolTipText(str + "%");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.mouseBtn) {
            if (!JViewerApp.getInstance().getKVMClient().redirection()) {
                return;
            }
            if (JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("MouseShowCursor").isSelected()) {
                if (!JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("MouseShowCursor").isEnabled()) return;
                JViewerApp.getInstance().OnShowCursor(false);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("MouseShowCursor", false);
                this.mouseBtn.setToolTipText(" Show Cursor is disabled");
                return;
            }
            JViewerApp.getInstance().OnShowCursor(true);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("MouseShowCursor", true);
            this.mouseBtn.setToolTipText(" Show Cursor is enabled");
            return;
        }
        if (e.getSource() == this.kbdBtn) {
            AutoKeyboardLayout autokeylayout;
            if (!JViewerApp.getInstance().getKVMClient().redirection()) {
                return;
            }
            JVMenu menu = JViewerApp.getInstance().getJVMenu();
            if (menu.getAutokeylayout() != null) {
                autokeylayout = menu.getAutokeylayout();
            } else {
                autokeylayout = new AutoKeyboardLayout();
                menu.setAutokeylayout(autokeylayout);
            }
            if (!menu.getMenuSelected("Auto detect").booleanValue()) {
                if (JVMenu.keyBoardLayout >= 0) {
                    JViewerApp.getInstance().OnSkbrdDisplay(JVMenu.keyBoardLayout);
                    return;
                }
            }
            menu.notifyMenuStateSelected("Auto detect", true);
            menu.SetMenuEnable("SoftKeyboard", false);
            menu.getMenu("SoftKeyboard").setEnabled(false);
            JVMenu.m_menuItems_setenabled.put("SoftKeyboard", false);
            if (autokeylayout.getKeyboardlayout() == 1036) {
                JViewerApp.getInstance().OnSkbrdDisplay(3);
                return;
            }
            if (autokeylayout.getKeyboardlayout() == 1031) {
                JViewerApp.getInstance().OnSkbrdDisplay(4);
                return;
            }
            if (autokeylayout.getKeyboardlayout() == 1033) {
                JViewerApp.getInstance().OnSkbrdDisplay(0);
                return;
            }
            if (autokeylayout.getKeyboardlayout() == 1041) {
                JViewerApp.getInstance().OnSkbrdDisplay(16);
                return;
            }
            if (autokeylayout.getKeyboardlayout() == 1034) {
                JViewerApp.getInstance().OnSkbrdDisplay(2);
                return;
            }
            JViewerApp.getInstance().OnSkbrdDisplay(0);
            return;
        }
        if (e.getSource() == this.fullScreenBtn) {
            if (!JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("VideoFullScreen").isEnabled()) {
                this.fullScreenBtn.setToolTipText(" Full Screen option is disabled");
                return;
            }
            if (JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("VideoFullScreen").isSelected()) {
                JViewerApp.getInstance().OnVideoFullScreen(false);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("VideoFullScreen", false);
                return;
            }
            JViewerApp.getInstance().OnVideoFullScreen(true);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("VideoFullScreen", true);
            return;
        }
        if (e.getSource() == this.altCtrlDelBtn) {
            if (!JViewerApp.getInstance().getKVMClient().redirection()) {
                return;
            }
            if (JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldLeftCtrlKey").booleanValue() || JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldRightCtrlKey").booleanValue()) {
                if (JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldLeftAltKey") != false) return;
                if (JViewerApp.getInstance().getJVMenu().getMenuSelected("KeyboardHoldRightAltKey").booleanValue()) {
                    return;
                }
            }
            JViewerApp.getInstance().OnKeyboardAltCtrlDel();
            return;
        }
        if (e.getSource() == this.m_hotKeyBtn) {
            this.m_popupMenu.show(e.getComponent(), 0, 30);
            return;
        }
        if (e.getSource() == this.playBtn) {
            if (!JViewerApp.getInstance().getJVMenu().getMenuItem("VideoResumeRedirection").isEnabled()) return;
            JViewerApp.getInstance().OnVideoResumeRedirection();
            return;
        }
        if (e.getSource() == this.pauseBtn) {
            if (!JViewerApp.getInstance().getJVMenu().getMenuItem("VideoPauseRedirection").isEnabled()) return;
            JViewerApp.getInstance().setM_userPause(true);
            JViewerApp.getInstance().OnVideoPauseRedirection();
            return;
        }
        if (e.getSource() == this.cdBtn) {
            if (!JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("DeviceMediaDialog").isEnabled()) return;
            JViewerApp.getInstance().OnvMedia();
            return;
        }
        if (e.getSource() == this.floppyBtn) {
            if (!JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("DeviceMediaDialog").isEnabled()) return;
            JViewerApp.getInstance().OnvMedia();
            return;
        }
        if (e.getSource() == this.hardddiskBtn) {
            if (!JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("DeviceMediaDialog").isEnabled()) return;
            JViewerApp.getInstance().OnvMedia();
            return;
        }
        if (e.getSource() == this.videoRecordBtn) {
            if (JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("VideoRecordStart").isEnabled()) {
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("VideoRecordStart", false);
                JViewerApp.getInstance().getM_videorecord().OnVideoRecordStart();
                return;
            }
            if (JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("VideoRecordStop").isEnabled()) {
                JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("VideoRecordStop", false);
                JViewerApp.getInstance().getM_videorecord().OnVideoRecordStop();
                return;
            }
            if (!JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("VideoRecordSettings").isEnabled()) return;
            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("VideoRecordSettings", false);
            JViewerApp.getInstance().OnVideoRecordSettings();
            return;
        }
        if (!e.getSource().equals(this.powerBtn)) return;
        if (JViewerApp.getInstance().getM_frame().getMenu().getMenuEnable("Power On Server").booleanValue()) {
            JViewerApp.getInstance().onSendPowerControlCommand("Power On Server");
            return;
        }
        JViewerApp.getInstance().onSendPowerControlCommand("Orderly Shutdown");
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void changeMacrowsStatusOnPauseResume(boolean status) {
        this.mouseBtn.setEnabled(status);
        this.kbdBtn.setEnabled(status);
        this.cdBtn.setEnabled(status);
        this.floppyBtn.setEnabled(status);
        this.hardddiskBtn.setEnabled(status);
        this.altCtrlDelBtn.setEnabled(status);
        this.altTab.setEnabled(status);
        this.videoRecordBtn.setEnabled(status);
        if (status) {
            this.powerBtn.addMouseListener(this);
        } else {
            this.powerBtn.removeMouseListener(this);
        }
        this.OnChangeToolbarIconState_KVMPartial();
    }

    public void OnChangeToolbarIconState_KVMPartial() {
        if (KVMSharing.KVM_REQ_GIVEN == 2 && !KVMShareDialog.is_first_client) {
            JVMenu menu = JViewerApp.getInstance().getM_wndFrame().getMenu();
            this.setButtonEnabled(this.kbdBtn, menu.getMenuEnable("Keyboard Layout"));
            this.setButtonEnabled(this.mouseBtn, menu.getMenuEnable("Mouse"));
            this.setButtonEnabled(this.m_hotKeyBtn, menu.getMenuEnable("Keyboard"));
            this.setButtonEnabled(this.floppyBtn, menu.getMenuEnable("Media"));
            this.setButtonEnabled(this.cdBtn, menu.getMenuEnable("Media"));
            this.setButtonEnabled(this.hardddiskBtn, menu.getMenuEnable("Media"));
            this.setButtonEnabled(this.powerBtn, menu.getMenuEnable("Power"));
        }
    }

    public void setButtonEnabled(JButton button, boolean state) {
        if (!button.equals(this.powerBtn)) {
            button.setEnabled(state);
        }
        if (state) {
            button.addMouseListener(this);
        } else {
            button.removeMouseListener(this);
        }
    }

    public void turnOnPowerButton(boolean state) {
        if (state) {
            URL imageURL = JViewer.class.getResource("res/poweron.png");
            this.powerBtn.setIcon(new ImageIcon(imageURL));
            this.powerBtn.setToolTipText("Server is Powered On");
        } else {
            URL imageURL = JViewer.class.getResource("res/poweroff.png");
            this.powerBtn.setIcon(new ImageIcon(imageURL));
            this.powerBtn.setToolTipText("Server is Powered Off");
        }
    }

    public JToolBar getToolBar() {
        return this.m_toolbar;
    }

    public JButton getCdBtn() {
        return this.cdBtn;
    }

    public void setCdBtn(JButton cdBtn) {
        this.cdBtn = cdBtn;
    }

    public JButton getFloppyBtn() {
        return this.floppyBtn;
    }

    public void setFloppyBtn(JButton floppyBtn) {
        this.floppyBtn = floppyBtn;
    }

    public JButton getHardddiskBtn() {
        return this.hardddiskBtn;
    }

    public void setHardddiskBtn(JButton hardddiskBtn) {
        this.hardddiskBtn = hardddiskBtn;
    }

    public void changeMacrowsStatus(boolean status) {
        this.mouseBtn.setEnabled(status);
        this.cdBtn.setEnabled(status);
        this.floppyBtn.setEnabled(status);
        this.hardddiskBtn.setEnabled(status);
        this.kbdBtn.setEnabled(status);
        this.playBtn.setEnabled(status);
        this.pauseBtn.setEnabled(status);
        this.fullScreenBtn.setEnabled(status);
        this.altCtrlDelBtn.setEnabled(status);
        this.altTab.setEnabled(status);
        this.videoRecordBtn.setEnabled(status);
        this.m_hotKeyBtn.setEnabled(status);
        this.powerBtn.setEnabled(status);
        if (this.slider_zoom != null) {
            this.slider_zoom.setValue(100);
        }
    }

    private class MyChangeAction
    implements ChangeListener {
        private MyChangeAction() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            if (!JViewerApp.getInstance().getKVMClient().redirection()) {
                return;
            }
            int value = JVToolBar.this.slider_zoom.getValue();
            JVToolBar.this.setZoomLabel(value);
            BigDecimal b = BigDecimal.valueOf(value, 1);
            JVMenu.m_scale = b.doubleValue() / 10.0;
            if (value >= 50 && value <= 150) {
                JViewerApp.getInstance().getJVMenu().SetMenuEnable("Zoom In", true);
                JViewerApp.getInstance().getJVMenu().getMenuItem("Zoom In").setEnabled(true);
                JViewerApp.getInstance().getJVMenu().SetMenuEnable("Zoom Out", true);
                JViewerApp.getInstance().getJVMenu().getMenuItem("Zoom Out").setEnabled(true);
            }
            if (value >= 150) {
                JViewerApp.getInstance().getJVMenu().SetMenuEnable("Zoom In", false);
                JViewerApp.getInstance().getJVMenu().getMenuItem("Zoom In").setEnabled(false);
            }
            if (value <= 50) {
                JViewerApp.getInstance().getJVMenu().SetMenuEnable("Zoom Out", false);
                JViewerApp.getInstance().getJVMenu().getMenuItem("Zoom Out").setEnabled(false);
            }
            JViewerApp.getInstance().getRCView().revalidate();
            JViewerApp.getInstance().getRCView().repaint();
        }
    }
}

