/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.iusb.CDROMRedir;
import com.ami.iusb.FloppyRedir;
import com.ami.iusb.HarddiskRedir;
import com.ami.iusb.IUSBRedirSession;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.common.ISOCApp;
import com.ami.kvm.jviewer.common.ISOCCreateBuffer;
import com.ami.kvm.jviewer.common.ISOCFrameHdr;
import com.ami.kvm.jviewer.common.ISOCKvmClient;
import com.ami.kvm.jviewer.common.ISOCManager;
import com.ami.kvm.jviewer.gui.AutoBWDlg;
import com.ami.kvm.jviewer.gui.Dialog_KVM_Thread;
import com.ami.kvm.jviewer.gui.Dialog_Thread;
import com.ami.kvm.jviewer.gui.FSFrame;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.gui.KVMShareDialog;
import com.ami.kvm.jviewer.gui.KVMSharing;
import com.ami.kvm.jviewer.gui.SoftKeyboard;
import com.ami.kvm.jviewer.gui.VideoRecord;
import com.ami.kvm.jviewer.gui.WindowFrame;
import com.ami.kvm.jviewer.gui.vMediaDialog;
import com.ami.kvm.jviewer.hid.KeyProcessor;
import com.ami.kvm.jviewer.hid.USBKeyProcessorEnglish;
import com.ami.kvm.jviewer.hid.USBKeyboardRep;
import com.ami.kvm.jviewer.hid.USBMouseRep;
import com.ami.kvm.jviewer.jvvideo.JVVideo;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.Mousecaliberation;
import com.ami.kvm.jviewer.videorecord.VideoRecordApp;
import java.awt.Color;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.GregorianCalendar;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import supermicro.jviewer.SIMWX9TestApplication;

public class JViewerApp {
    private static JViewerApp m_rcApp = new JViewerApp();
    private JVFrame m_frame;
    private KVMClient m_KVMClnt;
    private ISOCKvmClient sockvmclient;
    private VideoRecordApp videorecordapp;
    private JViewerView m_view;
    private String m_encToken;
    private boolean m_wndMode = true;
    private WindowFrame m_wndFrame;
    private FSFrame m_fsFrame;
    private byte Led_status = 0;
    private String m_webSession_token;
    private String m_session_token;
    private byte[] m_serverIP;
    private int m_serverPort;
    private int m_RedirectionState = REDIR_STOPPED;
    private boolean m_bUseSSL = false;
    private int m_cdPort;
    private int m_fdPort;
    private int m_hdPort;
    private int m_cdNum;
    private int m_fdNum;
    private int m_hdNum;
    private int m_cdStatus;
    private int m_fdStatus;
    private int m_hdStatus;
    private boolean m_bVMUseSSL = false;
    private IUSBRedirSession m_IUSBSession;
    private USBKeyboardRep m_USBKeyRep;
    private ISOCApp soc_App;
    private ISOCFrameHdr socframeHdr;
    private static ISOCManager soc_manager;
    private JLabel label;
    private JDialog dialog;
    private VideoRecord m_videorecord;
    private Mousecaliberation Mousecaliberation;
    private String Message;
    private String serverIP;
    private SoftKeyboard softKeyboard;
    private AutoBWDlg m_autoBWDlg;
    public static byte WEB_PREVIEWER_CAPTURE_SUCCESS;
    public static byte WEB_PREVIEWER_CAPTURE_FAILURE;
    public static byte WEB_PREVIEWER_CAPTURE_IN_PROGRESS;
    public static byte WEB_PREVIEWER_CONNECT_FAILURE;
    public static byte WEB_PREVIEWER_INVALID_SERVERIP;
    public static byte m_webPreviewer_cap_status;
    private KVMShareDialog kVMDialog = KVMShareDialog.getInstance();
    private int m_zoomSliderValue;
    private boolean m_userPause = false;
    private String m_conSessionMsg = "";
    public static String[] Imagepath_CD;
    public static String[] Imagepath_Floppy;
    public static String[] Imagepath_Harddsik;
    public static boolean showCursor;
    public static int REDIR_STOPPED;
    public static int REDIR_STARTING;
    public static int REDIR_STARTED;
    public static int REDIR_STOPPING;
    public static int REDIR_PAUSING;
    public static final int NUMLOCK = 1;
    public static final int CAPSLOCK = 2;
    public static final int SCROLLLOCK = 4;
    public boolean m_refresh = false;
    public vMediaDialog m_mediaDlg = null;
    public JDialog mediaDlg = null;
    public JVVideo vidClnt;
    public ISOCCreateBuffer prepare_buf;
    public final byte SERVER_POWER_ON = 1;
    public final byte SERVER_POWER_OFF = 0;
    private byte powerStatus;
    BufferedImage orgImage = null;
    BufferedImage capImage = null;

    private Object createObject(String className) {
        Object object = null;
        try {
            Class<?> classDefinition = Class.forName(className);
            object = classDefinition.newInstance();
        }
        catch (InstantiationException e) {
            Debug.out.println(e);
        }
        catch (IllegalAccessException e) {
            Debug.out.println(e);
        }
        catch (ClassNotFoundException e) {
            Debug.out.println(e);
        }
        return object;
    }

    public static JViewerApp getInstance() {
        return m_rcApp;
    }

    private JViewerApp() {
        soc_manager = (ISOCManager)this.createObject("com.ami.kvm.jviewer.soc.SOCManager");
        this.prepare_buf = soc_manager.getSOCCreateBuffer();
        this.soc_App = soc_manager.getSOCApp();
        this.socframeHdr = soc_manager.getSOCFramehdr();
        this.m_view = new JViewerView(1600, 1200);
        if (!JViewer.isWebPreviewer()) {
            this.m_wndFrame = new WindowFrame();
            if (!JViewer.isplayerapp() && !JViewer.isdownloadapp()) {
                this.m_fsFrame = new FSFrame();
                this.m_USBKeyRep = this.m_view.getM_USBKeyRep();
            }
        }
        this.m_zoomSliderValue = 100;
    }

    public void create_IUSBSession() {
        this.m_IUSBSession = new IUSBRedirSession();
    }

    public JViewerView getRCView() {
        return this.m_view;
    }

    public IUSBRedirSession getUSBRedirSession() {
        return this.m_IUSBSession;
    }

    public KVMClient getKVMClient() {
        return this.m_KVMClnt;
    }

    public JVMenu getJVMenu() {
        if (this.m_wndMode) {
            return ((JVFrame)this.m_wndFrame).getMenu();
        }
        return ((JVFrame)this.m_fsFrame).getMenu();
    }

    public JVFrame getMainWindow() {
        if (this.m_wndMode) {
            return this.m_wndFrame;
        }
        return this.m_fsFrame;
    }

    public String getToken() {
        return this.m_encToken;
    }

    public String getSessionToken() {
        return this.m_session_token;
    }

    public void setStatus(String msg) {
        this.m_frame.setStatus(msg);
    }

    public void resetStatus() {
        this.m_frame.resetStatus();
    }

    public boolean isFullScreenMode() {
        return !this.m_wndMode;
    }

    public void refreshAppWndLabel() {
        try {
            this.m_frame.refreshTitle();
        }
        catch (Exception e) {
            Debug.out.println("Not able to refresh the title");
        }
    }

    public void setAppWndLabel(String label) {
        try {
            this.m_frame.setWndLabel(label);
        }
        catch (Exception e) {
            Debug.out.println("Not able to set the Window Label");
        }
    }

    public int GetRedirectionState() {
        return this.m_RedirectionState;
    }

    public void Ondisplayvideo(String ip, String webPort, String sessionCookies, int secureConnect, String videoPath) {
        this.m_frame = this.m_wndFrame;
        this.m_wndFrame.attachView();
        this.attachFrame();
        this.OnVideoRecordStartRedirection(ip, webPort, sessionCookies, secureConnect, videoPath);
    }

    public void OnVideoRecordStartRedirection(String ip, String webPort, String sessionCookies, int secureConnect, String videoPath) {
        Debug.out.println("OnVideoRecordStartRedirection");
        this.m_RedirectionState = REDIR_STARTING;
        this.vidClnt = new JVVideo();
        this.setVidClnt(this.vidClnt);
        this.m_KVMClnt = new KVMClient(this.m_serverIP, this.m_serverPort, this.vidClnt, this.m_bUseSSL);
        this.sockvmclient = JViewerApp.getSoc_manager().getSOCKvmClient();
        this.sockvmclient.SetVidoclnt(this.vidClnt);
        this.sockvmclient.SetKVMClient(this.m_KVMClnt);
        this.sockvmclient.SOCKVM_reader();
        if (JViewer.isdownloadapp()) {
            this.m_videorecord = new VideoRecord();
        }
        this.videorecordapp = new VideoRecordApp();
        JVFrame.setServerIP(this.m_serverIP, this.m_RedirectionState);
        if (-1 == this.videorecordapp.startVideorecordRedirection(ip, webPort, secureConnect, sessionCookies, videoPath)) {
            JViewerApp.getInstance().getM_frame().windowClosed();
        }
        this.m_RedirectionState = REDIR_STARTED;
    }

    public void OnConnectToServer(byte[] serverIP, int serverPort, String token, boolean bUseSSL, boolean bVMUseSSL, int cdserver_port, int fdserver_port, int hdserver_port, byte num_cd, byte num_fd, byte num_hd, int cdstatus, int fdstatus, int hdstatus, int userPriv, String webSessionTok) {
        this.m_serverIP = serverIP;
        this.m_serverPort = serverPort;
        this.m_encToken = token;
        this.m_session_token = token;
        this.m_webSession_token = webSessionTok;
        this.m_frame = this.m_wndFrame;
        this.m_wndMode = true;
        this.m_bUseSSL = bUseSSL;
        this.m_cdPort = cdserver_port;
        this.m_fdPort = fdserver_port;
        this.m_hdPort = hdserver_port;
        this.m_cdNum = num_cd;
        this.m_fdNum = num_fd;
        this.m_hdNum = num_hd;
        this.m_cdStatus = cdstatus;
        this.m_fdStatus = fdstatus;
        this.m_hdStatus = hdstatus;
        this.m_bVMUseSSL = bVMUseSSL;
        this.m_wndFrame.attachView();
        this.attachFrame();
        JVMenu menu = this.m_frame.getMenu();
        menu.notifyMenuStateEnable("VideoPauseRedirection", false);
        menu.notifyMenuStateEnable("VideoResumeRedirection", true);
        menu.notifyMenuStateSelected("VideoFullScreen", false);
        this.OnVideoStartRedirection();
    }

    public void OnConnectToServer(byte[] serverIP, int serverPort, String token, boolean bUseSSL, String webSessionTok) {
        this.m_serverIP = serverIP;
        this.m_serverPort = serverPort;
        this.m_encToken = token;
        this.m_session_token = token;
        this.m_webSession_token = webSessionTok;
        this.m_bUseSSL = bUseSSL;
        this.OnVideoStartRedirection();
    }

    private void attachFrame() {
        if (JViewer.isStandalone()) {
            if (!this.isM_wndMode()) {
                JViewer.getMainFrame().dispose();
                if (!JViewer.getMainFrame().isDisplayable()) {
                    JViewer.getMainFrame().setUndecorated(true);
                }
            } else if (!JViewer.getMainFrame().isDisplayable()) {
                JViewer.getMainFrame().setUndecorated(false);
            }
            JViewer.getMainFrame().setExtendedState(6);
            JViewer.getMainFrame().setContentPane(this.m_frame);
            JViewer.getMainFrame().setSize(800, 600);
            JViewer.getMainFrame().setVisible(true);
            JViewerApp.getInstance().getRCView().requestFocus();
        } else {
            JViewer.getMainPane().add(this.m_frame);
        }
    }

    private void detachFrame() {
        if (JViewer.isStandalone()) {
            JViewer.getMainFrame().getContentPane().remove(this.m_frame);
            JViewer.getMainFrame().dispose();
        }
    }

    public void OnVideoStartRedirection() {
        Debug.out.println("OnVideoStartRedirection");
        this.m_RedirectionState = REDIR_STARTING;
        this.vidClnt = new JVVideo();
        this.setVidClnt(this.vidClnt);
        this.m_KVMClnt = new KVMClient(this.m_serverIP, this.m_serverPort, this.vidClnt, this.m_bUseSSL);
        this.sockvmclient = JViewerApp.getSoc_manager().getSOCKvmClient();
        this.sockvmclient.SetVidoclnt(this.vidClnt);
        this.sockvmclient.SetKVMClient(this.m_KVMClnt);
        this.sockvmclient.SOCKVM_reader();
        if (-1 == this.m_KVMClnt.startRedirection()) {
            this.m_RedirectionState = REDIR_STOPPED;
            if (!JViewer.isWebPreviewer()) {
                JOptionPane.showMessageDialog(this.m_frame, "Connection failed!", "Connection", 0);
                JViewerApp.getInstance().getM_frame().windowClosed();
            } else {
                JViewerApp.getInstance().setWebPreviewerCaptureStatus(WEB_PREVIEWER_CONNECT_FAILURE);
            }
        }
        if (!JViewer.isWebPreviewer()) {
            JVFrame.setServerIP(this.m_serverIP, this.m_RedirectionState);
            this.m_view.addKeyListener();
            JVMenu menu = this.m_frame.getMenu();
            menu.notifyMenuStateEnable("VideoPauseRedirection", true);
            menu.notifyMenuStateEnable("VideoResumeRedirection", false);
            this.m_RedirectionState = REDIR_STARTED;
            if (!this.m_KVMClnt.redirection()) {
                String[] exceptmenu = new String[]{"VideoExit", "HelpAboutJViewer", "VideoFullScreen"};
                menu.enableMenu(exceptmenu, false);
                JViewerApp.getInstance().getM_wndFrame().toolbar.changeMacrowsStatus(false);
                JViewerApp.getInstance().getM_wndFrame().getM_status().enableStatusBar(false);
            }
        }
        if (SIMWX9TestApplication.cmTest) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    JViewerApp.this.cmTest();
                }
            };
            thread.start();
        }
    }

    public void OnVideoStopRedirection() {
        Debug.out.println("OnVideoStopRedirection");
        this.m_RedirectionState = REDIR_STOPPING;
        this.m_KVMClnt.Stop_Cmd_Redirection();
        if (!JViewer.isWebPreviewer()) {
            JVFrame.setServerIP(null, this.m_RedirectionState);
            this.OnUSBMouseSyncCursor(false);
            this.m_frame.getMenu().notifyMenuStateEnable("VideoPauseRedirection", false);
            this.m_frame.getMenu().notifyMenuStateEnable("VideoResumeRedirection", true);
            if (this.isFullScreenMode()) {
                this.OnVideoFullScreen(false);
            }
        }
        this.m_KVMClnt.stopRedirection();
        this.m_view.removeKMListener();
        this.m_RedirectionState = REDIR_STOPPED;
    }

    public boolean isM_userPause() {
        return this.m_userPause;
    }

    public void setM_userPause(boolean m_userPause) {
        this.m_userPause = m_userPause;
    }

    private void changeMenuItemsStatusOnPauseResume(JVMenu menu, boolean status) {
        Set<String> set = JVMenu.m_menuItems_setenabled.keySet();
        for (String str : set) {
            if ("VideoResumeRedirection" == str) {
                menu.notifyMenuStateEnable(str, !status);
                continue;
            }
            if ("VideoFullScreen" == str || "VideoExit" == str || "HelpAboutJViewer" == str) continue;
            if ("VideoRecordStart" == str || "VideoRecordSettings" == str || "VideoRecordStop" == str) {
                if (JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("VideoRecordStop").isEnabled() && this.isM_userPause()) {
                    JViewerApp.getInstance().getM_videorecord().OnVideoRecordStop();
                    JOptionPane.showMessageDialog(this.m_frame, "Due to pausing the video redirection,video recording has been stopped.", "Video Recording", 0);
                    menu.notifyMenuStateEnable("VideoRecordStop", false);
                    continue;
                }
                if (JViewerApp.getInstance().getMainWindow().getMenu().getMenuItem("VideoRecordStart").isEnabled()) {
                    menu.notifyMenuStateEnable(str, status);
                    continue;
                }
                menu.notifyMenuStateEnable("VideoRecordSettings", status);
                continue;
            }
            if ("Calibrate Mouse Threshold" == str) {
                if (JViewerApp.getInstance().getM_view().m_USBMouseMode != USBMouseRep.RELATIVE_MOUSE_MODE) continue;
                menu.notifyMenuStateEnable(str, status);
                continue;
            }
            try {
                menu.notifyMenuStateEnable(str, status);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                menu.getMenuItem(str).setEnabled(menu.getMenuEnable(str));
            }
            catch (Exception e) {}
        }
    }

    public void OnVideoPauseRedirection() {
        if (this.m_RedirectionState != REDIR_STARTED) {
            return;
        }
        Debug.out.println("OnVideoPauseRedirection");
        this.m_RedirectionState = REDIR_PAUSING;
        JVFrame.setServerIP(null, this.m_RedirectionState);
        JViewerApp.getInstance().refreshAppWndLabel();
        this.m_KVMClnt.pauseRedirection();
        this.changeMenuItemsStatusOnPauseResume(this.m_frame.getMenu(), false);
        JViewerApp.getInstance().getM_wndFrame().toolbar.pauseBtn.setEnabled(false);
        JViewerApp.getInstance().getM_wndFrame().toolbar.pauseBtn.setToolTipText(" Redirection Paused ");
        JViewerApp.getInstance().getM_wndFrame().toolbar.playBtn.setEnabled(true);
        JViewerApp.getInstance().getM_wndFrame().toolbar.playBtn.setToolTipText(" click to play Redirection ");
        JViewerApp.getInstance().getM_wndFrame().toolbar.changeMacrowsStatusOnPauseResume(false);
        this.m_RedirectionState = REDIR_STOPPED;
    }

    public void OnVideoResumeRedirection() {
        Debug.out.println("OnVideoResume");
        JVFrame.setServerIP(this.m_serverIP, this.m_RedirectionState);
        JViewerApp.getInstance().refreshAppWndLabel();
        this.m_RedirectionState = REDIR_STARTING;
        this.m_KVMClnt.resumeRedirection();
        this.setM_userPause(false);
        this.changeMenuItemsStatusOnPauseResume(this.m_frame.getMenu(), true);
        if (this.m_view.GetUSBMouseMode() == USBMouseRep.RELATIVE_MOUSE_MODE) {
            this.m_view.m_mouseListener.splitandsend(-this.socframeHdr.getwidth(), -this.socframeHdr.getheight(), true);
        }
        JViewerApp.getInstance().getM_wndFrame().toolbar.pauseBtn.setEnabled(true);
        JViewerApp.getInstance().getM_wndFrame().toolbar.pauseBtn.setToolTipText(" Click to Pause Redirection ");
        JViewerApp.getInstance().getM_wndFrame().toolbar.playBtn.setEnabled(false);
        JViewerApp.getInstance().getM_wndFrame().toolbar.playBtn.setToolTipText("  Shows Redirection ");
        JViewerApp.getInstance().getM_wndFrame().toolbar.changeMacrowsStatusOnPauseResume(true);
        this.m_RedirectionState = REDIR_STARTED;
    }

    public void OnVideoRefreshRedirection() {
        Debug.out.println("OnVideoRefresh");
        if (JViewer.isjviewerapp()) {
            if (this.m_RedirectionState == REDIR_STOPPED) {
                if (this.m_KVMClnt.m_isBlank) {
                    this.OnVideoResumeRedirection();
                    this.OnVideoPauseRedirection();
                } else {
                    this.m_refresh = true;
                    this.OnVideoResumeRedirection();
                }
            } else {
                this.OnVideoPauseRedirection();
                this.OnVideoResumeRedirection();
            }
        }
    }

    public void OnVideoFullScreen(boolean state) {
        Debug.out.println("OnVideoFullScreen");
        if (this.m_wndMode) {
            this.m_wndFrame.detachView();
            this.detachFrame();
            this.m_frame = this.m_fsFrame;
            this.m_wndMode = false;
            this.m_fsFrame.attachView();
            this.attachFrame();
            this.m_fsFrame.showWindow();
            if (KVMSharing.KVM_REQ_GIVEN != 1) {
                String tip = "";
                if (this.m_conSessionMsg != "") {
                    tip = this.m_conSessionMsg;
                } else if (this.kVMDialog.kvms_conSessionMsg != "") {
                    tip = this.kVMDialog.kvms_conSessionMsg;
                }
                this.m_fsFrame.getM_menuBar().addConcurrentSessionMsg(tip);
            } else {
                this.onStopConcurrentSession();
            }
            if (KVMSharing.KVM_REQ_GIVEN == 2 && !KVMShareDialog.is_first_client) {
                this.OnChangeMenuState_KVMPartial(this.m_fsFrame.getMenu(), false);
            }
        } else {
            this.m_fsFrame.detachView();
            this.detachFrame();
            this.m_fsFrame.hideWindow();
            this.m_frame = this.m_wndFrame;
            this.m_wndMode = true;
            this.m_wndFrame.attachView();
            this.attachFrame();
            if (KVMSharing.KVM_REQ_GIVEN != 1) {
                String msg = "";
                if (this.m_conSessionMsg != "") {
                    msg = this.m_conSessionMsg;
                } else if (this.kVMDialog.kvms_conSessionMsg != "") {
                    msg = this.kVMDialog.kvms_conSessionMsg;
                }
                this.m_fsFrame.getM_menuBar().removeConcurrentSessionMsg();
                this.getM_wndFrame().toolbar.textlabel.setText(msg);
                this.getM_wndFrame().toolbar.textlabel.setVisible(true);
            } else {
                this.onStopConcurrentSession();
            }
            if (KVMSharing.KVM_REQ_GIVEN == 2 && !KVMShareDialog.is_first_client) {
                this.OnChangeMenuState_KVMPartial(this.m_wndFrame.getMenu(), false);
                this.getM_wndFrame().toolbar.OnChangeToolbarIconState_KVMPartial();
            }
        }
        if (this.m_frame.getMenu().getMenuItem("VideoPauseRedirection").isEnabled()) {
            JViewerApp.getInstance().setAppWndLabel("0 fps");
        }
        this.m_frame.getMenu().notifyMenuStateSelected("VideoFullScreen", state);
        this.m_frame.getMenu().notifyMenuStateEnable("VideoFullScreen", true);
        this.m_frame.getMenu().refreshMenu();
    }

    public void OnKeyboardHoldRightCtrlKey(boolean state) {
        Debug.out.println("OnKeyboardHoldRightCtrlKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(17, 3, state);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_frame.getMenu().notifyMenuStateSelected("KeyboardHoldRightCtrlKey", state);
        if (state) {
            this.getM_wndFrame().getM_status().getRightCtrl().setForeground(Color.red);
        } else {
            this.getM_wndFrame().getM_status().getRightCtrl().setForeground(Color.gray);
        }
    }

    public void OnKeyboardHoldRightAltKey(boolean state) {
        Debug.out.println("OnKeyboardHoldRightAltKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(18, 3, state);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_frame.getMenu().notifyMenuStateSelected("KeyboardHoldRightAltKey", state);
        if (state) {
            this.getM_wndFrame().getM_status().getRightAlt().setForeground(Color.red);
        } else {
            this.getM_wndFrame().getM_status().getRightAlt().setForeground(Color.gray);
        }
    }

    public void OnKeyboardHoldLeftCtrlKey(boolean state) {
        Debug.out.println("OnKeyboardHoldLeftCtrlKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(17, 2, state);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_frame.getMenu().notifyMenuStateSelected("KeyboardHoldLeftCtrlKey", state);
        if (state) {
            this.getM_wndFrame().getM_status().getLeftCtrl().setForeground(Color.red);
        } else {
            this.getM_wndFrame().getM_status().getLeftCtrl().setForeground(Color.gray);
        }
    }

    public void OnKeyboardHoldLeftAltKey(boolean state) {
        Debug.out.println("OnKeyboardHoldLeftAltKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(18, 2, state);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_frame.getMenu().notifyMenuStateSelected("KeyboardHoldLeftAltKey", state);
        if (state) {
            this.getM_wndFrame().getM_status().getLeftAlt().setForeground(Color.red);
        } else {
            this.getM_wndFrame().getM_status().getLeftAlt().setForeground(Color.gray);
        }
    }

    public void OnKeyboardLeftWindowsKeyHoldDown(boolean state) {
        Debug.out.println("OnKeyboardLeftWindowsKeyHoldDown");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(524, 2, state);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_frame.getMenu().notifyMenuStateSelected("KeyboardLeftWindowsKeyHoldDown", state);
    }

    public void OnKeyboardLeftWindowsKeyPressRelease() {
        Debug.out.println("OnKeyboardLeftWindowsKeyPressRelease");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(524, 2, true);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(524, 2, false);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
    }

    public void OnKeyboardRightWindowsKeyHoldDown(boolean state) {
        Debug.out.println("OnKeyboardRightWindowsKeyHoldDown");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(524, 3, state);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_frame.getMenu().notifyMenuStateSelected("KeyboardRightWindowsKeyHoldDown", state);
    }

    public void OnKeyboardRightWindowsKeyPressRelease() {
        Debug.out.println("OnKeyboardRightWindowsKeyPressRelease");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(524, 3, true);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(524, 3, false);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
    }

    public void OnKeyboardAltCtrlDel() {
        Debug.out.println("OnKeyboardAltCtrlDel");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_USBKeyRep.set(17, 2, true);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(127, 1, true);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(127, 1, false);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(17, 2, false);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
    }

    public void OnKeyboardContextMenu() {
        this.m_USBKeyRep.set(525, 1, true);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(525, 1, false);
        this.m_KVMClnt.sendKMMessage(this.m_USBKeyRep);
    }

    public void OnSkbrdDisplay(int langindex) {
        if (this.softKeyboard != null) {
            this.softKeyboard.m_skmouselistener.close();
            this.softKeyboard.dispose();
        }
        if (langindex == -1) {
            if (this.softKeyboard != null) {
                this.softKeyboard.setVisible(false);
                this.softKeyboard = null;
            }
        } else {
            this.softKeyboard = new SoftKeyboard(langindex);
        }
    }

    public void OnEncryptionStatus() {
        if (!this.m_frame.getMenu().getMenuItem("OptionsKeyboardMouseEncryption").isEnabled()) {
            this.m_frame.getMenu().notifyMenuStateEnable("OptionsKeyboardMouseEncryption", true);
        }
        if (this.m_KVMClnt.isKMEncryptionEnabled()) {
            return;
        }
        this.m_KVMClnt.notifyEncryption(true);
        this.m_frame.getMenu().notifyMenuStateSelected("OptionsKeyboardMouseEncryption", true);
        if (KVMClient.DISABLE_ENCRPT_FLAG) {
            JOptionPane.showMessageDialog(this.m_frame, "Keyboard/mouse encryption cannot be disabled\nAs multiple sessions are running", "Keyboard/mouse encryption", 1);
            KVMClient.DISABLE_ENCRPT_FLAG = false;
            this.m_KVMClnt.getCrypt().initialize(this.m_encToken, 1);
        } else {
            JOptionPane.showMessageDialog(this.m_frame, "Keyboard/mouse encryption is enabled by other sessions.\nEnabling encryption for this session", "Keyboard/mouse encryption", 1);
        }
    }

    public void OnInitialEncryptionStatus() {
        this.m_KVMClnt.notifyEncryption(true);
        this.m_frame.getMenu().notifyMenuStateSelected("OptionsKeyboardMouseEncryption", true);
        this.m_KVMClnt.getCrypt().initialize(this.m_encToken, 1);
        JOptionPane.showMessageDialog(this.m_frame, "Keyboard/mouse encryption is enabled by other sessions.\nEnabling encryption for this session", "Keyboard/mouse encryption", 1);
    }

    public void OnOptionsKeyboardMouseEncryption(boolean state) {
        Debug.out.println("OnOptionsKeyboardMouseEncryption");
        this.m_KVMClnt.setEncryption(state);
        this.m_frame.getMenu().notifyMenuStateSelected("OptionsKeyboardMouseEncryption", state);
        if (this.m_frame.getMenu().getMenuSelected("OptionsKeyboardMouseEncryption").booleanValue()) {
            this.m_frame.getMenu().notifyMenuStateEnable("OptionsKeyboardMouseEncryption", !state);
        }
        if (state) {
            this.m_KVMClnt.getCrypt().initialize(this.m_encToken, 1);
        } else {
            this.m_KVMClnt.getCrypt().close();
        }
    }

    public void OnUSBMouseSyncCursor(boolean state) {
        Debug.out.println("OnUSBMouseSyncCursor");
        showCursor = true;
        this.m_view.USBsyncCursor(state);
        this.m_frame.getMenu().refreshMenu();
    }

    public void OnShowCursor(boolean state) {
        Debug.out.println("OnShowCursor");
        this.getJVMenu().notifyMenuStateSelected("MouseShowCursor", state);
        if (state) {
            showCursor = true;
            this.m_view.ShowCursor(true);
            URL imageURLMouse = JViewer.class.getResource("res/Mouse2Btn.png");
            this.getM_wndFrame().toolbar.mouseBtn.setIcon(new ImageIcon(imageURLMouse));
            JViewerApp.getInstance().getM_wndFrame().toolbar.mouseBtn.setToolTipText(" Show Cursor is enabled");
        } else {
            showCursor = false;
            this.m_view.ShowCursor(false);
            URL imageURLMouse = JViewer.class.getResource("res/Mouse2Btn-gray.png");
            this.getM_wndFrame().toolbar.mouseBtn.setIcon(new ImageIcon(imageURLMouse));
            JViewerApp.getInstance().getM_wndFrame().toolbar.mouseBtn.setToolTipText(" Show Cursor is disabled");
        }
    }

    public void OnOptionsBandwidthAutoDetect() {
        Debug.out.println("OnOptionsBandwidthAutoDetect");
        this.m_KVMClnt.autoDetect();
        if (JViewer.isStandalone()) {
            this.m_autoBWDlg = new AutoBWDlg(JViewer.getMainFrame());
            this.m_autoBWDlg.setVisible(true);
        } else {
            JPanel panel = new JPanel();
            this.label = new JLabel("Detecting bandwidth ...");
            panel.add(this.label);
            JOptionPane optionPane = new JOptionPane(panel, -1);
            optionPane.setOptions(new Object[0]);
            this.dialog = optionPane.createDialog(JViewerApp.getInstance().getMainWindow(), "Detecting bandwidth...");
            this.dialog.setResizable(false);
            this.dialog.setSize(350, 100);
            this.dialog.setVisible(true);
        }
    }

    public void updateBandwidthMsg(String newBW) {
        if (JViewer.isStandalone()) {
            if (this.m_autoBWDlg != null && this.m_autoBWDlg.isVisible()) {
                this.m_autoBWDlg.setMessage("Detected bandwidth - " + newBW);
            }
            this.m_autoBWDlg.done();
        } else {
            try {
                this.label.setText("Detected bandwidth - " + newBW);
                Thread.sleep(1000L);
                this.label.setText("Changing the bandwidth settings..");
                Thread.sleep(1000L);
                this.label.setText("<html>Changed bandwidth to " + newBW + "<br><br>Done !!</html>");
                Thread.sleep(1000L);
                this.dialog.dispose();
            }
            catch (Exception e) {
                Debug.out.println(e);
            }
        }
    }

    public void OnOptionsBandwidth(int bandWidth) {
        this.m_KVMClnt.setBandwidth(bandWidth);
        this.m_frame.getMenu().SetMenuSelected(JVMenu.previous_bandwidth, false);
        switch (bandWidth) {
            case 32768: {
                Debug.out.println("OnOptionsBandwidth256Kbps");
                JVMenu.previous_bandwidth = "OptionsBandwidth256Kbps";
                this.m_frame.getMenu().notifyMenuStateSelected("OptionsBandwidth256Kbps", true);
                break;
            }
            case 65536: {
                Debug.out.println("OnOptionsBandwidth512Kbps");
                JVMenu.previous_bandwidth = "OptionsBandwidth512Kbps";
                this.m_frame.getMenu().notifyMenuStateSelected("OptionsBandwidth512Kbps", true);
                break;
            }
            case 131072: {
                Debug.out.println("OnOptionsBandwidth1Mbps");
                JVMenu.previous_bandwidth = "OptionsBandwidth1Mbps";
                this.m_frame.getMenu().notifyMenuStateSelected("OptionsBandwidth1Mbps", true);
                break;
            }
            case 0x140000: {
                Debug.out.println("OnOptionsBandwidth10Mbps");
                JVMenu.previous_bandwidth = "OptionsBandwidth10Mbps";
                this.m_frame.getMenu().notifyMenuStateSelected("OptionsBandwidth10Mbps", true);
                break;
            }
            case 0xC80000: {
                Debug.out.println("OnOptionsBandwidth100Mbps");
                JVMenu.previous_bandwidth = "OptionsBandwidth100Mbps";
                this.m_frame.getMenu().notifyMenuStateSelected("OptionsBandwidth100Mbps", true);
            }
        }
    }

    public void OnHelpAboutJViewer() {
        Debug.out.println("OnHelpAboutJViewer");
        JOptionPane.showMessageDialog(this.m_frame, "KVM Remote Console Utility Version 1.53.0\nPlugin Version " + JViewerApp.getSoc_manager().getSOCVersion() + " for " + JViewerApp.getSoc_manager().getSOC() + "\n" + "Copyright (c) 2010 American Megatrends, Inc.", "About JViewer", 1, new ImageIcon(JViewer.class.getResource("res/ami.jpg")));
    }

    public void OnVideoExit() {
        Debug.out.println("OnVideoExit");
        this.m_frame.exitApp();
    }

    public void onMaxSession() {
        JOptionPane.showMessageDialog(this.m_frame, "Maximum Session Reached.\nClosing the client....", "Max Session", 1);
        this.m_frame.exitApp();
    }

    public void OnGetMouseMode(byte mouse_mode) {
        Debug.out.println("Mouse mode response packet received. Mouse Mode:" + mouse_mode);
        this.m_view.SetUSBMouseMode(mouse_mode);
        this.OnUSBMouseSyncCursor(true);
        if (mouse_mode == USBMouseRep.RELATIVE_MOUSE_MODE) {
            JViewerApp.getInstance().OnShowCursor(false);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("Calibrate Mouse Threshold", true);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("Relative", true);
        } else {
            JViewerApp.getInstance().OnShowCursor(true);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("Calibrate Mouse Threshold", false);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("MouseShowCursor", true);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("Absolute", true);
        }
    }

    public void OnValidateVideoSessionResp(byte status) {
        if (status == 0) {
            this.m_frame.generalErrorMessage("Authentication", "Invalid Session token. Authentication failure.");
            System.exit(0);
        }
        this.m_KVMClnt.OnValidVideoSession();
        if (!JViewer.isWebPreviewer() && this.m_KVMClnt.redirection()) {
            String[] exceptmenu = new String[]{"VideoExit", "HelpAboutJViewer", "VideoFullScreen"};
            this.m_frame.getMenu().enableMenu(exceptmenu, true);
            if (KVMSharing.KVM_REQ_GIVEN == 2) {
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("OptionsKeyboardMouseEncryption", false);
            } else {
                JViewerApp.getInstance().getM_wndFrame().getM_status().enableStatusBar(true);
            }
            JViewerApp.getInstance().getM_wndFrame().toolbar.changeMacrowsStatus(true);
        }
    }

    public void onKeybdLED(byte Led_status) {
        if (!JViewerView.m_keyled_flag) {
            this.Led_status = Led_status;
            FloppyRedir flp = new FloppyRedir(true);
            byte clientKybdLED = flp.ReadKeybdLEDStatus();
            try {
                Robot r = new Robot();
                if (!this.m_frame.getMenu().getMenuItem("Calibrate Mouse Threshold").isSelected()) {
                    JViewerApp.getInstance().m_view.removeKeyListener();
                }
                if ((clientKybdLED & 1) != (Led_status & 1)) {
                    r.keyPress(144);
                    r.keyRelease(144);
                    Thread.sleep(100L);
                }
                if ((clientKybdLED & 2) != (Led_status & 2)) {
                    r.keyPress(20);
                    r.keyRelease(20);
                    Thread.sleep(100L);
                }
                if ((clientKybdLED & 4) != (Led_status & 4)) {
                    r.keyPress(145);
                    r.keyRelease(145);
                    Thread.sleep(100L);
                }
                if (!this.m_frame.getMenu().getMenuItem("Calibrate Mouse Threshold").isSelected()) {
                    JViewerApp.getInstance().m_view.addKeyListener();
                }
            }
            catch (Exception e) {
                Debug.out.println(e);
            }
            Object var2_2 = null;
        } else {
            this.Led_status = Led_status;
        }
        if (this.getSoftKeyboard() != null) {
            this.getSoftKeyboard().syncKbdLED();
        }
    }

    public void stopRedirection_ISoImage() {
        int k;
        if (this.m_IUSBSession.cdromSession != null) {
            for (k = 0; k < JViewerApp.getInstance().getM_cdNum(); ++k) {
                if (!JViewerApp.getInstance().getM_IUSBSession().cdromSession[k].ImageRedirectionCD || !this.m_IUSBSession.cdromSession[k].Ejectcdimage) continue;
                this.m_IUSBSession.StopISORedir(k);
            }
        }
        if (this.m_IUSBSession.floppySession != null) {
            for (k = 0; k < JViewerApp.getInstance().getM_cdNum(); ++k) {
                if (!JViewerApp.getInstance().getM_IUSBSession().floppySession[k].ImageRedirectionfloppy || !JViewerApp.getInstance().getM_IUSBSession().floppySession[k].Ejectfloppyimage) continue;
                this.m_IUSBSession.StopFloppyImageRedir(k);
            }
        }
        if (this.m_IUSBSession.harddiskSession != null) {
            for (k = 0; k < JViewerApp.getInstance().getM_cdNum(); ++k) {
                if (!JViewerApp.getInstance().getM_IUSBSession().harddiskSession[k].ImageRedirectionHD_USB || !JViewerApp.getInstance().getM_IUSBSession().harddiskSession[k].Ejectharddiskimage) continue;
                this.m_IUSBSession.StopHarddiskImageRedir(k);
            }
        }
    }

    public void OnCalibareteMouse(boolean state) {
        this.getJVMenu();
        if (JVMenu.m_scale != 1.0) {
            JOptionPane.showMessageDialog(this.getM_frame(), "Zoom value should be 100% to perform Mouse Calibration.", "Mouse Calibration", 1);
            this.getJVMenu().notifyMenuStateSelected("Calibrate Mouse Threshold", false);
            return;
        }
        JViewerApp.getInstance().getRCView().mouse_resync_linux_mode(0, 0);
        if (this.Mousecaliberation == null) {
            this.Mousecaliberation = new Mousecaliberation();
        }
        JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoFullScreen", false);
        JViewerApp.getInstance().getM_wndFrame().toolbar.fullScreenBtn.setToolTipText("Full Screen option is disabled");
        JViewerApp.getInstance().getRCView().removeKMListener();
        this.Mousecaliberation.OnCalibareteMouseThreshold(state);
    }

    public void OnSendKVMPrevilage(byte User2_status) {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_KVMClnt.SendKVMPrevilage(User2_status);
    }

    public void onStopConcurrentSession() {
        KVMSharing.KVM_REQ_GIVEN = 1;
        KVMShareDialog.is_first_client = true;
        if (JViewerApp.getInstance().isM_wndMode()) {
            JViewerApp.getInstance().getM_wndFrame().toolbar.textlabel.setText("");
            JViewerApp.getInstance().getM_wndFrame().toolbar.textlabel.setVisible(false);
            JViewerApp.getInstance().OnChangeMenuState_KVMPartial(JViewerApp.getInstance().getM_wndFrame().getMenu(), true);
            JViewerApp.getInstance().getM_wndFrame().toolbar.OnChangeToolbarIconState_KVMPartial();
        } else {
            JViewerApp.getInstance().OnChangeMenuState_KVMPartial(JViewerApp.getInstance().getM_fsFrame().getMenu(), true);
            JViewerApp.getInstance().getM_fsFrame().getM_menuBar().removeConcurrentSessionMsg();
        }
    }

    public int OnsendWebsessionToken() {
        int i;
        String web_session_token = JViewerApp.getInstance().getM_webSession_token();
        byte[] web_token = new byte[web_session_token.length()];
        web_token = web_session_token.getBytes();
        Debug.out.dump(web_token);
        IVTPPktHdr WebSessTokenPkt = new IVTPPktHdr(21, web_token.length, 0);
        ByteBuffer wbf = ByteBuffer.allocate(WebSessTokenPkt.size() + web_token.length);
        wbf.position(0);
        wbf.put(WebSessTokenPkt.array());
        wbf.put(web_token);
        wbf.position(0);
        byte[] wreport = new byte[wbf.limit()];
        wbf.get(wreport);
        if (wreport.length != this.getKVMClient().sendMessage(wreport, wreport.length)) {
            Debug.out.println("Failed to web Session token to the card");
            return -1;
        }
        IVTPPktHdr VideoSessTokenPkt = new IVTPPktHdr(18, 140, 0);
        String session_token = JViewerApp.getInstance().getSessionToken();
        ByteBuffer bf = ByteBuffer.allocate(VideoSessTokenPkt.size() + 124);
        byte[] hashed_token = new byte[16];
        hashed_token = session_token.getBytes();
        bf.position(0);
        bf.put(VideoSessTokenPkt.array());
        bf.put((byte)0);
        bf.put(session_token.getBytes());
        Debug.out.println("Hashed token");
        Debug.out.dump(hashed_token);
        for (i = bf.position(); i < 107; ++i) {
            bf.put((byte)0);
        }
        for (i = bf.position(); i < 107; ++i) {
            bf.put((byte)0);
        }
        bf.put(KVMSharing.KVM_CLIENT_OWN_IP.getBytes());
        for (i = bf.position(); i < bf.limit(); ++i) {
            bf.put((byte)0);
        }
        bf.position(0);
        byte[] report = new byte[bf.limit()];
        bf.get(report);
        if (report.length != this.getKVMClient().sendMessage(report, report.length)) {
            Debug.out.println("Failed to send Session token to the card");
            return -1;
        }
        if (this.getKVMClient().OnFormIVTPHdr_Send((short)6, 0, (short)0) == -1) {
            return -1;
        }
        return 0;
    }

    public int onSendWebPreviewerSession() {
        IVTPPktHdr webPreviewSession = new IVTPPktHdr(26, 0, 0);
        if (this.getKVMClient().sendMessage(webPreviewSession.array(), webPreviewSession.size()) != webPreviewSession.size()) {
            return -1;
        }
        return 0;
    }

    public void setWebPreviewerCaptureStatus(byte status) {
        m_webPreviewer_cap_status = status;
    }

    public byte getWebPreviewerCaptureStatus() {
        return m_webPreviewer_cap_status;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void OnKvmPrevilage(short User_command) {
        byte User_command_low_byte = (byte)User_command;
        byte User_command_high_byte = (byte)(User_command >> 8);
        boolean Second_Session_flag = false;
        Second_Session_flag = this.OnCheckSameClient();
        if (User_command_low_byte == 1) {
            if (Second_Session_flag) {
                return;
            }
            Dialog_KVM_Thread thread = null;
            thread = new Dialog_KVM_Thread();
            thread.start();
            KVMSharing.KVM_PRIV_RES_USER = 1;
            return;
        }
        if (User_command_low_byte == 2) {
            if (Second_Session_flag) {
                JVFrame frame = JViewerApp.getInstance().getMainWindow();
                this.OnVideoStopRedirection();
                JOptionPane.showMessageDialog(frame, "Unable to launch Virtual Console. Only one Virtual Console session is allowed for " + JViewer.getIp() + " " + "from the same client.", "INFORMATION", 1);
                this.OnVideoExit();
                return;
            }
            this.kVMDialog.setUserStatus(false);
            this.kVMDialog.constructDialog();
            this.kVMDialog.showDialog();
            KVMSharing.KVM_PRIV_RES_USER = (byte)2;
            return;
        }
        if (User_command_low_byte == 0) {
            if (Second_Session_flag) {
                return;
            }
            Debug.out.println("Cancel Packet received");
            this.kVMDialog.disposeUserOneDialog();
            return;
        }
        if (User_command_low_byte == 3) {
            Dialog_Thread thread = null;
            thread = new Dialog_Thread();
            this.setMessage("User  " + KVMSharing.KVM_CLIENT_USERNAME + " " + "with IP" + " " + KVMSharing.KVM_CLIENT_IP + " " + "Requested Virtual Console access to the current session. But this request has timed out");
            thread.start();
            this.m_conSessionMsg = KVMSharing.KVM_CLIENT_USERNAME + " " + "user with IP address" + " " + KVMSharing.KVM_CLIENT_IP + " " + "is in Concurrent Session";
            if (this.m_wndMode) {
                this.getM_wndFrame().toolbar.textlabel.setText(this.m_conSessionMsg);
                this.getM_wndFrame().toolbar.textlabel.setVisible(true);
                return;
            }
            this.getM_fsFrame().getM_menuBar().addConcurrentSessionMsg(this.m_conSessionMsg);
            return;
        }
        if (User_command_low_byte != 4) return;
        Debug.out.println("#########Got from user2########### and usercommand byte is:" + User_command_high_byte);
        this.kVMDialog.disposeUserTwoDialog();
        Dialog_Thread thread = null;
        thread = new Dialog_Thread();
        if (User_command_high_byte == 0) {
            Debug.out.println("IVTPPktHdr.KVM_REQ_ALLOWED");
            this.setMessage("Full Virtual Console access granted by " + KVMSharing.KVM_CLIENT_USERNAME + " " + "user with IP address" + " " + KVMSharing.KVM_CLIENT_IP);
            thread.start();
            KVMSharing.KVM_REQ_GIVEN = 0;
            this.m_conSessionMsg = KVMSharing.KVM_CLIENT_USERNAME + " " + "user with IP address" + " " + KVMSharing.KVM_CLIENT_IP + " " + "is in Concurrent Session";
            if (this.m_wndMode) {
                this.getM_wndFrame().toolbar.textlabel.setText(this.m_conSessionMsg);
                this.getM_wndFrame().toolbar.textlabel.setVisible(true);
                return;
            }
            this.getM_fsFrame().getM_menuBar().addConcurrentSessionMsg(this.m_conSessionMsg);
            return;
        }
        if (User_command_high_byte == 2) {
            Debug.out.println("IVTPPktHdr.KVM_REQ_PARTIAL");
            this.setMessage("Partial access (only video) granted by  " + KVMSharing.KVM_CLIENT_USERNAME + " " + "user with IP address" + " " + KVMSharing.KVM_CLIENT_IP);
            thread.start();
            KVMSharing.KVM_REQ_GIVEN = (byte)2;
            this.m_conSessionMsg = KVMSharing.KVM_CLIENT_USERNAME + " " + "user with IP address" + " " + KVMSharing.KVM_CLIENT_IP + " " + "is in Concurrent Session";
            if (this.m_wndMode) {
                this.getM_wndFrame().toolbar.textlabel.setText(this.m_conSessionMsg);
                this.getM_wndFrame().toolbar.textlabel.setVisible(true);
                this.OnChangeMenuState_KVMPartial(this.getM_wndFrame().getMenu(), false);
                this.getM_wndFrame().toolbar.OnChangeToolbarIconState_KVMPartial();
                return;
            }
            this.getM_fsFrame().getM_menuBar().addConcurrentSessionMsg(this.m_conSessionMsg);
            this.OnChangeMenuState_KVMPartial(this.getM_fsFrame().getMenu(), false);
            return;
        }
        if (User_command_high_byte != 3) {
            if (User_command_high_byte != 1) return;
            Debug.out.println("IVTPPktHdr.KVM_REQ_DENIED");
            this.kVMDialog.disposeUserTwoDialog();
            KVMSharing.KVM_REQ_GIVEN = 1;
            this.m_conSessionMsg = "";
            JViewerApp.getInstance().getKVMClient().setM_redirection(true);
            this.OnVideoStopRedirection();
            JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), "Access Denied. Closing the Viewer");
            JViewerApp.getInstance().getM_frame().windowClosed();
            return;
        }
        Debug.out.println("IVTPPktHdr.KVM_REQ_TIMEOUT");
        this.kVMDialog.disposeUserTwoDialog();
        this.setMessage("Full Virtual Console access, Due to timeout from the  " + KVMSharing.KVM_CLIENT_USERNAME + " " + "user with IP address" + " " + KVMSharing.KVM_CLIENT_IP);
        thread.start();
        KVMSharing.KVM_REQ_GIVEN = 0;
        this.m_conSessionMsg = KVMSharing.KVM_CLIENT_USERNAME + " " + "user with IP address" + " " + KVMSharing.KVM_CLIENT_IP + " " + "is in Concurrent Session";
        if (this.m_wndMode) {
            this.getM_wndFrame().toolbar.textlabel.setText(this.m_conSessionMsg);
            this.getM_wndFrame().toolbar.textlabel.setVisible(true);
            return;
        }
        this.getM_fsFrame().getM_menuBar().addConcurrentSessionMsg(this.m_conSessionMsg);
    }

    private boolean OnCheckSameClient() {
        byte[] ipDgt = null;
        byte[] ipDgt_own = null;
        InetAddress hostAddress = null;
        InetAddress hostAddress_own = null;
        boolean SameIP = false;
        try {
            hostAddress = InetAddress.getByName(KVMSharing.KVM_CLIENT_IP);
            hostAddress_own = InetAddress.getByName(KVMSharing.KVM_CLIENT_OWN_IP);
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        String ipStr = hostAddress.getHostAddress();
        String ipStr_own = hostAddress_own.getHostAddress();
        try {
            ipDgt = InetAddress.getByName(ipStr).getAddress();
            ipDgt_own = InetAddress.getByName(ipStr_own).getAddress();
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        try {
            if (InetAddress.getByAddress(ipDgt).equals(InetAddress.getByAddress(ipDgt_own))) {
                Debug.out.println("Equals");
                SameIP = true;
            } else {
                Debug.out.println("Not Equals");
                SameIP = false;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return SameIP;
    }

    private void OnChangeMenuState_KVMPartial(JVMenu menu, boolean state) {
        menu.notifyMenuEnable("Keyboard", state);
        menu.notifyMenuEnable("Mouse", state);
        menu.notifyMenuEnable("Media", state);
        menu.notifyMenuEnable("Keyboard Layout", state);
        menu.notifyMenuEnable("Power", state);
        menu.notifyMenuStateEnable("OptionsKeyboardMouseEncryption", state);
    }

    public void OnvMedia() {
        String serverIP = null;
        try {
            serverIP = InetAddress.getByAddress(this.m_serverIP).getHostAddress();
        }
        catch (UnknownHostException e) {
            Debug.out.println("Invalid IP address");
        }
        this.m_mediaDlg = new vMediaDialog(JViewer.getMainFrame(), this.m_IUSBSession, serverIP, this.getCDPort(), this.getFDPort(), this.getHDPort(), this.getM_cdNum(), this.getM_fdNum(), this.getM_hdNum(), this.getM_cdStatus(), this.getM_fdStatus(), this.getM_hdStatus(), this.m_bVMUseSSL, this.getSessionToken());
        if (JViewer.isStandalone()) {
            this.m_mediaDlg.DisplayDialog();
        } else {
            JOptionPane optionPane = new JOptionPane(this.m_mediaDlg.getDialogPanel(), -1);
            optionPane.setOptions(new Object[0]);
            this.mediaDlg = optionPane.createDialog(JViewerApp.getInstance().getMainWindow(), "Virtual Media");
            this.mediaDlg.setSize(780, 650);
            this.mediaDlg.setLocationRelativeTo(null);
            this.mediaDlg.setVisible(true);
        }
        this.m_mediaDlg = null;
    }

    public vMediaDialog getM_mediaDlg() {
        return this.m_mediaDlg;
    }

    public void OnVideoRecordSettings() {
        this.m_videorecord = new VideoRecord();
        this.m_videorecord.VideoRecordsettings();
    }

    public void reportCDROMAbnormal(int device_no) {
        this.m_IUSBSession.stopCDROMAbnormal(device_no);
        if (this.m_mediaDlg != null) {
            this.m_mediaDlg.updateCDROMRedirStatus(device_no);
        } else {
            URL imageCDR = JViewer.class.getResource("res/CD.png");
            JViewerApp.getInstance().getM_wndFrame().toolbar.cdBtn.setIcon(new ImageIcon(imageCDR));
            JViewerApp.getInstance().getM_wndFrame().toolbar.cdBtn.setToolTipText(" CD ROM is not Connected to the session");
        }
    }

    public void reportFloppyAbnormal(int device_no) {
        this.m_IUSBSession.stopFloppyAbnormal(device_no);
        if (this.m_mediaDlg != null) {
            this.m_mediaDlg.updateFloppyRedirStatus(device_no);
        } else {
            URL imageFD = JViewer.class.getResource("res/Floppy.png");
            JViewerApp.getInstance().getM_wndFrame().toolbar.floppyBtn.setIcon(new ImageIcon(imageFD));
            JViewerApp.getInstance().getM_wndFrame().toolbar.floppyBtn.setToolTipText(" Floppy is not Connected to the session");
        }
    }

    public void reportHarddiskAbnormal(int device_no) {
        this.m_IUSBSession.stopHarddiskAbnormal(device_no);
        if (this.m_mediaDlg != null) {
            this.m_mediaDlg.updateharddiskRedirStatus(device_no);
        } else {
            URL imageHDDR = JViewer.class.getResource("res/HD.png");
            JViewerApp.getInstance().getM_wndFrame().toolbar.hardddiskBtn.setIcon(new ImageIcon(imageHDDR));
            JViewerApp.getInstance().getM_wndFrame().toolbar.hardddiskBtn.setToolTipText(" Hard disk/USB Redirection is not Connected to the session");
        }
    }

    public boolean IsCDROMRedirRunning(int device_no) {
        try {
            if (this.m_IUSBSession.getCDROMRedirStatus(device_no) == 1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean IsCDROMRedirRunning() {
        for (int h = 0; h < this.getM_cdNum(); ++h) {
            try {
                if (this.m_IUSBSession.getCDROMRedirStatus(h) != 1) continue;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean IsFloppyRedirRunning(int device_no) {
        try {
            if (this.m_IUSBSession.getFloppyRedirStatus(device_no) == 1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean IsFloppyRedirRunning() {
        for (int h = 0; h < this.getM_fdNum(); ++h) {
            try {
                if (this.m_IUSBSession.getFloppyRedirStatus(h) != 1) continue;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean IsHarddiskRedirRunning(int device_no) {
        try {
            if (this.m_IUSBSession.getHarddiskRedirStatus(device_no) == 1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean IsHarddiskRedirRunning() {
        for (int h = 0; h < JViewerApp.getInstance().getM_hdNum(); ++h) {
            try {
                if (this.m_IUSBSession.getHarddiskRedirStatus(h) != 1) continue;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public int getCDPort() {
        return this.m_cdPort;
    }

    public int getFDPort() {
        return this.m_fdPort;
    }

    public int getHDPort() {
        return this.m_hdPort;
    }

    public int getCDStatus() {
        return this.m_cdStatus;
    }

    public int getFDStatus() {
        return this.m_fdStatus;
    }

    public int getHDStatus() {
        return this.m_hdStatus;
    }

    public String getM_webSession_token() {
        return this.m_webSession_token;
    }

    public JVFrame getM_frame() {
        return this.m_frame;
    }

    public FSFrame getM_fsFrame() {
        return this.m_fsFrame;
    }

    public boolean isM_wndMode() {
        return this.m_wndMode;
    }

    public void setM_wndMode(boolean mode) {
        this.m_wndMode = mode;
    }

    public byte getLed_status() {
        return this.Led_status;
    }

    public void setLed_status(byte led_status) {
        this.Led_status = led_status;
    }

    public ISOCApp getSoc_App() {
        return this.soc_App;
    }

    public void setSoc_App(ISOCApp soc_App) {
        this.soc_App = soc_App;
    }

    public JViewerView getM_view() {
        return this.m_view;
    }

    public void setM_view(JViewerView m_view) {
        this.m_view = m_view;
    }

    public static ISOCManager getSoc_manager() {
        return soc_manager;
    }

    public ISOCFrameHdr getSocframeHdr() {
        return this.socframeHdr;
    }

    public void setSocframeHdr(ISOCFrameHdr socframeHdr) {
        this.socframeHdr = socframeHdr;
    }

    public WindowFrame getM_wndFrame() {
        return this.m_wndFrame;
    }

    public void setM_wndFrame(WindowFrame frame) {
        this.m_wndFrame = frame;
    }

    public JVVideo getVidClnt() {
        return this.vidClnt;
    }

    public void setVidClnt(JVVideo vidClnt) {
        this.vidClnt = vidClnt;
    }

    public ISOCCreateBuffer getPrepare_buf() {
        return this.prepare_buf;
    }

    public ISOCKvmClient getSockvmclient() {
        return this.sockvmclient;
    }

    public void setSockvmclient(ISOCKvmClient sockvmclient) {
        this.sockvmclient = sockvmclient;
    }

    public KeyProcessor getKeyprocesssor() {
        KeyProcessor keyprocessor = this.getJVMenu().getAutokeylayout() == null ? new USBKeyProcessorEnglish() : this.getJVMenu().getAutokeylayout().ongetKeyprocessor();
        keyprocessor.setAutoKeybreakMode(true);
        return keyprocessor;
    }

    public USBKeyboardRep getM_USBKeyRep() {
        return this.m_USBKeyRep;
    }

    public void setM_USBKeyRep(USBKeyboardRep keyRep) {
        this.m_USBKeyRep = keyRep;
    }

    public SoftKeyboard getSoftKeyboard() {
        return this.softKeyboard;
    }

    public void setSoftKeyboard(SoftKeyboard softKeyboard) {
        this.softKeyboard = softKeyboard;
    }

    public IUSBRedirSession getM_IUSBSession() {
        return this.m_IUSBSession;
    }

    public void setM_IUSBSession(IUSBRedirSession session) {
        this.m_IUSBSession = session;
    }

    public VideoRecord getM_videorecord() {
        return this.m_videorecord;
    }

    public void setM_videorecord(VideoRecord m_videorecord) {
        this.m_videorecord = m_videorecord;
    }

    public void OnVideoZoomIn() {
        this.m_zoomSliderValue = this.getM_wndFrame().toolbar.slider_zoom.getValue();
        if (JVMenu.m_scale <= 1.5) {
            BigDecimal rate = new BigDecimal(JVMenu.m_scale);
            BigDecimal cost = new BigDecimal("0.1");
            BigDecimal stepped_value = rate.add(cost).setScale(2, 4);
            JVMenu.m_scale = stepped_value.floatValue();
            this.m_zoomSliderValue += 10;
            this.getM_wndFrame().toolbar.slider_zoom.setValue(this.m_zoomSliderValue);
            JViewerApp.getInstance().getRCView().revalidate();
            JViewerApp.getInstance().getRCView().repaint();
        }
        if (JVMenu.m_scale >= 0.5) {
            this.getJVMenu().SetMenuEnable("Zoom Out", true);
            this.getJVMenu().getMenuItem("Zoom Out").setEnabled(true);
        }
        if (JVMenu.m_scale >= 1.5) {
            this.getJVMenu().SetMenuEnable("Zoom In", false);
            this.getJVMenu().getMenuItem("Zoom In").setEnabled(false);
        }
    }

    public void OnVideoZoomOut() {
        this.m_zoomSliderValue = this.getM_wndFrame().toolbar.slider_zoom.getValue();
        if (JVMenu.m_scale >= 0.5) {
            BigDecimal rate = new BigDecimal(JVMenu.m_scale);
            BigDecimal cost = new BigDecimal("0.1");
            BigDecimal stepped_value = rate.subtract(cost).setScale(2, 4);
            JVMenu.m_scale = stepped_value.floatValue();
            this.m_zoomSliderValue -= 10;
            this.getM_wndFrame().toolbar.slider_zoom.setValue(this.m_zoomSliderValue);
            JViewerApp.getInstance().getRCView().revalidate();
            JViewerApp.getInstance().getRCView().repaint();
        }
        if (JVMenu.m_scale <= 0.5) {
            this.getJVMenu().SetMenuEnable("Zoom Out", false);
            this.getJVMenu().getMenuItem("Zoom Out").setEnabled(false);
        }
        if (JVMenu.m_scale >= 0.5) {
            this.getJVMenu().SetMenuEnable("Zoom In", true);
            this.getJVMenu().getMenuItem("Zoom In").setEnabled(true);
        }
    }

    public void onGetPowerControlStatus(byte pwrStatus) {
        if (pwrStatus == 1) {
            this.powerStatus = 1;
            try {
                if (this.getVidClnt().getPsMonitor() != null) {
                    this.getVidClnt().getPsMonitor().cancel();
                    this.getVidClnt().setPsMonitor(null);
                }
                if (this.getVidClnt().getPsMonitorTimer() != null) {
                    this.getVidClnt().getPsMonitorTimer().cancel();
                    this.getVidClnt().setPsMonitorTimer(null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (pwrStatus == 0) {
            this.powerStatus = 0;
        }
        this.enablePowerControls(true);
    }

    public void onSendPowerControlCommand(String command) {
        JVFrame frame = JViewerApp.getInstance().getMainWindow();
        int ret = JOptionPane.showConfirmDialog(frame, "You are about to perfrom a server power control opreation.\nThe action you have triggered will be performed in the server.\nDo you want to perform " + command + " operation?", "Power Control", 0);
        if (ret == 0) {
            this.enablePowerControls(false);
            if (command.equals("Reset Server")) {
                this.m_KVMClnt.sendPowerControlCommand((byte)3);
            } else if (command.equals("Immediate Shutdown")) {
                this.m_KVMClnt.sendPowerControlCommand((byte)0);
            } else if (command.equals("Orderly Shutdown")) {
                this.m_KVMClnt.sendPowerControlCommand((byte)4);
            } else if (command.equals("Power On Server")) {
                this.m_KVMClnt.sendPowerControlCommand((byte)1);
            } else if (command.equals("Power Cycle Server")) {
                this.m_KVMClnt.sendPowerControlCommand((byte)2);
            }
        }
    }

    private void enablePowerControls(boolean state) {
        this.m_frame.getMenu().notifyMenuStateEnable("Power On Server", state);
        this.m_frame.getMenu().notifyMenuStateEnable("Reset Server", state);
        this.m_frame.getMenu().notifyMenuStateEnable("Immediate Shutdown", state);
        this.m_frame.getMenu().notifyMenuStateEnable("Orderly Shutdown", state);
        this.m_frame.getMenu().notifyMenuStateEnable("Power Cycle Server", state);
        this.m_wndFrame.toolbar.powerBtn.setEnabled(state);
        if (state) {
            if (this.powerStatus == 0) {
                this.m_frame.getMenu().notifyMenuStateEnable("Reset Server", false);
                this.m_frame.getMenu().notifyMenuStateEnable("Immediate Shutdown", false);
                this.m_frame.getMenu().notifyMenuStateEnable("Orderly Shutdown", false);
                this.m_frame.getMenu().notifyMenuStateEnable("Power Cycle Server", false);
                this.m_wndFrame.toolbar.turnOnPowerButton(false);
            } else {
                this.m_frame.getMenu().notifyMenuStateEnable("Power On Server", false);
                this.m_wndFrame.toolbar.turnOnPowerButton(true);
            }
        }
    }

    public void onPowerControlResponse(byte response) {
        if (response != 0) {
            JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), "Failed to execute the server power control command!!!", "Power Control", 64);
        } else {
            JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), "Server power control command executed successfully.", "Power Control", 1);
        }
        this.enablePowerControls(true);
    }

    public Mousecaliberation getMousecaliberation() {
        return this.Mousecaliberation;
    }

    public void setMousecaliberation(Mousecaliberation mousecaliberation) {
        this.Mousecaliberation = mousecaliberation;
    }

    public int getM_cdNum() {
        return this.m_cdNum;
    }

    public void setM_cdNum(int num) {
        this.m_cdNum = num;
    }

    public int getM_fdNum() {
        return this.m_fdNum;
    }

    public void setM_fdNum(int num) {
        this.m_fdNum = num;
    }

    public int getM_hdNum() {
        return this.m_hdNum;
    }

    public void setM_hdNum(int num) {
        this.m_hdNum = num;
    }

    public int getM_cdStatus() {
        return this.m_cdStatus;
    }

    public int getM_fdStatus() {
        return this.m_fdStatus;
    }

    public int getM_hdStatus() {
        return this.m_hdStatus;
    }

    public void setM_cdStatus(int status) {
        this.m_cdStatus = status;
    }

    public void setM_fdStatus(int status) {
        this.m_fdStatus = status;
    }

    public void setM_hdStatus(int status) {
        this.m_hdStatus = status;
    }

    public String getMessage() {
        return this.Message;
    }

    public void setMessage(String message) {
        this.Message = message;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public void setServerIP(String serverIP) {
        this.serverIP = serverIP;
    }

    public VideoRecordApp getVideorecordapp() {
        return this.videorecordapp;
    }

    public void setVideorecordapp(VideoRecordApp videorecordapp) {
        this.videorecordapp = videorecordapp;
    }

    public int getM_hdPort() {
        return this.m_hdPort;
    }

    public void setM_hdPort(int port) {
        this.m_hdPort = port;
    }

    public int getM_fdPort() {
        return this.m_fdPort;
    }

    public void setM_fdPort(int port) {
        this.m_fdPort = port;
    }

    public int getM_cdPort() {
        return this.m_cdPort;
    }

    public void setM_cdPort(int port) {
        this.m_cdPort = port;
    }

    public boolean isM_bVMUseSSL() {
        return this.m_bVMUseSSL;
    }

    public void setM_bVMUseSSL(boolean useSSL) {
        this.m_bVMUseSSL = useSSL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncVMediaRedirection() {
        int count;
        Object object = CDROMRedir.getSyncObj();
        synchronized (object) {
            for (count = 0; count < JViewerApp.getInstance().getM_cdNum(); ++count) {
                if (JViewerApp.getInstance().getUSBRedirSession().getCdromSession(count) == null) continue;
                JViewerApp.getInstance().getUSBRedirSession().getCdromSession(count).setConfModified(true);
            }
            CDROMRedir.getSyncObj().notifyAll();
        }
        object = FloppyRedir.getSyncObj();
        synchronized (object) {
            for (count = 0; count < JViewerApp.getInstance().getM_fdNum(); ++count) {
                if (JViewerApp.getInstance().getUSBRedirSession().getFloppySession(count) == null) continue;
                JViewerApp.getInstance().getUSBRedirSession().getFloppySession(count).setConfModified(true);
            }
            FloppyRedir.getSyncObj().notifyAll();
        }
        object = HarddiskRedir.getSyncObj();
        synchronized (object) {
            for (count = 0; count < JViewerApp.getInstance().getM_hdNum(); ++count) {
                if (JViewerApp.getInstance().getUSBRedirSession().getHarddiskSession(count) == null) continue;
                JViewerApp.getInstance().getUSBRedirSession().getHarddiskSession(count).setConfModified(true);
            }
            HarddiskRedir.getSyncObj().notifyAll();
        }
    }

    public void OnSendMouseMode(byte mouseMode) {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        if (this.m_KVMClnt.SendMouseMode(mouseMode) == 1) {
            Debug.out.println("Mouse mode send failured");
        }
        Debug.out.println("Mouse mode send success");
    }

    public void cmTest() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.m_view.sendDVO();
        this.OnVideoRefreshRedirection();
        int retVal = this.testVideoSignal();
        System.out.println("Test Result = " + retVal);
        System.exit(retVal);
    }

    public int testVideoSignal() {
        this.orgImage = null;
        try {
            this.orgImage = ImageIO.read(new File("kvm.bmp"));
        }
        catch (IOException ex) {
            this.captureScreenToFile();
            return 6;
        }
        this.capImage = this.m_view.getImage();
        if (this.capImage == null) {
            return 1;
        }
        if (this.orgImage == null) {
            return 2;
        }
        int devide = 8;
        int width = this.capImage.getWidth();
        int height = this.capImage.getHeight();
        int cellWidth = width / devide;
        int cellHeight = height / devide;
        for (int i = 1; i <= devide; ++i) {
            for (int j = 1; j <= devide; ++j) {
                int x = i * cellWidth - cellWidth / 2;
                int y = j * cellHeight - cellHeight / 2;
                int rgb1 = -1;
                int rgb2 = -1;
                boolean sizeDiff = false;
                try {
                    rgb1 = this.capImage.getRGB(x, y);
                    rgb2 = this.orgImage.getRGB(x, y);
                }
                catch (ArrayIndexOutOfBoundsException ex1) {
                    sizeDiff = true;
                }
                if (!sizeDiff && rgb1 == rgb2) continue;
                this.captureScreenToFile();
                this.orgImage = null;
                this.capImage = null;
                if (sizeDiff) {
                    System.out.println("Resolution don't match");
                    return 7;
                }
                if (rgb1 == rgb2) continue;
                System.out.println("Color is different at (" + i + "," + j + ")");
                return 5;
            }
        }
        this.orgImage = null;
        this.capImage = null;
        return 0;
    }

    private void captureScreenToFile() {
        BufferedImage currentImage = this.m_view.getImage();
        File file = new File(this.serverIP + "_" + JViewerApp.getSystemDateTime() + "-kvm.bmp");
        try {
            ImageIO.write((RenderedImage)currentImage, "bmp", file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getSystemDateTime() {
        GregorianCalendar cd1 = new GregorianCalendar();
        String dateTime = "";
        int s_yy = cd1.get(1);
        dateTime = dateTime + s_yy + "-";
        int s_mon = cd1.get(2) + 1;
        if (s_mon < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_mon + "-";
        int s_dd = cd1.get(5);
        if (s_dd < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_dd + "-";
        int s_hh = cd1.get(11);
        if (s_hh < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_hh + ".";
        int s_min = cd1.get(12);
        if (s_min < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_min + ".";
        int s_ss = cd1.get(13);
        if (s_ss < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_ss + "." + cd1.get(14);
        return dateTime;
    }

    static {
        WEB_PREVIEWER_CAPTURE_SUCCESS = 0;
        WEB_PREVIEWER_CAPTURE_FAILURE = (byte)-1;
        WEB_PREVIEWER_CAPTURE_IN_PROGRESS = (byte)-2;
        WEB_PREVIEWER_CONNECT_FAILURE = (byte)-3;
        WEB_PREVIEWER_INVALID_SERVERIP = (byte)-4;
        m_webPreviewer_cap_status = WEB_PREVIEWER_CAPTURE_IN_PROGRESS;
        Imagepath_CD = new String[5];
        Imagepath_Floppy = new String[5];
        Imagepath_Harddsik = new String[5];
        showCursor = false;
        REDIR_STOPPED = 0;
        REDIR_STARTING = 1;
        REDIR_STARTED = 2;
        REDIR_STOPPING = 3;
        REDIR_PAUSING = 4;
    }
}

