/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.hid.KeyProcessor;
import com.ami.kvm.jviewer.hid.USBKeyboardRep;
import com.ami.kvm.jviewer.hid.USBMouseRep;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.Mousecaliberation;
import java.awt.AWTException;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class JViewerView
extends JComponent {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_VIEW_WIDTH = 1600;
    public static final int DEFAULT_VIEW_HEIGHT = 1200;
    public static float MOUSE_ACCELERATION = 2.0f;
    public static int ACCEL_THRESHOLD = 4;
    public static boolean Cursorwasout = false;
    public static boolean fisrttime = true;
    public static float RemainingX = 0.0f;
    public static float RemainingY = 0.0f;
    public static boolean Lost_focus_flag = false;
    public static int Mouse_X = 0;
    public static int Mouse_Y = 0;
    private int m_act_width;
    private int m_act_height;
    private short m_cur_width;
    private short m_cur_height;
    private int m_width;
    private int m_height;
    public RCMouseListener m_mouseListener;
    public RCKeyListener m_keyListener;
    public RCFocusListener m_focuslistener;
    public RCMouseWheelListener m_mousewheelListener;
    public static boolean m_keyled_flag = false;
    private USBKeyboardRep m_USBKeyRep;
    private USBMouseRep m_USBMouseRep;
    byte m_USBMouseMode = USBMouseRep.INVALID_MOUSE_MODE;
    public static final int NUMLOCK = 1;
    public static final int CAPSLOCK = 2;
    public static final int SCROLLLOCK = 4;
    private int lastX = -1;
    private int lastY = -1;
    public Robot robbie;
    int curX = 0;
    int curY = 0;
    private boolean m_bLeftCtrlDown = false;
    private boolean m_bRightCtrlDown = false;
    private boolean m_bMouseRedirRunning = false;
    private short keyPressedFlag = 0;
    private BufferedImage localImage = new BufferedImage(1600, 1200, 1);
    public MouseEvent mouse_event;
    public MouseEvent sentmouse_event;
    public Thread mouse_thread;
    private Timer m_mouseTmr;
    private byte[] bdata;
    private int keyCode;
    private int keyLocation;

    public JViewerView(int width, int height) {
        if (!JViewer.isplayerapp() && !JViewer.isdownloadapp()) {
            this.m_USBKeyRep = new USBKeyboardRep();
            this.m_USBMouseRep = new USBMouseRep();
            this.m_mouseListener = new RCMouseListener();
            this.m_keyListener = new RCKeyListener();
            this.m_focuslistener = new RCFocusListener();
            this.m_mousewheelListener = new RCMouseWheelListener();
            this.setFocusable(true);
            this.setFocusTraversalKeysEnabled(false);
            this.addFocusListener(new RCFocusListener());
            this.addMouseWheelListener(new RCMouseWheelListener());
            this.m_mouseTmr = new Timer();
            this.m_mouseTmr.schedule((TimerTask)new MousesendTask(), 0L, 60L);
        }
    }

    public void addKMListeners() {
        this.setkeyprocessor();
        this.addKeyListener(this.m_keyListener);
        this.addMouseListener(this.m_mouseListener);
        this.addMouseMotionListener(this.m_mouseListener);
    }

    public void addKeyListener() {
        this.setkeyprocessor();
        this.addKeyListener(this.m_keyListener);
    }

    public void setkeyprocessor() {
        KeyProcessor m_keyprocesor = JViewerApp.getInstance().getKeyprocesssor();
        JViewerApp.getInstance().getKeyprocesssor().setAutoKeybreakMode(true);
        JViewerApp.getInstance().getM_USBKeyRep().setM_USBKeyProcessor(m_keyprocesor);
    }

    public void removeKeyListener() {
        this.removeKeyListener(this.m_keyListener);
    }

    public void flushHID() {
        KeyEvent evt = new KeyEvent(this, 401, new Date().getTime(), 130, 17, '0');
        this.m_keyListener.keyPressed(evt);
        evt = new KeyEvent(this, 401, new Date().getTime(), 0, 17, '0');
        this.m_keyListener.keyReleased(evt);
    }

    public void removeKMListener() {
        this.removeKeyListener(this.m_keyListener);
        this.removeMouseListener(this.m_mouseListener);
        this.removeMouseMotionListener(this.m_mouseListener);
    }

    public int viewWidth() {
        return this.m_width;
    }

    public int viewHeight() {
        return this.m_height;
    }

    public void setRCView(int width, int height, int type) {
        this.m_width = width;
        this.m_act_width = JViewerApp.getInstance().getSocframeHdr().getwidth();
        this.m_act_height = this.m_height = height;
        this.m_cur_width = JViewerApp.getInstance().getSocframeHdr().getcurwidth();
        this.m_cur_height = JViewerApp.getInstance().getSocframeHdr().getcurheight();
        Debug.out.println("View - width: " + this.m_width + " height: " + this.m_height);
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.setMaximumSize(new Dimension(width, height));
        JViewerApp.getInstance().getPrepare_buf().prepareBufImage(width, height, type);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public Dimension getPreferredSize() {
        BufferedImage m_image = JViewerApp.getInstance().getPrepare_buf().getM_image();
        if (m_image != null) {
            return new Dimension((int)((double)m_image.getWidth(this) + (double)m_image.getWidth(this) * (JVMenu.m_scale - 1.0)), (int)((double)m_image.getHeight(this) + (double)m_image.getHeight(this) * (JVMenu.m_scale - 1.0)));
        }
        return new Dimension(1024, 768);
    }

    @Override
    public void paint(Graphics g) {
        block7: {
            try {
                BufferedImage m_image;
                this.localImage = m_image = JViewerApp.getInstance().getPrepare_buf().getM_image();
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                if (m_image.getType() == 8) {
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                } else {
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                AffineTransform tx = AffineTransform.getScaleInstance(JVMenu.m_scale, JVMenu.m_scale);
                if (JViewer.isdownloadapp()) {
                    return;
                }
                g2.drawImage(m_image, tx, this);
                if (this.m_USBMouseMode != USBMouseRep.RELATIVE_MOUSE_MODE) break block7;
                JViewerApp.getInstance();
                if (!JViewerApp.showCursor || Mouse_X > this.m_width || Mouse_Y > this.m_height) break block7;
                URL imageURL = JViewer.class.getResource("res/cursor.gif");
                BufferedImage img = null;
                try {
                    img = ImageIO.read(imageURL);
                }
                catch (IOException e) {
                    Debug.out.println(e);
                }
                g.drawImage(img, Mouse_X, Mouse_Y, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void ShowCursor(boolean show) {
        if (this.m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE) {
            Mouse_X = 0;
            Mouse_Y = 0;
            try {
                this.robbie = new Robot();
            }
            catch (AWTException e) {
                this.robbie = null;
                return;
            }
            Mousecaliberation.resetCursor();
            BufferedImage invisCursor = new BufferedImage(32, 32, 3);
            Cursor invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(invisCursor, new Point(0, 0), "Invisible Cursor");
            this.setCursor(invisibleCursor);
            return;
        }
        if (show) {
            if (this.m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE) {
                Mousecaliberation.resetCursor();
            } else {
                this.setCursor(null);
            }
        } else {
            BufferedImage invisCursor = new BufferedImage(32, 32, 3);
            Cursor invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(invisCursor, new Point(0, 0), "Invisible Cursor");
            this.setCursor(invisibleCursor);
        }
    }

    public void SetUSBMouseMode(byte mode) {
        if (!fisrttime) {
            InfoDialog infoDialog = new InfoDialog();
        }
        this.m_USBMouseMode = mode;
        JVMenu.m_mouseMode = mode;
    }

    public byte GetUSBMouseMode() {
        return this.m_USBMouseMode;
    }

    public BufferedImage getImage() {
        return this.localImage;
    }

    public void mouse_resync_linux_mode(int x, int y) {
        if (Lost_focus_flag) {
            return;
        }
        if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
            this.m_mouseListener.splitandsend(-this.m_width, -this.m_height, true);
        } else {
            this.m_mouseListener.splitandsend_Move(-this.m_width, -this.m_height, true);
        }
        Mouse_X = 0;
        Mouse_Y = 0;
        Point currMousePos = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(currMousePos, this);
        this.lastX = (int)currMousePos.getX();
        this.lastY = (int)currMousePos.getY();
        if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
            this.m_mouseListener.splitandsend(this.lastX, this.lastY, true);
        } else {
            this.m_mouseListener.splitandsend_Move(this.lastX, this.lastY, true);
        }
    }

    public boolean USBsyncCursor(boolean state) {
        if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
            return false;
        }
        if (state) {
            if (this.m_bMouseRedirRunning) {
                return true;
            }
            if (this.m_USBMouseMode == USBMouseRep.INVALID_MOUSE_MODE) {
                JViewerApp.getInstance().getMainWindow().generalErrorMessage("Sync Cursor", "Invalid Mouse Mode. Mouse Mode Response packet\nnot yet received from Video Server.\nPlease try after some time.");
                return false;
            }
            this.addMouseListener(this.m_mouseListener);
            this.addMouseMotionListener(this.m_mouseListener);
            this.m_bMouseRedirRunning = true;
        } else {
            this.removeMouseListener(this.m_mouseListener);
            this.removeMouseMotionListener(this.m_mouseListener);
            this.m_bMouseRedirRunning = false;
        }
        return true;
    }

    public boolean getMouseRedirStatus() {
        return this.m_bMouseRedirRunning;
    }

    public USBKeyboardRep getM_USBKeyRep() {
        return this.m_USBKeyRep;
    }

    public void setM_USBKeyRep(USBKeyboardRep keyRep) {
        this.m_USBKeyRep = keyRep;
    }

    public MouseEvent getMouse_event() {
        return this.mouse_event;
    }

    public void setMouse_event(MouseEvent mouse_event) {
        this.mouse_event = mouse_event;
    }

    public USBMouseRep getM_USBMouseRep() {
        return this.m_USBMouseRep;
    }

    public void setM_USBMouseRep(USBMouseRep mouseRep) {
        this.m_USBMouseRep = mouseRep;
    }

    public MouseEvent getSentmouse_event() {
        return this.sentmouse_event;
    }

    public void setSentmouse_event(MouseEvent sentmouse_event) {
        this.sentmouse_event = sentmouse_event;
    }

    public void sendDVO() {
        KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
        this.m_USBKeyRep.set(68, 1, true);
        kvmClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(86, 1, true);
        kvmClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(79, 1, true);
        kvmClnt.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(10, 1, true);
        kvmClnt.sendKMMessage(this.m_USBKeyRep);
    }

    static /* synthetic */ byte[] access$002(JViewerView x0, byte[] x1) {
        x0.bdata = x1;
        return x1;
    }

    static /* synthetic */ short access$308(JViewerView x0) {
        short s = x0.keyPressedFlag;
        x0.keyPressedFlag = (short)(s + 1);
        return s;
    }

    static /* synthetic */ short access$310(JViewerView x0) {
        short s = x0.keyPressedFlag;
        x0.keyPressedFlag = (short)(s - 1);
        return s;
    }

    class MousesendTask
    extends TimerTask {
        MousesendTask() {
        }

        @Override
        public void run() {
            long sent_event;
            long last_sent_event;
            MouseEvent mousevent = JViewerApp.getInstance().getRCView().getMouse_event();
            MouseEvent mousesentevent = JViewerApp.getInstance().getRCView().getSentmouse_event();
            byte m_USBMouseMode = JViewerView.this.GetUSBMouseMode();
            USBMouseRep m_USBMouseRep = JViewerView.this.getM_USBMouseRep();
            byte mouseButtonStatus = JViewerApp.getInstance().getRCView().m_mouseListener.getM_btnStatus();
            if (mousevent != null && mousesentevent != null && (last_sent_event = mousesentevent.getWhen()) == (sent_event = mousevent.getWhen())) {
                return;
            }
            if (mousevent != null) {
                JViewerView.this.curX = mousevent.getX();
                JViewerView.this.curY = mousevent.getY();
                if (JViewerView.this.curX < 0) {
                    JViewerView.this.curX = 0;
                }
                if (JViewerView.this.curY < 0) {
                    JViewerView.this.curY = 0;
                }
                if (m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE) {
                    if ((double)JViewerView.this.curX < (double)JViewerView.this.m_cur_width * JVMenu.m_scale && (double)JViewerView.this.curY < (double)JViewerView.this.m_cur_height * JVMenu.m_scale) {
                        KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
                        m_USBMouseRep.set(mouseButtonStatus, (double)JViewerView.this.curX / JVMenu.m_scale, (double)JViewerView.this.curY / JVMenu.m_scale, m_USBMouseMode, JViewerView.this.m_cur_width, JViewerView.this.m_cur_height, (byte)0);
                        kvmClnt.sendKMMessage(m_USBMouseRep);
                        JViewerApp.getInstance().getRCView().setSentmouse_event(mousevent);
                    }
                    return;
                }
                if (m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE) {
                    int xDisp = JViewerView.this.curX - JViewerView.this.lastX;
                    int yDisp = JViewerView.this.curY - JViewerView.this.lastY;
                    int ret = 0;
                    if ((double)JViewerView.this.curX < (double)JViewerView.this.m_cur_width * JVMenu.m_scale && (double)JViewerView.this.curY < (double)JViewerView.this.m_cur_height * JVMenu.m_scale) {
                        ret = JViewerApp.getInstance().getRCView().m_mouseListener.splitandsend_Move(xDisp, yDisp, true);
                    }
                    JViewerApp.getInstance().getRCView().setSentmouse_event(mousevent);
                    if (ret == 0) {
                        JViewerView.this.lastX = JViewerView.this.curX;
                        JViewerView.this.lastY = JViewerView.this.curY;
                    }
                }
                JViewerView.this.repaint();
            }
        }
    }

    class RCMouseWheelListener
    implements MouseWheelListener {
        RCMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            byte wheelrotation = (byte)e.getWheelRotation();
            wheelrotation = wheelrotation < 0 ? (byte)1 : -1;
            KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
            JViewerView.this.m_USBMouseRep.set((byte)0, 0.0, 0.0, JViewerView.this.m_USBMouseMode, JViewerView.this.m_cur_width, JViewerView.this.m_cur_height, wheelrotation);
            kvmClnt.sendKMMessage(JViewerView.this.m_USBMouseRep);
        }
    }

    class RCFocusListener
    extends FocusAdapter {
        RCFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Lost_focus_flag = false;
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    public class RCMouseListener
    extends MouseInputAdapter {
        public static final byte MOUSE_MOVE = 0;
        public static final byte LBUTTON_DOWN = 1;
        public static final byte RBUTTON_DOWN = 2;
        public static final byte MBUTTON_DOWN = 4;
        private byte m_btnStatus = 0;

        public byte getM_btnStatus() {
            return this.m_btnStatus;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JViewerView.this.requestFocus();
            JViewerView.this.curX = e.getX();
            JViewerView.this.curY = e.getY();
            JViewerView.this.curX = JViewerView.this.m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE ? e.getX() : 0;
            int n = JViewerView.this.curY = JViewerView.this.m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE ? e.getY() : 0;
            if (JViewerView.this.curX < 0) {
                JViewerView.this.curX = 0;
            }
            if (JViewerView.this.curY < 0) {
                JViewerView.this.curY = 0;
            }
            switch (e.getButton()) {
                case 1: {
                    this.m_btnStatus = (byte)(this.m_btnStatus | 1);
                    break;
                }
                case 2: {
                    this.m_btnStatus = (byte)(this.m_btnStatus | 4);
                    break;
                }
                case 3: {
                    this.m_btnStatus = (byte)(this.m_btnStatus | 2);
                    break;
                }
                default: {
                    return;
                }
            }
            KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
            JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, (double)JViewerView.this.curX / JVMenu.m_scale, (double)JViewerView.this.curY / JVMenu.m_scale, JViewerView.this.m_USBMouseMode, JViewerView.this.m_cur_width, JViewerView.this.m_cur_height, (byte)0);
            kvmClnt.sendKMMessage(JViewerView.this.m_USBMouseRep);
            JViewerView.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JViewerView.this.curX = e.getX();
            JViewerView.this.curY = e.getY();
            JViewerView.this.curX = JViewerView.this.m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE ? e.getX() : 0;
            int n = JViewerView.this.curY = JViewerView.this.m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE ? e.getY() : 0;
            if (JViewerView.this.curX < 0) {
                JViewerView.this.curX = 0;
            }
            if (JViewerView.this.curY < 0) {
                JViewerView.this.curY = 0;
            }
            switch (e.getButton()) {
                case 1: {
                    this.m_btnStatus = (byte)(this.m_btnStatus & 0xFFFFFFFE);
                    break;
                }
                case 2: {
                    this.m_btnStatus = (byte)(this.m_btnStatus & 0xFFFFFFFB);
                    break;
                }
                case 3: {
                    this.m_btnStatus = (byte)(this.m_btnStatus & 0xFFFFFFFD);
                    break;
                }
                default: {
                    return;
                }
            }
            KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
            JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, (double)JViewerView.this.curX / JVMenu.m_scale, (double)JViewerView.this.curY / JVMenu.m_scale, JViewerView.this.m_USBMouseMode, JViewerView.this.m_cur_width, JViewerView.this.m_cur_height, (byte)0);
            kvmClnt.sendKMMessage(JViewerView.this.m_USBMouseRep);
            JViewerView.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JViewerApp.getInstance().getRCView().setMouse_event(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            JViewerApp.getInstance().getRCView().setMouse_event(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (JViewerApp.getInstance().getJVMenu().getMenuItem("MouseShowCursor").isSelected()) {
                JViewerApp.showCursor = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JViewerApp.getInstance();
            JViewerApp.showCursor = false;
            JViewerView.this.repaint();
        }

        public int splitandsend_Move(int xDisp, int yDisp, boolean isLinuxMode) {
            Point AftercurrMousePos;
            if (Lost_focus_flag) {
                return 0;
            }
            int ret = this.splitandsend(xDisp, yDisp, isLinuxMode);
            if (Mousecaliberation.THRESHOLDFLAG || Mousecaliberation.ACCELERATION_FLAG) {
                return ret;
            }
            Point p = JViewerApp.getInstance().getMainWindow().m_viewSP.getLocationOnScreen();
            int viewPositionX = p.x - JViewerApp.getInstance().getMainWindow().m_viewSP.getHorizontalScrollBar().getValue();
            int viewPositionY = p.y - JViewerApp.getInstance().getMainWindow().m_viewSP.getVerticalScrollBar().getValue();
            Point currMousePos = MouseInfo.getPointerInfo().getLocation();
            int Endx = p.x + JViewerApp.getInstance().getSocframeHdr().getresX();
            int Endy = p.y + JViewerApp.getInstance().getSocframeHdr().getresY();
            int XDiff = currMousePos.x - (viewPositionX + Mouse_X);
            int YDiff = currMousePos.y - (viewPositionY + Mouse_Y);
            if ((XDiff <= -2 || XDiff >= 2) && currMousePos.x < Endx) {
                JViewerView.this.removeMouseMotionListener(JViewerView.this.m_mouseListener);
                JViewerView.this.robbie.mouseMove(viewPositionX + Mouse_X, currMousePos.y);
                currMousePos = MouseInfo.getPointerInfo().getLocation();
                AftercurrMousePos = MouseInfo.getPointerInfo().getLocation();
                ret = 1;
                JViewerView.this.lastX = AftercurrMousePos.x - viewPositionX;
                JViewerView.this.addMouseMotionListener(JViewerView.this.m_mouseListener);
            }
            if ((YDiff <= -2 || YDiff >= 2) && currMousePos.y < Endy) {
                JViewerView.this.removeMouseMotionListener(JViewerView.this.m_mouseListener);
                currMousePos = MouseInfo.getPointerInfo().getLocation();
                JViewerView.this.robbie.mouseMove(currMousePos.x, viewPositionY + Mouse_Y);
                AftercurrMousePos = MouseInfo.getPointerInfo().getLocation();
                ret = 1;
                JViewerView.this.lastY = AftercurrMousePos.y - viewPositionY;
                JViewerView.this.addMouseMotionListener(JViewerView.this.m_mouseListener);
            }
            return ret;
        }

        public int splitandsend(int xDisp, int yDisp, boolean isLinuxMode) {
            if (Lost_focus_flag) {
                return 0;
            }
            int ret = 0;
            int xDir = xDisp >= 0 ? 1 : -1;
            int yDir = yDisp >= 0 ? 1 : -1;
            xDisp = Math.abs(xDisp);
            yDisp = Math.abs(yDisp);
            do {
                int x = xDisp > 126 ? 126 : xDisp;
                int y = yDisp > 126 ? 126 : yDisp;
                xDisp -= x;
                yDisp -= y;
                if (isLinuxMode) {
                    this.sendto_linux_target(x * xDir, y * yDir);
                    int dx = x * xDir;
                    int dy = y * yDir;
                    if (fisrttime) {
                        Mouse_X = JViewerView.this.lastX;
                        Mouse_Y = JViewerView.this.lastY;
                        fisrttime = false;
                    }
                    if (this.ABS(dx) + this.ABS(dy) >= ACCEL_THRESHOLD) {
                        float Rounded_Accel_X = (float)dx * MOUSE_ACCELERATION;
                        float Rounded_Accel_Y = (float)dy * MOUSE_ACCELERATION;
                        RemainingX += Rounded_Accel_X % 1.0f;
                        RemainingY += Rounded_Accel_Y % 1.0f;
                        Mouse_Y += (int)Rounded_Accel_Y;
                        if ((double)this.ABS(RemainingX) >= 1.0 && (Mouse_X += (int)Rounded_Accel_X) > 0) {
                            if ((double)RemainingX >= 1.0) {
                                ++Mouse_X;
                                RemainingX = (float)((double)RemainingX - 1.0);
                            } else {
                                --Mouse_X;
                                RemainingX = (float)((double)RemainingX + 1.0);
                            }
                        }
                        if ((double)this.ABS(RemainingY) >= 1.0 && Mouse_Y > 0) {
                            if ((double)RemainingY >= 1.0) {
                                ++Mouse_Y;
                                RemainingY = (float)((double)RemainingY - 1.0);
                            } else {
                                --Mouse_Y;
                                RemainingY = (float)((double)RemainingY + 1.0);
                            }
                        }
                    } else {
                        Mouse_X += dx;
                        Mouse_Y += dy;
                    }
                    Point p = JViewerApp.getInstance().getMainWindow().m_viewSP.getLocationOnScreen();
                    Point currMousePos = MouseInfo.getPointerInfo().getLocation();
                    try {
                        JViewerView.this.robbie = new Robot();
                    }
                    catch (AWTException e) {
                        Debug.out.println(e);
                    }
                    if (Mouse_X <= 0) {
                        Mouse_X = 0;
                        JViewerView.this.robbie.mouseMove(p.x, currMousePos.y);
                    }
                    if (Mouse_Y <= 0) {
                        Mouse_Y = 0;
                        JViewerView.this.robbie.mouseMove(currMousePos.x, p.y);
                    }
                    if (Mouse_X >= JViewerView.this.m_cur_width) {
                        Mouse_X = JViewerView.this.m_cur_width - 1;
                    }
                    if (Mouse_Y >= JViewerView.this.m_cur_height) {
                        Mouse_Y = JViewerView.this.m_cur_height - 1;
                    }
                    JViewerView.this.repaint();
                    continue;
                }
                KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
                JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, (double)(x * xDir) / JVMenu.m_scale, (double)(y * yDir) / JVMenu.m_scale, JViewerView.this.m_USBMouseMode, JViewerView.this.m_cur_width, JViewerView.this.m_cur_height, (byte)0);
                kvmClnt.sendKMMessage(JViewerView.this.m_USBMouseRep);
            } while (xDisp > 0 || yDisp > 0);
            return ret;
        }

        private int ABS(int x) {
            return x < 0 ? -x : x;
        }

        private float ABS(float x) {
            return x < 0.0f ? -x : x;
        }

        private void sendto_linux_target(int dx, int dy) {
            KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
            JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, (double)dx / JVMenu.m_scale, (double)dy / JVMenu.m_scale, JViewerView.this.m_USBMouseMode, JViewerView.this.m_cur_width, JViewerView.this.m_cur_height, (byte)0);
            kvmClnt.sendKMMessage(JViewerView.this.m_USBMouseRep);
        }
    }

    class RCKeyListener
    extends KeyAdapter {
        RCKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (JViewerApp.getInstance().getJVMenu().getAutokeylayout() != null) {
                JViewerApp.getInstance().getJVMenu().getAutokeylayout().OnkeyTyped(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            JVMenu menu;
            try {
                Class<?> cl = Class.forName("java.awt.AWTEvent");
                Field f = cl.getDeclaredField("bdata");
                f.setAccessible(true);
                JViewerView.access$002(JViewerView.this, (byte[])f.get(e));
            }
            catch (Exception e1) {
                // empty catch block
            }
            JViewerView.this.keyCode = e.getKeyCode();
            JViewerView.this.keyLocation = e.getKeyLocation();
            JViewerView.access$308(JViewerView.this);
            KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
            byte led_status = 0;
            if (e.getKeyCode() == 17) {
                return;
            }
            if (e.getKeyCode() == 524) {
                return;
            }
            if ((e.getModifiersEx() & 0x200) == 512) {
                if (JViewerApp.getInstance().isFullScreenMode()) {
                    this.OnInvokeMenuShortCutFullscreen(e);
                    e.consume();
                }
                return;
            }
            if ((e.getModifiersEx() & 0x80) == 128) {
                if (e.getKeyLocation() == 2) {
                    JViewerView.this.m_bLeftCtrlDown = true;
                } else {
                    JViewerView.this.m_bRightCtrlDown = true;
                }
                if (e.getKeyCode() == 112) {
                    JViewerApp.getInstance().OnHelpAboutJViewer();
                }
                e.consume();
                return;
            }
            if (e.getKeyCode() == 127 && ((menu = JViewerApp.getInstance().getJVMenu()).getMenuSelected("KeyboardHoldLeftCtrlKey").booleanValue() && menu.getMenuSelected("KeyboardHoldRightCtrlKey").booleanValue() && menu.getMenuSelected("KeyboardHoldRightAltKey").booleanValue() || menu.getMenuSelected("KeyboardHoldLeftCtrlKey").booleanValue() && menu.getMenuSelected("KeyboardHoldRightCtrlKey").booleanValue() && menu.getMenuSelected("KeyboardHoldLeftAltKey").booleanValue())) {
                return;
            }
            led_status = JViewerApp.getInstance().getLed_status();
            if (e.getKeyCode() == 144 || e.getKeyCode() == 20 || e.getKeyCode() == 145) {
                if (e.getKeyCode() == 144) {
                    led_status = (byte)(led_status ^ 1);
                }
                if (e.getKeyCode() == 20) {
                    led_status = (byte)(led_status ^ 2);
                }
                if (e.getKeyCode() == 145) {
                    led_status = (byte)(led_status ^ 4);
                }
                JViewerApp.getInstance().getM_wndFrame().getM_status().setKeyboardLEDStatus(led_status);
                JViewerApp.getInstance().setLed_status(led_status);
                if (JViewerApp.getInstance().getJVMenu().getAutokeylayout() != null && JViewerApp.getInstance().getJVMenu().getAutokeylayout().OnkeyPressed(e)) {
                    return;
                }
            }
            if (JViewerView.this.bdata != null && JViewerView.this.bdata[14] == 115) {
                JViewerView.this.keyCode = 226;
            }
            JViewerView.this.m_USBKeyRep.set(JViewerView.this.keyCode, JViewerView.this.keyLocation, true);
            kvmClnt.sendKMMessage(JViewerView.this.m_USBKeyRep);
            e.consume();
        }

        private void OnInvokeMenuShortCutFullscreen(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 70: {
                    JViewerApp.getInstance().OnVideoFullScreen(false);
                    break;
                }
                case 69: {
                    JViewerApp.getInstance().OnVideoRefreshRedirection();
                    break;
                }
                case 80: {
                    JViewerApp.getInstance().setM_userPause(true);
                    JViewerApp.getInstance().OnVideoPauseRedirection();
                    break;
                }
                case 82: {
                    JViewerApp.getInstance().OnVideoResumeRedirection();
                    break;
                }
                case 84: {
                    if (JViewerView.this.m_USBMouseMode != USBMouseRep.RELATIVE_MOUSE_MODE || JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STARTED) break;
                    boolean mouseThresState = JViewerApp.getInstance().getJVMenu().getMenuSelected("Calibrate Mouse Threshold");
                    JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("Calibrate Mouse Threshold", !mouseThresState);
                    JViewerApp.getInstance().OnCalibareteMouse(!mouseThresState);
                    JViewerApp.getInstance().getRCView().requestFocus();
                    break;
                }
                case 67: {
                    boolean cursurMenuState = JViewerApp.getInstance().getJVMenu().getMenuSelected("MouseShowCursor");
                    JViewerApp.getInstance().OnShowCursor(!cursurMenuState);
                    JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("MouseShowCursor", !cursurMenuState);
                    break;
                }
                default: {
                    JViewerApp.getInstance().getSoc_App().OnInvokeSocMenuShortCutFullscreen(e);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            try {
                Class<?> cl = Class.forName("java.awt.AWTEvent");
                Field f = cl.getDeclaredField("bdata");
                f.setAccessible(true);
                JViewerView.access$002(JViewerView.this, (byte[])f.get(e));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            JViewerView.this.keyCode = e.getKeyCode();
            JViewerView.this.keyLocation = e.getKeyLocation();
            if (JViewerView.this.bdata != null && JViewerView.this.bdata[14] == 115) {
                JViewerView.this.keyCode = 226;
            }
            JViewerView.this.m_USBKeyRep.set(JViewerView.this.keyCode, JViewerView.this.keyLocation, false);
            KVMClient kvmClnt = JViewerApp.getInstance().getKVMClient();
            if (e.getKeyCode() == 17) {
                return;
            }
            if ((e.getModifiersEx() & 0x200) == 512) {
                return;
            }
            if ((e.getModifiersEx() & 0x80) == 128) {
                if (e.getKeyLocation() == 2) {
                    JViewerView.this.m_bLeftCtrlDown = false;
                } else {
                    JViewerView.this.m_bRightCtrlDown = false;
                }
            }
            if (JViewerApp.getInstance().getJVMenu().getAutokeylayout() != null && JViewerApp.getInstance().getJVMenu().getAutokeylayout().OnkeyReleased(e)) {
                return;
            }
            JViewerView.this.m_USBKeyRep.set(e.getKeyCode(), e.getKeyLocation(), false);
            kvmClnt.sendKMMessage(JViewerView.this.m_USBKeyRep);
            if (JViewerView.this.keyPressedFlag == 0) {
                JViewerView.this.m_USBKeyRep.set(e.getKeyCode(), e.getKeyLocation(), true);
                kvmClnt.sendKMMessage(JViewerView.this.m_USBKeyRep);
                JViewerView.this.m_USBKeyRep.set(e.getKeyCode(), e.getKeyLocation(), false);
                kvmClnt.sendKMMessage(JViewerView.this.m_USBKeyRep);
            } else {
                JViewerView.access$310(JViewerView.this);
            }
            e.consume();
        }
    }
}

