/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.VideoRecordSettings;
import com.ami.kvm.jviewer.gui.VideoRecordStart;
import java.awt.Point;
import java.io.File;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class VideoRecord {
    public int Frame_Interval;
    public int Frame_No;
    public String StoreLocation;
    public String videoType = ".avi";
    public String Temp_store_Path;
    private String dateTime;
    public Timer m_recordTimer;
    public Timer m_stopTimer;
    public JDialog videoPath = null;
    private VideoRecordSettings m_videoPath;
    public static boolean Recording_Started = false;
    public static boolean Record_Processing = false;
    public static boolean Record_Interrupted = false;
    public boolean singleVideo = true;
    public VideoRecordStart m_videorecord;
    public final Object obj = new Object();
    public static int fps = 0;
    public static float Avg_fps = 0.0f;
    public static int TotalFrames = 0;
    public static int RecordStopTimer = 1;
    public Date TimeToRun = new Date(0L);
    JViewerApp RCApp = JViewerApp.getInstance();

    public VideoRecord() {
        this.m_videorecord = new VideoRecordStart();
    }

    public void deleteFiles(int count, String path) {
        while (count < TotalFrames) {
            File file = this.getFile(count, path);
            if (file.isFile()) {
                file.delete();
            }
            ++count;
        }
    }

    public File getFile(int count, String path) {
        String fileName = "file" + count + ".jpeg";
        File file = new File(path, fileName);
        return file;
    }

    public void mktmp_videoPath() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy-HH-mm-ss");
        Date date = new Date();
        this.dateTime = dateFormat.format(date);
        this.Temp_store_Path = this.StoreLocation + "\\Captured-at" + this.dateTime;
        boolean success = new File(this.Temp_store_Path).mkdirs();
        if (success) {
            Debug.out.println("Directories: " + this.Temp_store_Path + " created");
        }
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public void OnLowDiskSpace(File infile, String errorMsg) {
        File tempDirectory = infile.getParentFile();
        if (!tempDirectory.delete()) {
            this.RCApp.getM_videorecord().deleteFiles(0, tempDirectory.getPath());
            tempDirectory.delete();
        }
        if (JViewer.isdownloadapp()) {
            JViewerApp.getInstance().getVideorecordapp().disposeInformationDialog();
        }
        JVFrame mframe = JViewerApp.getInstance().getMainWindow();
        JOptionPane.showMessageDialog(mframe, errorMsg, "Video Recording Error", 0);
        if (!JViewer.isdownloadapp()) {
            JViewerApp.getInstance().getM_wndFrame().getM_status().resetStatus();
            JViewerApp.getInstance().getM_wndFrame().getWindowMenu().setMessage("");
            TotalFrames = 0;
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordSettings", true);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordSettings", true);
        }
    }

    public void OnVideoRecordStart() {
        TotalFrames = 0;
        this.TimeToRun = new Date(System.currentTimeMillis() / 1000L + (long)RecordStopTimer);
        this.m_recordTimer = null;
        Recording_Started = true;
        this.m_recordTimer = new Timer(true);
        if (!JViewer.isdownloadapp()) {
            this.RCApp.getJVMenu().notifyMenuStateEnable("VideoRecordStart", false);
            this.RCApp.getJVMenu().notifyMenuStateEnable("VideoRecordStop", true);
            this.RCApp.getJVMenu().notifyMenuStateEnable("VideoRecordSettings", false);
            this.RCApp.getM_wndFrame().getM_status().setStatus("Recording...");
            this.RCApp.getM_wndFrame().getWindowMenu().setMessage("Recording Under Progress...");
        }
        this.mktmp_videoPath();
        this.m_recordTimer.schedule((TimerTask)this.m_videorecord, 0L, (long)RecordStopTimer);
    }

    public void OnVideoRecordStop() {
        this.m_recordTimer.cancel();
        Recording_Started = false;
        Record_Processing = true;
        if (!JViewer.isdownloadapp()) {
            this.RCApp.getJVMenu().notifyMenuStateEnable("VideoRecordStop", false);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordStart", false);
        }
        if (!Record_Interrupted) {
            try {
                Avg_fps = fps / TotalFrames;
            }
            catch (ArithmeticException ae) {
                Avg_fps = 1.0f;
            }
            fps = 0;
            if (Avg_fps >= 5.0f) {
                Avg_fps /= 3.0f;
            }
            if (Avg_fps < 1.0f) {
                Avg_fps = 1.0f;
            }
            try {
                if (!JViewer.isdownloadapp()) {
                    this.RCApp.getM_wndFrame().getWindowMenu().setMessage("Creating Video File...");
                    JViewerApp.getInstance().getM_wndFrame().getM_status().resetStatus();
                }
                this.m_videorecord.makeVideo(this.Temp_store_Path + "\\CaptureVideoAt" + this.getDateTime() + ".avi");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        Record_Interrupted = false;
        this.RCApp.getMainWindow().repaint();
    }

    public void VideoRecordsettings() {
        Debug.out.println("OnVideoRecordSettings");
        if (this.m_videoPath == null) {
            this.m_videoPath = new VideoRecordSettings(JViewer.getMainFrame());
        }
        if (JViewer.isStandalone()) {
            this.m_videoPath.setVisible(true);
        } else {
            JOptionPane optionPane = new JOptionPane(this.m_videoPath.getJContentPane(), -1);
            optionPane.setOptions(new Object[0]);
            this.videoPath = optionPane.createDialog(this.RCApp.getMainWindow(), "Video Record");
            this.videoPath.setSize(465, 243);
            this.videoPath.setLocation(new Point(200, 150));
            this.videoPath.setTitle("Video Record");
            this.videoPath.setVisible(true);
            this.videoPath.setSize(750, 520);
            this.videoPath.setLocationRelativeTo(null);
            this.videoPath.setVisible(true);
            this.m_videoPath = (VideoRecordSettings)this.videoPath;
        }
        this.m_videoPath = null;
    }
}

