/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.iusb.CDROMRedir;
import com.ami.iusb.FloppyRedir;
import com.ami.iusb.HarddiskRedir;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ConfPkt {
    private char[] serviceName = new char[16];
    private byte currentState;
    private char[] interfaceName = new char[16];
    private short nonSecureAccessPort;
    private short secureAccessPort;
    private int sessionInactivityTimeout;
    private byte maxAllowedSessions;
    private byte currentActiveSession;
    private int maxSessionInactivityTimeout;
    private int minSessionInactivityTimeout;
    public static final String SERV_CD_MEDIA = "cd-media";
    public static final String SERV_FD_MEDIA = "fd-media";
    public static final String SERV_HD_MEDIA = "hd-media";
    public static final int CONF_PKT_SIZE = 51;
    public static final short CONF_SERVICE_COUNT = 5;
    public static final short CHANGE_CURR_STATE = 0;
    public static final short CHANGE_IFACE_NAME = 1;
    public static final short CHANGE_NON_SEC_PORT = 2;
    public static final short CHANGE_SEC_PORT = 3;
    public static final short CHANGE_TIME_OUT = 4;
    public static final short CHANGE_MAX_SESSION = 5;
    public static final short CHANGE_CURR_ACTIVE_SESS = 6;
    public static final short CHANGE_MAX_TIME_OUT = 7;
    public static final short CHANGE_MIN_TIME_OUT = 8;
    public static boolean confModified = false;

    public ConfPkt(byte[] dataBuf) {
        ByteBuffer dataBuffer = ByteBuffer.wrap(dataBuf);
        dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] temp = new byte[16];
        dataBuffer.get(temp);
        this.serviceName = new String(temp).toCharArray();
        this.currentState = dataBuffer.get();
        dataBuffer.get(temp);
        this.interfaceName = new String(temp).toCharArray();
        this.nonSecureAccessPort = dataBuffer.getShort();
        this.secureAccessPort = dataBuffer.getShort();
        this.sessionInactivityTimeout = dataBuffer.getInt();
        this.maxAllowedSessions = dataBuffer.get();
        this.currentActiveSession = dataBuffer.get();
        this.maxSessionInactivityTimeout = dataBuffer.getInt();
        this.minSessionInactivityTimeout = dataBuffer.getInt();
    }

    public String getServiceName() {
        return new String(this.serviceName).trim();
    }

    public void setServiceName(char[] serviceName) {
        this.serviceName = serviceName;
    }

    public byte getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(byte currentState) {
        this.currentState = currentState;
    }

    public String getInterfaceName() {
        return new String(this.interfaceName).trim();
    }

    public void setInterfaceName(char[] interfaceName) {
        this.interfaceName = interfaceName;
    }

    public short getNonSecureAccessPort() {
        return this.nonSecureAccessPort;
    }

    public void setNonSecureAccessPort(short nonSecureAccessPort) {
        this.nonSecureAccessPort = nonSecureAccessPort;
    }

    public short getSecureAccessPort() {
        return this.secureAccessPort;
    }

    public void setSecureAccessPort(short secureAccessPort) {
        this.secureAccessPort = secureAccessPort;
    }

    public int getSessionInactivityTimeout() {
        return this.sessionInactivityTimeout;
    }

    public void setSessionInactivityTimeout(int sessionInactivityTimeout) {
        this.sessionInactivityTimeout = sessionInactivityTimeout;
    }

    public byte getMaxAllowedSessions() {
        return this.maxAllowedSessions;
    }

    public void setMaxAllowedSessions(byte maxAllowedSessions) {
        this.maxAllowedSessions = maxAllowedSessions;
    }

    public byte getCurrentActiveSession() {
        return this.currentActiveSession;
    }

    public void setCurrentActiveSession(byte currentActiveSession) {
        this.currentActiveSession = currentActiveSession;
    }

    public int getMaxSessionInactivityTimeout() {
        return this.maxSessionInactivityTimeout;
    }

    public void setMaxSessionInactivityTimeout(int maxSessionInactivityTimeout) {
        this.maxSessionInactivityTimeout = maxSessionInactivityTimeout;
    }

    public int getMinSessionInactivityTimeout() {
        return this.minSessionInactivityTimeout;
    }

    public void setMinSessionInactivityTimeout(int minSessionInactivityTimeout) {
        this.minSessionInactivityTimeout = minSessionInactivityTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showConfDataChangeMsg(String message) {
        confModified = true;
        JFrame parent = JViewer.getMainFrame();
        String serviceName = this.getServiceName();
        JOptionPane.showMessageDialog(parent, serviceName + " configuration changed." + " The following field(s) have been modified.\n" + message + "Restatring the service...", "Services Configuration Change", 1);
        if (serviceName.equalsIgnoreCase("kvm") || serviceName.equalsIgnoreCase("web")) {
            JViewerApp.getInstance().getM_frame().windowClosed();
        }
        Object object = CDROMRedir.getSyncObj();
        synchronized (object) {
            CDROMRedir.getSyncObj().notify();
        }
        object = FloppyRedir.getSyncObj();
        synchronized (object) {
            FloppyRedir.getSyncObj().notify();
        }
        object = HarddiskRedir.getSyncObj();
        synchronized (object) {
            HarddiskRedir.getSyncObj().notify();
        }
    }
}

