/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.Debug;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class KMCrypt {
    public static final int ENCRYPT = 1;
    public static final int DECRYPT = 2;
    public static final int PLACE_HOLDER_SIZE = 16;
    private Cipher m_bf = null;

    public int initialize(String token, int mode) {
        byte[] key = new byte[16];
        byte[] tempkey = token.getBytes();
        if (tempkey.length < 16) {
            for (int i = 0; i < tempkey.length; ++i) {
                key[i] = tempkey[i];
            }
        } else {
            key = token.getBytes();
        }
        if (key == null) {
            return -1;
        }
        SecretKeySpec skeySpec = new SecretKeySpec(key, "Blowfish");
        try {
            this.m_bf = Cipher.getInstance("Blowfish/ECB/NoPadding");
            this.m_bf.init(mode, skeySpec);
        }
        catch (Exception e) {
            Debug.out.println("Crypt initialization failed\n");
            return -1;
        }
        return 0;
    }

    public byte[] encrypt(byte[] buf) {
        byte[] encbuf;
        byte[] inbuf = this.pad(buf);
        try {
            encbuf = this.m_bf.doFinal(inbuf);
        }
        catch (Exception e) {
            Debug.out.println("Encryption failed\n");
            return null;
        }
        return encbuf;
    }

    public byte[] decrypt(byte[] buf) {
        byte[] decbuf;
        try {
            decbuf = this.m_bf.doFinal(buf);
        }
        catch (Exception e) {
            Debug.out.println("Decryption failed\n");
            return null;
        }
        return decbuf;
    }

    public void close() {
        this.m_bf = null;
    }

    public boolean isInitialized() {
        return this.m_bf != null;
    }

    private byte[] pad(byte[] buf) {
        if (buf.length % 8 == 0) {
            return buf;
        }
        byte[] padbuf = new byte[buf.length + (8 - buf.length % 8)];
        Arrays.fill(padbuf, (byte)0);
        System.arraycopy(buf, 0, padbuf, 0, buf.length);
        return padbuf;
    }
}

